/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.SensorTree;
import oracle.adf.share.perf.analysis.TreeNode;

class SensorTable {
    private LinkedHashMap mThreads;
    private String mEcid;
    private String mUrl;
    private int mMinThreadCount;
    private int mMaxThreadCount;
    private long mTotalThreadCount;
    private long mRequestCount;
    private int mThreadIdCounter;
    private static final int INDENTATION_SPACES = 2;
    private static final double IGNORE_THREAD_RATIO = Analyzer.sAllPattern ? 0.0 : 0.05;

    private /* synthetic */ void $init$() {
        this.mThreads = new LinkedHashMap();
        this.mEcid = null;
        this.mUrl = null;
        this.mMinThreadCount = Integer.MAX_VALUE;
        this.mMaxThreadCount = Integer.MIN_VALUE;
        this.mTotalThreadCount = 0L;
        this.mRequestCount = 0L;
        this.mThreadIdCounter = 5000;
    }

    SensorTable(String string) {
        this.$init$();
        this.mEcid = string;
    }

    void add(SensorResult sensorResult) {
        Integer n;
        SensorThread sensorThread;
        int n2 = sensorResult.mNameIndex;
        boolean bl = false;
        if (((String)Analyzer.sSensorTypes.get(n2)).equalsIgnoreCase("s") && ((String)Analyzer.sSensorNames.get(n2)).endsWith("/url")) {
            this.mUrl = sensorResult.getValue();
            bl = true;
        }
        if ((sensorThread = (SensorThread)this.mThreads.get(n = new Integer(sensorResult.mThreadId))) == null) {
            sensorThread = new SensorThread();
            this.mThreads.put(n, sensorThread);
        }
        if (bl) {
            sensorThread.setHaveUrl();
        }
        if (((String)Analyzer.sSensorTypes.get(n2)).equalsIgnoreCase("t") || !Analyzer.sTimerOnly) {
            sensorThread.add(sensorResult);
        }
    }

    String getURL() {
        return this.mUrl;
    }

    void reBaseTimeStamp() {
        Iterator iterator = this.mThreads.entrySet().iterator();
        long l = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            SensorThread sensorThread = (SensorThread)iterator.next().getValue();
            if (sensorThread.getEarliestTimeStamp() >= l) continue;
            l = sensorThread.getEarliestTimeStamp();
        }
        iterator = this.mThreads.entrySet().iterator();
        while (iterator.hasNext()) {
            SensorThread sensorThread = (SensorThread)iterator.next().getValue();
            sensorThread.reBaseTimeStamp(l);
        }
    }

    void print(PrintStream printStream) {
        Iterator iterator = this.mThreads.entrySet().iterator();
        int n = 1;
        int n2 = this.mThreads.size();
        while (iterator.hasNext()) {
            int n3 = 1;
            Map.Entry entry = iterator.next();
            SensorThread sensorThread = (SensorThread)entry.getValue();
            if (n2 > 1) {
                printStream.println("Thread " + n + ": [id=" + entry.getKey() + "]");
                ++n3;
                ++n;
            }
            sensorThread.print(printStream, n3);
        }
    }

    void aggregate(SensorTable sensorTable) {
        if (this.mTotalThreadCount == 0L) {
            this.mTotalThreadCount = this.mThreads.size();
            this.mMaxThreadCount = this.mThreads.size();
            this.mMinThreadCount = this.mThreads.size();
            this.mRequestCount = 1L;
        }
        if (sensorTable.mThreads.size() > this.mMaxThreadCount) {
            this.mMaxThreadCount = sensorTable.mThreads.size();
        }
        if (sensorTable.mThreads.size() < this.mMinThreadCount) {
            this.mMinThreadCount = sensorTable.mThreads.size();
        }
        this.mTotalThreadCount += (long)sensorTable.mThreads.size();
        ++this.mRequestCount;
        Iterator iterator = sensorTable.mThreads.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Map.Entry entry = iterator.next();
            SensorThread sensorThread = (SensorThread)entry.getValue();
            SensorThread sensorThread2 = null;
            Iterator iterator2 = this.mThreads.entrySet().iterator();
            while (!bl && iterator2.hasNext()) {
                entry = iterator2.next();
                sensorThread2 = (SensorThread)entry.getValue();
                bl = sensorThread2.match(sensorThread);
            }
            if (bl) {
                sensorThread2.aggregate(sensorThread);
                continue;
            }
            if (!((double)this.mRequestCount * IGNORE_THREAD_RATIO < 100.0)) continue;
            this.mThreads.put(new Integer(this.mThreadIdCounter++), sensorThread);
        }
    }

    SensorTree convertToTree() {
        if (this.mTotalThreadCount == 0L) {
            this.mTotalThreadCount = this.mThreads.size();
            this.mMaxThreadCount = this.mThreads.size();
            this.mMinThreadCount = this.mThreads.size();
            this.mRequestCount = 1L;
        }
        SensorTree sensorTree = new SensorTree(this.mMinThreadCount, this.mMaxThreadCount, this.mTotalThreadCount, this.mRequestCount);
        int n = 0;
        Iterator iterator = this.mThreads.entrySet().iterator();
        while (iterator.hasNext()) {
            ++n;
            Map.Entry entry = iterator.next();
            SensorThread sensorThread = (SensorThread)entry.getValue();
            SensorResult sensorResult = (SensorResult)sensorThread.getSensors().get(0);
            if ((double)sensorResult.mHit < IGNORE_THREAD_RATIO * (double)this.mRequestCount) continue;
            TreeNode treeNode = null;
            ArrayList arrayList = sensorThread.getSensors();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                SensorResult sensorResult2 = (SensorResult)iterator2.next();
                sensorResult2.mThreadId = n;
                treeNode = sensorTree.insertToThread(treeNode, sensorResult2);
            }
            if (treeNode == null) continue;
            sensorTree.addThread(treeNode, sensorThread.hasUrl());
        }
        return sensorTree;
    }

    private class SensorThread {
        private long mEarliestTS;
        private ArrayList mSensors;
        private boolean mHasUrl;

        private /* synthetic */ void $init$() {
            this.mEarliestTS = Long.MAX_VALUE;
            this.mSensors = new ArrayList();
            this.mHasUrl = false;
        }

        ArrayList getSensors() {
            return this.mSensors;
        }

        void setHaveUrl() {
            this.mHasUrl = true;
        }

        boolean hasUrl() {
            return this.mHasUrl;
        }

        void add(SensorResult sensorResult) {
            this.mSensors.add(sensorResult);
            if (this.mEarliestTS > sensorResult.mTimeStamp) {
                this.mEarliestTS = sensorResult.mTimeStamp;
            }
        }

        long getEarliestTimeStamp() {
            return this.mEarliestTS;
        }

        void reBaseTimeStamp(long l) {
            Iterator iterator = this.mSensors.iterator();
            while (iterator.hasNext()) {
                SensorResult sensorResult = (SensorResult)iterator.next();
                sensorResult.mTimeStamp -= l;
            }
        }

        void print(PrintStream printStream, int n) {
            byte[] byArray = new byte[2 * (n - 1)];
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = 32;
                ++n2;
            }
            String string = new String(byArray);
            Iterator iterator = this.mSensors.iterator();
            while (iterator.hasNext()) {
                SensorResult sensorResult = (SensorResult)iterator.next();
                sensorResult.print(printStream, false, string);
            }
        }

        boolean match(SensorThread sensorThread) {
            boolean bl;
            boolean bl2 = bl = this.mSensors.size() == sensorThread.mSensors.size();
            if (!bl) {
                return false;
            }
            int n = this.mSensors.size();
            int n2 = 0;
            while (n2 < n) {
                SensorResult sensorResult = (SensorResult)this.mSensors.get(n2);
                SensorResult sensorResult2 = (SensorResult)sensorThread.mSensors.get(n2);
                boolean bl3 = bl = sensorResult.mNameIndex == sensorResult2.mNameIndex;
                if (!bl) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        void aggregate(SensorThread sensorThread) {
            int n = this.mSensors.size();
            int n2 = 0;
            while (n2 < n) {
                SensorResult sensorResult = (SensorResult)this.mSensors.get(n2);
                SensorResult sensorResult2 = (SensorResult)sensorThread.mSensors.get(n2);
                sensorResult.aggregate(sensorResult2);
                ++n2;
            }
        }

        private SensorThread() {
            this.$init$();
        }
    }
}

