/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import oracle.adf.share.perf.ADFPerfSensor;
import oracle.dms.instrument.DMSConsole;

public class PerfUtil {
    private static Hashtable sSensor = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ADFPerfSensor putSensor(String string, ADFPerfSensor aDFPerfSensor) {
        Hashtable hashtable = sSensor;
        synchronized (hashtable) {
            ADFPerfSensor aDFPerfSensor2 = (ADFPerfSensor)sSensor.get(string);
            if (aDFPerfSensor2 == null) {
                sSensor.put(string, aDFPerfSensor);
                aDFPerfSensor2 = aDFPerfSensor;
            }
            ADFPerfSensor aDFPerfSensor3 = aDFPerfSensor2;
            return aDFPerfSensor3;
        }
    }

    static ADFPerfSensor getSensor(String string) {
        return (ADFPerfSensor)sSensor.get(string);
    }

    static String getNounType(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
        }
        return string2.toUpperCase();
    }

    static Level getDMSSensorLevel() {
        try {
            int n = DMSConsole.getSensorWeight();
            switch (n) {
                case 0: {
                    Level level = Level.OFF;
                    return level;
                }
                case 5: {
                    Level level = Level.INFO;
                    return level;
                }
                case 10: {
                    Level level = Level.FINE;
                    return level;
                }
                case 0x7FFFFFFF: {
                    Level level = Level.FINEST;
                    return level;
                }
            }
            Level level = Level.OFF;
            return level;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Level level = Level.OFF;
            return level;
        }
    }

    public static String getUrl(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getRequestURI());
        String string = httpServletRequest.getMethod();
        if (string.equalsIgnoreCase("GET")) {
            String string2 = httpServletRequest.getQueryString();
            if (string2 != null) {
                stringBuffer.append("?");
                stringBuffer.append(string2);
            }
        } else if (string.equalsIgnoreCase("POST")) {
            Enumeration enumeration = httpServletRequest.getParameterNames();
            stringBuffer.append("?");
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string3.equalsIgnoreCase("oracle.adf.faces.STATE_TOKEN")) continue;
                stringBuffer.append(string3);
                stringBuffer.append("=");
                String[] stringArray = httpServletRequest.getParameterValues(string3);
                int n = 0;
                while (n < stringArray.length) {
                    if (n > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(stringArray[n]);
                    ++n;
                }
                stringBuffer.append("&");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.insert(0, string + ":");
        return stringBuffer.toString();
    }

    static String standardizeGroupName(String string) {
        if (string != null) {
            int n;
            if (string.length() >= 1 && string.charAt(0) != '/') {
                string = '/' + string;
            }
            if ((n = (string = string.replace(' ', '_')).length()) > 0 && string.charAt(n - 1) == '/') {
                string = string.substring(0, n - 1);
            }
        }
        return string;
    }

    static String standardizeSensorName(String string) {
        if (string != null && string.length() >= 1) {
            string = string.substring(0, 1).toLowerCase() + string.substring(1);
            string = string.replace(' ', '_');
        }
        return string;
    }
}

