/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.adf.share.jndi.BindingsEnumerator;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.adf.share.jndi.FileSystemBackingStore;
import oracle.adf.share.jndi.NameClassEnumerator;
import oracle.adf.share.jndi.NameParserImpl;
import oracle.adf.share.jndi.ProviderProperties;
import oracle.adf.share.jndi.ReferenceStoreHelper;
import oracle.adf.share.jndi.xml.References;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ContextImpl
implements ProviderProperties,
AdfJndiContext {
    private Hashtable mEnv;
    private transient DocumentBackingStore mStore;
    private transient JAXBContext mJaxbContext;
    private transient Marshaller mMarshaller;
    private transient Unmarshaller mUnmarshaller;
    private transient Hashtable mBindings;
    private transient Object mRefStoreLock;
    private transient ReferenceStoreHelper mRefStore;
    private static /* synthetic */ Class class$oracle$adf$share$jndi$DocumentBackingStore;

    private /* synthetic */ void $init$() {
        this.mEnv = null;
        this.mStore = null;
        this.mRefStoreLock = new Object();
        this.mRefStore = new ReferenceStoreHelper();
    }

    ContextImpl(Hashtable hashtable) throws NamingException {
        this.$init$();
        this.mEnv = hashtable;
        this.init();
    }

    public Object lookup(Name name) throws NamingException {
        return this.findObject(name);
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(NameParserImpl.getInstance().parse(string));
    }

    public void bind(Name name, Object object) throws NamingException {
        if (this.exists(name)) {
            throw new NameAlreadyBoundException(name.toString());
        }
        this.bindObject(name, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(NameParserImpl.getInstance().parse(string), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.removeObject(name);
        this.bindObject(name, object);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(NameParserImpl.getInstance().parse(string), object);
    }

    public void unbind(Name name) throws NamingException {
        this.removeObject(name);
    }

    public void unbind(String string) throws NamingException {
        this.unbind(NameParserImpl.getInstance().parse(string));
    }

    public void rename(Name name, Name name2) throws NamingException {
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(NameParserImpl.getInstance().parse(string), NameParserImpl.getInstance().parse(string2));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new NameClassEnumerator(this);
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(NameParserImpl.getInstance().parse(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (!name.isEmpty()) {
            throw new OperationNotSupportedException();
        }
        return new BindingsEnumerator(this);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(NameParserImpl.getInstance().parse(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(NameParserImpl.getInstance().parse(string));
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(NameParserImpl.getInstance().parse(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(NameParserImpl.getInstance().parse(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return NameParserImpl.getInstance();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getNameParser(NameParserImpl.getInstance().parse(string));
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        return null;
    }

    public String composeName(String string, String string2) throws NamingException {
        return this.composeName(NameParserImpl.getInstance().parse(string), NameParserImpl.getInstance().parse(string2)).toString();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.mEnv.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.mEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.mEnv.clone();
    }

    public void close() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
    }

    public String getNameInNamespace() throws NamingException {
        return null;
    }

    private void init() throws NamingException {
        String string = this.getDocumentUrl();
        try {
            if (this.cacheEnabled()) {
                this.mBindings = new Hashtable(12);
            }
            this.mJaxbContext = JAXBContext.newInstance((String)"oracle.adf.share.jndi.xml");
            this.mStore = this.createDocumentBackingStore();
            this.mStore.initialize(this.mEnv, string);
            this.load();
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
    }

    protected DocumentBackingStore createDocumentBackingStore() throws NamingException {
        String string = (String)this.mEnv.get("oracle.adf.share.jndi.documentstore");
        if (string != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                Class clazz2 = class$oracle$adf$share$jndi$DocumentBackingStore;
                if (clazz2 == null) {
                    clazz2 = class$oracle$adf$share$jndi$DocumentBackingStore = ContextImpl.class$("oracle.adf.share.jndi.DocumentBackingStore");
                }
                if (!clazz2.isAssignableFrom(clazz)) {
                    StringBuffer stringBuffer = new StringBuffer().append(string).append(" doesn't implement ");
                    Class clazz3 = class$oracle$adf$share$jndi$DocumentBackingStore;
                    if (clazz3 == null) {
                        clazz3 = class$oracle$adf$share$jndi$DocumentBackingStore = ContextImpl.class$("oracle.adf.share.jndi.DocumentBackingStore");
                    }
                    throw new NamingException(stringBuffer.append(clazz3.getName()).toString());
                }
                DocumentBackingStore documentBackingStore = (DocumentBackingStore)clazz.newInstance();
                return documentBackingStore;
            }
            catch (InstantiationException instantiationException) {
                this.throwNamingException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.throwNamingException(illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.throwNamingException(classNotFoundException);
            }
        }
        return new FileSystemBackingStore();
    }

    private void throwNamingException(Exception exception) throws NamingException {
        NamingException namingException;
        if (exception instanceof NamingException) {
            namingException = (NamingException)exception;
        } else {
            namingException = new NamingException();
            namingException.setRootCause(exception);
        }
        throw namingException;
    }

    private String getDocumentUrl() throws NamingException {
        String string = (String)this.mEnv.get("java.naming.provider.url");
        if (string == null) {
            throw new NamingException("Missing provider url");
        }
        return string;
    }

    private String getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return name.get(0);
        }
        return name.toString();
    }

    private Marshaller getMarshaller() throws NamingException {
        if (this.mMarshaller == null) {
            try {
                this.mMarshaller = this.mJaxbContext.createMarshaller();
                this.mMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (JAXBException jAXBException) {
                this.throwNamingException((Exception)((Object)jAXBException));
            }
        }
        return this.mMarshaller;
    }

    private Unmarshaller getUnmarshaller() throws NamingException {
        if (this.mUnmarshaller == null) {
            try {
                this.mUnmarshaller = this.mJaxbContext.createUnmarshaller();
            }
            catch (JAXBException jAXBException) {
                this.throwNamingException((Exception)((Object)jAXBException));
            }
        }
        return this.mUnmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object findObject(Name name) throws NamingException {
        String string = this.getMyComponents(name);
        Object object = null;
        if (this.cacheEnabled() && (object = (Object)this.mBindings.get(string)) != null) {
            return object;
        }
        Object object2 = this.mRefStoreLock;
        synchronized (object2) {
            try {
                object = this.mRefStore.getObjectForReference(string);
            }
            catch (Exception exception) {
                this.throwNamingException(exception);
            }
        }
        if (object == null) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setRemainingName(name);
            throw nameNotFoundException;
        }
        if (this.cacheEnabled()) {
            this.mBindings.put(string, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindObject(Name name, Object object) throws NamingException {
        if (this.mStore.isReadOnly()) {
            throw new NamingException("ReadOnly BackingStore.");
        }
        Reference reference = null;
        if (object instanceof Reference) {
            reference = (Reference)object;
        } else if (object instanceof Referenceable) {
            reference = ((Referenceable)object).getReference();
        } else {
            throw new OperationNotSupportedException("Can only bind Referenceable and Reference");
        }
        String string = this.getMyComponents(name);
        Object object2 = this.mRefStoreLock;
        synchronized (object2) {
            this.mRefStore.addReference(string, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObject(Name name) throws NamingException {
        if (this.mStore.isReadOnly()) {
            throw new NamingException("ReadOnly BackingStore.");
        }
        String string = this.getMyComponents(name);
        if (this.cacheEnabled()) {
            this.mBindings.remove(string);
        }
        Object object = this.mRefStoreLock;
        synchronized (object) {
            this.mRefStore.removeReference(string);
        }
    }

    private boolean exists(Name name) throws NamingException {
        Object v;
        String string = this.getMyComponents(name);
        if (this.cacheEnabled() && (v = this.mBindings.get(string)) != null) {
            return true;
        }
        return this.mRefStore.exists(string);
    }

    private void load() throws NamingException {
        try {
            if (this.mStore.documentExists(this.getDocumentUrl())) {
                Document document = this.mStore.readDocument(this.getDocumentUrl());
                References references = (References)this.getUnmarshaller().unmarshal((Node)document);
                this.mRefStore.init(references, this, this.mEnv);
            } else {
                this.mRefStore.init(null, this, this.mEnv);
            }
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
    }

    private void saveDocument(String string) throws NamingException {
        References references;
        if (!this.mStore.isReadOnly() && (references = this.mRefStore.getReferences()) != null) {
            try {
                this.mRefStore.saveCredentials();
                Document document = this.mStore.createDocument(string);
                this.getMarshaller().marshal((Object)references, (Node)document);
                this.mStore.writeDocument(document, string);
                this.mStore.closeDocument(string);
            }
            catch (Exception exception) {
                this.throwNamingException(exception);
            }
        }
    }

    public void reload() throws NamingException {
        this.load();
    }

    public void save() throws NamingException {
        this.saveDocument(this.getDocumentUrl());
    }

    public void saveAs(String string) throws NamingException {
        this.saveDocument(string);
    }

    ReferenceStoreHelper getReferenceStoreHelper() {
        return this.mRefStore;
    }

    private boolean cacheEnabled() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

