/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.adf.share.Environment;

public class ServletEnvironment
extends Environment {
    private final ServletContext mServletContext;
    private final HttpServletRequest mRequest;
    private final HttpServletResponse mResponse;

    public ServletEnvironment(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.mServletContext = servletContext;
        this.mRequest = (HttpServletRequest)servletRequest;
        this.mResponse = (HttpServletResponse)servletResponse;
    }

    public Object getRequest() {
        return this.mRequest;
    }

    public Object getResponse() {
        return this.mResponse;
    }

    public Object getContext() {
        return this.mServletContext;
    }

    public Locale getRequestLocale() {
        return this.mRequest.getLocale();
    }

    public String getRequestServletPath() {
        return this.mRequest.getServletPath();
    }

    public String getRequestPathInfo() {
        return this.mRequest.getPathInfo();
    }

    public String encodeResourceURL(String string) {
        return this.mResponse.encodeURL(string);
    }

    public void redirect(String string) throws IOException {
        this.mResponse.sendRedirect(string);
    }

    public String getRequestContextPath() {
        return this.mRequest.getContextPath();
    }

    public String getRequestURI() {
        return this.mRequest.getRequestURI();
    }

    public String getRequestCharacterEncoding() {
        return this.mRequest.getCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String string) throws IOException {
        this.mRequest.setCharacterEncoding(string);
    }

    public Map getRequestParameterMap() {
        return this.mRequest.getParameterMap();
    }

    public void dispatch(String string) throws IOException {
        RequestDispatcher requestDispatcher = this.mRequest.getRequestDispatcher(string);
        if (requestDispatcher == null) {
            this.mResponse.sendError(500, "No request dispatcher for " + string);
            return;
        }
        try {
            requestDispatcher.forward((ServletRequest)this.mRequest, (ServletResponse)this.mResponse);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ServletException servletException) {
            // empty catch block
        }
    }
}

