/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.adf.share.ADFConfig;
import oracle.adf.share.ADFContext;
import oracle.adf.share.ADFScope;
import oracle.adf.share.Environment;
import oracle.adf.share.config.ADFConfigFactory;
import oracle.adf.share.http.HttpADFContextVariableResolverImpl;
import oracle.adf.share.http.HttpServletRequestScopeAdapter;
import oracle.adf.share.http.HttpSessionScopeAdapter;
import oracle.adf.share.http.HttpStateManagerScopeAdapter;
import oracle.adf.share.http.HttpUtil;
import oracle.adf.share.http.ServletContextScopeAdapter;
import oracle.adf.share.http.ServletEnvironment;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.SecurityContext;

public class ServletADFContext
extends ADFContext {
    private Environment env;
    private ADFConfig application;
    private String deployedAppName;
    private static ADFLogger logger;
    private static final String SERVLET_CONTEXT_APPLICATION_SCOPE_KEY = "__adf_application_scope__";
    private static final String SERVLET_CONTEXT_APPLICATION_NAME_SCOPE_KEY = "__adf_applicationname_scope__";
    private static final String HTTP_SESSION_SCOPE_KEY = "__adf_session_scope__";
    private static HttpUtil mUtil;
    private static /* synthetic */ Class class$oracle$adf$share$http$ServletADFContext;

    private /* synthetic */ void $init$() {
        this.deployedAppName = null;
    }

    ServletADFContext() {
        this.$init$();
    }

    ServletADFContext(SecurityContext securityContext, Environment environment) {
        this();
        this.setSecurityContext(securityContext);
        this.setEnvironment(environment);
    }

    public ADFConfig getADFConfig() {
        Environment environment = this.getEnvironment();
        if (this.application == null) {
            this.application = environment != null && environment.getContext() != null ? ADFConfigFactory.findOrCreateADFConfig(environment.getContext(), "WEB-INF/adf-config.xml") : ADFConfigFactory.findOrCreateADFConfig();
        }
        return this.application;
    }

    public String getApplicationName() {
        Map map = this.getScope(ADFContext.APPLICATION_SCOPE);
        return (String)map.get(SERVLET_CONTEXT_APPLICATION_NAME_SCOPE_KEY);
    }

    private void getDeployedAppName() {
        if (this.deployedAppName != null) {
            return;
        }
        try {
            MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer();
            String string = "*:j2eeType=J2EEApplication,*";
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName(string), null);
            Iterator<ObjectName> iterator = set.iterator();
            ObjectName objectName = null;
            if (iterator.hasNext()) {
                objectName = iterator.next();
            }
            this.deployedAppName = objectName.getKeyProperty("name");
        }
        catch (Exception exception) {
            logger.fine("Application Name not created");
        }
    }

    public Map createScope(String string) {
        Map map = null;
        if (ADFContext.SESSION_SCOPE.equals(string)) {
            HttpServletRequest httpServletRequest = this.getHttpRequest();
            if (httpServletRequest != null) {
                HttpSession httpSession = httpServletRequest.getSession(true);
                map = HttpSessionScopeAdapter.getScope(httpSession);
            } else {
                map = super.createScope(string);
            }
        } else {
            map = super.createScope(string);
        }
        return map;
    }

    protected HttpServletRequest getHttpRequest() {
        return (HttpServletRequest)this.env.getRequest();
    }

    protected HttpServletResponse getHttpResponse() {
        return (HttpServletResponse)this.env.getResponse();
    }

    protected void setSecurityContext(SecurityContext securityContext) {
        super.setSecurityContext(securityContext);
        this.setUserPrincipal();
    }

    private void setUserPrincipal() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            try {
                SecurityContext securityContext = this.getSecurityContext();
                securityContext.addToEnvironment("java.naming.security.principal", principal);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected Principal getUserPrincipal() {
        return mUtil.getUserPrincipal(this.getHttpRequest());
    }

    protected void setEnvironment(Environment environment) {
        this.env = environment;
    }

    protected Environment loadEnvironment() {
        return this.env;
    }

    public Map getStateManager(String string, Hashtable hashtable) {
        return new HttpStateManagerScopeAdapter(string, hashtable);
    }

    public boolean hasSession() {
        Object object = this.getEnvironment().getRequest();
        if (object instanceof HttpServletRequest) {
            return ((HttpServletRequest)object).getSession(false) != null;
        }
        return super.hasSession();
    }

    public int getContextType() {
        return 2;
    }

    public boolean isHttpContext() {
        return true;
    }

    public static void initThreadContext(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        ServletADFContext servletADFContext = new ServletADFContext();
        servletADFContext.initialize(servletContext, servletRequest, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        ADFContext aDFContext = ADFContext.getCurrent();
        Map map = aDFContext.getRequestScope();
        this.setEnvironment(new ServletEnvironment(servletContext, (ServletRequest)((HttpServletRequest)servletRequest), (ServletResponse)((HttpServletResponse)servletResponse)));
        this.setAsCurrent();
        this.getSecurityContext();
        String string = aDFContext.getVariableResolver().getClass().getName();
        this.setVariableResolver(new HttpADFContextVariableResolverImpl(aDFContext.getVariableResolver()));
        this.setExpressionEvaluator(aDFContext.getExpressionEvaluator());
        if (servletContext != null) {
            Map map2 = (Map)mUtil.getAttribute(servletContext, SERVLET_CONTEXT_APPLICATION_SCOPE_KEY);
            if (map2 == null) {
                ServletContext servletContext2 = servletContext;
                synchronized (servletContext2) {
                    map2 = (Map)mUtil.getAttribute(servletContext, SERVLET_CONTEXT_APPLICATION_SCOPE_KEY);
                    if (map2 == null) {
                        map2 = new ServletContextScopeAdapter(ADFContext.APPLICATION_SCOPE, servletContext);
                        mUtil.setAttribute(servletContext, SERVLET_CONTEXT_APPLICATION_SCOPE_KEY, (Object)map2);
                        this.getDeployedAppName();
                        map2.put(SERVLET_CONTEXT_APPLICATION_NAME_SCOPE_KEY, this.deployedAppName);
                    }
                }
            }
            this.putScope(ADFContext.APPLICATION_SCOPE, map2);
        }
        this.putScope(ADFContext.SESSION_SCOPE, null);
        if (servletRequest != null) {
            HttpServletRequestScopeAdapter httpServletRequestScopeAdapter = new HttpServletRequestScopeAdapter(ADFContext.REQUEST_SCOPE, (HttpServletRequest)servletRequest);
            this.putScope(ADFContext.REQUEST_SCOPE, httpServletRequestScopeAdapter);
        }
    }

    public static void resetThreadContext() {
        ADFContext aDFContext = ADFContext.getCurrent();
        ADFScope aDFScope = (ADFScope)aDFContext.getRequestScope();
        if (aDFScope != null) {
            aDFScope.invalidate();
            aDFContext.removeScope(ADFContext.REQUEST_SCOPE);
        }
        aDFContext.removeAsCurrent();
    }

    public boolean hasEnvironment() {
        return true;
    }

    static {
        Class clazz = class$oracle$adf$share$http$ServletADFContext;
        if (clazz == null) {
            clazz = class$oracle$adf$share$http$ServletADFContext = ServletADFContext.class$("oracle.adf.share.http.ServletADFContext");
        }
        logger = ADFLogger.createADFLogger(clazz);
        mUtil = HttpUtil.getInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

