/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.MaskBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.gvt.filter.MaskRable8Bit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGMaskElementBridge
extends AbstractSVGBridge
implements MaskBridge {
    public String getLocalName() {
        return "mask";
    }

    public Mask createMask(BridgeContext ctx, Element maskElement, Element maskedElement, GraphicsNode maskedNode) {
        Rectangle2D maskRegion = SVGUtilities.convertMaskRegion(maskElement, maskedElement, maskedNode, ctx);
        GVTBuilder builder = ctx.getGVTBuilder();
        CompositeGraphicsNode maskNode = new CompositeGraphicsNode();
        CompositeGraphicsNode maskNodeContent = new CompositeGraphicsNode();
        maskNode.getChildren().add(maskNodeContent);
        boolean hasChildren = false;
        Node node = maskElement.getFirstChild();
        while (node != null) {
            Element child;
            GraphicsNode gn;
            if (node.getNodeType() == 1 && (gn = builder.build(ctx, child = (Element)node)) != null) {
                hasChildren = true;
                maskNodeContent.getChildren().add(gn);
            }
            node = node.getNextSibling();
        }
        if (!hasChildren) {
            return null;
        }
        String s = maskElement.getAttributeNS(null, "transform");
        AffineTransform Tx = s.length() != 0 ? SVGUtilities.convertTransform(maskElement, "transform", s) : new AffineTransform();
        s = maskElement.getAttributeNS(null, "maskContentUnits");
        short coordSystemType = s.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(maskElement, "maskContentUnits", s);
        if (coordSystemType == 2) {
            Tx = SVGUtilities.toObjectBBox(Tx, maskedNode);
        }
        maskNodeContent.setTransform(Tx);
        Filter filter = maskedNode.getFilter();
        if (filter == null) {
            filter = maskedNode.getGraphicsNodeRable(true);
        }
        return new MaskRable8Bit(filter, maskNode, maskRegion);
    }
}

