/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import oracle.net.ano.Ano;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.resolver.AddrResolution;

public class NSProtocol
implements Communication,
SQLnetDef {
    private static final boolean ACTIVATE_ANO = true;
    private AddrResolution addrRes;
    private SessionAtts sAtts = new SessionAtts(4086, Short.MAX_VALUE);
    private MarkerPacket mkPkt;
    private Packet packet;

    public NSProtocol() {
        this.sAtts.connected = false;
    }

    public void connect(String string, Properties properties) throws IOException, NetException {
        RedirectPacket redirectPacket;
        AcceptPacket acceptPacket;
        ConnectPacket connectPacket;
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (string == null) {
            throw new NetException(208);
        }
        this.addrRes = new AddrResolution(string, properties);
        if (this.addrRes.connection_revised) {
            string = this.addrRes.getTNSAddress();
            properties = this.addrRes.getUp();
        }
        this.sAtts.profile = new ClientProfile(properties);
        this.establishConnection(string);
        Object var7_3 = null;
        try {
            var7_3 = Class.forName("oracle.net.ano.Ano").newInstance();
            this.sAtts.anoEnabled = true;
        }
        catch (Exception exception) {
            this.sAtts.anoEnabled = false;
        }
        if (var7_3 != null) {
            ((Ano)var7_3).init(this.sAtts);
            this.sAtts.ano = var7_3;
            this.sAtts.anoEnabled = true;
        }
        block8: while (true) {
            connectPacket = new ConnectPacket(this.sAtts);
            connectPacket.send();
            this.packet = new Packet(this.sAtts);
            this.packet.receive();
            switch (this.packet.type) {
                case 11: {
                    continue block8;
                }
                case 2: {
                    acceptPacket = new AcceptPacket(this.packet);
                    break block8;
                }
                case 5: {
                    redirectPacket = new RedirectPacket(this.packet);
                    StringBuffer stringBuffer = this.sAtts.cOption.conn_data;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts = this.establishConnection(redirectPacket.getData());
                    this.sAtts.cOption.conn_data = stringBuffer;
                    continue block8;
                }
                case 4: {
                    RefusePacket refusePacket = new RefusePacket(this.packet);
                    throw new NetException(206, refusePacket.getData());
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
            break;
        }
        this.setNetStreams();
        this.sAtts.connected = true;
        if (this.sAtts.ano != null) {
            this.sAtts.ano.negotiation();
        }
        this.packet = null;
        connectPacket = null;
        acceptPacket = null;
        redirectPacket = null;
        Object var5_9 = null;
    }

    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sAtts.nsOutputStream.close();
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.connected = false;
    }

    private SessionAtts establishConnection(String string) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string);
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        return this.sAtts;
    }

    public InputStream getInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    public OutputStream getOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    public void sendBreak() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(1);
        this.mkPkt = null;
    }

    private void sendMarker(int n) throws IOException, NetException {
        this.mkPkt = n == 1 ? new MarkerPacket(this.sAtts) : new MarkerPacket(this.sAtts, n);
        this.mkPkt.send();
    }

    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(2);
        while (this.sAtts.onBreakReset) {
            this.packet = new Packet(this.sAtts);
            this.packet.receive();
            if (this.packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(this.packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    public void setO3logSessionKey(byte[] byArray) throws NetException, NetException {
        if (byArray != null) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }
}

