/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.Serializable;
import java.util.Vector;
import oracle.dss.util.persistence.ObjectScope;
import org.w3c.dom.Node;

public abstract class BaseNode
implements Serializable {
    public static final int NONE = 0;
    public static final int NEWLINE = 1;
    public static final int FULL = 2;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String INDENT = "    ";
    public static final String LT_STR = "&#60;";
    public static final String GT_STR = "&#62;";
    public static final String AMP_STR = "&#38;";
    public static final String APOS_STR = "&#39;";
    public static final String QUOT_STR = "&#34;";
    public static final String SPACE_STR = " ";
    public static final int LT = 60;
    public static final int GT = 62;
    public static final int AMP = 38;
    public static final int APOS = 39;
    public static final int QUOT = 34;
    public static final int SPACE_CHAR = 32;
    public static final String NULL_VAL = "NULL";
    protected String m_name;
    protected Node m_node;
    protected ObjectScope m_scope;
    protected Vector m_nodes;
    protected StringBuffer m_buffer;
    protected StringBuffer m_post;
    protected static final int s_bufSize = 150;

    BaseNode(ObjectScope objectScope, Node node) {
        this.m_scope = objectScope;
        this.m_node = node;
    }

    public BaseNode(String string) {
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public Object getImplObject() {
        return this.m_node;
    }

    void initBuffer() {
        if (this.m_buffer == null) {
            this.m_buffer = new StringBuffer(150);
        }
    }

    void initVector() {
        if (this.m_nodes == null) {
            this.m_nodes = new Vector(10, 50);
        }
    }

    Node getDOMElement() {
        return this.m_node;
    }

    ObjectScope getScope() {
        return this.m_scope;
    }

    void finishAll(StringBuffer stringBuffer, String string, int n) {
        String string2 = null;
        String string3 = null;
        if (n == 1) {
            string2 = "";
            string3 = NEW_LINE;
        } else if (n == 2) {
            string2 = INDENT;
            string3 = NEW_LINE;
        } else {
            string2 = "";
            string3 = "";
        }
        if (this.m_buffer != null && this.m_post != null) {
            stringBuffer.append(string);
            stringBuffer.append((Object)this.m_buffer);
            if (this.m_post.length() == 2) {
                stringBuffer.append((Object)this.m_post);
            } else {
                stringBuffer.append(">");
            }
            stringBuffer.append(string3);
            this.finishChildren(stringBuffer, string, n, string2, string3);
        } else if (this.m_buffer != null && this.m_post == null) {
            stringBuffer.append(string);
            stringBuffer.append((Object)this.m_buffer);
            stringBuffer.append(string3);
        } else if (this.m_post != null) {
            stringBuffer.append(string);
            stringBuffer.append("<");
            stringBuffer.append(this.m_name);
            stringBuffer.append(">");
            stringBuffer.append(string3);
            this.finishChildren(stringBuffer, string, n, string2, string3);
        } else {
            stringBuffer.append(string);
            stringBuffer.append("<");
            stringBuffer.append(this.m_name);
            stringBuffer.append("/>");
            stringBuffer.append(string3);
        }
    }

    private void finishChildren(StringBuffer stringBuffer, String string, int n, String string2, String string3) {
        if (this.m_nodes != null) {
            int n2 = 0;
            while (n2 < this.m_nodes.size()) {
                Object e = this.m_nodes.elementAt(n2);
                if (e instanceof BaseNode) {
                    ((BaseNode)e).finishAll(stringBuffer, String.valueOf(string) + string2, n);
                } else {
                    stringBuffer.append(string);
                    stringBuffer.append(string2);
                    stringBuffer.append(e.toString());
                    stringBuffer.append(string3);
                }
                ++n2;
            }
            stringBuffer.append(string);
            stringBuffer.append((Object)this.m_post);
            stringBuffer.append(string3);
        }
    }

    int getRequiredCapacity(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1) {
            n5 = NEW_LINE.length();
        } else if (n2 == 2) {
            n4 = INDENT.length();
            n5 = NEW_LINE.length();
        }
        if (this.m_buffer != null && this.m_post != null) {
            n3 = n3 + n + this.m_buffer.length();
            n3 = this.m_post.length() == 2 ? (n3 += 2) : ++n3;
            n3 += n5;
            if (this.m_nodes != null) {
                int n6 = 0;
                while (n6 < this.m_nodes.size()) {
                    Object e = this.m_nodes.elementAt(n6);
                    n3 = e instanceof BaseNode ? (n3 += ((BaseNode)e).getRequiredCapacity(n + n4, n2)) : n3 + n + n4 + e.toString().length() + n5;
                    ++n6;
                }
                n3 = n3 + n + this.m_post.length() + n5;
            }
        } else if (this.m_buffer != null && this.m_post == null) {
            n3 = n3 + n + this.m_buffer.length() + n5;
        } else if (this.m_post != null) {
            n3 = n3 + this.m_name.length() + 2 + n + n5;
            if (this.m_nodes != null) {
                int n7 = 0;
                while (n7 < this.m_nodes.size()) {
                    Object e = this.m_nodes.elementAt(n7);
                    n3 = e instanceof BaseNode ? (n3 += ((BaseNode)e).getRequiredCapacity(n + n4, n2)) : n3 + n + n4 + e.toString().length() + n5;
                    ++n7;
                }
                n3 = n3 + n + this.m_post.length() + n5;
            }
        } else {
            n3 = n3 + this.m_name.length() + 3 + n + n5;
        }
        return n3;
    }

    public static String createEscapes(String string) {
        if (string.indexOf(34) > -1 || string.indexOf(39) > -1 || string.indexOf(60) > -1 || string.indexOf(62) > -1 || string.indexOf(38) > -1) {
            char c = '\u0000';
            int n = string.length();
            int n2 = Math.min(n, 20) * 4;
            StringBuffer stringBuffer = new StringBuffer(n + n2);
            int n3 = 0;
            while (n3 < n) {
                c = string.charAt(n3);
                switch (c) {
                    case '\"': {
                        stringBuffer.append(QUOT_STR);
                        break;
                    }
                    case '\'': {
                        stringBuffer.append(APOS_STR);
                        break;
                    }
                    case '<': {
                        stringBuffer.append(LT_STR);
                        break;
                    }
                    case '>': {
                        stringBuffer.append(GT_STR);
                        break;
                    }
                    case '&': {
                        stringBuffer.append(AMP_STR);
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    String createCDATA(String string) {
        return string;
    }

    public String toString() {
        if (this.m_buffer != null) {
            return this.m_buffer.toString();
        }
        return super.toString();
    }
}

