/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.dss.util.gui.layout.LayoutComponent;

public class LayoutPagingComponent
extends PagingComponent
implements LayoutComponent,
FocusListener {
    private int m_edge;
    public static final String COMMAND_POPUP = "SHOW_POPUP";
    private static final KeyStroke _KEY_STROKE_SHIFT_F10 = KeyStroke.getKeyStroke(121, 1);
    private ActionListener m_keyBoardActionListener;
    private MouseListener m_mouseListener;
    protected int lastIndex = -1;

    public LayoutPagingComponent(int n) {
        this.m_edge = n;
    }

    public int getEdge() {
        return this.m_edge;
    }

    public void setEdge(int n) {
        this.m_edge = n;
    }

    public String[] getItems() {
        int n = this.getComponentCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2).getText();
            ++n2;
        }
        return stringArray;
    }

    public void setKeyBoardActionListener(ActionListener actionListener) {
        this.m_keyBoardActionListener = actionListener;
    }

    public ActionListener getKeyBoardActionListener() {
        return this.m_keyBoardActionListener;
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.m_mouseListener = mouseListener;
    }

    public void focusGained(FocusEvent focusEvent) {
        int n;
        int n2;
        if (!focusEvent.isTemporary() && (n2 = this.getIndex((PageItem)focusEvent.getSource())) == -1 && (n = this.getLastSelectedIndex()) != -1) {
            int n3 = this.getComponentCount();
            if (n3 > 0) {
                PageItem pageItem = n > n3 - 1 ? this.getItem(n3 - 1) : this.getItem(n);
                pageItem.requestFocus();
            } else {
                this.transferFocus();
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        PageItem pageItem = (PageItem)focusEvent.getSource();
        this.setLastSelectedIndex(this.getIndex(pageItem));
        this.processFocusEvent(focusEvent);
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.registerKeyboardAction(this.m_keyBoardActionListener, COMMAND_POPUP, _KEY_STROKE_SHIFT_F10, 0);
            if (component instanceof PageItem && this.m_mouseListener != null) {
                PageItem pageItem = (PageItem)component;
                pageItem.addFocusListener((FocusListener)this);
                int n2 = pageItem.getComponentCount();
                int n3 = 0;
                while (n3 < n2) {
                    pageItem.getComponent(n3).addMouseListener(this.m_mouseListener);
                    ++n3;
                }
            }
        }
    }

    private void setLastSelectedIndex(int n) {
        this.lastIndex = n;
    }

    private int getLastSelectedIndex() {
        return this.lastIndex;
    }
}

