/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.dss.util.gui.BIFontPane;

public class FontButton
extends JButton
implements ActionListener,
PropertyChangeListener {
    private ResourceBundle rBundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    protected JButton m_fontButton;
    protected Font m_font;
    protected int m_horizontalAlignment;
    protected int m_verticalAlignment;
    protected BIFontPane m_fontPane;
    protected boolean m_underline;
    protected boolean m_strikethrough;
    protected Color m_foreground = Color.black;
    protected Color m_background = Color.white;
    protected String m_faceStr;
    protected int m_visibleStyle = 15;
    protected int m_visibleAlignment = 479;
    protected int m_visibleColor = 7;
    protected int m_textRotation;
    protected int m_textRotationMask = 0;
    protected Locale m_locale;
    protected HelpProvider m_helpProvider;
    protected boolean m_customColorsEnabled;
    public static final String PROPERTY_CANCELLED = "fontDialogCancelled";
    private static ArrayTwoDModel m_colorPalette;
    private static Color[][] m_defaultColorArray;
    private static int m_currentColumn;
    private Color[][] m_colors;
    private static ArrayTwoDModel m_cPalette;
    private boolean m_bColorPaletteSet;
    private String m_dialogTitle = "";
    private boolean panelShow;

    public FontButton(ImageIcon imageIcon, String string) {
        super(string, imageIcon);
        this.addActionListener(this);
    }

    public FontButton(String string) {
        this();
        this.m_faceStr = string;
        this.setText(string);
    }

    public FontButton() {
        this.addActionListener(this);
    }

    public void setColorPalette(Color[][] colorArray) {
        this.m_colors = colorArray;
        if (this.m_colors != null) {
            m_cPalette = FontButton.getArrayTwoDModel(colorArray);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            m_cPalette = null;
        }
        if (this.m_fontPane != null) {
            this.setColorPaletteOnChoices();
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.m_fontPane != null) {
            return FontButton.getColorArray(this.m_fontPane.getFontColorChoice().getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel arrayTwoDModel) {
        this.m_bColorPaletteSet = arrayTwoDModel != null;
        m_cPalette = arrayTwoDModel;
        if (this.m_fontPane != null) {
            this.setColorPaletteOnChoices();
        }
    }

    protected int convertBaliHAlignmentToSwing(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 10: {
                n2 = 10;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    protected int convertBaliVAlignmentToSwing(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setText(String string) {
        String string2 = MessageFormat.format(this.rBundle.getString("ellipses"), string);
        super.setText(string2);
    }

    public void setDialogTitle(String string) {
        this.m_dialogTitle = string;
    }

    public FontPane getFontPane() {
        return this.m_fontPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.panelShow) {
            return;
        }
        this.panelShow = true;
        if (this.m_fontPane == null) {
            this.m_fontPane = new BIFontPane();
            this.m_fontPane.setCustomColorsEnabled(this.m_customColorsEnabled);
            if (this.m_bColorPaletteSet) {
                this.setColorPaletteOnChoices();
            }
            ColorChoice colorChoice = this.m_fontPane.getFontBackgroundColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)colorChoice.getColorPalette(), (Color)this.m_background)) {
                    colorChoice.setColorPalette(FontButton.getNewColorPalette(colorChoice.getColorPalette(), this.m_background, this.m_bColorPaletteSet));
                }
                colorChoice.setSelectedColor(this.m_background);
            } else {
                colorChoice.setSelectedColor(colorChoice.getClosestColor(this.m_background));
            }
            if (!this.m_bColorPaletteSet) {
                colorChoice = this.m_fontPane.getFontColorChoice();
                if (!ColorChoice.isColorInPalette((TwoDModel)colorChoice.getColorPalette(), (Color)this.m_foreground)) {
                    colorChoice.setColorPalette(FontButton.getNewColorPalette(colorChoice.getColorPalette(), this.m_foreground, this.m_bColorPaletteSet));
                }
                colorChoice.setSelectedColor(this.m_foreground);
            } else {
                colorChoice.setSelectedColor(colorChoice.getClosestColor(this.m_foreground));
            }
        }
        HelpUtils.setHelpProvider((JComponent)((Object)this.m_fontPane), (HelpProvider)this.getHelpProvider());
        this.m_fontPane.setStyleButtonMask(this.m_visibleStyle);
        this.m_fontPane.setAlignmentButtonMask(this.m_visibleAlignment);
        this.m_fontPane.setColorComponentMask(this.m_visibleColor);
        this.m_fontPane.setRotationButtonMask(this.m_textRotationMask);
        if (this.m_locale != null) {
            this.m_fontPane.setLocale(this.m_locale);
        }
        this._initFontPane();
        this.m_fontPane.addPropertyChangeListener(this);
        int n = FontPane.showDialog((Component)this, (FontPane)this.m_fontPane, (String)this.m_dialogTitle, (boolean)false);
        if (n == 2) {
            this.firePropertyChange(PROPERTY_CANCELLED, false, true);
        } else {
            this.applyFontPane();
            this.firePropertyChange(PROPERTY_CANCELLED, true, false);
        }
        this.m_fontPane.removePropertyChangeListener(this);
        this.panelShow = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "fontHorizontalAlignment") {
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n2 = (Integer)propertyChangeEvent.getNewValue();
            this.firePropertyChange(string, this.convertBaliHAlignmentToSwing(n), this.convertBaliHAlignmentToSwing(n2));
        } else if (string == "fontVerticalAlignment") {
            int n = (Integer)propertyChangeEvent.getOldValue();
            int n3 = (Integer)propertyChangeEvent.getNewValue();
            this.firePropertyChange(string, this.convertBaliVAlignmentToSwing(n), this.convertBaliVAlignmentToSwing(n3));
        } else {
            this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public void setRotationButtonMask(int n) {
        this.m_textRotationMask = n;
    }

    public void setStyleButtonMask(int n) {
        this.m_visibleStyle = n;
    }

    public void setAlignmentButtonMask(int n) {
        this.m_visibleAlignment = n;
    }

    public void setColorComponentMask(int n) {
        this.m_visibleColor = n;
    }

    public int getTextRotation() {
        return this.m_textRotation;
    }

    public void setTextRotation(int n) {
        this.m_textRotation = n;
    }

    public Color getComponentForeground() {
        return this.m_foreground;
    }

    public void setComponentForeground(Color color) {
        if (this.m_fontPane != null) {
            ColorChoice colorChoice = this.m_fontPane.getFontColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)colorChoice.getColorPalette(), (Color)color)) {
                    colorChoice.setColorPalette(FontButton.getNewColorPalette(colorChoice.getColorPalette(), color, this.m_bColorPaletteSet));
                }
                colorChoice.setSelectedColor(color);
            } else {
                this.m_foreground = colorChoice.getClosestColor(color);
                colorChoice.setSelectedColor(this.m_foreground);
            }
        }
        this.m_foreground = color;
    }

    public Color getComponentBackground() {
        return this.m_background;
    }

    public void setComponentBackground(Color color) {
        if (this.m_fontPane != null) {
            ColorChoice colorChoice = this.m_fontPane.getFontBackgroundColorChoice();
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)colorChoice.getColorPalette(), (Color)color)) {
                    colorChoice.setColorPalette(FontButton.getNewColorPalette(colorChoice.getColorPalette(), color, this.m_bColorPaletteSet));
                }
                colorChoice.setSelectedColor(color);
            } else {
                this.m_background = colorChoice.getClosestColor(color);
                colorChoice.setSelectedColor(this.m_background);
            }
        }
        this.m_background = color;
    }

    public Font getComponentFont() {
        return this.m_font;
    }

    public void setComponentFont(Font font) {
        this.m_font = font;
    }

    public boolean isUnderlineStyle() {
        return this.m_underline;
    }

    public void setUnderlineStyle(boolean bl) {
        this.m_underline = bl;
    }

    public boolean isStrikeThroughStyle() {
        return this.m_strikethrough;
    }

    public void setStrikeThroughStyle(boolean bl) {
        this.m_strikethrough = bl;
    }

    public int getPaneHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    public void setPaneHorizontalAlignment(int n) {
        this.m_horizontalAlignment = n;
    }

    public int getPaneVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public void setPaneVerticalAlignment(int n) {
        this.m_verticalAlignment = n;
    }

    public void applyFontPane() {
        if (!this.m_foreground.equals(this.m_fontPane.getFontColor())) {
            this.m_foreground = this.m_fontPane.getFontColor();
        }
        if (!this.m_background.equals(this.m_fontPane.getFontBackgroundColor())) {
            this.m_background = this.m_fontPane.getFontBackgroundColor();
        }
        if (!this.m_font.equals(this.m_fontPane.getCurrentFont())) {
            this.m_font = this.m_fontPane.getCurrentFont();
        }
        if (this.m_textRotation != this.m_fontPane.getTextRotation()) {
            this.m_textRotation = this.m_fontPane.getTextRotation();
        }
        this.m_horizontalAlignment = this.convertBaliHAlignmentToSwing(this.m_fontPane.getFontHorizontalAlignment());
        this.m_verticalAlignment = this.convertBaliVAlignmentToSwing(this.m_fontPane.getFontVerticalAlignment());
        this.m_underline = this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 4;
        this.m_strikethrough = this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 8;
        if (this.m_fontPane.getFontStyle() - this.m_font.getStyle() == 12) {
            this.m_strikethrough = true;
            this.m_underline = true;
        }
    }

    public void setPaneLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle(locale);
        this.setText(this.m_faceStr);
    }

    public static TwoDModel getNewColorPalette(TwoDModel twoDModel, Color color, boolean bl) {
        int n;
        int n2 = twoDModel.getRowCount();
        int n3 = twoDModel.getColumnCount();
        if (m_colorPalette == null || bl) {
            ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(n3, n2 + 1);
            n = 0;
            while (n < n2) {
                int n4 = 0;
                while (n4 < n3) {
                    arrayTwoDModel.setData(n4, n, twoDModel.getData(n4, n));
                    ++n4;
                }
                ++n;
            }
            n = 0;
            while (n < n3) {
                arrayTwoDModel.setData(n, n2, (Object)Color.white);
                ++n;
            }
            if (bl) {
                arrayTwoDModel.setData(0, arrayTwoDModel.getRowCount() - 1, (Object)color);
                return arrayTwoDModel;
            }
            m_colorPalette = arrayTwoDModel;
        }
        n = 0;
        while (n < m_colorPalette.getColumnCount()) {
            if (color.equals(m_colorPalette.getData(n, m_colorPalette.getRowCount() - 1))) {
                return m_colorPalette;
            }
            ++n;
        }
        if (m_currentColumn == n3) {
            m_currentColumn = 0;
        }
        m_colorPalette.setData(m_currentColumn++, m_colorPalette.getRowCount() - 1, (Object)color);
        return m_colorPalette;
    }

    public static ArrayTwoDModel getArrayTwoDModel(Color[][] colorArray) {
        int n = colorArray.length;
        int n2 = colorArray[0].length;
        ArrayTwoDModel arrayTwoDModel = new ArrayTwoDModel(n2, n);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                arrayTwoDModel.setData(n4, n3, (Object)colorArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
        return arrayTwoDModel;
    }

    public static Color[][] getColorArray(TwoDModel twoDModel) {
        Color[][] colorArray = new Color[twoDModel.getRowCount()][twoDModel.getColumnCount()];
        int n = 0;
        while (n < twoDModel.getRowCount()) {
            int n2 = 0;
            while (n2 < twoDModel.getColumnCount()) {
                colorArray[n][n2] = (Color)twoDModel.getData(n2, n);
                ++n2;
            }
            ++n;
        }
        return colorArray;
    }

    public static Color[][] getDefaultColorArray() {
        if (m_defaultColorArray == null) {
            ColorChoice colorChoice = new ColorChoice();
            m_defaultColorArray = FontButton.getColorArray(colorChoice.getColorPalette());
            colorChoice = null;
        }
        return m_defaultColorArray;
    }

    public void cleanUp() {
        m_colorPalette = null;
        m_cPalette = null;
    }

    public void setCustomColorsEnabled(boolean bl) {
        this.m_customColorsEnabled = bl;
    }

    protected void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle");
    }

    private void setColorPaletteOnChoices() {
        ColorChoice colorChoice = this.m_fontPane.getFontColorChoice();
        if (this.m_foreground != null) {
            colorChoice.setSelectedColor((Color)colorChoice.getColorPalette().getData(0, 0));
            colorChoice.setColorPalette((TwoDModel)m_cPalette);
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)colorChoice.getColorPalette(), (Color)this.m_foreground)) {
                    colorChoice.setColorPalette(FontButton.getNewColorPalette(colorChoice.getColorPalette(), this.m_foreground, this.m_bColorPaletteSet));
                }
                colorChoice.setSelectedColor(this.m_foreground);
            } else {
                colorChoice.setSelectedColor(colorChoice.getClosestColor(this.m_foreground));
            }
        } else {
            colorChoice.setColorPalette((TwoDModel)m_cPalette);
        }
        ColorChoice colorChoice2 = this.m_fontPane.getFontBackgroundColorChoice();
        if (this.m_background != null) {
            colorChoice2.setSelectedColor((Color)colorChoice2.getColorPalette().getData(0, 0));
            colorChoice2.setColorPalette((TwoDModel)m_cPalette);
            if (!this.m_bColorPaletteSet) {
                if (!ColorChoice.isColorInPalette((TwoDModel)colorChoice2.getColorPalette(), (Color)this.m_background)) {
                    colorChoice2.setColorPalette(FontButton.getNewColorPalette(colorChoice2.getColorPalette(), this.m_background, this.m_bColorPaletteSet));
                }
                colorChoice2.setSelectedColor(this.m_background);
            } else {
                colorChoice2.setSelectedColor(colorChoice2.getClosestColor(this.m_background));
            }
        } else {
            colorChoice2.setColorPalette((TwoDModel)m_cPalette);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void _initFontPane() {
        if (this.m_font != null) {
            block19: {
                try {
                    this.m_fontPane.setFontName(this.m_font.getName());
                    break block19;
                }
                catch (IllegalArgumentException var1_1) {
                    var2_3 = this.m_fontPane.getFontNames();
                    var3_4 = new String[var2_3.length + 1];
                    var4_5 = false;
                    var5_6 = 0;
                    var6_7 = 0;
                    ** while (var6_7 < var3_4.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (var4_5 || var5_6 < var2_3.length && this.m_font.getName().compareTo(var2_3[var5_6]) > 0) {
                        var3_4[var6_7] = var2_3[var5_6];
                        ++var5_6;
                    } else {
                        var3_4[var6_7] = this.m_font.getName();
                        var4_5 = true;
                    }
                    ++var6_7;
                    continue;
                }
lbl20:
                // 1 sources

                this.m_fontPane.setFontNames(var3_4);
                this.m_fontPane.setFontName(this.m_font.getName());
            }
            this.m_fontPane.setFontStyle(this.m_font.getStyle());
            if (this.m_underline) {
                this.m_fontPane.setFontStyle(this.m_fontPane.getFontStyle() | 4);
            }
            if (this.m_strikethrough) {
                this.m_fontPane.setFontStyle(this.m_fontPane.getFontStyle() | 8);
            }
            this.m_fontPane.setFontSize(this.m_font.getSize());
        }
        if (this.m_foreground != null) {
            this.m_fontPane.setFontColor(this.m_foreground);
        }
        if (this.m_background != null) {
            this.m_fontPane.setFontBackgroundColor(this.m_background);
        }
        switch (this.m_horizontalAlignment) {
            case 2: {
                var1_2 = 2;
                break;
            }
            case 4: {
                var1_2 = 4;
                break;
            }
            case 10: {
                var1_2 = 10;
                break;
            }
            default: {
                var1_2 = 0;
            }
        }
        this.m_fontPane.setFontHorizontalAlignment(var1_2);
        switch (this.m_verticalAlignment) {
            case 1: {
                var1_2 = 1;
                break;
            }
            case 3: {
                var1_2 = 3;
                break;
            }
            default: {
                var1_2 = 0;
            }
        }
        this.m_fontPane.setFontVerticalAlignment(var1_2);
        this.m_fontPane.setTextRotation(this.m_textRotation);
    }
}

