/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.DataAccess;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.dimensionList.DataAccessDimensionModel;
import oracle.dss.util.dimensionList.DefaultListDataItem;
import oracle.dss.util.dimensionList.DefaultListDataModel;
import oracle.dss.util.dimensionList.DefaultListSelection;
import oracle.dss.util.dimensionList.DimFindEvent;
import oracle.dss.util.dimensionList.DimFindEventListener;
import oracle.dss.util.dimensionList.DimFindHistory;
import oracle.dss.util.dimensionList.DimFindTool;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimListSelectionModel;
import oracle.dss.util.dimensionList.DimensionList;
import oracle.dss.util.dimensionList.DimensionListListener;
import oracle.dss.util.dimensionList.DimensionUtil;
import oracle.dss.util.gui.LazyScrollPane;

public class DimensionListPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ListDataListener,
DimFindEventListener,
Serializable {
    protected DimensionList m_jlist;
    private LazyScrollPane m_jscrolllist;
    private JPanel m_pnlDescription;
    protected JLabel m_lblMembers;
    protected JLabel m_countLabel;
    protected JPanel m_toolbar;
    private JButton m_btnCollapse;
    private JButton m_btnExpand;
    private JButton m_btnFind;
    private Icon m_collapseAllIcon;
    private Icon m_expandAllIcon;
    private Icon m_findIcon;
    private boolean m_showCount = true;
    private boolean m_showToolbar = true;
    private boolean m_showHierarchy = true;
    private JDialog m_dlg;
    private DimFindTool m_findTool;
    private DimFindHistory m_fh;
    private String m_textFound;
    private String m_textNotFound;
    private static ResourceBundle m_localStrings;
    protected Locale m_locale;
    private Vector m_listeners;
    protected HelpProvider m_helpProvider;
    private DefaultListDataModel m_dataModel;
    private DefaultListSelection m_selectionModel;
    private String m_dimName = "";
    private String m_labelType = "shortName";
    private String m_closeText;
    private String m_findNextText;
    private String m_findHelpText;
    private PushButton m_findNextButton;
    private PushButton m_closeButton;
    private PushButton m_findHelpButton;
    private JPanel m_content;
    private transient DataAccessDimensionModel m_listModel;
    private transient boolean m_internalLayout;
    private transient int m_debugLevel;
    protected String m_strDimension;
    protected String m_strHierarchy;
    protected boolean m_blnIsHierarchical = true;
    protected Window m_parent;
    private Icon m_iconExpanded;
    private Icon m_iconCollapsed;
    private static final int TOP_INSET = 0;
    private static final int BOTTOM_INSET = 0;
    private static final int LEFT_INSET = 2;
    private static final int RIGHT_INSET = 2;
    private boolean m_blnFromMouseEvent;
    protected boolean m_bSuperCalled = true;

    public DimensionListPanel() {
        this((Frame)null);
    }

    public DimensionListPanel(Frame frame) {
        this.m_parent = frame;
        this.init();
    }

    public DimensionListPanel(Dialog dialog) {
        this.m_parent = dialog;
        this.init();
    }

    public DimensionListPanel(DataAccess dataAccess, MemberListAccess memberListAccess, String string, String string2, boolean bl) {
        this();
        this.initPanel(dataAccess, memberListAccess, string, string2, bl);
    }

    public DimensionListPanel(Frame frame, DataAccess dataAccess, MemberListAccess memberListAccess, String string, String string2, boolean bl) {
        this(frame);
        this.initPanel(dataAccess, memberListAccess, string, string2, bl);
    }

    public DimensionListPanel(Dialog dialog, DataAccess dataAccess, MemberListAccess memberListAccess, String string, String string2, boolean bl) {
        this(dialog);
        this.initPanel(dataAccess, memberListAccess, string, string2, bl);
    }

    private void initPanel(DataAccess dataAccess, MemberListAccess memberListAccess, String string, String string2, boolean bl) {
        DataAccessDimensionModel dataAccessDimensionModel = new DataAccessDimensionModel(dataAccess, memberListAccess, string, bl);
        this.setLabelType(string2);
        this.initDimensionListPanel(string, dataAccessDimensionModel, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.m_jlist.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.m_jlist.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addDimensionListListener(DimensionListListener dimensionListListener) {
        if (this.m_jlist != null) {
            this.m_jlist.addDimensionListListener(dimensionListListener);
        }
    }

    public synchronized void removeDimensionListListener(DimensionListListener dimensionListListener) {
        if (this.m_jlist != null) {
            this.m_jlist.removeDimensionListListener(dimensionListListener);
        }
    }

    public Dimension getPreferredSize() {
        if (this.m_jlist != null) {
            return this.m_jlist.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public DimensionList getDimensionList() {
        return this.m_jlist;
    }

    public void setCountLabelVisible(boolean bl) {
        this.m_showCount = bl;
        this.addCountLabel();
    }

    public boolean isCountLabelVisible() {
        return this.m_showCount;
    }

    public void setLabelType(String string) {
        if (string != null) {
            this.m_labelType = string;
        }
    }

    public String getLabelType() {
        return this.m_labelType;
    }

    public void setToolbarVisible(boolean bl) {
        this.m_showToolbar = bl;
        this.addToolbar();
    }

    public boolean isToolbarVisible() {
        return this.m_showToolbar;
    }

    public void setHierarchyVisible(boolean bl) {
        this.m_showHierarchy = bl;
        this.updateToolbar();
    }

    public boolean isHierarchyVisible() {
        return this.m_showHierarchy;
    }

    public synchronized void setDimensionName(String string) {
        if (this.m_listModel == null) {
            this.initDataAccessDataSource();
        }
        if (this.m_listModel != null) {
            this.m_listModel.setDimensionName(string);
        }
    }

    public String getDimensionName() {
        if (this.m_listModel != null) {
            return this.m_listModel.getDimensionName();
        }
        return "";
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateCountLabel();
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateCountLabel();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateCountLabel();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateCountLabel();
    }

    public int doFind(String string, int n, int n2, boolean bl) {
        int n3 = -1;
        return n3;
    }

    public void doFindDialog(String string) {
        if (this.m_dlg == null) {
            Object var2_2 = null;
            GrayPane grayPane = null;
            this.m_dlg = this.m_parent instanceof Frame ? new JDialog((Frame)this.m_parent, this.getIntlString("findDlgTitle")) : (this.m_parent instanceof Dialog ? new JDialog((Dialog)this.m_parent, this.getIntlString("findDlgTitle")) : new JDialog(null, this.getIntlString("findDlgTitle")));
            this.m_dlg.setModal(true);
            JComponent jComponent = (JComponent)this.m_dlg.getContentPane();
            jComponent.setLayout(new BorderLayout());
            jComponent.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            int n = this.m_dlg.getSize().width;
            int n2 = this.m_dlg.getSize().height;
            int n3 = this.getSize().width;
            int n4 = this.getSize().height;
            int n5 = this.getLocationOnScreen().x;
            int n6 = this.getLocationOnScreen().y;
            int n7 = n5 + n3 / 2 - n / 2;
            int n8 = n6 + n4 / 2 - n2 / 2;
            this.m_dlg.setLocation(n7, n8);
            if (this.m_findTool == null) {
                this.m_findTool = new DimFindTool();
                this.m_findTool.setLocale(this.getLocale());
                this.m_findTool.addDimFindEventListener(this);
            }
            grayPane = new GrayPane((Component)this.m_findTool);
            this.m_closeText = new String(this.getIntlString("btnClose"));
            this.m_findNextText = new String(this.getIntlString("btnNext"));
            this.m_findHelpText = new String(this.getIntlString("btnHelp"));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            JLabel jLabel = new JLabel(" ");
            this.m_findNextButton = new PushButton(StringUtils.stripMnemonic((String)this.m_findNextText));
            this.m_findNextButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_findNextText));
            this.m_findNextButton.setLeftmost(true);
            this.m_findNextButton.setRightmost(true);
            this.m_findNextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionListPanel.this.m_findTool.processFindNextButton();
                }
            });
            this.m_closeButton = new PushButton(StringUtils.stripMnemonic((String)this.m_closeText));
            this.m_closeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_closeText));
            this.m_closeButton.setLeftmost(true);
            this.m_closeButton.setRightmost(true);
            this.m_closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionListPanel.this.m_findTool.processCloseButton();
                }
            });
            this.m_findHelpButton = new PushButton(StringUtils.stripMnemonic((String)this.m_findHelpText));
            this.m_findHelpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_findHelpText));
            this.m_findHelpButton.setLeftmost(true);
            this.m_findHelpButton.setRightmost(true);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    HelpProvider helpProvider = DimensionListPanel.this.getHelpProvider();
                    if (helpProvider != null) {
                        try {
                            helpProvider.showHelp((Component)DimensionListPanel.this.m_findTool);
                        }
                        catch (HelpUnavailableException helpUnavailableException) {
                            // empty catch block
                        }
                    }
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DimensionListPanel.this.m_dlg.dispose();
                }
            };
            this.m_findHelpButton.addActionListener(actionListener);
            this.m_dlg.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(112, 0), 2);
            this.m_dlg.getRootPane().registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(156, 0), 2);
            this.m_dlg.getRootPane().registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(27, 0), 2);
            jPanel2.add((Component)this.m_findNextButton, "North");
            jPanel2.add((Component)this.m_closeButton, "South");
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jLabel, "Center");
            jPanel.add((Component)this.m_findHelpButton, "South");
            jComponent.add(Box.createRigidArea(new Dimension(0, 5)), "North");
            jComponent.add(Box.createRigidArea(new Dimension(5, 0)), "West");
            jComponent.add((Component)grayPane, "Center");
            jComponent.add((Component)jPanel, "East");
            jComponent.add(Box.createRigidArea(new Dimension(0, 5)), "South");
        }
        this.m_dlg.pack();
        WindowUtils.registerWindow((Window)this.m_dlg);
        this.m_dlg.show();
        this.m_dlg.requestFocus();
        WindowUtils.unregisterWindow((Window)this.m_dlg);
    }

    public DimListSelectionModel getSelectionModel() {
        return (DimListSelectionModel)((Object)this.m_jlist.getSelectionModel());
    }

    public synchronized void setSelectionModel(DimListSelectionModel dimListSelectionModel) {
        this.m_jlist.setSelectionModel((ListSelectionModel)((Object)dimListSelectionModel));
    }

    public boolean clearSelection() {
        if (this.m_jlist != null) {
            this.m_jlist.clearSelection();
            return true;
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        return this.m_jlist.isSelectionEmpty();
    }

    public int getCount() {
        DimListDataModel dimListDataModel;
        ListModel listModel = this.m_jlist.getModel();
        if (listModel instanceof DimListDataModel && (dimListDataModel = (DimListDataModel)listModel) != null) {
            return dimListDataModel.size();
        }
        return 0;
    }

    public void setSelectedIndex(int n) {
        if (this.m_jlist != null && n > -1 && n < this.getCount()) {
            this.m_jlist.setSelectedIndex(n);
        }
    }

    public int getSelectedIndex() {
        if (this.m_jlist != null) {
            return this.m_jlist.getSelectedIndex();
        }
        return -1;
    }

    public void setSelectedItems(Vector vector) {
        if (vector == null) {
            return;
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        if (this.m_jlist != null) {
            int n = 0;
            while (n < this.m_jlist.getModel().getSize()) {
                DefaultListDataItem defaultListDataItem = (DefaultListDataItem)((DimListDataModel)this.m_jlist.getModel()).elementAt(n);
                if (vector.indexOf(defaultListDataItem.getValue()) != -1) {
                    vector2.addElement(new Integer(n));
                }
                ++n;
            }
        }
        if (vector2.size() > 0) {
            int[] nArray = new int[vector2.size()];
            int n = 0;
            while (n < vector2.size()) {
                nArray[n] = (Integer)vector2.elementAt(n);
                ++n;
            }
            this.m_jlist.setSelectedIndices(nArray);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnExpand) {
            if (this.m_jlist != null) {
                this.m_jlist.doExpandAll();
                this.requestDefaultFocus();
                this.m_jlist.requestFocus();
            }
        } else if (object == this.m_btnCollapse) {
            if (this.m_jlist != null) {
                this.m_jlist.doCollapseAll();
                this.requestDefaultFocus();
                this.m_jlist.requestFocus();
            }
        } else if (object == this.m_btnFind) {
            this.doFindDialog(null);
        }
    }

    public void processDimFindEvent(DimFindEvent dimFindEvent) {
        boolean bl = dimFindEvent.getSearchDescendants();
        boolean bl2 = dimFindEvent.getMatchCase();
        int n = dimFindEvent.getSearchChoice();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 8;
            }
        }
        int n3 = 0;
        n3 = bl2 ? n3 & 0xFFFFFF7F : 128;
        n3 |= n2;
        if (dimFindEvent.getId() == 1) {
            this.m_dlg.dispose();
            this.m_btnFind.setEnabled(true);
            this.requestDefaultFocus();
            this.m_jlist.requestFocus();
        } else if (dimFindEvent.getId() == 2 && this.m_jlist != null) {
            int n4;
            String string = dimFindEvent.getText();
            int n5 = this.m_jlist.doFind(string, n3, n4 = this.m_jlist.getSelectedIndex() + 1, false);
            string = n5 > -1 ? String.valueOf(string) + this.m_textFound : String.valueOf(string) + this.m_textNotFound;
            this.m_findTool.setStatusText(string);
        }
    }

    public synchronized void setExpandedIcon(Icon icon) {
        Icon icon2;
        if (this.m_jlist != null && (icon2 = this.m_jlist.getExpandedIcon()) != icon) {
            this.m_jlist.setExpandedIcon(icon);
            this.firePropertyChange("ExpandedIcon", icon2, icon);
        }
    }

    public Icon getExpandedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getExpandedIcon();
        }
        return icon;
    }

    public synchronized void setCollapsedIcon(Icon icon) {
        Icon icon2;
        if (this.m_jlist != null && (icon2 = this.m_jlist.getCollapsedIcon()) != icon) {
            this.m_jlist.setCollapsedIcon(icon);
            this.firePropertyChange("CollapsedIcon", icon2, icon);
        }
    }

    public Icon getCollapsedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getCollapsedIcon();
        }
        return icon;
    }

    public synchronized void setOpenedIcon(Icon icon) {
        Icon icon2;
        if (this.m_jlist != null && (icon2 = this.m_jlist.getOpenedIcon()) != icon) {
            this.m_jlist.setOpenedIcon(icon);
            this.firePropertyChange("OpenedIcon", icon2, icon);
        }
    }

    public Icon getOpenedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getOpenedIcon();
        }
        return icon;
    }

    public synchronized void setClosedIcon(Icon icon) {
        Icon icon2;
        if (this.m_jlist != null && (icon2 = this.m_jlist.getClosedIcon()) != icon) {
            this.m_jlist.setClosedIcon(icon);
            this.firePropertyChange("ClosedIcon", icon2, icon);
        }
    }

    public Icon getClosedIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getClosedIcon();
        }
        return icon;
    }

    public synchronized void setNodeIcon(Icon icon) {
        Icon icon2;
        if (this.m_jlist != null && (icon2 = this.m_jlist.getNodeIcon()) != icon) {
            this.m_jlist.setNodeIcon(icon);
            this.firePropertyChange("NodeIcon", icon2, icon);
        }
    }

    public Icon getNodeIcon() {
        Icon icon = null;
        if (this.m_jlist != null) {
            icon = this.m_jlist.getNodeIcon();
        }
        return icon;
    }

    public synchronized void setExpandAllIcon(Icon icon) {
        DimensionUtil dimensionUtil = new DimensionUtil();
        Icon icon2 = this.m_expandAllIcon;
        try {
            this.m_expandAllIcon = icon != null ? icon : new ImageIcon(dimensionUtil.getImageResource("images/minuses.gif", true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (icon2 != this.m_expandAllIcon) {
            this.firePropertyChange("ExpandAllIcon", icon2, this.m_expandAllIcon);
            this.updateToolbar();
        }
    }

    public Icon getExpandAllIcon() {
        return this.m_expandAllIcon;
    }

    public synchronized void setCollapseAllIcon(Icon icon) {
        DimensionUtil dimensionUtil = new DimensionUtil();
        Icon icon2 = this.m_collapseAllIcon;
        try {
            this.m_collapseAllIcon = icon != null ? icon : new ImageIcon(dimensionUtil.getImageResource("images/pluses.gif", true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (icon2 != this.m_collapseAllIcon) {
            this.firePropertyChange("CollapseAllIcon", icon2, this.m_collapseAllIcon);
            this.updateToolbar();
        }
    }

    public Icon getCollapseAllIcon() {
        return this.m_collapseAllIcon;
    }

    public synchronized void setFindIcon(Icon icon) {
        DimensionUtil dimensionUtil = new DimensionUtil();
        Icon icon2 = this.m_findIcon;
        try {
            this.m_findIcon = icon != null ? icon : new ImageIcon(dimensionUtil.getImageResource("images/find.gif", true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (icon2 != this.m_findIcon) {
            this.firePropertyChange("FindIcon", icon2, this.m_findIcon);
            this.updateToolbar();
        }
    }

    public Icon getFindIcon() {
        return this.m_findIcon;
    }

    protected synchronized void setDataModel(DimListDataModel dimListDataModel) {
        this.m_dataModel.removeListDataListener(this);
        if (dimListDataModel == null) {
            this.m_jlist.setModel(this.m_dataModel);
            this.m_jlist.setPrototypeCellValue("RSTLENWy");
            this.m_dataModel.addListDataListener(this);
        } else {
            this.m_jlist.setModel(dimListDataModel);
            dimListDataModel.addListDataListener(this);
        }
        this.updateCountLabel();
    }

    protected DimListDataModel getDataModel() {
        return (DimListDataModel)this.m_jlist.getModel();
    }

    protected String getIntlString(String string) {
        String string2;
        if (m_localStrings == null) {
            return string;
        }
        try {
            string2 = m_localStrings.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            String string3 = string;
            return string3;
        }
        return string2;
    }

    protected void updateCountLabel() {
        int[] nArray = this.m_jlist.getSelectedIndices();
        int n = nArray == null ? 0 : nArray.length;
        int n2 = this.getCount();
        if (n2 < 1) {
            n = 0;
        }
        String string = Integer.toString(n);
        String string2 = Integer.toString(n2);
        String[] stringArray = new String[]{string, string2};
        MessageFormat messageFormat = new MessageFormat(this.getIntlString("countLabel"));
        this.m_countLabel.setText(messageFormat.format(stringArray));
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.m_content = new JPanel();
        if (m_localStrings == null) {
            try {
                m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle");
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
                m_localStrings = null;
            }
        }
        this.m_textFound = new String(this.getIntlString("foundText"));
        this.m_textNotFound = new String(this.getIntlString("notFoundText"));
        this.m_pnlDescription = new JPanel(new BorderLayout());
        this.m_lblMembers = new JLabel();
        this.m_countLabel = new JLabel(this.getIntlString("itemsNbr"));
        this.m_dataModel = new DefaultListDataModel();
        this.m_jlist = new DimensionList();
        this.m_jscrolllist = new LazyScrollPane(this.m_jlist);
        this.m_jlist.addListSelectionListener(this);
        this.m_jlist.requestDefaultFocus();
        this.setDataModel(null);
        this.createToolbar();
        this.m_internalLayout = true;
        this.m_content.setLayout(new BorderLayout());
        this.m_internalLayout = false;
        this.m_content.add((Component)this.m_jscrolllist, "Center");
        this.add((Component)this.m_content, "Center");
    }

    private boolean initDataAccessDataSource() {
        boolean bl = false;
        this.m_listModel = new DataAccessDimensionModel();
        if (this.m_listModel != null && this.m_jlist != null) {
            this.m_jlist.setModel(this.m_listModel);
            bl = true;
        }
        return bl;
    }

    private void createToolbar() {
        Insets insets = new Insets(0, 2, 0, 2);
        this.setExpandAllIcon(null);
        this.setCollapseAllIcon(null);
        this.setFindIcon(null);
        this.m_btnCollapse = new JButton();
        this.m_btnExpand = new JButton();
        this.m_btnFind = new JButton();
        this.m_btnCollapse.setMargin(insets);
        this.m_btnExpand.setMargin(insets);
        this.m_btnFind.setMargin(insets);
        this.m_btnCollapse.setToolTipText(this.getIntlString("collapseAllTip"));
        this.m_btnExpand.setToolTipText(this.getIntlString("expandAllTip"));
        this.m_btnFind.setToolTipText(this.getIntlString("findTip"));
        this.m_btnCollapse.addActionListener(this);
        this.m_btnExpand.addActionListener(this);
        this.m_btnFind.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.m_btnCollapse);
        jPanel.add(this.m_btnExpand);
        jPanel.add(this.m_btnFind);
        this.m_toolbar = new JPanel();
        this.m_toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_toolbar.setLayout(new BorderLayout());
        this.m_toolbar.add((Component)jPanel, "West");
        this.updateToolbar();
    }

    protected void updateToolbar() {
        if (this.m_toolbar != null) {
            this.m_btnCollapse.setIcon(this.m_expandAllIcon);
            this.m_btnExpand.setIcon(this.m_collapseAllIcon);
            this.m_btnFind.setIcon(this.m_findIcon);
            this.m_toolbar.repaint();
        }
    }

    private void addToolbar() {
        this.m_content.remove(this.m_toolbar);
        if (this.m_showToolbar) {
            this.m_content.add((Component)this.m_toolbar, "South");
        }
        this.revalidate();
    }

    protected String getMemberLabel() {
        return this.getIntlString("membersLabel");
    }

    private void addCountLabel() {
        this.m_pnlDescription.remove(this.m_lblMembers);
        this.m_pnlDescription.remove(this.m_countLabel);
        this.m_content.remove(this.m_pnlDescription);
        if (this.m_showCount) {
            this.m_lblMembers.setText(StringUtils.stripMnemonic((String)this.getMemberLabel()));
            this.m_lblMembers.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.getMemberLabel()));
            this.m_lblMembers.setLabelFor(this.m_jlist);
            this.m_pnlDescription.add((Component)this.m_lblMembers, "Center");
            this.m_pnlDescription.add((Component)this.m_countLabel, "East");
            this.m_content.add((Component)this.m_pnlDescription, "North");
        }
        this.revalidate();
    }

    public void setModel(DataAccessDimensionModel dataAccessDimensionModel) {
        this.m_listModel = dataAccessDimensionModel;
        if (this.m_labelType != null) {
            this.m_listModel.setLabelType(this.m_labelType);
        }
    }

    public String getDimension() {
        return this.m_strDimension;
    }

    public void setDimension(String string) {
        this.m_strDimension = string;
    }

    public String getHierarchy() {
        return this.m_strHierarchy;
    }

    public void setHierarchy(String string) {
        this.m_strHierarchy = string;
    }

    public boolean isHierarchical() {
        return this.m_blnIsHierarchical;
    }

    public void setHierarchical(boolean bl) {
        this.m_blnIsHierarchical = bl;
    }

    public void initDimensionListPanel(String string, DataAccessDimensionModel dataAccessDimensionModel, boolean bl) {
        this.setDimension(string);
        this.setHierarchical(bl);
        this.setModel(dataAccessDimensionModel);
        this.setCountLabelVisible(true);
        this.setToolbarVisible(false);
        this.getDimensionList().setContextIconVisible(true);
        this.updateDimensionListModel();
        this.getDimensionList().doExpandAll();
    }

    public Vector getSelectedMembers(boolean bl) {
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = this.getDimensionList().getSelectedValues();
        int n = 0;
        while (n < objectArray.length) {
            DefaultListDataItem defaultListDataItem = (DefaultListDataItem)objectArray[n];
            vector.addElement(bl ? defaultListDataItem.getDescription() : defaultListDataItem.getValue());
            ++n;
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public Vector getSelectedMembers() {
        return this.getSelectedMembers(false);
    }

    public String getSelectedMember() {
        String string = null;
        Vector vector = this.getSelectedMembers();
        if (vector != null && vector.size() > 0) {
            string = vector.firstElement().toString();
        }
        return string;
    }

    public void updateDimensionListModel() {
        if (this.m_strDimension != null) {
            if (this.m_listModel == null) {
                this.m_listModel = new DataAccessDimensionModel();
                this.m_listModel.setHierarchical(this.m_blnIsHierarchical);
            }
            this.m_listModel.setDimensionName(this.m_strDimension);
            this.getDimensionList().setModel(this.m_listModel);
            this.setDimListDrillIcons();
        }
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = locale;
        m_localStrings = ResourceBundle.getBundle("oracle.dss.util.dimensionList.resource.DimensionListBundle", locale);
        this.updateResources();
    }

    private void updateResources() {
        this.m_btnCollapse.setToolTipText(this.getIntlString("collapseAllTip"));
        this.m_btnExpand.setToolTipText(this.getIntlString("expandAllTip"));
        this.m_btnFind.setToolTipText(this.getIntlString("findTip"));
        this.m_textFound = new String(this.getIntlString("foundText"));
        this.m_textNotFound = new String(this.getIntlString("notFoundText"));
        this.addCountLabel();
        this.updateCountLabel();
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setSelectionMode(int n) {
        this.m_jlist.setSelectionMode(n);
    }

    public LazyScrollPane getScrollPane() {
        return this.m_jscrolllist;
    }

    public JPanel getToolbar() {
        return this.m_toolbar;
    }

    protected void setDimListDrillIcons() {
        if (this.getDimensionList() != null) {
            this.getDimensionList().setExpandedIcon(this.m_iconExpanded);
            this.getDimensionList().setCollapsedIcon(this.m_iconCollapsed);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004 && !this.m_blnFromMouseEvent) {
            this.getDimensionList().requestFocus();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        this.m_blnFromMouseEvent = true;
        super.processMouseEvent(mouseEvent);
        this.m_blnFromMouseEvent = false;
    }
}

