/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.io.Serializable;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.model3d.Matrix3d;

public final class Matrix4d
implements Serializable {
    public static final int ROT_X = 0;
    public static final int ROT_Y = 1;
    public static final int ROT_Z = 2;
    public double m00;
    public double m01;
    public double m02;
    public double m03;
    public double m10;
    public double m11;
    public double m12;
    public double m13;
    public double m20;
    public double m21;
    public double m22;
    public double m23;
    public double m30;
    public double m31;
    public double m32;
    public double m33;

    public Matrix4d() {
        this(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix4d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public Matrix4d(int n, double d) {
        this();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        switch (n) {
            case 0: {
                this.m11 = d2;
                this.m12 = d3;
                this.m21 = -d3;
                this.m22 = d2;
                break;
            }
            case 1: {
                this.m00 = d2;
                this.m02 = -d3;
                this.m20 = d3;
                this.m22 = d2;
                break;
            }
            case 2: {
                this.m00 = d2;
                this.m01 = d3;
                this.m10 = -d3;
                this.m11 = d2;
                break;
            }
            default: {
                throw new AssertionException(String.valueOf(String.valueOf("unknown type of rotation matrix")) + n);
            }
        }
    }

    public Matrix4d(Matrix3d matrix3d) {
        this(matrix3d.m00, matrix3d.m01, matrix3d.m02, 0.0, matrix3d.m10, matrix3d.m11, matrix3d.m12, 0.0, matrix3d.m20, matrix3d.m21, matrix3d.m22, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix4d(Matrix4d matrix4d) {
        this(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33);
    }

    public Matrix3d getMatrix3d() {
        Matrix3d matrix3d = new Matrix3d(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        return matrix3d;
    }

    public void identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m03 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m13 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        this.m23 = 0.0;
        this.m30 = 0.0;
        this.m31 = 0.0;
        this.m32 = 0.0;
        this.m33 = 1.0;
    }

    public void mult(Matrix3d matrix3d) {
        double d = this.m00 * matrix3d.m00 + this.m01 * matrix3d.m10 + this.m02 * matrix3d.m20;
        double d2 = this.m00 * matrix3d.m01 + this.m01 * matrix3d.m11 + this.m02 * matrix3d.m21;
        double d3 = this.m00 * matrix3d.m02 + this.m01 * matrix3d.m12 + this.m02 * matrix3d.m22;
        double d4 = this.m10 * matrix3d.m00 + this.m11 * matrix3d.m10 + this.m12 * matrix3d.m20;
        double d5 = this.m10 * matrix3d.m01 + this.m11 * matrix3d.m11 + this.m12 * matrix3d.m21;
        double d6 = this.m10 * matrix3d.m02 + this.m11 * matrix3d.m12 + this.m12 * matrix3d.m22;
        double d7 = this.m20 * matrix3d.m00 + this.m21 * matrix3d.m10 + this.m22 * matrix3d.m20;
        double d8 = this.m20 * matrix3d.m01 + this.m21 * matrix3d.m11 + this.m22 * matrix3d.m21;
        double d9 = this.m20 * matrix3d.m02 + this.m21 * matrix3d.m12 + this.m22 * matrix3d.m22;
        double d10 = this.m30 * matrix3d.m00 + this.m31 * matrix3d.m10 + this.m32 * matrix3d.m20;
        double d11 = this.m30 * matrix3d.m01 + this.m31 * matrix3d.m11 + this.m32 * matrix3d.m21;
        double d12 = this.m30 * matrix3d.m02 + this.m31 * matrix3d.m12 + this.m32 * matrix3d.m22;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
        this.m30 = d10;
        this.m31 = d11;
        this.m32 = d12;
    }

    public void mult(Matrix4d matrix4d) {
        double d = this.m00 * matrix4d.m00 + this.m01 * matrix4d.m10 + this.m02 * matrix4d.m20 + this.m03 * matrix4d.m30;
        double d2 = this.m00 * matrix4d.m01 + this.m01 * matrix4d.m11 + this.m02 * matrix4d.m21 + this.m03 * matrix4d.m31;
        double d3 = this.m00 * matrix4d.m02 + this.m01 * matrix4d.m12 + this.m02 * matrix4d.m22 + this.m03 * matrix4d.m32;
        double d4 = this.m00 * matrix4d.m03 + this.m01 * matrix4d.m13 + this.m02 * matrix4d.m23 + this.m03 * matrix4d.m33;
        double d5 = this.m10 * matrix4d.m00 + this.m11 * matrix4d.m10 + this.m12 * matrix4d.m20 + this.m13 * matrix4d.m30;
        double d6 = this.m10 * matrix4d.m01 + this.m11 * matrix4d.m11 + this.m12 * matrix4d.m21 + this.m13 * matrix4d.m31;
        double d7 = this.m10 * matrix4d.m02 + this.m11 * matrix4d.m12 + this.m12 * matrix4d.m22 + this.m13 * matrix4d.m32;
        double d8 = this.m10 * matrix4d.m03 + this.m11 * matrix4d.m13 + this.m12 * matrix4d.m23 + this.m13 * matrix4d.m33;
        double d9 = this.m20 * matrix4d.m00 + this.m21 * matrix4d.m10 + this.m22 * matrix4d.m20 + this.m23 * matrix4d.m30;
        double d10 = this.m20 * matrix4d.m01 + this.m21 * matrix4d.m11 + this.m22 * matrix4d.m21 + this.m23 * matrix4d.m31;
        double d11 = this.m20 * matrix4d.m02 + this.m21 * matrix4d.m12 + this.m22 * matrix4d.m22 + this.m23 * matrix4d.m32;
        double d12 = this.m20 * matrix4d.m03 + this.m21 * matrix4d.m13 + this.m22 * matrix4d.m23 + this.m23 * matrix4d.m33;
        double d13 = this.m30 * matrix4d.m00 + this.m31 * matrix4d.m10 + this.m32 * matrix4d.m20 + this.m33 * matrix4d.m30;
        double d14 = this.m30 * matrix4d.m01 + this.m31 * matrix4d.m11 + this.m32 * matrix4d.m21 + this.m33 * matrix4d.m31;
        double d15 = this.m30 * matrix4d.m02 + this.m31 * matrix4d.m12 + this.m32 * matrix4d.m22 + this.m33 * matrix4d.m32;
        double d16 = this.m30 * matrix4d.m03 + this.m31 * matrix4d.m13 + this.m32 * matrix4d.m23 + this.m33 * matrix4d.m33;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m03 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m13 = d8;
        this.m20 = d9;
        this.m21 = d10;
        this.m22 = d11;
        this.m23 = d12;
        this.m30 = d13;
        this.m31 = d14;
        this.m32 = d15;
        this.m33 = d16;
    }

    public Matrix4d multBy(Matrix4d matrix4d) {
        Matrix4d matrix4d2 = new Matrix4d(this.m00 * matrix4d.m00 + this.m01 * matrix4d.m10 + this.m02 * matrix4d.m20 + this.m03 * matrix4d.m30, this.m00 * matrix4d.m01 + this.m01 * matrix4d.m11 + this.m02 * matrix4d.m21 + this.m03 * matrix4d.m31, this.m00 * matrix4d.m02 + this.m01 * matrix4d.m12 + this.m02 * matrix4d.m22 + this.m03 * matrix4d.m32, this.m00 * matrix4d.m03 + this.m01 * matrix4d.m13 + this.m02 * matrix4d.m23 + this.m03 * matrix4d.m33, this.m10 * matrix4d.m00 + this.m11 * matrix4d.m10 + this.m12 * matrix4d.m20 + this.m13 * matrix4d.m30, this.m10 * matrix4d.m01 + this.m11 * matrix4d.m11 + this.m12 * matrix4d.m21 + this.m13 * matrix4d.m31, this.m10 * matrix4d.m02 + this.m11 * matrix4d.m12 + this.m12 * matrix4d.m22 + this.m13 * matrix4d.m32, this.m10 * matrix4d.m03 + this.m11 * matrix4d.m13 + this.m12 * matrix4d.m23 + this.m13 * matrix4d.m33, this.m20 * matrix4d.m00 + this.m21 * matrix4d.m10 + this.m22 * matrix4d.m20 + this.m23 * matrix4d.m30, this.m20 * matrix4d.m01 + this.m21 * matrix4d.m11 + this.m22 * matrix4d.m21 + this.m23 * matrix4d.m31, this.m20 * matrix4d.m02 + this.m21 * matrix4d.m12 + this.m22 * matrix4d.m22 + this.m23 * matrix4d.m32, this.m20 * matrix4d.m03 + this.m21 * matrix4d.m13 + this.m22 * matrix4d.m23 + this.m23 * matrix4d.m33, this.m30 * matrix4d.m00 + this.m31 * matrix4d.m10 + this.m32 * matrix4d.m20 + this.m33 * matrix4d.m30, this.m30 * matrix4d.m01 + this.m31 * matrix4d.m11 + this.m32 * matrix4d.m21 + this.m33 * matrix4d.m31, this.m30 * matrix4d.m02 + this.m31 * matrix4d.m12 + this.m32 * matrix4d.m22 + this.m33 * matrix4d.m32, this.m30 * matrix4d.m03 + this.m31 * matrix4d.m13 + this.m32 * matrix4d.m23 + this.m33 * matrix4d.m33);
        return matrix4d2;
    }

    public void rotate(Matrix3d matrix3d) {
        this.mult(matrix3d);
    }

    public void scale(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
    }

    public void translate(double d, double d2, double d3) {
        this.m30 += d;
        this.m31 += d2;
        this.m32 += d3;
    }

    public Matrix4d transpose() {
        Matrix4d matrix4d = new Matrix4d(this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33);
        return matrix4d;
    }
}

