/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.LookKeyObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.TDGToken;
import oracle.dss.graph.pfj.TDGTokenizer;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Matrix3d;

public class TDGProperties
extends HashMap
implements Serializable {
    Perspective m_Perspective;
    String m_ChartObjectName;
    public static final int NB_IDENTOBJ_PARAMS = 6;
    IdentObj m_identObj = new IdentObj(-3);
    String m_szMethodName;
    String m_szParamObj;
    public static final int ANY_EXPECTED = 0;
    public static final int NEXTPARAM_EXPECTED = 1;
    public static final int SEPARATOR_EXPECTED = 2;
    public static final int OPEN_PARENTHESES_EXPECTED = 3;
    Vector m_Tokens = new Vector();
    int m_nIndex;
    TDGToken m_Token;
    Method[] m_Methods;
    int m_nCurrentSeries;
    FileOutputStream m_fos;
    boolean m_bDebugToFile;
    boolean m_bDebugToConsole;
    static final char LINEBREAK = '\n';

    public TDGProperties(Perspective perspective) {
        super(400);
        this.m_Perspective = perspective;
        this.m_bDebugToFile = false;
        this.m_bDebugToConsole = false;
        if (this.m_bDebugToFile) {
            try {
                this.m_fos = new FileOutputStream("debug.log");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private boolean parseObject(Object object) {
        boolean bl = true;
        if (object.getClass().getName().equals("java.lang.Integer") || object.getClass().getName().equals("java.lang.Double") || object.getClass().getName().equals("java.lang.Boolean")) {
            this.m_szParamObj = object.toString();
        } else if (object.getClass().getName().equals("java.lang.String")) {
            this.m_szParamObj = String.valueOf(String.valueOf("\"")) + object.toString() + "\"";
            this.m_szParamObj = TDGProperties.ReplaceMacro(this.m_szParamObj, "\n", "\\n");
        } else if (object.getClass().getName().equals("java.awt.Color")) {
            Color color = (Color)object;
            Integer n = new Integer(color.getRed());
            Integer n2 = new Integer(color.getGreen());
            Integer n3 = new Integer(color.getBlue());
            this.m_szParamObj = String.valueOf(String.valueOf("new Color(")) + n.toString() + "," + n2.toString() + "," + n3.toString() + ")";
        } else if (object.getClass().getName().equals("java.awt.Rectangle")) {
            Rectangle rectangle = (Rectangle)object;
            Integer n = new Integer(rectangle.x);
            Integer n4 = new Integer(rectangle.y);
            Integer n5 = new Integer(rectangle.width);
            Integer n6 = new Integer(rectangle.height);
            this.m_szParamObj = String.valueOf(String.valueOf("new Rectangle(")) + n.toString() + "," + n4.toString() + "," + n5.toString() + "," + n6.toString() + ")";
        } else if (object.getClass().getName().equals("oracle.dss.graph.pfj.model3d.Matrix3d")) {
            Matrix3d matrix3d = (Matrix3d)object;
            Double d = new Double(matrix3d.m00);
            Double d2 = new Double(matrix3d.m01);
            Double d3 = new Double(matrix3d.m02);
            Double d4 = new Double(matrix3d.m10);
            Double d5 = new Double(matrix3d.m11);
            Double d6 = new Double(matrix3d.m12);
            Double d7 = new Double(matrix3d.m20);
            Double d8 = new Double(matrix3d.m21);
            Double d9 = new Double(matrix3d.m22);
            this.m_szParamObj = String.valueOf(d.toString()) + "," + d2.toString() + "," + d3.toString() + "," + d4.toString() + "," + d5.toString() + "," + d6.toString() + "," + d7.toString() + "," + d8.toString() + "," + d9.toString();
        } else {
            bl = false;
        }
        return bl;
    }

    private void parseKey(LookKeyObj lookKeyObj) {
        boolean bl = false;
        this.m_szMethodName = lookKeyObj.getAttr().toString();
        this.m_identObj = lookKeyObj.getIdentObj();
    }

    private void writeLine(OutputStream outputStream) throws IOException {
        String string;
        if (this.isProperty()) {
            string = this.m_ChartObjectName.equals("") ? String.valueOf(String.valueOf("set")) + this.m_szMethodName + "(" + this.m_szParamObj + ");\r\n" : String.valueOf(this.m_ChartObjectName) + ".set" + this.m_szMethodName + "(" + this.m_szParamObj + ");\r\n";
        } else {
            String string2;
            String string3 = this.m_identObj.getIdentObjMethod();
            if (!this.m_identObj.isMISC_NA()) {
                Integer n = new Integer(this.m_identObj.getMiscID());
                string2 = String.valueOf(String.valueOf(",")) + n.toString();
            } else {
                string2 = "";
            }
            string = string3.equals("GLOBAL_SCALAR_PROPERTY") ? String.valueOf(String.valueOf("set")) + this.m_szMethodName + "(" + this.m_szParamObj + string2 + ");\r\n" : (this.m_ChartObjectName.equals("") ? String.valueOf(String.valueOf("set")) + this.m_szMethodName + "(" + string3 + "," + this.m_szParamObj + string2 + ");\r\n" : String.valueOf(this.m_ChartObjectName) + ".set" + this.m_szMethodName + "(" + this.m_ChartObjectName + "." + string3 + "," + this.m_szParamObj + string2 + ");\r\n");
        }
        outputStream.write(string.getBytes());
    }

    private boolean isProperty() {
        return this.m_identObj.isOBJECT_NA() && this.m_identObj.isSERIES_NA() && this.m_identObj.isGROUP_NA() && this.m_identObj.isSTACK_NA() && this.m_identObj.isMISC_NA();
    }

    public void save(OutputStream outputStream, String string) throws IOException {
        this.m_ChartObjectName = string;
    }

    public void save(OutputStream outputStream) throws IOException {
        this.m_ChartObjectName = "";
    }

    public void _save(OutputStream outputStream) throws IOException {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String string = k.getClass().getName();
            if (string.equals("java.lang.String")) continue;
            LookKeyObj lookKeyObj = (LookKeyObj)k;
            Object v = this.get(lookKeyObj);
            this.debugPrintln(String.valueOf(String.valueOf("key = ")) + lookKeyObj);
            this.parseKey(lookKeyObj);
            if (this.parseObject(v)) {
                this.debugPrintln(String.valueOf(String.valueOf("Parameter = ")) + this.m_szParamObj);
                this.writeLine(outputStream);
                continue;
            }
            this.debugPrintln(String.valueOf(String.valueOf("saving of : ")) + this.m_szMethodName + " object : " + v.getClass().getName() + " failed!!!!!!!!!");
        }
    }

    public void load(InputStream inputStream) {
        inputStream = this.initialization(inputStream, this.m_Perspective.getClass());
        this.parsePass1(inputStream);
        if (this.m_bDebugToFile || this.m_bDebugToConsole) {
            Enumeration enumeration = this.m_Tokens.elements();
            while (enumeration.hasMoreElements()) {
                TDGToken tDGToken = (TDGToken)enumeration.nextElement();
                String string = tDGToken.toString();
                this.debugPrintln(string);
            }
        }
        this.parsePass2();
    }

    private void parsePass1(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        TDGTokenizer tDGTokenizer = new TDGTokenizer(bufferedReader);
        int n = 1;
        tDGTokenizer.resetSyntax();
        tDGTokenizer.wordChars(97, 122);
        tDGTokenizer.wordChars(65, 90);
        tDGTokenizer.wordChars(160, 255);
        tDGTokenizer.whitespaceChars(0, 32);
        tDGTokenizer.slashStarComments(true);
        tDGTokenizer.quoteChar(34);
        tDGTokenizer.parseNumbers();
        this.m_Tokens.removeAllElements();
        try {
            do {
                TDGToken tDGToken = null;
                switch (tDGTokenizer.nextToken()) {
                    case -3: {
                        String string = tDGTokenizer.sval;
                        if (string.equals("new")) {
                            tDGToken = new TDGToken(1);
                            n = 1;
                            break;
                        }
                        if (string.equals("true")) {
                            tDGToken = new TDGToken(2, Boolean.TRUE);
                            n = 2;
                            break;
                        }
                        if (string.equals("false")) {
                            tDGToken = new TDGToken(2, Boolean.FALSE);
                            n = 2;
                            break;
                        }
                        if (string.equals("null")) {
                            tDGToken = new TDGToken(10);
                            n = 2;
                            break;
                        }
                        tDGToken = new TDGToken(3, string);
                        n = 3;
                        break;
                    }
                    case 40: {
                        tDGToken = new TDGToken(4);
                        n = 1;
                        break;
                    }
                    case 41: {
                        tDGToken = new TDGToken(5);
                        n = 2;
                        break;
                    }
                    case 59: {
                        tDGToken = new TDGToken(6);
                        n = 1;
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 44: {
                        tDGToken = new TDGToken(7);
                        n = 1;
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 34: {
                        String string = tDGTokenizer.sval;
                        string = TDGProperties.ReplaceMacro(string, "\\n", "\n");
                        string = TDGProperties.ReplaceMacro(string, "[QUOTE]", "'");
                        string = this.UnicodeTranslation(string);
                        tDGToken = new TDGToken(8, string);
                        n = 2;
                        break;
                    }
                    case -2: {
                        tDGToken = new TDGToken(9, new Double(tDGTokenizer.nval));
                        n = 2;
                        break;
                    }
                    default: {
                        this.debugPrintln(String.valueOf(String.valueOf("st.ttype = ")) + tDGTokenizer.ttype);
                        this.debugPrintln(String.valueOf(String.valueOf("Unknown String ->[")) + tDGTokenizer.sval + "]");
                        this.debugPrintln(String.valueOf(String.valueOf("Unknown Number ->[")) + tDGTokenizer.nval + "]");
                    }
                }
                if (tDGToken == null) continue;
                this.m_Tokens.addElement(tDGToken);
            } while (tDGTokenizer.ttype != -1);
            inputStream.close();
        }
        catch (Exception exception) {
            this.debugPrintln("Exception in parsePass1");
            exception.printStackTrace();
        }
    }

    private void parsePass2() {
        this.m_nIndex = 0;
        while (this.m_nIndex < this.m_Tokens.size()) {
            this.parseParameter();
            this.m_Token = this.getToken(1);
            if (this.m_Token == null) {
                this.debugPrintln(";");
                this.debugPrintln("Parsing Done");
                break;
            }
            if (this.m_Token.getType() == 6) {
                this.debugPrintln(";");
            } else {
                this.debugPrintln("Wrong token encountered");
                while (this.m_nIndex < this.m_Tokens.size() && this.m_Token.getType() != 6) {
                    this.m_Token = this.getToken(1);
                }
            }
            this.m_Token = this.getToken(1);
        }
    }

    private Object parseParameter() {
        this.debugPrint("[");
        Vector<Object> vector = new Vector<Object>();
        this.m_Token = this.getToken(0);
        switch (this.m_Token.getType()) {
            case 1: {
                this.m_Token = this.getToken(1);
                if (this.m_Token == null || this.m_Token.getType() != 3) {
                    return null;
                }
                String string = (String)this.m_Token.getObject();
                this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.m_Token = this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.debugPrint(String.valueOf(String.valueOf("new ")) + string + "(");
                while (this.m_Token.isNewParameter()) {
                    vector.addElement(this.parseParameter());
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    if (this.m_Token.getType() != 7) continue;
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    this.debugPrint(",");
                }
                if (this.m_Token.getType() != 5) {
                    throw new AssertionException("Parser Error: open parentheses expected");
                }
                this.debugPrint(")");
                return this.invokeConstructor(string, vector);
            }
            case 3: {
                String string = (String)this.m_Token.getObject();
                this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.m_Token = this.getToken(1);
                if (this.m_Token == null) {
                    return null;
                }
                this.debugPrint(String.valueOf(string) + "(");
                while (this.m_Token.isNewParameter()) {
                    vector.addElement(this.parseParameter());
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    if (this.m_Token.getType() != 7) continue;
                    this.m_Token = this.getToken(1);
                    if (this.m_Token == null) {
                        return null;
                    }
                    this.debugPrint(",");
                }
                if (this.m_Token.getType() != 5) {
                    return null;
                }
                this.debugPrint(")");
                return this.invokeMethod(string, vector);
            }
            case 2: 
            case 8: 
            case 9: {
                this.debugPrint(String.valueOf(this.m_Token.getObject().toString()) + "]");
                return this.m_Token.getObject();
            }
            case 10: {
                this.debugPrint("NULL]");
                return null;
            }
        }
        return null;
    }

    private TDGToken getToken(int n) {
        if (this.m_nIndex + n < this.m_Tokens.size()) {
            this.m_nIndex += n;
            TDGToken tDGToken = (TDGToken)this.m_Tokens.elementAt(this.m_nIndex);
            return tDGToken;
        }
        return null;
    }

    private Object invokeMethod(String string, Vector vector) {
        Object object;
        boolean bl = false;
        Object object2 = null;
        Object[] objectArray = new Object[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            objectArray[n] = vector.elementAt(n);
            ++n;
        }
        n = 0;
        while (n < this.m_Methods.length) {
            if (this.m_Methods[n].getName().equals(string)) {
                object = this.m_Methods[n].getParameterTypes();
                if (vector.size() == ((Class<?>[])object).length) {
                    int n2 = 0;
                    while (n2 < ((Class<?>[])object).length) {
                        if (objectArray[n2] == null) {
                            return null;
                        }
                        if (((Class)object[n2]).getName().equals("int") && objectArray[n2].getClass().getName().equals("java.lang.Double")) {
                            objectArray[n2] = new Integer(((Double)objectArray[n2]).intValue());
                        }
                        ++n2;
                    }
                    try {
                        object2 = this.m_Methods[n].invoke((Object)this.m_Perspective, objectArray);
                        bl = true;
                        break;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        if (!bl) {
            if (string.equals("setSeriesLabelArray")) {
                n = 0;
                while (n < vector.size()) {
                    object = vector.elementAt(n);
                    if (object instanceof String) {
                        this.m_Perspective.setSeriesLabel(n, (String)object);
                    }
                    ++n;
                }
                bl = true;
            } else if (string.equals("setGroupLabelArray")) {
                n = 0;
                while (n < vector.size()) {
                    object = vector.elementAt(n);
                    if (object instanceof String) {
                        this.m_Perspective.setGroupLabel(n, (String)object);
                    }
                    ++n;
                }
                bl = true;
            } else if (string.equals("setDataSeries")) {
                n = 0;
                while (n < vector.size()) {
                    object = vector.elementAt(n);
                    if (object == null || object.getClass().getName().equals("java.lang.Double") || object.getClass().getName().equals("java.lang.String")) {
                        this.m_Perspective.setData(this.m_nCurrentSeries, n, object);
                    }
                    ++n;
                }
                ++this.m_nCurrentSeries;
                bl = true;
            }
        }
        if (bl) {
            this.debugPrint("]\"invoke ok\"");
        } else {
            this.debugPrint("]\"invoke failed!!!!!!!!!!!!\"");
        }
        return object2;
    }

    private Object invokeConstructor(String string, Vector vector) {
        Serializable serializable = null;
        Object[] objectArray = new Object[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            objectArray[n] = vector.elementAt(n);
            ++n;
        }
        if (string.equals("Color")) {
            serializable = vector.size() == 1 && objectArray[0].getClass().getName().equals("java.lang.Double") ? new Color(((Double)objectArray[0]).intValue()) : (vector.size() == 3 ? (objectArray[0].getClass().getName().equals("java.lang.Double") && objectArray[1].getClass().getName().equals("java.lang.Double") && objectArray[2].getClass().getName().equals("java.lang.Double") && ((Double)objectArray[0] > 1.0 || (Double)objectArray[1] > 1.0 || (Double)objectArray[2] > 1.0) ? new Color(((Double)objectArray[0]).intValue(), ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue()) : new Color(((Double)objectArray[0]).floatValue(), ((Double)objectArray[1]).floatValue(), ((Double)objectArray[2]).floatValue())) : Color.white);
        } else if (string.equals("Rectangle")) {
            serializable = vector.size() == 4 && objectArray[0].getClass().getName().equals("java.lang.Double") && objectArray[1].getClass().getName().equals("java.lang.Double") && objectArray[2].getClass().getName().equals("java.lang.Double") && objectArray[3].getClass().getName().equals("java.lang.Double") ? new Rectangle(((Double)objectArray[0]).intValue(), ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), ((Double)objectArray[3]).intValue()) : new Rectangle();
        }
        if (serializable != null) {
            this.debugPrint("]\"invoke ok\"");
        } else {
            this.debugPrint("]\"invoke failed!!!!!!!!!!!!\"");
        }
        return serializable;
    }

    public String UnicodeTranslation(String string) {
        int n;
        String string2 = "";
        String string3 = "\\u";
        string2 = string;
        while ((n = string2.indexOf(string3)) != -1) {
            String string4 = string2.substring(0, n);
            string4 = String.valueOf(string4) + this.makeUnicodeChar(string2.substring(n + 2, n + 6));
            string2 = string4 = String.valueOf(string4) + string2.substring(n += string3.length() + 4, string2.length());
        }
        return string2;
    }

    char makeUnicodeChar(String string) {
        string = string.toUpperCase();
        char[] cArray = string.toCharArray();
        int n = this.hex2Int(cArray[3]) + this.hex2Int(cArray[2]) * 16 + this.hex2Int(cArray[1]) * 256 + this.hex2Int(cArray[0]) * 4096;
        char c = (char)n;
        return c;
    }

    int hex2Int(char c) {
        int n = 0;
        switch (c) {
            case '0': {
                n = 0;
                break;
            }
            case '1': {
                n = 1;
                break;
            }
            case '2': {
                n = 2;
                break;
            }
            case '3': {
                n = 3;
                break;
            }
            case '4': {
                n = 4;
                break;
            }
            case '5': {
                n = 5;
                break;
            }
            case '6': {
                n = 6;
                break;
            }
            case '7': {
                n = 7;
                break;
            }
            case '8': {
                n = 8;
                break;
            }
            case '9': {
                n = 9;
                break;
            }
            case 'A': {
                n = 10;
                break;
            }
            case 'B': {
                n = 11;
                break;
            }
            case 'C': {
                n = 12;
                break;
            }
            case 'D': {
                n = 13;
                break;
            }
            case 'E': {
                n = 14;
                break;
            }
            case 'F': {
                n = 15;
            }
        }
        return n;
    }

    public static String ReplaceMacro(String string, String string2, String string3) {
        int n;
        String string4 = "";
        string4 = string;
        while ((n = string4.indexOf(string2)) != -1) {
            String string5 = string4.substring(0, n);
            string5 = String.valueOf(string5) + string3;
            string4 = string5 = String.valueOf(string5) + string4.substring(n += string2.length(), string4.length());
        }
        return string4;
    }

    private InputStream initialization(InputStream inputStream, Class clazz) {
        this.m_nCurrentSeries = 0;
        this.m_Methods = clazz.getMethods();
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = new String(byteArrayOutputStream.toByteArray());
        string = TDGProperties.ReplaceMacro(string, "&quot;", "\"");
        return new ByteArrayInputStream(string.getBytes());
    }

    private void debugPrint(String string) {
        if (this.m_bDebugToConsole) {
            System.out.print(string);
        }
        if (this.m_bDebugToFile) {
            try {
                this.m_fos.write(string.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void debugPrintln(String string) {
        if (this.m_bDebugToConsole) {
            System.out.println(string);
        }
        if (this.m_bDebugToFile) {
            try {
                string = String.valueOf(string) + "\n\r";
                this.m_fos.write(string.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

