/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.DataScroller;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.LegendMarkersLabels;
import oracle.dss.graph.pfj.LegendScroller;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class LegendObj
implements Serializable {
    public static final int LAYOUT_VERT = 0;
    public static final int LAYOUT_HORZ = 1;
    public static final int LAYOUT_AUTO = 2;
    public int BOX_MARGIN_HT;
    public int DOUBLE_BOX_MARGIN_HT;
    public int BOX_MARGIN_W;
    public int DOUBLE_BOX_MARGIN_W;
    protected Perspective m_Perspective;
    protected Detectiv m_Detectiv;
    protected IdentObj m_id;
    protected Access m_Access;
    protected JChart_Base m_Chart;
    protected boolean m_bLegendReverse;
    protected boolean m_nBiDirectionalText;
    protected Rectangle m_rVirtLegendBoxCell;
    protected Rectangle m_rLegendBox;
    protected Dimension m_dimCell;
    protected int m_nLayoutOrient;
    protected boolean m_bAutomatic;
    protected DataScroller m_ScrollerSeries;
    protected LegendScroller m_ScrollerLegend;
    protected boolean m_bDataScrollerActive;
    protected boolean m_bLegendScrollerActive;
    protected int m_nNumberCol;
    protected int m_nNumberRow;
    protected LegendMarkersLabels m_MarkersLabels;
    protected boolean m_bSpectralLegend;

    public LegendObj(Perspective perspective, Access access, JChart_Base jChart_Base, boolean bl) {
        this.m_Perspective = perspective;
        this.m_id = new IdentObj(12);
        this.m_Access = access;
        this.m_Chart = jChart_Base;
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_bSpectralLegend = bl;
        this.BOX_MARGIN_W = this.m_Perspective.getVC().destToVirtWidth(4);
        this.DOUBLE_BOX_MARGIN_W = 2 * this.BOX_MARGIN_W;
        this.BOX_MARGIN_HT = this.m_Perspective.getVC().destToVirtHeight(2);
        this.DOUBLE_BOX_MARGIN_HT = 2 * this.BOX_MARGIN_HT;
        this.m_MarkersLabels = new LegendMarkersLabels(perspective, access, jChart_Base, this);
    }

    public void init() {
        this.m_rLegendBox = this.m_Perspective.getLegendRect();
        this.m_rVirtLegendBoxCell = new Rectangle(this.m_rLegendBox.x, this.m_rLegendBox.y, this.m_rLegendBox.width, this.m_rLegendBox.height);
        this.m_nBiDirectionalText = this.m_Perspective.getBiDirectional();
        this.m_bAutomatic = this.m_Perspective.getLegendAutomatic();
        this.m_bLegendReverse = this.m_Perspective.getLegendReverse();
        this.m_nLayoutOrient = this.m_Perspective.getLegendOrient();
        if (this.m_nLayoutOrient == 2) {
            int n = this.m_nLayoutOrient = this.m_rVirtLegendBoxCell.width > this.m_rVirtLegendBoxCell.height ? 1 : 0;
        }
        if (this.m_nBiDirectionalText && this.m_nLayoutOrient == 1) {
            this.m_bLegendReverse = !this.m_bLegendReverse;
        }
        this.m_MarkersLabels.init();
        this.m_MarkersLabels.loadDrillMarker();
        if (this.m_bSpectralLegend) {
            this.m_MarkersLabels.loadSpectralVectors();
        } else {
            this.m_MarkersLabels.loadSeriesVectors();
        }
        this.m_MarkersLabels.loadReferenceLineVectors();
        if (this.m_bAutomatic) {
            double d = (double)this.m_rVirtLegendBoxCell.height / (double)this.m_rVirtLegendBoxCell.width;
            int n = this.getSeriesCount();
            this.m_nNumberCol = this.getNumColByNumSeriesAndAspectRatio(n, d);
        } else {
            this.m_nNumberCol = this.m_Perspective.getLegendMarkersPerRow();
        }
        if (this.m_nNumberCol <= 0) {
            switch (this.m_nLayoutOrient) {
                case 0: {
                    this.m_nNumberCol = 1;
                    break;
                }
                default: {
                    this.m_nNumberCol = this.getSeriesCount();
                }
            }
        }
        boolean bl = this.m_nLayoutOrient == 0;
        this.m_ScrollerSeries = new DataScroller(this.m_Perspective, this.m_rLegendBox, bl, false);
        this.m_ScrollerLegend = new LegendScroller(this.m_Perspective, this, this.m_rLegendBox, bl);
    }

    protected int getNumColByNumSeriesAndAspectRatio(int n, double d) {
        double d2;
        double d3 = Math.sqrt(n);
        if (d < 1.0) {
            double d4 = 1.0 - d;
            d2 = d3 + d4 * d3;
        } else {
            double d5 = d - 1.0;
            d2 = d3 - d5 * d3;
            if (d2 <= 1.0) {
                d2 = 1.0;
            }
        }
        int n2 = (int)d2;
        return n2;
    }

    public void calc() {
        this.init();
        if (this.m_MarkersLabels.getNumLabels() > 0) {
            this.layoutCells();
            this.m_MarkersLabels.calcMarkerSize();
            this.m_MarkersLabels.calcLabelSize();
            this.calcLegendBox();
            this.m_MarkersLabels.calcMarkers();
            this.m_MarkersLabels.calcLabels();
            if (this.m_bDataScrollerActive) {
                this.m_ScrollerSeries.calc();
            }
            if (this.m_bLegendScrollerActive) {
                this.m_ScrollerLegend.calc();
            }
        }
    }

    public boolean canScrollLegend() {
        boolean bl = this.m_Perspective.getLegendScroll() == 1 && this.m_Perspective.getLegendSeriesCount() != 0;
        boolean bl2 = bl = bl || this.m_Perspective.getLegendScroll() == 2;
        if (this.m_Perspective.getLegendScroll() == 1) {
            bl = bl && this.m_Perspective.getLegendSeriesCount() < this.getNumItemsInLegend();
        }
        bl = bl && !this.m_ScrollerSeries.isPresent();
        return bl;
    }

    private Dimension cellDimFromCols(Dimension dimension, int n) {
        PfjAssert.pfjAssert(n > 0);
        PfjAssert.pfjAssert(this.m_MarkersLabels.getNumLabels() > 0);
        int n2 = this.getNumOfRows(n);
        int n3 = dimension.width / n;
        int n4 = dimension.height / n2;
        Dimension dimension2 = new Dimension(n3, n4);
        return dimension2;
    }

    public int getNumOfRows(int n) {
        int n2 = this.getSeriesCount();
        int n3 = n2 / n;
        int n4 = n2 % n;
        if (n4 != 0) {
            ++n3;
        }
        this.m_nNumberRow = n3;
        return n3;
    }

    public int getNumOfCols() {
        return this.m_nNumberCol;
    }

    public int getNumOfRows() {
        return this.m_nNumberRow;
    }

    public Rectangle getCellRect(int n) {
        int n2;
        int n3;
        int n4 = this.m_rVirtLegendBoxCell.y + this.m_rVirtLegendBoxCell.height;
        switch (this.m_nLayoutOrient) {
            default: {
                n3 = n % this.m_nNumberCol;
                n2 = n / this.m_nNumberCol;
                break;
            }
            case 0: {
                int n5 = this.getNumOfRows(this.m_nNumberCol);
                n3 = n / n5;
                n2 = n % n5;
            }
        }
        int n6 = this.m_rVirtLegendBoxCell.x + this.BOX_MARGIN_W;
        int n7 = n4 - this.BOX_MARGIN_HT - this.m_dimCell.height;
        Rectangle rectangle = new Rectangle(this.m_dimCell);
        rectangle.translate(n6 += n3 * this.m_dimCell.width, n7 -= n2 * this.m_dimCell.height);
        return rectangle;
    }

    public void calcLegendBox() {
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, this.m_id);
        new DetRect(this.m_Detectiv, this.m_id, this.m_rLegendBox.x, this.m_rLegendBox.y, this.m_rLegendBox.width, this.m_rLegendBox.height, blackBoxObj, true, true);
    }

    public boolean isHorz() {
        return this.m_nLayoutOrient == 0;
    }

    public void layoutCells() {
        Dimension dimension = new Dimension(this.m_rVirtLegendBoxCell.width, this.m_rVirtLegendBoxCell.height);
        dimension.width -= this.DOUBLE_BOX_MARGIN_W;
        dimension.height -= this.DOUBLE_BOX_MARGIN_HT;
        this.adjustForDataScroller(dimension);
        this.adjustForLegendScroller(dimension);
        this.m_dimCell = this.cellDimFromCols(dimension, this.m_nNumberCol);
    }

    public void adjustForDataScroller(Rectangle rectangle) {
        boolean bl = this.m_ScrollerSeries.isPresent();
        if (bl) {
            if (this.m_nLayoutOrient == 0) {
                int n = this.m_ScrollerSeries.getScrollerWidthVC();
                if (n < (rectangle.width + n) / 3) {
                    rectangle.width += n;
                    rectangle.x -= n;
                    if (rectangle.x < -16000) {
                        rectangle.x += n;
                    }
                }
            } else {
                int n = this.m_ScrollerSeries.getScrollerHeightVC();
                if (n < (rectangle.height + n) / 3) {
                    rectangle.height += n;
                    rectangle.y -= n;
                }
            }
        }
    }

    public void adjustForLegendScroller(Rectangle rectangle) {
        this.m_bLegendScrollerActive = false;
        if (this.canScrollLegend()) {
            if (this.m_nLayoutOrient == 0) {
                int n = this.m_ScrollerLegend.getScrollerWidthVC();
                if (n < (rectangle.width + n) / 3) {
                    this.m_bLegendScrollerActive = true;
                    rectangle.width += n;
                    rectangle.x -= n;
                    if (rectangle.x < -16000) {
                        rectangle.x += n;
                    }
                }
            } else {
                int n = this.m_ScrollerLegend.getScrollerHeightVC();
                if (n < (rectangle.height + n) / 3) {
                    this.m_bLegendScrollerActive = true;
                    rectangle.height += n;
                    rectangle.y -= n;
                }
            }
        }
    }

    protected void adjustForDataScroller(Dimension dimension) {
        boolean bl = this.m_ScrollerSeries.isPresent();
        this.m_bDataScrollerActive = false;
        if (bl) {
            if (this.m_nLayoutOrient == 0) {
                int n = this.m_ScrollerSeries.getScrollerWidthVC();
                if (n < this.m_rVirtLegendBoxCell.width / 3) {
                    this.m_bDataScrollerActive = true;
                    dimension.width -= n;
                    this.m_rVirtLegendBoxCell.x += n;
                    this.m_rVirtLegendBoxCell.width -= n;
                }
            } else {
                int n = this.m_ScrollerSeries.getScrollerHeightVC();
                if (n < this.m_rVirtLegendBoxCell.height / 3) {
                    this.m_bDataScrollerActive = true;
                    dimension.height -= n;
                    this.m_rVirtLegendBoxCell.y += n;
                    this.m_rVirtLegendBoxCell.height -= n;
                }
            }
        }
    }

    protected void adjustForLegendScroller(Dimension dimension) {
        this.m_bLegendScrollerActive = false;
        if (this.canScrollLegend()) {
            if (this.m_nLayoutOrient == 0) {
                int n = this.m_ScrollerLegend.getScrollerWidthVC();
                if (n < this.m_rVirtLegendBoxCell.width / 3) {
                    this.m_bLegendScrollerActive = true;
                    dimension.width -= n;
                    this.m_rVirtLegendBoxCell.x += n;
                    this.m_rVirtLegendBoxCell.width -= n;
                }
            } else {
                int n = this.m_ScrollerLegend.getScrollerHeightVC();
                if (n < this.m_rVirtLegendBoxCell.height / 3) {
                    this.m_bLegendScrollerActive = true;
                    dimension.height -= n;
                    this.m_rVirtLegendBoxCell.y += n;
                    this.m_rVirtLegendBoxCell.height -= n;
                }
            }
        }
    }

    public int getSeriesStart() {
        int n = 0;
        int n2 = this.m_Perspective.getLegendSeriesCount();
        boolean bl = this.dataScrolling();
        if (n2 != 0 && !this.m_bDataScrollerActive && !bl) {
            int n3;
            int n4;
            n = this.m_Perspective.getLegendSeriesStart();
            if (n > (n4 = (n3 = this.getNumItemsInLegend()) - n2)) {
                n = n4;
            }
            if (n < 0) {
                n = 0;
            }
            if (n >= n3) {
                n = 0;
            }
        }
        return n;
    }

    private boolean dataScrolling() {
        int n = this.m_Perspective.getViewableSeries();
        boolean bl = n > 0 && n < this.getNumItemsInLegend();
        return bl;
    }

    public int getNumItemsInLegend() {
        int n = this.m_MarkersLabels.getNumLabels();
        return n;
    }

    public int getSeriesCount() {
        int n = 0;
        int n2 = this.getSeriesStart();
        int n3 = this.getNumItemsInLegend();
        int n4 = this.m_Perspective.getLegendSeriesCount();
        boolean bl = this.dataScrolling();
        if (n4 == 0 || this.m_bDataScrollerActive || bl) {
            n = n3;
            if ((this.m_bDataScrollerActive || bl) && n4 != 0 && n4 < n) {
                n = n4;
            }
        } else {
            n = n4;
            int n5 = this.getSeriesStart() + n;
            if (n5 >= n3) {
                n = n3 - n2;
            }
        }
        return n;
    }

    public int getSeriesRange() {
        int n;
        int n2 = this.getSeriesStart();
        int n3 = n2 + this.getSeriesCount();
        if (n3 > (n = this.getNumItemsInLegend())) {
            n3 = n;
        }
        return n3;
    }

    public LegendMarkersLabels getMarkersLabels() {
        return this.m_MarkersLabels;
    }

    public boolean getLegendReverse() {
        return this.m_bLegendReverse;
    }

    public int getLayoutOrient() {
        return this.m_nLayoutOrient;
    }

    public Dimension getDimCell() {
        return this.m_dimCell;
    }

    public boolean isSpectralLegend() {
        return this.m_bSpectralLegend;
    }

    public boolean isDataScrollerActive() {
        return this.m_bDataScrollerActive;
    }

    public void setY1Axis(RelativeAxisObj relativeAxisObj) {
        this.m_MarkersLabels.setY1Axis(relativeAxisObj);
    }

    public void releaseReferences() {
        this.m_ScrollerSeries.releaseReferences();
        this.m_ScrollerLegend.releaseReferences();
        this.m_MarkersLabels.releaseReferences();
        this.m_Perspective = null;
    }
}

