/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StyleListEntry {
    protected String m_styleName;
    protected String m_key;
    protected String m_stylePath;
    protected Locale m_locale;
    protected ResourceBundle m_bundle;
    private boolean _isStandard;

    public StyleListEntry() {
        this(null, null);
    }

    public StyleListEntry(String string, String string2) {
        this(string, string2, null);
    }

    public StyleListEntry(String string, String string2, boolean bl) {
        this(string, null, string2);
        this._isStandard = bl;
    }

    public StyleListEntry(String string, String string2, String string3) {
        this.m_key = string3;
        this.m_stylePath = string;
        this.m_styleName = string2;
    }

    public boolean equals(Object object) {
        if (object instanceof StyleListEntry) {
            StyleListEntry styleListEntry = (StyleListEntry)object;
            if (this == styleListEntry) {
                return true;
            }
            String string = styleListEntry.getStylePath();
            String string2 = this.getStylePath();
            if (string != null && string2 != null && string2.equals(string)) {
                return true;
            }
        }
        return false;
    }

    public String getStylePath() {
        return this.m_stylePath;
    }

    public String getStyleName() {
        if (this.m_key != null && this.m_bundle != null) {
            this.m_styleName = this.m_bundle.getString(this.m_key);
        }
        return this.m_styleName;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle();
    }

    protected void setResourceBundle(ResourceBundle resourceBundle) {
        this.m_bundle = resourceBundle;
    }

    protected void updateResourceBundle() {
        try {
            this.m_bundle = this.m_locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", this.m_locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
        }
        catch (MissingResourceException missingResourceException) {
            this.m_bundle = null;
        }
    }

    public boolean isStandardStyle() {
        return this._isStandard;
    }
}

