/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIReferenceLine;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.gui.LimitedTextDocument;

public class ReferenceLine
extends JPanel {
    protected Graph m_graph;
    protected int m_componentID;
    protected int m_graphType;
    protected String[] m_referenceNames;
    protected TableColumn m_itemColumn;
    protected TableColumn m_colorColumn;
    protected TableColumn m_lineColumn;
    protected TableColumn m_labelColumn;
    protected TableColumn m_valueColumn;
    protected Object[][] m_data;
    protected String[] m_names;
    protected ReferenceJTable m_table;
    protected LineWidth lineWidth;
    protected CheckBoxEditor checkBoxEditor;
    protected ColorEditor colorEditor;
    protected ColorRenderer colorRenderer;
    protected CheckBoxRenderer itemLabelRenderer;
    protected LabelRenderer lineWidthRenderer;
    protected LabelRenderer labelRenderer;
    protected LabelRenderer crossRenderer;
    protected BIColorChoice button;
    protected Color[][] m_colors;
    protected ArrayTwoDModel m_colorPalette;
    protected boolean m_bColorPaletteSet;
    protected JScrollPane m_scrollPane;
    protected ActionListener editAction;
    protected boolean[] m_visibleChanged;
    protected boolean[] m_lineColorChanged;
    protected boolean[] m_lineWidthChanged;
    protected boolean[] m_textChanged;
    protected boolean[] m_valueChanged;
    private boolean m_focusOut = true;
    private boolean _flag;
    private NumberFormat m_numberFormat;
    private ResourceBundle rBundle;
    private Filter _filter = new Filter();
    private int oldAnchorRow;
    private int oldAnchorColumn;
    private boolean editorFocus;
    private int m_colToSelect;
    private int m_rowToSelect;
    private int tableMnemonicKey;
    private boolean spacePressedInEditor;
    private boolean spacePressedInTable;

    public ReferenceLine(Graph graph, int n) {
        this.m_graph = graph;
        this.m_componentID = n;
        this.initAll();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.m_numberFormat = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
    }

    public JTable getTable() {
        return this.m_table;
    }

    private void initAll() {
        this.removeAll();
        this.m_numberFormat = this.m_graph.getLocale() != null ? NumberFormat.getInstance(this.m_graph.getLocale()) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
        this.updateResourceBundle(this.m_graph.getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        String string = this.rBundle.getString("ReferenceLinePanelLabel");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.tableMnemonicKey = StringUtils.getMnemonicKeyCode((String)string);
        jLabel.setAlignmentX(0.0f);
        this.add(jLabel);
        this.add(Box.createVerticalStrut(3));
        this._initialize();
        this.m_table = new ReferenceJTable(this.m_data, this.m_names);
        jLabel.setLabelFor(this.m_table);
        this.m_table.setAlignmentX(0.0f);
        this.m_table.setRowHeight(24);
        this.m_table.setAutoResizeMode(4);
        this.m_table.setCellSelectionEnabled(true);
        this.m_table.getSelectionModel().setSelectionInterval(0, 0);
        this.m_table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.editAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListSelectionModel listSelectionModel = ReferenceLine.this.m_table.getSelectionModel();
                int n = listSelectionModel.getAnchorSelectionIndex();
                ListSelectionModel listSelectionModel2 = ReferenceLine.this.m_table.getColumnModel().getSelectionModel();
                int n2 = listSelectionModel2.getAnchorSelectionIndex();
                ReferenceLine.this.m_table.editCellAt(n, n2);
                Component component = ReferenceLine.this.m_table.getEditorComponent();
                if (component != null) {
                    component.requestFocus();
                } else {
                    ReferenceLine.this.m_table.requestFocus();
                }
            }
        };
        this.m_table.registerKeyboardAction(this.editAction, KeyStroke.getKeyStroke(113, 0), 1);
        Object object = new Object();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ReferenceLine.this.getRootPane().getDefaultButton() != null) {
                    ReferenceLine.this.getRootPane().getDefaultButton().requestFocus();
                    ReferenceLine.this.m_table.getParent().dispatchEvent(new KeyEvent(ReferenceLine.this.m_table, 401, System.currentTimeMillis(), 0, 10, '\uffff'));
                }
            }
        };
        this.m_table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), object);
        this.m_table.getActionMap().put(object, abstractAction);
        object = new Object();
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ReferenceLine.this.m_table.hasFocus()) {
                    int n = ReferenceLine.this.m_table.getEditingRow();
                    int n2 = ReferenceLine.this.m_table.getEditingColumn();
                    if (n >= 0 && n2 >= 0) {
                        ReferenceLine.this.m_table.getCellEditor(n, n2).cancelCellEditing();
                    }
                    ReferenceLine.this.m_table.requestFocus();
                } else {
                    int n = ReferenceLine.this.m_table.getSelectedColumn();
                    int n3 = ReferenceLine.this.m_table.getSelectedRow();
                    if (n >= 0 && n < ReferenceLine.this.m_table.getColumnCount() && n3 >= 0 && n3 < ReferenceLine.this.m_table.getRowCount()) {
                        ReferenceLine.this.m_table.getCellEditor(n3, n).cancelCellEditing();
                    }
                }
                ReferenceLine.this.m_table.setRowSelectionInterval(0, 0);
                ReferenceLine.this.m_table.setColumnSelectionInterval(0, 0);
                ReferenceLine.this.m_rowToSelect = 0;
                ReferenceLine.this.m_colToSelect = 0;
            }
        };
        this.m_table.getInputMap(2).put(KeyStroke.getKeyStroke(this.tableMnemonicKey, 8), object);
        this.m_table.getInputMap(0).put(KeyStroke.getKeyStroke(this.tableMnemonicKey, 8), object);
        this.m_table.getActionMap().put(object, abstractAction2);
        this.m_itemColumn = this.m_table.getColumnModel().getColumn(0);
        this._setupItemColumn();
        this.m_colorColumn = this.m_table.getColumnModel().getColumn(1);
        this._setupColorColumn();
        this.m_lineColumn = this.m_table.getColumnModel().getColumn(2);
        this._setupLineWidthColumn();
        this.m_labelColumn = this.m_table.getColumnModel().getColumn(3);
        this._setupLabelColumn();
        this.m_valueColumn = this.m_table.getColumnModel().getColumn(4);
        this._setupValueColumn();
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_scrollPane.setAlignmentX(0.0f);
        this.m_scrollPane.setPreferredSize(new Dimension(this.m_table.getPreferredSize().width + 5, this.m_table.getPreferredSize().height + this.m_table.getTableHeader().getPreferredSize().height + 4));
        this.m_scrollPane.setMinimumSize(this.m_scrollPane.getPreferredSize());
        this.add(this.m_scrollPane);
        this.setMinimumSize(new Dimension(this.m_scrollPane.getMinimumSize().width + 20, this.getPreferredSize().height));
    }

    public void setGraph(Graph graph) {
        this.m_graph = graph;
        this.removeAll();
        this.m_table = null;
        this.resetFocus();
        this.initAll();
    }

    public void cleanUp() {
        this.m_table.getInputMap().clear();
        this.m_table.getActionMap().clear();
        this.m_table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this.editAction = null;
        this.m_scrollPane.setViewportView(null);
        this.m_table = null;
    }

    public void setColorPalette(Color[][] colorArray) {
        this.m_colors = colorArray;
        if (this.m_colors != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel(colorArray);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        if (this.m_colors != null) {
            return this.m_colors;
        }
        if (this.button != null) {
            return FontButton.getColorArray(this.button.getColorPalette());
        }
        return FontButton.getDefaultColorArray();
    }

    public void setColorPalette(ArrayTwoDModel arrayTwoDModel) {
        this.m_bColorPaletteSet = arrayTwoDModel != null;
        this.m_colorPalette = arrayTwoDModel;
        if (this.button != null) {
            this.button.setSelectedColor((Color)this.button.getColorPalette().getData(0, 0));
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
    }

    protected void resetFocus() {
        this.m_focusOut = true;
        this.m_colToSelect = 0;
        this.m_rowToSelect = 0;
    }

    protected void resetFocusLast() {
        this.m_focusOut = true;
        this.m_colToSelect = this.m_table.getColumnCount() - 1;
        this.m_rowToSelect = this.m_table.getRowCount() - 1;
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _setupItemColumn() {
        int n = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[0]);
        int n2 = 0;
        while (n2 < 3) {
            int n3 = this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_referenceNames[n2]) + 20;
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        this.m_itemColumn.setPreferredWidth(n += 10);
        this.m_itemColumn.setMinWidth(this.m_itemColumn.getPreferredWidth());
        this.m_itemColumn.setMaxWidth(this.m_itemColumn.getPreferredWidth());
        this.m_itemColumn.setResizable(false);
        TabCheckBox tabCheckBox = new TabCheckBox();
        this.m_itemColumn.setCellEditor(new CheckBoxEditor(tabCheckBox));
        this.itemLabelRenderer = new CheckBoxRenderer();
        this.m_itemColumn.setCellRenderer(this.itemLabelRenderer);
    }

    private void _setupLineWidthColumn() {
        this.lineWidth = new LightLineWidth();
        this.lineWidth.setCellColor(Color.black);
        this.m_lineColumn.setCellEditor(new LineWidthEditor(this.lineWidth));
        LineWidthRenderer lineWidthRenderer = new LineWidthRenderer(true);
        this.m_lineColumn.setCellRenderer(lineWidthRenderer);
        this.m_lineColumn.setPreferredWidth(80);
        this.m_lineColumn.setMinWidth(this.m_lineColumn.getPreferredWidth());
        this.m_lineColumn.setMaxWidth(this.m_lineColumn.getPreferredWidth());
        this.m_lineColumn.setResizable(false);
    }

    private void _setupColorColumn() {
        this.button = new BIColorChoice();
        this.button.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        if (this.m_bColorPaletteSet) {
            this.button.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.colorEditor = new ColorEditor(this.button);
        this.m_colorColumn.setCellEditor(this.colorEditor);
        this.colorRenderer = null.new ColorRenderer(true);
        this.m_colorColumn.setCellRenderer(this.colorRenderer);
        this.m_colorColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[1]) + 10);
        this.m_colorColumn.setMinWidth(this.m_colorColumn.getPreferredWidth());
        this.m_colorColumn.setMaxWidth(this.m_colorColumn.getPreferredWidth());
        this.m_colorColumn.setResizable(false);
    }

    private void _setupLabelColumn() {
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024);
        TabTextField tabTextField = new TabTextField(limitedTextDocument, "", 0);
        this.m_labelColumn.setCellEditor(new TextFieldEditor(tabTextField));
        this.m_labelColumn.setCellRenderer(null.new LabelRenderer());
        this.m_labelColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[3]) + 30);
        this.m_labelColumn.setMinWidth(this.m_labelColumn.getPreferredWidth());
        this.m_labelColumn.setMaxWidth(this.m_labelColumn.getPreferredWidth());
        this.m_labelColumn.setResizable(false);
    }

    private void _setupValueColumn() {
        TabNumberTextField tabNumberTextField = new TabNumberTextField();
        if (this.m_graph.getLocale() != null) {
            tabNumberTextField.setLocale(this.m_graph.getLocale());
        }
        tabNumberTextField.setDataType(Class.forName("java.lang.Double"));
        this.m_valueColumn.setCellEditor(new TextFieldEditor((JTextField)((Object)tabNumberTextField)));
        this.m_valueColumn.setCellRenderer(null.new LabelRenderer());
        this.m_valueColumn.setPreferredWidth(this.getToolkit().getFontMetrics(this.m_table.getFont()).stringWidth(this.m_names[4]) + 20);
        this.m_valueColumn.setMinWidth(this.m_valueColumn.getPreferredWidth());
        this.m_valueColumn.setMaxWidth(this.m_valueColumn.getPreferredWidth());
        this.m_valueColumn.setResizable(false);
    }

    private ImageIcon _getImageIcon(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.Series"), (String)string));
    }

    private void _initialize() {
        int n;
        UIReferenceLine uIReferenceLine;
        this.m_referenceNames = new String[3];
        this.m_referenceNames[0] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), "1"));
        this.m_referenceNames[1] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), "2"));
        this.m_referenceNames[2] = new String(MessageFormat.format(this.rBundle.getString("Reference Line"), "3"));
        Boolean[] booleanArray = new Boolean[3];
        Integer[] integerArray = new Integer[3];
        Color[] colorArray = new Color[3];
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[3];
        this.m_visibleChanged = new boolean[3];
        this.m_lineColorChanged = new boolean[3];
        this.m_lineWidthChanged = new boolean[3];
        this.m_textChanged = new boolean[3];
        this.m_valueChanged = new boolean[3];
        switch (this.m_componentID) {
            case 41: {
                uIReferenceLine = this.m_graph.getUIX1ReferenceLine();
                break;
            }
            case 46: {
                uIReferenceLine = this.m_graph.getUIY1ReferenceLine();
                break;
            }
            case 51: {
                uIReferenceLine = this.m_graph.getUIY2ReferenceLine();
                break;
            }
            default: {
                uIReferenceLine = null;
            }
        }
        if (uIReferenceLine != null) {
            n = 0;
            while (n < 3) {
                booleanArray[n] = new Boolean(uIReferenceLine.isVisible(n));
                integerArray[n] = new Integer(uIReferenceLine.getLineWidth(n));
                colorArray[n] = uIReferenceLine.getLineColor(n);
                stringArray[n] = uIReferenceLine.getText(n);
                stringArray2[n] = this.m_numberFormat.format(uIReferenceLine.getValue(n));
                ++n;
            }
        } else {
            n = 0;
            while (n < 3) {
                booleanArray[n] = new Boolean(GraphDefaultValues.isReferenceLineVisible());
                integerArray[n] = new Integer(GraphDefaultValues.getReferenceLineWidth());
                colorArray[n] = new Color(ReferenceLine.hexStringToInt(GraphDefaultValues.getReferenceLineColor(n)));
                stringArray[n] = GraphDefaultValues.getReferenceLineText(n);
                stringArray2[n] = this.m_numberFormat.format(GraphDefaultValues.getReferenceLineValue());
                ++n;
            }
        }
        this.m_names = new String[5];
        this.m_names[0] = this.rBundle.getString("ShowRefrenceLine");
        this.m_names[1] = this.rBundle.getString("Color");
        this.m_names[2] = this.rBundle.getString("Thickness");
        this.m_names[3] = this.rBundle.getString("ReferenceLineLabel");
        this.m_names[4] = this.rBundle.getString("ReferenceLineCrossAt");
        this.m_data = new Object[3][5];
        n = 0;
        while (n < 3) {
            this.m_data[n][0] = booleanArray[n];
            this.m_data[n][1] = colorArray[n];
            this.m_data[n][2] = integerArray[n];
            this.m_data[n][3] = stringArray[n];
            this.m_data[n][4] = stringArray2[n];
            ++n;
        }
    }

    private Icon _getColorIcon(Image image, int n) {
        this._filter.setColor(n);
        Image image2 = ReferenceLine._createFilteredImage(image, this._filter);
        return new ImageIcon(image2);
    }

    private static Image _createFilteredImage(Image image, ImageFilter imageFilter) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    private void _processTabKey(KeyEvent keyEvent) {
        int n = this.m_table.getSelectionModel().getAnchorSelectionIndex();
        int n2 = this.m_table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        if (keyEvent.isControlDown()) {
            this.m_table.getCellEditor(n, n2).stopCellEditing();
            if (!keyEvent.isShiftDown()) {
                FocusManager.getCurrentManager().focusNextComponent(this.m_table);
            } else {
                FocusManager.getCurrentManager().focusPreviousComponent(this.m_table);
            }
            this.resetFocus();
        } else if (!keyEvent.isShiftDown()) {
            this.m_table.getCellEditor(n, n2).stopCellEditing();
            if (n == this.m_table.getRowCount() - 1 && n2 == this.m_table.getColumnCount() - 1) {
                if (FocusManager.isFocusManagerEnabled()) {
                    FocusManager.getCurrentManager().focusNextComponent(this.m_table);
                    keyEvent.consume();
                }
            } else {
                this.m_table.moveRight();
            }
        } else {
            this.m_table.getCellEditor(n, n2).stopCellEditing();
            if (n == 0 && n2 == 0) {
                if (FocusManager.isFocusManagerEnabled()) {
                    FocusManager.getCurrentManager().focusPreviousComponent(this.m_table);
                    keyEvent.consume();
                }
            } else {
                this.m_table.moveLeft();
            }
        }
    }

    public void apply() {
        UIReferenceLine uIReferenceLine;
        switch (this.m_componentID) {
            case 41: {
                uIReferenceLine = this.m_graph.getUIX1ReferenceLine();
                break;
            }
            case 46: {
                uIReferenceLine = this.m_graph.getUIY1ReferenceLine();
                break;
            }
            case 51: {
                uIReferenceLine = this.m_graph.getUIY2ReferenceLine();
                break;
            }
            default: {
                return;
            }
        }
        int n = 0;
        while (n < 3) {
            if (this.m_visibleChanged[n]) {
                uIReferenceLine.setVisible((Boolean)this.m_table.getValueAt(n, 0), n);
                uIReferenceLine.setDisplayedInLegend((Boolean)this.m_table.getValueAt(n, 0), n);
            }
            if (this.m_lineColorChanged[n]) {
                uIReferenceLine.setLineColor((Color)this.m_table.getValueAt(n, 1), n);
            }
            if (this.m_lineWidthChanged[n]) {
                uIReferenceLine.setLineWidth(new Integer(this.m_table.getValueAt(n, 2).toString()), n);
            }
            if (this.m_textChanged[n]) {
                uIReferenceLine.setText((String)this.m_table.getValueAt(n, 3), n);
            }
            if (this.m_valueChanged[n]) {
                try {
                    double d = this.m_numberFormat.parse((String)this.m_table.getValueAt(n, 4)).doubleValue();
                    uIReferenceLine.setValue(d, n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    protected static int hexStringToInt(String string) {
        String string2 = string.substring(1);
        return Integer.parseInt(string2, 16);
    }

    protected class ReferenceJTable
    extends JTable
    implements TableModelListener {
        private boolean helpKey;

        public ReferenceJTable(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
            this.getTableHeader().setReorderingAllowed(false);
        }

        public void setCellEditor(TableCellEditor tableCellEditor) {
            super.setCellEditor(tableCellEditor);
            if (tableCellEditor != null) {
                ReferenceLine.this._flag = false;
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            super.tableChanged(tableModelEvent);
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getFirstRow();
            if (n2 < 0) {
                return;
            }
            if (!ReferenceLine.this._flag) {
                return;
            }
            if (n == 0) {
                ReferenceLine.this.m_visibleChanged[n2] = true;
                ReferenceLine.this._flag = false;
                return;
            }
            if (n == 1) {
                ReferenceLine.this.m_lineColorChanged[n2] = true;
            } else if (n == 2) {
                ReferenceLine.this.m_lineWidthChanged[n2] = true;
            } else if (n == 3) {
                ReferenceLine.this.m_textChanged[n2] = true;
            } else if (n == 4) {
                ReferenceLine.this.m_valueChanged[n2] = true;
            }
            if (!((Boolean)this.getValueAt(n2, 0)).booleanValue()) {
                this.setValueAt(new Boolean(true), n2, 0);
            }
            ReferenceLine.this._flag = false;
        }

        public void moveLeft() {
            this.requestFocus();
            int n = this.getSelectionModel().getAnchorSelectionIndex();
            int n2 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n == 0 && n2 == 0) {
                this.changeSelection(this.getRowCount() - 1, this.getColumnCount() - 1, false, false);
            } else if (n2 == 0) {
                this.changeSelection(n - 1, this.getColumnCount() - 1, false, false);
            } else {
                this.changeSelection(n, n2 - 1, false, false);
            }
            ReferenceLine.this._flag = false;
        }

        public void moveRight() {
            this.requestFocus();
            int n = this.getSelectionModel().getAnchorSelectionIndex();
            int n2 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n == this.getRowCount() - 1 && n2 == this.getColumnCount() - 1) {
                this.changeSelection(0, 0, false, false);
            } else if (n2 == this.getColumnCount() - 1) {
                this.changeSelection(n + 1, 0, false, false);
            } else {
                this.changeSelection(n, n2 + 1, false, false);
            }
            ReferenceLine.this._flag = false;
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            TableCellEditor tableCellEditor;
            if (this.isEditing() && (tableCellEditor = this.getCellEditor()) != null) {
                Object object = tableCellEditor.getCellEditorValue();
                this.setValueAt(object, this.getEditingRow(), this.getEditingColumn());
            }
            this.resizeAndRepaint();
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            int n = this.getSelectionModel().getAnchorSelectionIndex();
            int n2 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
                if (keyEvent.getKeyCode() == 9) {
                    if (keyEvent.isControlDown()) {
                        if (keyEvent.getID() != 402) {
                            this.getCellEditor(n, n2).stopCellEditing();
                            if (!keyEvent.isShiftDown()) {
                                FocusManager.getCurrentManager().focusNextComponent(this);
                            } else {
                                FocusManager.getCurrentManager().focusPreviousComponent(this);
                            }
                            ReferenceLine.this.resetFocus();
                        }
                    } else {
                        if (n2 == this.getColumnCount() - 1 && n == this.getRowCount() - 1 && !keyEvent.isShiftDown() && keyEvent.getID() != 402) {
                            this.getCellEditor(n, n2).stopCellEditing();
                            if (FocusManager.isFocusManagerEnabled()) {
                                FocusManager.getCurrentManager().focusNextComponent(this);
                                keyEvent.consume();
                            }
                            return;
                        }
                        if (n2 == 0 && n == 0 && keyEvent.isShiftDown() && keyEvent.getID() != 402) {
                            if (FocusManager.isFocusManagerEnabled()) {
                                FocusManager.getCurrentManager().focusPreviousComponent(this);
                                keyEvent.consume();
                            }
                            return;
                        }
                    }
                } else if (keyEvent.getKeyCode() == 40 && keyEvent.isAltDown() && keyEvent.getID() != 402 && (n2 == 1 || n2 == 2)) {
                    this.editCellAt(n, n2);
                    ReferenceLine.this._flag = false;
                    this.getEditorComponent().requestFocus();
                    if (this.getEditorComponent() instanceof JComboBox) {
                        this.getEditorComponent().setVisible(true);
                        ((JComboBox)this.getEditorComponent()).showPopup();
                    }
                }
            } else if (keyEvent.getKeyCode() == 32 && n2 != 0) {
                if (!ReferenceLine.this.spacePressedInEditor) {
                    this.editCellAt(n, n2);
                    ReferenceLine.this._flag = false;
                    this.getEditorComponent().requestFocus();
                    if (this.getEditorComponent() instanceof JComboBox) {
                        this.getEditorComponent().setVisible(true);
                        ((JComboBox)this.getEditorComponent()).showPopup();
                    }
                    ReferenceLine.this.spacePressedInTable = true;
                } else {
                    ReferenceLine.this.spacePressedInEditor = false;
                }
            } else if (keyEvent.getKeyCode() == 72) {
                if (keyEvent.isAltDown() && keyEvent.getID() != 402) {
                    this.helpKey = true;
                } else if (n2 == 3 || n2 == 4) {
                    return;
                }
            } else if (!(n2 != 3 && n2 != 4 || this.isEditing() || keyEvent.getKeyCode() == 10 || keyEvent.isAltDown() && keyEvent.getKeyCode() == ReferenceLine.this.tableMnemonicKey)) {
                return;
            }
            super.processKeyEvent(keyEvent);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            if (focusEvent.getID() == 1004) {
                if (ReferenceLine.this.m_focusOut) {
                    int n = this.getSelectedColumn();
                    int n2 = this.getSelectedRow();
                    if (n >= 0 && n < this.getColumnCount() && n2 >= 0 && n2 < this.getRowCount()) {
                        this.getCellEditor(n2, n).cancelCellEditing();
                    }
                    this.setRowSelectionInterval(ReferenceLine.this.m_rowToSelect, ReferenceLine.this.m_rowToSelect);
                    this.setColumnSelectionInterval(ReferenceLine.this.m_colToSelect, ReferenceLine.this.m_colToSelect);
                    ReferenceLine.this.m_focusOut = false;
                }
            } else if (focusEvent.getID() == 1005 && this.helpKey) {
                int n = this.getSelectedColumn();
                int n3 = this.getSelectedRow();
                if (n >= 0 && n < this.getColumnCount() && n3 >= 0 && n3 < this.getRowCount()) {
                    this.getCellEditor(n3, n).cancelCellEditing();
                }
                this.helpKey = false;
            }
            super.processFocusEvent(focusEvent);
        }
    }

    class TextFieldEditor
    extends DefaultCellEditor
    implements FocusListener,
    CaretListener {
        private JTextField textField;
        private int rowEdited;
        private int columnEdited;

        public TextFieldEditor(JTextField jTextField) {
            super(jTextField);
            this.textField = jTextField;
            this.setClickCountToStart(1);
            this.textField.addFocusListener(this);
            this.textField.addCaretListener(this);
        }

        public void caretUpdate(CaretEvent caretEvent) {
            String string = this.textField.getText();
            int n = ReferenceLine.this.m_table.getEditingColumn();
            if (n < 0) {
                return;
            }
            int n2 = ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(ReferenceLine.this.m_names[n]) + 20;
            int n3 = 0;
            while (n3 < 3) {
                int n4 = 0;
                n4 = n3 == ReferenceLine.this.m_table.getEditingRow() ? ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(this.textField.getText()) : ReferenceLine.this.getToolkit().getFontMetrics(ReferenceLine.this.m_table.getFont()).stringWidth(ReferenceLine.this.m_table.getValueAt(n3, n).toString());
                if (n4 > n2) {
                    n2 = n4;
                }
                ++n3;
            }
            n2 += 10;
            if (n == 3) {
                ReferenceLine.this.m_labelColumn.setMaxWidth(n2);
            } else {
                ReferenceLine.this.m_valueColumn.setMaxWidth(n2);
            }
            ReferenceLine.this.m_table.revalidate();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                if (this.textField instanceof TabNumberTextField) {
                    TabNumberTextField tabNumberTextField = (TabNumberTextField)((Object)this.textField);
                    if (tabNumberTextField.isValidValue()) {
                        this.fireEditingStopped();
                    } else if (tabNumberTextField.isShowing()) {
                        tabNumberTextField.showErrorDialog();
                    }
                } else {
                    this.fireEditingStopped();
                }
            }
        }

        public boolean stopCellEditing() {
            TabNumberTextField tabNumberTextField;
            if (this.textField instanceof TabNumberTextField && !(tabNumberTextField = (TabNumberTextField)((Object)this.textField)).isValidValue()) {
                return false;
            }
            return super.stopCellEditing();
        }

        public void fireEditingCanceled() {
            ReferenceLine.this._flag = false;
            super.fireEditingCanceled();
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!ReferenceLine.this.m_table.isEditing()) {
                ReferenceLine.this.m_table.editCellAt(this.rowEdited, this.columnEdited);
            }
            if (ReferenceLine.this.m_table.getEditingColumn() != -1) {
                String string = ReferenceLine.this.m_names[ReferenceLine.this.m_table.getEditingColumn()];
                this.textField.getAccessibleContext().setAccessibleName(string);
            }
            this.textField.selectAll();
            ReferenceLine.this.m_focusOut = false;
        }

        public Object getCellEditorValue() {
            if (this.textField instanceof NumberTextField) {
                if (this.textField.getText().length() == 0) {
                    return ReferenceLine.this.m_table.getValueAt(ReferenceLine.this.m_table.getEditingRow(), ReferenceLine.this.m_table.getEditingColumn());
                }
                if (((NumberTextField)this.textField).getNumber() != null) {
                    String string = ReferenceLine.this.m_numberFormat.format(((NumberTextField)this.textField).getNumber().doubleValue());
                    return string;
                }
                return this.textField.getText();
            }
            return this.textField.getText();
        }
    }

    class CheckBoxEditor
    extends DefaultCellEditor
    implements ItemListener,
    FocusListener {
        public CheckBoxEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            jCheckBox.removeItemListener(this);
            this.editorComponent = jCheckBox;
            jCheckBox.addItemListener(this);
            jCheckBox.addFocusListener(this);
            this.setClickCountToStart(1);
        }

        public Object getCellEditorValue() {
            return new Boolean(((JCheckBox)this.editorComponent).isSelected());
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.fireEditingStopped();
        }

        public void focusGained(FocusEvent focusEvent) {
            ReferenceLine.this.m_focusOut = false;
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JCheckBox)this.editorComponent).setSelected((Boolean)object);
            ((JCheckBox)this.editorComponent).setText(ReferenceLine.this.m_referenceNames[n]);
            return this.editorComponent;
        }
    }

    class ColorEditor
    extends DefaultCellEditor
    implements PropertyChangeListener {
        Color currentColor;

        public ColorEditor(BIColorChoice bIColorChoice) {
            super(new JCheckBox());
            this.editorComponent = bIColorChoice;
            this.setClickCountToStart(1);
            this.editorComponent.addPropertyChangeListener(this);
            this.editorComponent.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ ColorEditor this$0;

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        this.this$0.fireEditingCanceled();
                    }
                }
                {
                    this.this$0 = colorEditor;
                }
            });
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
                ReferenceLine.this._flag = true;
                this.fireEditingStopped();
            }
        }

        public void fireEditingStopped() {
            this.currentColor = ((BIColorChoice)((Object)this.editorComponent)).getSelectedColor();
            super.fireEditingStopped();
        }

        public void fireEditingCanceled() {
            ReferenceLine.this._flag = false;
            super.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            BIColorChoice bIColorChoice = (BIColorChoice)((Object)this.editorComponent);
            if (!ReferenceLine.this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)bIColorChoice.getColorPalette(), (Color)((Color)object))) {
                    bIColorChoice.setColorPalette(FontButton.getNewColorPalette(bIColorChoice.getColorPalette(), (Color)object, ReferenceLine.this.m_bColorPaletteSet));
                }
                bIColorChoice.setSelectedColor((Color)object);
            } else {
                bIColorChoice.setSelectedColor(bIColorChoice.getClosestColor((Color)object));
            }
            this.currentColor = (Color)object;
            return this.editorComponent;
        }
    }

    private class CheckBoxRenderer
    extends JPanel
    implements TableCellRenderer {
        JCheckBox checkBox;

        public CheckBoxRenderer() {
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.setLayout(new BoxLayout(this, 0));
            this.checkBox = new JCheckBox();
            this.checkBox.setBackground(Color.white);
            this.checkBox.setForeground(Color.black);
            this.add(this.checkBox);
            this.checkBox.setAlignmentX(0.0f);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.checkBox.setSelected((Boolean)object);
            }
            this.checkBox.setText(ReferenceLine.this.m_referenceNames[n]);
            this.getAccessibleContext().setAccessibleName(this.checkBox.getText());
            if (bl) {
                this.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            } else {
                this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createLineBorder(this.getBackground(), 2));
            }
            return this;
        }
    }

    private class LabelRenderer
    extends DefaultTableCellRenderer {
        LabelRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                this.getAccessibleContext().setAccessibleName(object.toString());
            }
            component.setBackground(Color.white);
            component.setForeground(Color.black);
            if (bl) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
            } else {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground()));
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground()));
            }
            return component;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.setText("");
            if (object instanceof Color) {
                this.setBackground((Color)object);
            } else {
                this.setBackground(Color.white);
            }
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground()));
            }
            return this;
        }

        public void cleanUp() {
            this.setBorder(null);
            this.unselectedBorder = null;
            this.selectedBorder = null;
        }
    }

    class LineWidthRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder;
        Border selectedBorder;
        boolean isBordered = true;

        public LineWidthRenderer(boolean bl) {
            this.isBordered = bl;
            this.setBackground(Color.white);
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = new Integer(jTable.getValueAt(n, n2).toString());
            this.setIcon(ReferenceLine.this._getColorIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ReferenceLine$LineWidthRenderer"), (String)(String.valueOf(String.valueOf("images/Line")) + n3 + ".gif")), n));
            if (n3 == 1) {
                this.getAccessibleContext().setAccessibleName(ReferenceLine.this.rBundle.getString("Single pixel"));
            } else {
                this.getAccessibleContext().setAccessibleName(MessageFormat.format(ReferenceLine.this.rBundle.getString("pixels"), new Integer(n3)));
            }
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black);
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            if (!bl2) {
                this.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, jTable.getBackground()));
            }
            return this;
        }
    }

    private class Filter
    extends RGBImageFilter {
        private int _color;
        private final int _sCOLOR = new Color(255, 0, 255).getRGB();

        public Filter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(int n) {
            Color color = (Color)ReferenceLine.this.m_table.getValueAt(n, 1);
            if (color.getRGB() == -1) {
                color = Color.black;
            }
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._sCOLOR) {
                return this._color;
            }
            return n3;
        }
    }

    private class LineWidthEditor
    extends ComboBoxCellEditor {
        public LineWidthEditor(JComboBox jComboBox) {
            super(jComboBox);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.delegate.setValue(object.toString());
            LineWidth lineWidth = (LineWidth)this.editorComponent;
            if (ReferenceLine.this.lineWidth.getBackground().getRGB() == -1 && ((Color)ReferenceLine.this.m_table.getValueAt(n, 1)).getRGB() == -1) {
                lineWidth.setCellColor(Color.black);
            } else {
                lineWidth.setCellColor((Color)ReferenceLine.this.m_table.getValueAt(n, 1));
            }
            return this.editorComponent;
        }
    }

    private class ComboBoxCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        boolean stopEditing;

        public ComboBoxCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            jComboBox.addFocusListener(this);
            this.delegate = new DefaultCellEditor.EditorDelegate(jComboBox, this){
                final /* synthetic */ JComboBox al$comboBox;
                final /* synthetic */ ComboBoxCellEditor this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$0.stopEditing) {
                        ComboBoxCellEditor.access$5000771(this.this$0);
                    } else {
                        this.this$0.stopEditing = true;
                    }
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    ReferenceLine.access$5000249(this.this$0.ReferenceLine.this, true);
                    ComboBoxCellEditor.access$5000771(this.this$0);
                }

                public void setValue(Object object) {
                    this.al$comboBox.setSelectedItem(object);
                }

                public Object getCellEditorValue() {
                    return this.al$comboBox.getSelectedItem();
                }
                {
                    this.al$comboBox = jComboBox;
                    this.this$0 = comboBoxCellEditor;
                }
            };
            jComboBox.addItemListener(this.delegate);
        }

        public void fireEditingCanceled() {
            ReferenceLine.this._flag = false;
            super.fireEditingCanceled();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.stopEditing = false;
            ReferenceLine.this.m_focusOut = false;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.stopEditing = true;
            }
        }

        static /* synthetic */ void access$5000771(ComboBoxCellEditor comboBoxCellEditor) {
            comboBoxCellEditor.fireEditingStopped();
        }
    }

    private class LightLineWidth
    extends LineWidth
    implements ActionListener {
        public LightLineWidth() {
            this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                ReferenceLine.this._processTabKey(keyEvent);
            } else {
                if (keyEvent.getKeyCode() != 27 && !this.isPopupVisible()) {
                    ReferenceLine.this.m_table.requestFocus();
                    return;
                }
                if (keyEvent.getKeyCode() == 32) {
                    ReferenceLine.this.spacePressedInEditor = true;
                    if (ReferenceLine.this.spacePressedInTable) {
                        ReferenceLine.this.spacePressedInTable = false;
                        return;
                    }
                } else {
                    ReferenceLine.this.spacePressedInEditor = false;
                }
            }
            super.processKeyEvent(keyEvent);
        }
    }

    private class TabCheckBox
    extends JCheckBox {
        public void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 501) {
                ReferenceLine.this._flag = true;
            }
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                ReferenceLine.this._processTabKey(keyEvent);
            } else {
                ReferenceLine.this._flag = true;
            }
            super.processKeyEvent(keyEvent);
        }
    }

    private class TabNumberTextField
    extends NumberTextField
    implements FocusListener {
        public boolean keyTyped;

        public TabNumberTextField() {
            this.addFocusListener(this);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.keyTyped = false;
            ReferenceLine.this._flag = false;
        }

        public boolean isValidValue() {
            return !this.getText().equals("-") && !this.getText().equals("+") && !this.getText().equals(".");
        }

        public void showErrorDialog() {
            String string = MessageFormat.format(ReferenceLine.this.rBundle.getString("WrongCrossAtValue"), this.getText());
            JOptionPane jOptionPane = new JOptionPane(string, 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.ReferenceLine"), (String)"images/stop.gif")));
            jOptionPane.getAccessibleContext().setAccessibleName(string);
            JDialog jDialog = jOptionPane.createDialog(ReferenceLine.this.m_table, ReferenceLine.this.rBundle.getString("Graph"));
            jDialog.show();
            SwingUtilities.invokeLater(new Runnable(this){
                final /* synthetic */ TabNumberTextField this$0;

                public void run() {
                    this.this$0.requestFocus();
                }
                {
                    this.this$0 = tabNumberTextField;
                }
            });
            this.selectAll();
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                if (this.isValidValue()) {
                    ReferenceLine.this._processTabKey(keyEvent);
                } else {
                    this.showErrorDialog();
                    return;
                }
            }
            if (!keyEvent.isActionKey() && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 0 && keyEvent.getKeyCode() != 32 && keyEvent.getKeyCode() != 521 && keyEvent.getKeyCode() != 45 && keyEvent.getKeyCode() != 46) {
                this.keyTyped = true;
            }
            ReferenceLine.this._flag = this.keyTyped;
            super.processKeyEvent(keyEvent);
        }
    }

    private class TabTextField
    extends JTextField
    implements FocusListener {
        private boolean keyTyped;
        private boolean startEditing;

        public TabTextField() {
            this.addFocusListener(this);
        }

        public TabTextField(Document document, String string, int n) {
            super(document, string, n);
            this.addFocusListener(this);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.keyTyped = false;
            ReferenceLine.this._flag = false;
            this.startEditing = false;
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            this.startEditing = true;
            super.processMouseEvent(mouseEvent);
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                ReferenceLine.this._processTabKey(keyEvent);
            } else if (keyEvent.getKeyCode() == 0) {
                if (!this.keyTyped) {
                    this.selectAll();
                    return;
                }
            } else if (keyEvent.getKeyCode() == 32) {
                if (this.startEditing) {
                    this.keyTyped = true;
                } else {
                    this.startEditing = true;
                }
            } else if (!keyEvent.isActionKey() && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 10) {
                this.keyTyped = true;
            }
            ReferenceLine.this._flag = this.keyTyped;
            super.processKeyEvent(keyEvent);
        }
    }
}

