/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.awt.Image;
import java.util.BitSet;
import java.util.Vector;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.BaseGraphXML;
import oracle.dss.graph.Graph;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class SFX
extends BaseGraphXML {
    protected static final int ATTR_FILLTYPE = 0;
    protected static final int ATTR_GRADIENTDIRECTION = 1;
    protected static final int ATTR_TEXTUREDISPLAYMODE = 2;
    protected static final int ATTR_TEXTUREURL = 3;
    protected static final int ATTR_GRADIENTNUMSTOPS = 4;
    protected static final int ATTR_GRADIENTREVERSED = 5;
    protected static final int ATTR_STYLE_MAXID = 6;
    protected static final int ATTR_GRADIENTSTOPCOLOR = 0;
    protected static final int ATTR_GRADIENTSTOPPOSITION = 1;
    protected static final int ATTR_GRADIENTSTOP_MAXID = 2;
    protected BitSet[] _stopUserOverrideFlags = new BitSet[100];
    protected BitSet[] _stopStyleOverrideFlags = new BitSet[100];
    protected static final int fillType = 1;
    protected static final int gradientDirection = 1;
    protected static final int gradientNumPins = 2;
    protected static final int textureDisplayMode = 0;
    protected static final double position = 0.5;
    protected static final String gradientPinLeftColor = "#ffffff";
    protected static final String gradientPinRightColor = "#ffffff";
    protected static final String a_fillType = "fillType";
    protected static final String a_gradientDirection = "gradientDirection";
    protected static final String a_gradientNumPins = "gradientNumPins";
    protected static final String a_textureDisplayMode = "textureDisplayMode";
    protected static final String a_pinIndex = "pinIndex";
    protected static final String a_position = "position";
    protected static final String a_gradientPinLeftColor = "gradientPinLeftColor";
    protected static final String a_gradientPinRightColor = "gradientPinRightColor";
    protected static final String a_textureURL = "textureURL";
    protected static final String GRADIENTPINSTYLE_NAME = "GradientPinStyle";
    protected static final String a_gradientStopColor = "gradientStopColor";
    protected static final String a_gradientStopPosition = "gradientStopPosition";
    protected static final String a_gradientNumStops = "gradientNumStops";
    protected static final String a_gradientReversed = "gradientReversed";
    protected static final String GRADIENTSTOPSTYLE_NAME = "GradientStopStyle";
    protected Graph m_graph;
    protected PFJ m_pfj;
    protected IdentObj m_identObj;
    protected IdentObj m_identObj2;
    protected boolean m_isSeries;
    private boolean m_url;
    private boolean m_reversed;
    private int m_series;
    private Vector m_isDefaultColor;
    private Vector m_isDefaultPosition;
    private boolean m_isCalledFromNumStops;
    private boolean m_isCalledFromFillType;
    private boolean m_depDirection;

    public SFX(Graph graph, IdentObj identObj) {
        this(graph, identObj, null);
    }

    public SFX(Graph graph, IdentObj identObj, IdentObj identObj2) {
        super(graph);
        this.m_graph = graph;
        this.m_pfj = graph.getPFJ();
        this.m_identObj = identObj;
        this.m_identObj2 = identObj2;
        if (this.m_identObj2 == null) {
            this.m_isSeries = false;
        } else {
            this.m_isSeries = true;
            this.m_series = this.m_identObj.getSeriesID();
        }
        this.m_isDefaultColor = new Vector();
        this.m_isDefaultPosition = new Vector();
        int n = 0;
        while (n < this.getGradientNumPins()) {
            this.m_isDefaultColor.addElement(new Boolean(true));
            this.m_isDefaultPosition.addElement(new Boolean(true));
            ++n;
        }
        this.createStopPropertyOverrideFlags();
    }

    public int getFillType() {
        return this.m_pfj.getFillType(this.m_identObj);
    }

    public void setFillType(int n) {
        if (n < 1 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid fill type", this.getClass().getName(), "setFillType(int type)");
        } else {
            this.m_pfj.setFillType(this.m_identObj, n);
            if (this.m_isSeries) {
                this.m_pfj.setFillType(this.m_identObj2, n);
            }
            this.setPropertyOverrideFlags(0);
            if (n == 2) {
                this.m_isCalledFromFillType = true;
                this.setGradientNumStops(this.getGradientNumStops());
            }
        }
    }

    public int getGradientDirection() {
        int n = this.m_pfj.getGradientDirection(this.m_identObj);
        if (!this.isGradientReversed()) {
            return n;
        }
        return this._calcReversedGradientDirection(n);
    }

    public void setGradientDirection(int n) {
        if (n < 1 || n > 13) {
            this.m_graph.getErrorHandler().log("invalid gradient direction", this.getClass().getName(), "setGradientDirection(int dir)");
            return;
        }
        switch (n) {
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.m_depDirection = true;
                break;
            }
            default: {
                this.m_depDirection = false;
            }
        }
        int n2 = n;
        if (this.isGradientReversed()) {
            n2 = this._calcReversedGradientDirection(n);
        }
        this.m_pfj.setGradientDirection(this.m_identObj, n2);
        if (this.m_isSeries) {
            this.m_pfj.setGradientDirection(this.m_identObj2, n2);
        }
        if (!this.m_depDirection) {
            this.setPropertyOverrideFlags(1);
        }
    }

    public int getGradientNumPins() {
        return this.m_pfj.getGradientNumPins(this.m_identObj);
    }

    public void setGradientNumPins(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid number of pins", this.getClass().getName(), "setGradientNumPins(int numPins)");
            return;
        }
        int n2 = this.m_isDefaultColor.size();
        if (n2 < n) {
            int n3 = 0;
            while (n3 < n - n2) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n3;
            }
        }
        this.m_pfj.setGradientNumPins(this.m_identObj, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientNumPins(this.m_identObj2, n);
        }
    }

    public double getGradientPinPosition(int n) {
        return this.m_pfj.getGradientPinPosition(this.m_identObj, n);
    }

    public void setGradientPinPosition(double d, int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid pin index", this.getClass().getName(), "setGradientPinPosition(double newPos, int pinIndex)");
            return;
        }
        if (d < 0.0 || d > 1.0) {
            this.m_graph.getErrorHandler().log("invalid Pin Position", this.getClass().getName(), "setGradientPinPosition(double newPos, int pinIndex)");
            return;
        }
        int n2 = this.m_isDefaultColor.size();
        if (n2 <= n) {
            int n3 = 0;
            while (n3 < n - n2 + 1) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n3;
            }
        }
        this.m_isDefaultPosition.set(n, new Boolean(false));
        this.m_pfj.setGradientPinPosition(this.m_identObj, d, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinPosition(this.m_identObj2, d, n);
        }
    }

    public Color getGradientPinLeftColor(int n) {
        return this.m_pfj.getGradientPinLeftColor(this.m_identObj, n);
    }

    public void setGradientPinLeftColor(Color color, int n) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGradientPinLeftColor( Color newColor, int pinIndex )");
            return;
        }
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid pin index", this.getClass().getName(), "setGradientPinLeftColor(Color newColor, int pinIndex)");
            return;
        }
        int n2 = this.m_isDefaultColor.size();
        if (n2 <= n) {
            int n3 = 0;
            while (n3 < n - n2 + 1) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n3;
            }
        }
        this.m_isDefaultColor.set(n, new Boolean(false));
        this.m_pfj.setGradientPinLeftColor(this.m_identObj, color, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinLeftColor(this.m_identObj2, color, n);
        }
    }

    public Color getGradientPinRightColor(int n) {
        return this.m_pfj.getGradientPinRightColor(this.m_identObj, n);
    }

    public void setGradientPinRightColor(Color color, int n) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGradientPinRightColor( Color newColor, int pinIndex )");
            return;
        }
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid pin index", this.getClass().getName(), "setGradientPinRightColor(Color newColor, int pinIndex)");
            return;
        }
        int n2 = this.m_isDefaultColor.size();
        if (n2 <= n) {
            int n3 = 0;
            while (n3 < n - n2 + 1) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n3;
            }
        }
        this.m_isDefaultColor.set(n, new Boolean(false));
        this.m_pfj.setGradientPinRightColor(this.m_identObj, color, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinRightColor(this.m_identObj2, color, n);
        }
    }

    public Color getGradientStopColor(int n) {
        return this.m_pfj.getGradientPinRightColor(this.m_identObj, n);
    }

    public void setGradientStopColor(Color color, int n) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setGradientStopColor( Color newColor, int index )");
            return;
        }
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid stop index", this.getClass().getName(), "setGradientStopColor( Color newColor, int index )");
            return;
        }
        int n2 = this.m_isDefaultColor.size();
        if (n2 <= n) {
            int n3 = 0;
            while (n3 < n - n2 + 1) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n3;
            }
        }
        this.m_pfj.setGradientPinRightColor(this.m_identObj, color, n);
        this.m_pfj.setGradientPinLeftColor(this.m_identObj, color, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinRightColor(this.m_identObj2, color, n);
            this.m_pfj.setGradientPinLeftColor(this.m_identObj2, color, n);
        }
        if (!this.m_isCalledFromNumStops) {
            this.m_isDefaultColor.set(n, new Boolean(false));
            this.setStopPropertyOverrideFlags(0, n);
        }
    }

    public double getGradientStopPosition(int n) {
        return (double)100 * this.m_pfj.getGradientPinPosition(this.m_identObj, n);
    }

    public void setGradientStopPosition(double d, int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid stop index", this.getClass().getName(), "setGradientStopPosition(double newPos, int index)");
            return;
        }
        if (d < 0.0 || d > 100.0) {
            this.m_graph.getErrorHandler().log("invalid stop Position", this.getClass().getName(), "setGradientStopPosition(double newPos, int index)");
            return;
        }
        int n2 = this.m_isDefaultColor.size();
        if (n2 <= n) {
            int n3 = 0;
            while (n3 < n - n2 + 1) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n3;
            }
        }
        this.m_pfj.setGradientPinPosition(this.m_identObj, d /= 100.0, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientPinPosition(this.m_identObj2, d, n);
        }
        this.m_isDefaultPosition.set(n, new Boolean(false));
        this.setStopPropertyOverrideFlags(1, n);
    }

    public int getGradientNumStops() {
        return this.m_pfj.getGradientNumPins(this.m_identObj);
    }

    public void setGradientNumStops(int n) {
        int n2;
        int n3 = this.m_isDefaultColor.size();
        if (n3 < n) {
            n2 = 0;
            while (n2 < n - n3) {
                this.m_isDefaultColor.addElement(new Boolean(true));
                this.m_isDefaultPosition.addElement(new Boolean(true));
                ++n2;
            }
        }
        if (n < 2) {
            this.m_graph.getErrorHandler().log("invalid number of stops", this.getClass().getName(), "setGradientNumStops(int numStops)");
            return;
        }
        this.m_pfj.setGradientNumPins(this.m_identObj, n);
        if (this.m_isSeries) {
            this.m_pfj.setGradientNumPins(this.m_identObj2, n);
        }
        n2 = 0;
        while (n2 < n) {
            if (((Boolean)this.m_isDefaultPosition.elementAt(n2)).booleanValue()) {
                double d = (double)n2 / (double)(n - 1);
                this.m_pfj.setGradientPinPosition(this.m_identObj, d, n2);
                if (this.m_isSeries) {
                    this.m_pfj.setGradientPinPosition(this.m_identObj2, d, n2);
                }
            }
            if (((Boolean)this.m_isDefaultColor.elementAt(n2)).booleanValue()) {
                this.m_isCalledFromNumStops = true;
                if (n2 % 2 == 0) {
                    if (this.m_isSeries) {
                        this.setGradientStopColor(this.m_pfj.getFillColor(this.m_pfj.getSeries(this.m_series)), n2);
                    } else {
                        this.setGradientStopColor(new Color(-2302756), n2);
                    }
                } else {
                    this.setGradientStopColor(Color.white, n2);
                }
            }
            ++n2;
        }
        this.m_isCalledFromNumStops = false;
        if (!this.m_isCalledFromFillType) {
            this.setPropertyOverrideFlags(4);
        }
        this.m_isCalledFromFillType = false;
    }

    public void setGradientReversed(boolean bl) {
        int n = this.getGradientDirection();
        int n2 = this._calcReversedGradientDirection(n);
        int n3 = n;
        if (bl) {
            n3 = n2;
        }
        this.m_pfj.setGradientDirection(this.m_identObj, n3);
        if (this.m_isSeries) {
            this.m_pfj.setGradientDirection(this.m_identObj2, n3);
        }
        this.m_reversed = bl;
        this.setPropertyOverrideFlags(5);
    }

    private int _calcReversedGradientDirection(int n) {
        switch (n) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 9: {
                return 9;
            }
        }
        return n;
    }

    public boolean isGradientReversed() {
        return this.m_reversed;
    }

    public int getTextureDisplayMode() {
        return this.m_pfj.getTextureDisplayMode(this.m_identObj);
    }

    public void setTextureDisplayMode(int n) {
        if (n != 1 && n != 0) {
            this.m_graph.getErrorHandler().log("invalid texture mode", this.getClass().getName(), "setTextureDisplayMode(int mode)");
        } else {
            this.m_pfj.setTextureDisplayMode(this.m_identObj, n);
            if (this.m_isSeries) {
                this.m_pfj.setTextureDisplayMode(this.m_identObj2, n);
            }
            this.setPropertyOverrideFlags(2);
        }
    }

    public String getTexture() {
        return this.m_pfj.getTexture(this.m_identObj);
    }

    public String getTextureURL() {
        String string = "";
        if (this.m_url) {
            string = this.m_pfj.getTexture(this.m_identObj);
        }
        return string;
    }

    public void setTextureURL(String string) {
        if (string == null) {
            this.m_graph.getErrorHandler().log("invalid URL", this.getClass().getName(), "setTextureURL");
            return;
        }
        this.m_pfj.setTextureURL(this.m_identObj, string);
        if (this.m_isSeries) {
            this.m_pfj.setTextureURL(this.m_identObj2, string);
        }
        this.m_url = true;
    }

    public void setTextureImage(String string, Image image) {
        this.m_pfj.setTextureURL(this.m_identObj, string, image);
        if (this.m_isSeries) {
            this.m_pfj.setTextureURL(this.m_identObj2, string, image);
        }
        this.m_url = false;
    }

    protected void setGradientPinStyleXML(ObjectNode objectNode, int n) {
        PropertyNode propertyNode = objectNode.getProperty(a_position);
        if (propertyNode != null) {
            this.setGradientPinPosition(propertyNode.getValueAsInteger(), n);
        }
        if ((propertyNode = objectNode.getProperty(a_gradientPinLeftColor)) != null) {
            this.setGradientPinLeftColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())), n);
        }
        if ((propertyNode = objectNode.getProperty(a_gradientPinRightColor)) != null) {
            this.setGradientPinRightColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())), n);
        }
    }

    protected ObjectNode getGradientStyleXML(boolean bl, int n) {
        ObjectNode objectNode = new ObjectNode(GRADIENTPINSTYLE_NAME);
        boolean bl2 = false;
        objectNode.addProperty(a_pinIndex, n);
        if (bl || !this.isStopUserOverrideFlag(1, n) && !((Boolean)this.m_isDefaultPosition.elementAt(n)).booleanValue() && 0.5 != this.getGradientPinPosition(n)) {
            objectNode.addProperty(a_position, this.getGradientPinPosition(n));
            bl2 = true;
        }
        if (bl || !this.isStopUserOverrideFlag(0, n) && !((Boolean)this.m_isDefaultColor.elementAt(n)).booleanValue() && !"#ffffff".equals(BaseGraphComponent.toHexString(this.getGradientPinLeftColor(n).getRGB()))) {
            objectNode.addProperty(a_gradientPinLeftColor, BaseGraphComponent.toHexString(this.getGradientPinLeftColor(n).getRGB()));
            bl2 = true;
        }
        if (bl || !this.isStopUserOverrideFlag(0, n) && !((Boolean)this.m_isDefaultColor.elementAt(n)).booleanValue() && !"#ffffff".equals(BaseGraphComponent.toHexString(this.getGradientPinRightColor(n).getRGB()))) {
            objectNode.addProperty(a_gradientPinRightColor, BaseGraphComponent.toHexString(this.getGradientPinRightColor(n).getRGB()));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected String getComponentName() {
        return "SFX";
    }

    protected int getStylePropertyCount() {
        return 6;
    }

    protected ObjectNode getGradientStopStyleXML(boolean bl, int n) {
        ObjectNode objectNode = new ObjectNode(GRADIENTSTOPSTYLE_NAME);
        boolean bl2 = false;
        objectNode.addProperty("stopIndex", n);
        if (bl || this.isStopUserOverrideFlag(1, n)) {
            objectNode.addProperty(a_gradientStopPosition, this.getGradientStopPosition(n));
            bl2 = true;
        }
        if (bl || this.isStopUserOverrideFlag(0, n)) {
            objectNode.addProperty(a_gradientStopColor, BaseGraphComponent.toHexString(this.getGradientStopColor(n).getRGB()));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected ContainerNode getXML(boolean bl, boolean bl2) {
        int n;
        ContainerNode containerNode = new ContainerNode(this.getComponentName());
        boolean bl3 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            n = this.getFillType();
            if (n == 1) {
                containerNode.addProperty(a_fillType, "FT_COLOR");
            } else if (n == 2) {
                containerNode.addProperty(a_fillType, "FT_GRADIENT");
            } else if (n == 3) {
                containerNode.addProperty(a_fillType, "FT_TEXTURE");
            }
            bl3 = true;
        }
        if (this.m_url) {
            containerNode.addProperty(a_textureURL, this.getTexture());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            n = this.getGradientDirection();
            if (n == 1) {
                containerNode.addProperty(a_gradientDirection, "GD_RIGHT");
            } else if (n == 3) {
                containerNode.addProperty(a_gradientDirection, "GD_DOWN");
            } else if (n == 5) {
                containerNode.addProperty(a_gradientDirection, "GD_DIAGONAL_45");
            } else if (n == 9) {
                containerNode.addProperty(a_gradientDirection, "GD_RADIAL");
            } else if (n == 7) {
                containerNode.addProperty(a_gradientDirection, "GD_DIAGONAL_135");
            }
            bl3 = true;
        }
        if (this.m_depDirection && bl2) {
            n = 1;
            int n2 = this.getGradientDirection();
            if (n2 == 2) {
                containerNode.addProperty(a_gradientDirection, "GD_LEFT");
            } else if (n2 == 4) {
                containerNode.addProperty(a_gradientDirection, "GD_UP");
            } else if (n2 == 6) {
                containerNode.addProperty(a_gradientDirection, "GD_UP_LEFT");
            } else if (n2 == 8) {
                containerNode.addProperty(a_gradientDirection, "GD_UP_RIGHT");
            } else if (n2 == 11) {
                containerNode.addProperty(a_gradientDirection, "GD_RADIAL_TOP_RIGHT");
            } else if (n2 == 10) {
                containerNode.addProperty(a_gradientDirection, "GD_RADIAL_TOP_LEFT");
            } else if (n2 == 13) {
                containerNode.addProperty(a_gradientDirection, "GD_RADIAL_BOTTOM_RIGHT");
            } else if (n2 == 12) {
                containerNode.addProperty(a_gradientDirection, "GD_RADIAL_BOTTOM_LEFT");
            } else {
                n = 0;
            }
            if (n != 0) {
                bl3 = true;
            }
        }
        if (bl2 && (bl || !this.isUserOverrideFlag(4) && 2 != this.getGradientNumPins())) {
            containerNode.addProperty(a_gradientNumPins, this.getGradientNumPins());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            n = this.getTextureDisplayMode();
            if (n == 1) {
                containerNode.addProperty(a_textureDisplayMode, "TDM_STRETCHED");
            } else if (n == 0) {
                containerNode.addProperty(a_textureDisplayMode, "TDM_TILED");
            }
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            containerNode.addProperty(a_gradientNumStops, this.getGradientNumStops());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            containerNode.addProperty(a_gradientReversed, this.isGradientReversed());
            bl3 = true;
        }
        if (bl2) {
            n = 0;
            while (n < this.getGradientNumPins()) {
                ObjectNode objectNode = this.getGradientStyleXML(bl, n);
                if (objectNode != null) {
                    containerNode.addContainedObject(objectNode);
                    bl3 = true;
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.getGradientNumStops()) {
            ObjectNode objectNode = this.getGradientStopStyleXML(bl, n);
            if (objectNode != null) {
                containerNode.addContainedObject(objectNode);
                bl3 = true;
            }
            ++n;
        }
        if (bl3) {
            return containerNode;
        }
        return null;
    }

    protected void setXML(ContainerNode containerNode, boolean bl) {
        int n;
        PropertyNode propertyNode;
        ObjectNode objectNode;
        Object object;
        PropertyNode propertyNode2 = containerNode.getProperty(a_fillType);
        if (propertyNode2 != null) {
            object = propertyNode2.getValueAsString();
            if (((String)object).equals("FT_COLOR")) {
                this.setFillType(1);
            } else if (((String)object).equals("FT_GRADIENT")) {
                this.setFillType(2);
            } else if (((String)object).equals("FT_TEXTURE")) {
                this.setFillType(3);
            }
        }
        if ((propertyNode2 = containerNode.getProperty(a_textureURL)) != null) {
            this.setTextureURL(propertyNode2.getValueAsString());
        }
        if ((propertyNode2 = containerNode.getProperty(a_gradientDirection)) != null) {
            object = propertyNode2.getValueAsString();
            if (((String)object).equals("GD_RIGHT")) {
                this.setGradientDirection(1);
            } else if (((String)object).equals("GD_LEFT")) {
                this.setGradientDirection(2);
            } else if (((String)object).equals("GD_DOWN")) {
                this.setGradientDirection(3);
            } else if (((String)object).equals("GD_UP")) {
                this.setGradientDirection(4);
            } else if (((String)object).equals("GD_DOWN_LEFT")) {
                this.setGradientDirection(5);
            } else if (((String)object).equals("GD_DOWN_RIGHT")) {
                this.setGradientDirection(7);
            } else if (((String)object).equals("GD_UP_RIGHT")) {
                this.setGradientDirection(8);
            } else if (((String)object).equals("GD_RADIAL_TOP_LEFT")) {
                this.setGradientDirection(10);
            } else if (((String)object).equals("GD_RADIAL_BOTTOM_LEFT")) {
                this.setGradientDirection(12);
            } else if (((String)object).equals("GD_RADIAL_BOTTOM_RIGHT")) {
                this.setGradientDirection(13);
            } else if (((String)object).equals("GD_RADIAL_TOP_RIGHT")) {
                this.setGradientDirection(11);
            } else if (((String)object).equals("GD_RADIAL")) {
                this.setGradientDirection(9);
            } else if (((String)object).equals("GD_UP_LEFT")) {
                this.setGradientDirection(6);
            } else if (((String)object).equals("GD_DIAGONAL_45")) {
                this.setGradientDirection(5);
            } else if (((String)object).equals("GD_DIAGONAL_135")) {
                this.setGradientDirection(7);
            }
        }
        if (bl && (propertyNode2 = containerNode.getProperty(a_gradientNumPins)) != null) {
            this.setGradientNumPins(propertyNode2.getValueAsInteger());
        }
        if ((propertyNode2 = containerNode.getProperty(a_textureDisplayMode)) != null) {
            object = propertyNode2.getValueAsString();
            if (((String)object).equals("TDM_STRETCHED")) {
                this.setTextureDisplayMode(1);
            } else if (((String)object).equals("TDM_TILED")) {
                this.setTextureDisplayMode(0);
            }
        }
        if (bl) {
            object = containerNode.getContainedObject();
            while (object.hasMoreElements()) {
                objectNode = (ObjectNode)object.nextElement();
                propertyNode = objectNode.getProperty(a_pinIndex);
                if (propertyNode == null) continue;
                n = propertyNode.getValueAsInteger();
                propertyNode2 = objectNode.getProperty(a_position);
                if (propertyNode2 != null) {
                    this.setGradientPinPosition(propertyNode2.getValueAsDouble(), n);
                }
                if ((propertyNode2 = objectNode.getProperty(a_gradientPinLeftColor)) != null) {
                    this.setGradientPinLeftColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode2.getValueAsString())), n);
                }
                if ((propertyNode2 = objectNode.getProperty(a_gradientPinRightColor)) == null) continue;
                this.setGradientPinRightColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode2.getValueAsString())), n);
            }
        }
        if ((propertyNode2 = containerNode.getProperty(a_gradientNumStops)) != null) {
            this.setGradientNumStops(propertyNode2.getValueAsInteger());
        }
        if ((propertyNode2 = containerNode.getProperty(a_gradientReversed)) != null) {
            this.setGradientReversed(propertyNode2.getValueAsBoolean());
        }
        object = containerNode.getContainedObject();
        while (object.hasMoreElements()) {
            objectNode = (ObjectNode)object.nextElement();
            propertyNode = objectNode.getProperty("stopIndex");
            if (propertyNode == null) continue;
            n = propertyNode.getValueAsInteger();
            propertyNode2 = objectNode.getProperty(a_gradientStopPosition);
            if (propertyNode2 != null) {
                this.setGradientStopPosition(propertyNode2.getValueAsDouble(), n);
            }
            if ((propertyNode2 = objectNode.getProperty(a_gradientStopColor)) == null) continue;
            this.setGradientStopColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode2.getValueAsString())), n);
        }
    }

    protected void createStopPropertyOverrideFlags() {
        int n = 0;
        while (n < 100) {
            this._stopUserOverrideFlags[n] = this.m_graph.createPropertyOverrideFlags(2);
            this._stopStyleOverrideFlags[n] = this.m_graph.createPropertyOverrideFlags(2);
            ++n;
        }
    }

    protected void setStopPropertyOverrideFlags(int n, int n2) {
        this.m_graph.setPropertyOverrideFlags(n, this._stopUserOverrideFlags[n2], this._stopStyleOverrideFlags[n2]);
    }

    protected boolean isStopUserOverrideFlag(int n, int n2) {
        return this.m_graph.isPropertyOverrideFlag(n, this._stopUserOverrideFlags[n2]);
    }
}

