/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.BaseGraphXML;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.SFX;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class ExceptionalRiser
extends BaseGraphXML {
    protected static final int ATTR_FILLCOLOR = 0;
    protected static final int ATTR_BORDERCOLOR = 1;
    protected static final int ATTR_STYLE_MAXID = 2;
    protected Graph m_graph;
    protected PFJ m_pfj;
    protected IdentObj m_identObj;
    protected SFX m_sfx;
    protected static final String a_series = "series";
    protected static final String a_group = "group";
    protected static final String a_borderColor = "borderColor";
    protected static final String a_fillColor = "fillColor";
    protected String fillColor;
    protected String borderColor;

    public ExceptionalRiser(Graph graph, int n, int n2) {
        super(graph);
        this.m_graph = graph;
        this.m_pfj = graph.getPFJ();
        this.m_pfj.setExceptionalRiser(n, n2);
        this.m_identObj = this.m_pfj.getExceptionalRiser(n, n2);
        this.fillColor = GraphDefaultValues.getExceptionalRaiserFillColor();
        this.borderColor = GraphDefaultValues.getExceptionalRaiserBorderColor();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_graph, this.m_identObj);
        }
        return this.m_sfx;
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(0);
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(1);
    }

    protected String getComponentName() {
        return "ExceptionalRiser";
    }

    protected int getStylePropertyCount() {
        return 2;
    }

    protected ObjectNode getXML(boolean bl, boolean bl2) {
        ObjectNode objectNode = new ObjectNode(this.getComponentName());
        boolean bl3 = false;
        objectNode.addProperty(a_series, this.m_identObj.getSeriesID());
        objectNode.addProperty(a_group, this.m_identObj.getGroupID());
        ContainerNode containerNode = this.getSFX().getXML(bl, bl2);
        if (containerNode != null) {
            objectNode.addContainer(containerNode);
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty(a_borderColor, BaseGraphComponent.toHexString(this.getBorderColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty(a_fillColor, BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
            bl3 = true;
        }
        return bl3 ? objectNode : null;
    }

    protected void setXML(ObjectNode objectNode, boolean bl) {
        PropertyNode propertyNode;
        ContainerNode containerNode = objectNode.getContainer("SFX");
        if (containerNode != null) {
            this.getSFX().setXML(containerNode, bl);
        }
        if ((propertyNode = objectNode.getProperty(a_borderColor)) != null) {
            this.setBorderColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty(a_fillColor)) != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
    }

    protected void resetStyle() {
        this.m_pfj.setBorderColor(this.m_identObj, new Color(BaseGraphComponent.hexStringToInt(this.borderColor)));
        this.m_pfj.setFillColor(this.m_identObj, new Color(BaseGraphComponent.hexStringToInt(this.fillColor)));
        super.resetStyle();
    }

    protected void createPropertyOverrideFlags() {
        if (this.m_sfx != null) {
            this.m_sfx.createPropertyOverrideFlags();
        }
        super.createPropertyOverrideFlags();
    }
}

