/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.util.ErrorHandler;

public class PageSetupSheetPanel
extends JPanel
implements ActionListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected JPanel m_pageOrderPanel;
    protected JLabel m_pageOrderLabel;
    protected JPanel m_mainPanel;
    protected JCheckBox m_repeatHeaderCheckBox;
    protected JCheckBox m_repeatTitleCheckBox;
    protected JRadioButton m_downRadionButton;
    protected JRadioButton m_acrossRadionButton;
    protected JLabel m_downLabel;
    protected JLabel m_acrossLabel;
    protected JPanel m_scalePanel;
    protected JLabel m_scaleLabel;
    protected JRadioButton m_actualSizeRadioButton;
    protected JRadioButton m_graphFitToRadioButton;
    protected JCheckBox m_pRatioCheckBox;
    protected JCheckBox m_pFontSizeCheckBox;
    protected JRadioButton m_zoomRadioButton;
    protected JRadioButton m_fullFitRadioButton;
    protected MyNumericSpinBox m_zoomNumericSpinBox;
    protected JLabel m_zoomLabel;
    protected NumericSpinBox m_widthNumericSpinBox;
    protected JLabel m_widthLabel;
    protected NumericSpinBox m_heightNumericSpinBox;
    protected JLabel m_heightLabel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled = true;
    private int m_viewType;

    public PageSetupSheetPanel(ViewPrinter[] viewPrinterArray) {
        this((UIViewPrinter[])viewPrinterArray);
    }

    public PageSetupSheetPanel(UIViewPrinter[] uIViewPrinterArray) {
        if (uIViewPrinterArray == null) {
            return;
        }
        this.m_viewPrinter = uIViewPrinterArray;
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_viewType = uIViewPrinterArray[0].getViewPrinterType();
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        if (this.m_viewType != 2) {
            this.m_pageOrderPanel = new JPanel();
            this.m_pageOrderPanel.setAlignmentX(0.0f);
            this.m_pageOrderPanel.setLayout(new BoxLayout(this.m_pageOrderPanel, 1));
            String string = this.m_viewType == 0 ? this.rBundle.getString("Crosstab Page Order") : this.rBundle.getString("Table Page Order");
            this.m_pageOrderLabel = new JLabel(string);
            this.m_pageOrderLabel.setAlignmentX(0.0f);
            this.m_pageOrderLabel.setMinimumSize(this.m_pageOrderLabel.getPreferredSize());
            this.m_pageOrderLabel.setMaximumSize(this.m_pageOrderLabel.getPreferredSize());
            this.m_pageOrderPanel.add(this.m_pageOrderLabel);
            JPanel jPanel = new JPanel();
            jPanel.setAlignmentX(0.0f);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            string = this.rBundle.getString("Across, then Down");
            this.m_acrossRadionButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_acrossRadionButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_acrossRadionButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("AcrossThenDownADA"));
            this.m_acrossRadionButton.setAlignmentX(0.0f);
            this.m_acrossLabel = new JLabel();
            this.m_acrossLabel.setAlignmentX(0.0f);
            this.m_acrossLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.PageSetupSheetPanel"), (String)"images/across_down.gif")));
            jPanel.add(this.m_acrossRadionButton);
            jPanel.add(this.m_acrossLabel);
            jPanel.setMinimumSize(jPanel.getPreferredSize());
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            this.m_pageOrderPanel.add(jPanel);
            jPanel = new JPanel();
            jPanel.setAlignmentX(0.0f);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            string = this.rBundle.getString("Down, then Across");
            this.m_downRadionButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_downRadionButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_downRadionButton.setAlignmentX(0.0f);
            this.m_downRadionButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("DownThenAcrossADA"));
            this.m_downLabel = new JLabel();
            this.m_downLabel.setAlignmentX(0.0f);
            this.m_downLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.PageSetupSheetPanel"), (String)"images/down_across.gif")));
            jPanel.add(this.m_downRadionButton);
            jPanel.add(this.m_downLabel);
            jPanel.setMinimumSize(jPanel.getPreferredSize());
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            this.m_pageOrderPanel.add(jPanel);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_downRadionButton);
            buttonGroup.add(this.m_acrossRadionButton);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            string = this.rBundle.getString("Repeat headers on every page");
            this.m_repeatHeaderCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.m_repeatHeaderCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_repeatHeaderCheckBox.addActionListener(this);
            this.m_repeatHeaderCheckBox.setAlignmentX(0.0f);
            jPanel.add(this.m_repeatHeaderCheckBox);
            string = this.m_viewType == 0 ? this.rBundle.getString("Repeat crosstab title on every page") : this.rBundle.getString("Repeat table title on every page");
            this.m_repeatTitleCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.m_repeatTitleCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_repeatTitleCheckBox.addActionListener(this);
            this.m_repeatTitleCheckBox.setAlignmentX(0.0f);
            jPanel.add(this.m_repeatTitleCheckBox);
            jPanel.setMinimumSize(jPanel.getPreferredSize());
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            this.m_pageOrderPanel.add(jPanel);
            this.m_pageOrderPanel.setMinimumSize(this.m_pageOrderPanel.getPreferredSize());
            this.m_pageOrderPanel.setMaximumSize(this.m_pageOrderPanel.getPreferredSize());
            this.m_mainPanel.add(this.m_pageOrderPanel);
            this.m_mainPanel.add(Box.createVerticalStrut(15));
            this.m_scalePanel = new JPanel();
            this.m_scalePanel.setAlignmentX(0.0f);
            this.m_scalePanel.setLayout(new BoxLayout(this.m_scalePanel, 1));
            string = this.m_viewType == 0 ? this.rBundle.getString("Crosstab Scaling") : this.rBundle.getString("Table Scaling");
            this.m_scaleLabel = new JLabel(string);
            this.m_scaleLabel.setAlignmentX(0.0f);
            this.m_scaleLabel.setMinimumSize(this.m_scaleLabel.getPreferredSize());
            this.m_scaleLabel.setMaximumSize(this.m_scaleLabel.getPreferredSize());
            this.m_scalePanel.add(this.m_scaleLabel);
            this.m_scalePanel.add(Box.createVerticalStrut(5));
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            string = this.rBundle.getString("Adjust to");
            this.m_zoomRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_zoomRadioButton.setMinimumSize(this.m_zoomRadioButton.getPreferredSize());
            this.m_zoomRadioButton.setMaximumSize(this.m_zoomRadioButton.getPreferredSize());
            this.m_zoomRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_zoomRadioButton.setSelected(true);
            this.m_zoomRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("AdjustToADA"));
            this.m_zoomNumericSpinBox = new MyNumericSpinBox(1, 9999);
            this.m_zoomNumericSpinBox.setPreferredSize(new Dimension(50, 22));
            this.m_zoomNumericSpinBox.setMinimumSize(this.m_zoomNumericSpinBox.getPreferredSize());
            this.m_zoomNumericSpinBox.setMaximumSize(this.m_zoomNumericSpinBox.getPreferredSize());
            this.m_zoomNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("AdjustToADA"));
            jPanel.add(this.m_zoomRadioButton);
            jPanel.add((Component)((Object)this.m_zoomNumericSpinBox));
            this.m_scalePanel.add(jPanel);
            string = this.rBundle.getString("Fit to");
            this.m_fullFitRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_fullFitRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_fullFitRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("Fit to"));
            this.m_fullFitRadioButton.setMinimumSize(this.m_fullFitRadioButton.getPreferredSize());
            this.m_fullFitRadioButton.setMaximumSize(this.m_fullFitRadioButton.getPreferredSize());
            this.m_scalePanel.add(this.m_fullFitRadioButton);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            this.m_widthNumericSpinBox = new NumericSpinBox(1, 9999);
            this.m_widthNumericSpinBox.setPreferredSize(new Dimension(50, 22));
            this.m_widthNumericSpinBox.setMinimumSize(this.m_widthNumericSpinBox.getPreferredSize());
            this.m_widthNumericSpinBox.setMaximumSize(this.m_widthNumericSpinBox.getPreferredSize());
            this.m_widthNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("FitToPagesWideADA"));
            string = this.rBundle.getString("Pages Wide");
            this.m_widthLabel = new JLabel(StringUtils.stripMnemonic((String)string));
            this.m_widthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_widthLabel.setAlignmentX(0.0f);
            jPanel.add(Box.createHorizontalStrut(20));
            jPanel.add(this.m_widthLabel);
            jPanel.add((Component)this.m_widthNumericSpinBox);
            this.m_scalePanel.add(jPanel);
            this.m_scalePanel.add(Box.createVerticalStrut(3));
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            string = this.rBundle.getString("Pages Tall");
            this.m_heightLabel = new JLabel(StringUtils.stripMnemonic((String)string));
            this.m_heightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_heightLabel.setAlignmentX(0.0f);
            this.m_heightNumericSpinBox = new NumericSpinBox(1, 9999);
            this.m_heightNumericSpinBox.setPreferredSize(new Dimension(50, 22));
            this.m_heightNumericSpinBox.setMinimumSize(this.m_heightNumericSpinBox.getPreferredSize());
            this.m_heightNumericSpinBox.setMaximumSize(this.m_heightNumericSpinBox.getPreferredSize());
            this.m_heightLabel.setLabelFor((Component)this.m_heightNumericSpinBox);
            this.m_heightNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("ByPagesTallADA"));
            jPanel.add(Box.createHorizontalStrut(20));
            jPanel.add(this.m_heightLabel);
            jPanel.add((Component)this.m_heightNumericSpinBox);
            this.m_scalePanel.add(jPanel);
            int n = Math.max(this.getToolkit().getFontMetrics(this.m_widthLabel.getFont()).stringWidth(this.m_widthLabel.getText()), this.getToolkit().getFontMetrics(this.m_heightLabel.getFont()).stringWidth(this.m_heightLabel.getText()));
            this.m_widthLabel.setPreferredSize(new Dimension(n, this.m_widthLabel.getPreferredSize().height));
            this.m_widthLabel.setMinimumSize(this.m_widthLabel.getPreferredSize());
            this.m_widthLabel.setMaximumSize(this.m_widthLabel.getPreferredSize());
            this.m_heightLabel.setPreferredSize(new Dimension(n, this.m_heightLabel.getPreferredSize().height));
            this.m_heightLabel.setMinimumSize(this.m_heightLabel.getPreferredSize());
            this.m_heightLabel.setMaximumSize(this.m_heightLabel.getPreferredSize());
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.m_zoomRadioButton);
            buttonGroup2.add(this.m_fullFitRadioButton);
            this.m_scalePanel.setMinimumSize(this.m_scalePanel.getPreferredSize());
            this.m_scalePanel.setMaximumSize(this.m_scalePanel.getPreferredSize());
            this.m_mainPanel.add(this.m_scalePanel);
            this.m_zoomRadioButton.addActionListener(this);
            this.m_fullFitRadioButton.addActionListener(this);
        } else {
            String string = this.rBundle.getString("Graph Scaling");
            this.m_scaleLabel = new JLabel(string);
            this.m_scaleLabel.setAlignmentX(0.0f);
            this.m_scaleLabel.setMinimumSize(this.m_scaleLabel.getPreferredSize());
            this.m_scaleLabel.setMaximumSize(this.m_scaleLabel.getPreferredSize());
            this.m_mainPanel.add(this.m_scaleLabel);
            string = this.rBundle.getString("Actual size(100%)");
            this.m_actualSizeRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_actualSizeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_actualSizeRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("ActualSizeADA"));
            this.m_actualSizeRadioButton.setAlignmentX(0.0f);
            this.m_mainPanel.add(this.m_actualSizeRadioButton);
            string = this.rBundle.getString("Fit to page");
            this.m_graphFitToRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_graphFitToRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_graphFitToRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("FitToPageADA"));
            this.m_graphFitToRadioButton.setAlignmentX(0.0f);
            this.m_mainPanel.add(this.m_graphFitToRadioButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.m_actualSizeRadioButton);
            buttonGroup.add(this.m_graphFitToRadioButton);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            string = this.rBundle.getString("Preserve the ratio of height and width");
            this.m_pRatioCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.m_pRatioCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_pRatioCheckBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("PreserveTheRatioADA"));
            this.m_pRatioCheckBox.setAlignmentX(0.0f);
            jPanel.add(Box.createHorizontalStrut(25));
            jPanel.add(this.m_pRatioCheckBox);
            this.m_mainPanel.add(jPanel);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            string = this.rBundle.getString("Preserve the actual font size");
            this.m_pFontSizeCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)string));
            this.m_pFontSizeCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_pFontSizeCheckBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("PreserveTheActualADA"));
            this.m_pFontSizeCheckBox.setAlignmentX(0.0f);
            jPanel.add(Box.createHorizontalStrut(25));
            jPanel.add(this.m_pFontSizeCheckBox);
            this.m_mainPanel.add(jPanel);
            this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
            this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
            this.m_graphFitToRadioButton.addActionListener(this);
            this.m_actualSizeRadioButton.addActionListener(this);
        }
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        this._initiate();
    }

    private void _initiate() {
        if (this.m_viewType != 2) {
            if (this.m_viewPrinter[0].isPrintByColumns()) {
                this.m_acrossRadionButton.setSelected(true);
            } else {
                this.m_downRadionButton.setSelected(true);
            }
            if (this.m_viewPrinter[0].isRepeatComponent(1)) {
                this.m_repeatHeaderCheckBox.setSelected(true);
            } else {
                this.m_repeatHeaderCheckBox.setSelected(false);
            }
            if (this.m_viewPrinter[0].isDataviewTitleVisible() && this.m_viewPrinter[0].isRepeatComponent(8) || this.m_viewPrinter[0].isDataviewSubtitleVisible() && this.m_viewPrinter[0].isRepeatComponent(16) || this.m_viewPrinter[0].isDataviewFootnoteVisible() && this.m_viewPrinter[0].isRepeatComponent(32) || this.m_viewPrinter[0].isRepeatComponent(8)) {
                this.m_repeatTitleCheckBox.setSelected(true);
            } else {
                this.m_repeatTitleCheckBox.setSelected(false);
            }
            this.m_zoomNumericSpinBox.setIntValue(this.m_viewPrinter[0].getPrintZoomFactor());
            if (this.m_viewPrinter[0].getFitToNumPagesTall() > 0) {
                this.m_heightNumericSpinBox.setIntValue(this.m_viewPrinter[0].getFitToNumPagesTall());
            } else {
                this.m_heightNumericSpinBox.setIntValue(1);
            }
            if (this.m_viewPrinter[0].getFitToNumPagesWide() > 0) {
                this.m_widthNumericSpinBox.setIntValue(this.m_viewPrinter[0].getFitToNumPagesWide());
            } else {
                this.m_widthNumericSpinBox.setIntValue(1);
            }
            switch (this.m_viewPrinter[0].getGridViewPrintScaleType()) {
                case 0: {
                    this.m_zoomRadioButton.setSelected(true);
                    this.m_zoomNumericSpinBox.setEnabled(true);
                    this.m_zoomNumericSpinBox.setIntValue(100);
                    this.m_fullFitRadioButton.setSelected(false);
                    break;
                }
                case 2: {
                    this.m_fullFitRadioButton.setSelected(true);
                    this.m_widthNumericSpinBox.setEnabled(true);
                    this.m_heightNumericSpinBox.setEnabled(true);
                    break;
                }
                case 1: {
                    this.m_zoomRadioButton.setSelected(true);
                    this.m_zoomNumericSpinBox.setEnabled(true);
                }
            }
        } else {
            switch (this.m_viewPrinter[0].getGraphPrintScaleType()) {
                case 0: {
                    this.m_actualSizeRadioButton.setSelected(true);
                    this.m_graphFitToRadioButton.setSelected(false);
                    this.m_pRatioCheckBox.setEnabled(false);
                    this.m_pFontSizeCheckBox.setEnabled(false);
                    break;
                }
                case 3: {
                    this.m_graphFitToRadioButton.setSelected(true);
                    break;
                }
                case 4: {
                    this.m_graphFitToRadioButton.setSelected(true);
                    this.m_pRatioCheckBox.setSelected(true);
                    this.m_pRatioCheckBox.setEnabled(true);
                    this.m_pFontSizeCheckBox.setEnabled(true);
                }
            }
            if (this.m_viewPrinter[0].getScaleFontSize() == -1) {
                this.m_pFontSizeCheckBox.setSelected(true);
            } else {
                this.m_pFontSizeCheckBox.setSelected(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_zoomRadioButton) {
            if (this.m_zoomRadioButton.isSelected()) {
                this.m_zoomNumericSpinBox.setEnabled(true);
                this.m_widthNumericSpinBox.setEnabled(false);
                this.m_heightNumericSpinBox.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.m_fullFitRadioButton) {
            if (this.m_fullFitRadioButton.isSelected()) {
                this.m_widthNumericSpinBox.setEnabled(true);
                this.m_heightNumericSpinBox.setEnabled(true);
                this.m_zoomNumericSpinBox.setEnabled(false);
            }
        } else if (actionEvent.getSource() == this.m_graphFitToRadioButton) {
            this.m_pRatioCheckBox.setEnabled(this.m_graphFitToRadioButton.isSelected());
            this.m_pFontSizeCheckBox.setEnabled(this.m_graphFitToRadioButton.isSelected());
        } else if (actionEvent.getSource() == this.m_actualSizeRadioButton) {
            this.m_pRatioCheckBox.setEnabled(!this.m_actualSizeRadioButton.isSelected());
            this.m_pFontSizeCheckBox.setEnabled(!this.m_actualSizeRadioButton.isSelected());
        }
    }

    public void apply() {
        int n = 0;
        while (n < this.m_viewPrinter.length) {
            this.m_viewPrinter[n].setPrintByColumns(this.m_acrossRadionButton.isSelected());
            if (this.m_viewType == 2) {
                if (this.m_actualSizeRadioButton.isSelected()) {
                    this.m_viewPrinter[n].setGraphPrintScaleType(0);
                } else if (this.m_graphFitToRadioButton.isSelected()) {
                    if (this.m_pRatioCheckBox.isSelected()) {
                        this.m_viewPrinter[n].setGraphPrintScaleType(4);
                    } else {
                        this.m_viewPrinter[n].setGraphPrintScaleType(3);
                    }
                }
            } else {
                this.m_viewPrinter[n].setRepeatComponent(1, this.m_repeatHeaderCheckBox.isSelected());
                this.m_viewPrinter[n].setRepeatComponent(2, this.m_repeatHeaderCheckBox.isSelected());
                this.m_viewPrinter[n].setRepeatComponent(4, this.m_repeatHeaderCheckBox.isSelected());
                this.m_viewPrinter[n].setRepeatComponent(8, this.m_repeatTitleCheckBox.isSelected());
                this.m_viewPrinter[n].setRepeatComponent(16, this.m_repeatTitleCheckBox.isSelected());
                this.m_viewPrinter[n].setRepeatComponent(32, this.m_repeatTitleCheckBox.isSelected());
                if (this.m_zoomRadioButton.isSelected()) {
                    if (this.m_zoomNumericSpinBox.getIntValue() == 100) {
                        this.m_viewPrinter[n].setGridViewPrintScaleType(0);
                    } else {
                        this.m_viewPrinter[n].setGridViewPrintScaleType(1);
                        int n2 = this.m_zoomNumericSpinBox.getIntValue();
                        if (n2 < 10) {
                            n2 = 10;
                        }
                        this.m_viewPrinter[n].setPrintZoomFactor(n2);
                    }
                } else if (this.m_fullFitRadioButton.isSelected()) {
                    this.m_viewPrinter[n].setGridViewPrintScaleType(2);
                    this.m_viewPrinter[n].setFitToNumPagesTall(this.m_heightNumericSpinBox.getIntValue());
                    this.m_viewPrinter[n].setFitToNumPagesWide(this.m_widthNumericSpinBox.getIntValue());
                }
            }
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setViewPrinter(ViewPrinter[] viewPrinterArray) {
        if (viewPrinterArray != null) {
            this.m_viewPrinter = viewPrinterArray;
        }
        this._init();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this._init();
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    class NumberLocaleDocument
    extends PlainDocument {
        private DecimalFormat m_format;
        private JTextField m_text;
        private char Minus;
        private char Dec;

        public NumberLocaleDocument(JTextField jTextField, Locale locale) {
            this.m_text = jTextField;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.m_format.setGroupingUsed(false);
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            try {
                StringBuffer stringBuffer = new StringBuffer(this.m_text.getText());
                if (stringBuffer.length() == 4) {
                    return;
                }
                if (stringBuffer.length() == 3 && !string.equals("%")) {
                    return;
                }
                if (this.m_text.getText().endsWith("%")) {
                    stringBuffer = new StringBuffer(this.m_text.getText().substring(0, this.m_text.getText().length() - 1));
                }
                if (!this.m_text.getText().endsWith("%") && string.equals("%")) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                stringBuffer.insert(n, string);
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = this.m_format.parse(stringBuffer.toString(), parsePosition);
                if (parsePosition.getIndex() != stringBuffer.length() || string.equals(".") || string.equals("-")) {
                    return;
                }
                super.insertString(n, string, attributeSet);
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    class MySpinBuddy
    extends JTextField
    implements SpinBuddy {
        int p;
        MyNumericSpinBox m_myNumericSpinBox;
        NumberLocaleDocument m_numberLocaleDocument = null.new NumberLocaleDocument(this, Locale.getDefault());

        MySpinBuddy(MyNumericSpinBox myNumericSpinBox) {
            this.setBorder(null);
            this.setDocument(this.m_numberLocaleDocument);
            this.m_myNumericSpinBox = myNumericSpinBox;
            this.addKeyListener(new KeyAdapter(this){
                final /* synthetic */ MySpinBuddy this$0;

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        try {
                            this.this$0.m_numberLocaleDocument.insertString(this.this$0.m_numberLocaleDocument.getLength(), "%", null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
                {
                    this.this$0 = mySpinBuddy;
                }
            });
        }

        public void setValue(Object object) {
            try {
                this.m_numberLocaleDocument.remove(0, this.m_numberLocaleDocument.getLength());
                this.m_numberLocaleDocument.insertString(0, object.toString(), null);
                this.m_numberLocaleDocument.insertString(this.m_numberLocaleDocument.getLength(), "%", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class MySpinBoxModel
    implements SpinBoxModel {
        int m_value;
        boolean m_forward = true;

        MySpinBoxModel() {
        }

        public final Object nextElement() {
            if (this.m_forward) {
                ++this.m_value;
                if (this.m_value > 999) {
                    this.m_value = 999;
                }
            } else {
                --this.m_value;
                if (this.m_value < 0) {
                    this.m_value = 0;
                }
            }
            return new Integer(this.m_value);
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 10;
        }

        public void setIteratingForward(boolean bl) {
            this.m_forward = bl;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int n) {
            if (this.m_forward) {
                this.m_value += 1 * n;
                return new Integer(this.m_value);
            }
            this.m_value -= 1 * n;
            if (this.m_value < 0) {
                this.m_value = 0;
            }
            return new Integer(this.m_value);
        }

        public int remainingElements(int n) {
            return n - this.m_value;
        }

        public void setValue(int n) {
            this.m_value = n;
        }

        public int getValue() {
            return this.m_value;
        }
    }

    class MyNumericSpinBox
    extends SpinBox {
        private MySpinBuddy mySpinBuddy;
        private MySpinBoxModel mySpinBoxModel = null.new MySpinBoxModel();

        MyNumericSpinBox(int n, int n2) {
            this.mySpinBuddy = new MySpinBuddy(this);
            this.setSpinBuddy(this.mySpinBuddy);
            this.setModel(this.mySpinBoxModel);
        }

        public int getIntValue() {
            String string = this.mySpinBuddy.getText();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            return new Integer(string);
        }

        public void setIntValue(int n) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(n);
            } else {
                this.mySpinBoxModel.setValue(n);
            }
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 2));
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 1));
        }

        public void spinButtonSpinning(SpinButtonEvent spinButtonEvent) {
            String string = this.mySpinBuddy.getText();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n != null) {
                this.setIntValue(n);
            }
            super.spinButtonSpinning(spinButtonEvent);
        }
    }
}

