/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class RelationalEdge
implements Edge {
    private int m_nLimit = -1;
    private Member[] m_members;

    public RelationalEdge(ObjectNode objectNode, Data data, Map map) {
        int n = 0;
        ContainerNode containerNode = null;
        if (objectNode != null) {
            try {
                n = objectNode.getPropertyValueAsInteger("layerCount");
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
            try {
                this.m_nLimit = objectNode.getPropertyValueAsInteger("limit");
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
            containerNode = objectNode.getContainer("Layers");
            if (containerNode == null) {
                n = 0;
            }
        }
        this.m_members = new Member[n];
        if (n > 0) {
            Enumeration enumeration = containerNode.getContainedObject("Member");
            int n2 = 0;
            while (n2 < n) {
                if (enumeration.hasMoreElements()) {
                    ObjectNode objectNode2 = (ObjectNode)enumeration.nextElement();
                    this.m_members[n2] = new Member(objectNode2, map);
                    ContainerNode containerNode2 = objectNode2.getContainer("Data");
                    if (data != null && containerNode2 != null) {
                        data.readDataFromXML(containerNode2, n2);
                    }
                } else {
                    this.m_members[n2] = new Member();
                }
                ++n2;
            }
        }
    }

    public RelationalEdge(DataAccess dataAccess, int n, Map map, int n2) {
        int n3 = 1;
        try {
            n3 = dataAccess.getLayerCount(n);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        if (n2 != -1 && n3 > n2) {
            n3 = n2;
            this.m_nLimit = n2;
        }
        this.m_members = new Member[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_members[n4] = new Member(dataAccess, n, n4, 0, map);
            ++n4;
        }
    }

    public ObjectNode addEdgeToXML(String string, Data data, Map map, Map map2) {
        ObjectNode objectNode = new ObjectNode(string);
        int n = this.getLayerCount();
        objectNode.addProperty("layerCount", n);
        objectNode.addProperty("limit", this.getLimit());
        ContainerNode containerNode = new ContainerNode("Layers");
        int n2 = 0;
        while (n2 < n) {
            ObjectNode objectNode2 = this.m_members[n2].addMemberToXML(map);
            if (data != null) {
                ContainerNode containerNode2 = new ContainerNode("Data");
                data.addDataToXML(containerNode2, n2);
                objectNode2.addContainer(containerNode2);
            }
            containerNode.addContainedObject(objectNode2);
            ++n2;
        }
        objectNode.addContainer(containerNode);
        return objectNode;
    }

    public Object getMemberMetadata(int n, int n2, String string) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getMember(n).getMetadata(string);
    }

    public Object getLayerMetadata(int n, String string) throws LayerOutOfRangeException {
        if (string.equals("dimShortName")) {
            string = "shortName";
        } else if (string.equals("dimMediumName")) {
            string = "mediumName";
        } else if (string.equals("dimLongName")) {
            string = "longName";
        } else if (string.equals("dimName")) {
            string = "value";
        }
        return this.getMember(n).getMetadata(string);
    }

    public int getLayerCount() {
        return this.m_members.length;
    }

    public int getExtent() {
        return this.getLayerCount();
    }

    public int getLimit() {
        return this.m_nLimit;
    }

    public Object getSliceLabel(int n) throws SliceOutOfRangeException {
        try {
            Object object = this.getMember(n).getMetadata("longName");
            return object;
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            Object var3_4 = null;
            return var3_4;
        }
    }

    public int getSliceMemberCount(int n) throws SliceOutOfRangeException {
        return 0;
    }

    public int getMemberDepth(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 1;
    }

    public int getSliceOutlineLayer(int n) throws SliceOutOfRangeException {
        return 0;
    }

    public int getMemberStartLayer(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 0;
    }

    public int getMemberExtent(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    public int getMemberStartSlice(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    public int getMemberSiblingCount(int[] nArray, int n) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 0;
    }

    public Object getMemberMetadata(int[] nArray, int n, int n2, String string) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getMemberHPos(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getFirstHPos() {
        return null;
    }

    public int[] getLastHPos() {
        return null;
    }

    public int[] getPrevHPos(int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getNextHPos(int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int getCurrentSlice() {
        return 0;
    }

    public int[] getCurrentHPos() {
        return null;
    }

    public QDR getMemberQDR(int n, int n2) {
        return null;
    }

    public QDR getSliceQDR(int n) {
        return null;
    }

    private Member getMember(int n) throws LayerOutOfRangeException {
        if (n >= this.m_members.length) {
            throw new LayerOutOfRangeException(n, this.m_members.length - 1);
        }
        if (n < 0) {
            throw new LayerOutOfRangeException(n, 0);
        }
        return this.m_members[n];
    }

    public Enumeration getMemberEnumeration(int n) {
        return null;
    }
}

