/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import oracle.jbo.mom.DefinitionManager;
import oracle.jbo.mom.xml.DefXMLParser;
import org.xml.sax.SAXParseException;

public class VerifyXML {
    private FilenameFilter mFilenameFilter;
    DefinitionManager mDefMgr;

    public VerifyXML(DefinitionManager definitionManager) {
        this.mDefMgr = definitionManager;
    }

    public void parseXML(String string) {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not locate file : " + string);
            System.out.println("Trying in the Class Path...");
            String string2 = "/" + string.replace('.', '/') + ".xml";
            inputStream = this.getClass().getResourceAsStream(string2);
            if (inputStream != null) {
                System.out.println("XML File found in the ClassPath");
            }
            System.out.println("XML File Not found in the CLASSPATH.");
            return;
        }
        try {
            System.out.println("Validating: " + string);
            DefXMLParser defXMLParser = new DefXMLParser(this.mDefMgr);
            defXMLParser.parse(inputStream);
            System.out.println("     Valid: " + string);
        }
        catch (Exception exception) {
            System.out.println("Error While Parsing XML File : " + string);
            System.out.println(exception.toString());
        }
    }

    public FilenameFilter getFilenameFilter() {
        if (this.mFilenameFilter == null) {
            this.mFilenameFilter = new XMLFilenameFilter();
        }
        return this.mFilenameFilter;
    }

    private void parseDir(File file, String string) throws Exception {
        String[] stringArray = file.list(this.getFilenameFilter());
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        File file2 = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            string2 = file.getAbsolutePath() + File.separator + stringArray[n];
            file2 = new File(string2);
            if (file2.isDirectory()) {
                this.parseDir(file2, string);
            } else {
                this.parseXML(string2);
            }
            ++n;
        }
    }

    private void processRecursiveOption(String string) {
        try {
            if (string == null) {
                string = ".";
            }
            File file = new File(string);
            this.parseDir(file, null);
        }
        catch (Exception exception) {
            System.out.println("Error While looking for XML Files ");
            System.out.println(exception.toString());
        }
    }

    private static void printUsage() {
        System.out.println("VerifyXML:Invalid Syntax");
        System.out.println("VerifyXML Usage: VerifyXML [options] XML-File-Name");
        System.out.println("options: ");
        System.out.println("\t -r Recurse subdirectories for all XML Files");
        System.out.println("\nExample: ");
        System.out.println("VerifyXML -r j:\\myprojects");
        System.out.println("VerifyXML j:\\myprojects\\package1\\dept.xml");
        System.out.println("VerifyXML package1.dept");
    }

    public static void runMain(DefinitionManager definitionManager, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            VerifyXML.printUsage();
            return;
        }
        VerifyXML verifyXML = new VerifyXML(definitionManager);
        if (stringArray[0].charAt(0) == '-') {
            if (stringArray[0].equalsIgnoreCase("-r")) {
                if (stringArray.length > 1) {
                    verifyXML.processRecursiveOption(stringArray[1]);
                } else {
                    verifyXML.processRecursiveOption(null);
                }
            } else {
                VerifyXML.printUsage();
            }
        } else {
            verifyXML.parseXML(stringArray[0]);
        }
    }

    private static String xmlError(SAXParseException sAXParseException, String string) {
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        String string2 = sAXParseException.getMessage();
        return "XML parse error in file " + string + "\n" + "at line " + n + ", character " + n2 + "\n" + string2;
    }

    public class XMLFilenameFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            return string.endsWith(".xml") || new File(file, string).isDirectory();
        }

        XMLFilenameFilter() {
        }
    }
}

