/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.http;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import oracle.adf.share.http.ServletADFContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.ApplicationPoolException;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.common.ampool.SessionCookieFactory;
import oracle.jbo.common.ampool.SessionCookieListener;
import oracle.jbo.http.BindingEvent;
import oracle.jbo.http.BindingListener;
import oracle.jbo.http.HttpSessionCookieFactory;
import oracle.jbo.http.HttpSessionCookieHelper;
import oracle.jbo.http.HttpSessionCookieHelperManager;
import oracle.jbo.http.HttpSessionCookieProperties;
import oracle.jbo.uicli.mom.JUMetaObjectManager;

public class HttpContainer
implements Serializable,
SessionCookieListener,
HttpSessionBindingListener {
    static final long serialVersionUID = -4535142613500954819L;
    public static final String PAGE_CONTEXT_CONTAINER_NAME = "jbo.PageContext";
    public static final String SESSION_CONTEXT_CONTAINER_NAME = "jbo.SessionContext";
    public static final String APPLICATION_COOKIE_PREFIX = "jbo.ApplicationCookie.";
    public static final String APPLICATION_BINDING_LISTENER_PREFIX = "ApplicationBindingListener_";
    public static final String APPLICATION_PREFIX = "Application_";
    private HashMap mCookies;
    private transient HashMap mResources;
    private transient boolean mRefreshingSession;
    private transient HttpSession mSession;
    private transient Object mLock;
    private transient Object mContextRef;
    private static HashMap mSessionLockMap = new HashMap();
    private static /* synthetic */ Class class$oracle$jbo$common$ampool$AMPoolMessageBundle;

    private /* synthetic */ void $init$() {
        this.mCookies = new HashMap(1);
        this.mResources = null;
        this.mRefreshingSession = false;
        this.mSession = null;
        this.mLock = null;
        this.mContextRef = null;
    }

    public HttpContainer(Object object) {
        this.$init$();
        this.mContextRef = object;
        this.initialize();
    }

    public HttpContainer() {
        this.$init$();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getSessionSyncLock(Object object) {
        HashMap hashMap = mSessionLockMap;
        synchronized (hashMap) {
            Object object2 = mSessionLockMap.get(object);
            if (object2 == null) {
                object2 = new Object();
                mSessionLockMap.put(object, object2);
            }
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object removeSessionSyncLock(Object object) {
        HashMap hashMap = mSessionLockMap;
        synchronized (hashMap) {
            Object object2 = mSessionLockMap.remove(object);
            return object2;
        }
    }

    public Object getValue(Object object) {
        Object object2 = null;
        if (this.mResources != null) {
            object2 = this.getValue(this.mResources, object);
        }
        return object2;
    }

    public Object removeValue(Object object, Properties properties) {
        Object object2 = null;
        if (this.mResources != null) {
            object2 = this.removeValue(this.mResources, object, properties, true);
        }
        return object2;
    }

    public Object removeValueInternal(Object object) {
        Object object2 = null;
        if (this.mResources != null) {
            object2 = this.removeValue(this.mResources, object, null, false);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Properties properties) {
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        BindingEvent bindingEvent = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResources != null) {
                hashMap = (HashMap)this.mResources.clone();
                this.mResources.clear();
            }
            hashMap2 = (HashMap)this.mCookies.clone();
            this.mCookies.clear();
            bindingEvent = this.buildBindingEvent(properties);
        }
        if (hashMap != null) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                this.fireValueUnbound(object2, bindingEvent);
            }
        }
        Iterator iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            this.fireValueUnbound(object3, bindingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(Properties properties) {
        HashMap hashMap = null;
        HashMap hashMap2 = null;
        BindingEvent bindingEvent = null;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mResources != null) {
                hashMap = (HashMap)this.mResources.clone();
                this.mResources.clear();
            }
            hashMap2 = (HashMap)this.mCookies.clone();
            this.mCookies.clear();
            bindingEvent = this.buildBindingEvent(properties);
        }
        if (hashMap != null) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                this.fireTimeout(object2, bindingEvent);
            }
        }
        Iterator iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            Object object3 = iterator.next();
            this.fireTimeout(object3, bindingEvent);
        }
    }

    public Object putValue(Object object, Object object2, Properties properties) {
        if (this.mResources == null) {
            this.mResources = new HashMap();
        }
        return this.setValue(this.mResources, object, object2, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRefreshingSession) {
                this.mSession = httpSessionBindingEvent.getSession();
                this.initialize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        boolean bl = false;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mRefreshingSession) {
                if (this.mSession != null) {
                    HttpContainer.removeSessionSyncLock(this.mSession);
                }
                this.mSession = null;
                bl = true;
            }
        }
        if (bl) {
            this.timeout(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpContainer getInstanceFromSession(HttpSession httpSession) {
        HttpContainer httpContainer = null;
        boolean bl = false;
        Object object = HttpContainer.getSessionSyncLock(httpSession);
        synchronized (object) {
            httpContainer = (HttpContainer)httpSession.getValue(SESSION_CONTEXT_CONTAINER_NAME);
            if (httpContainer == null) {
                httpContainer = new HttpContainer();
                httpSession.putValue(SESSION_CONTEXT_CONTAINER_NAME, (Object)httpContainer);
                bl = true;
            }
        }
        if (!bl) {
            Object object2 = httpContainer.mLock;
            synchronized (object2) {
                httpContainer.mSession = httpSession;
            }
        }
        return httpContainer;
    }

    public SessionCookie getSessionCookie(String string) {
        String string2 = APPLICATION_COOKIE_PREFIX + string;
        return (SessionCookie)this.getValue(this.mCookies, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionCookie[] getSessionCookies() {
        Object object = this.mLock;
        synchronized (object) {
            Object[] objectArray = new SessionCookie[this.mCookies.size()];
            this.mCookies.values().toArray(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    public void setSessionCookie(String string, SessionCookie sessionCookie) {
        String string2 = APPLICATION_COOKIE_PREFIX + string;
        Object object = this.setValue(this.mCookies, string2, sessionCookie, null);
        if (sessionCookie != null) {
            sessionCookie.setSessionCookieListener((SessionCookieListener)this);
        } else if (object != null) {
            ((SessionCookie)object).setSessionCookieListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodeURL(String string) {
        Object object = this.mLock;
        synchronized (object) {
            HttpSessionCookieHelper httpSessionCookieHelper = HttpSessionCookieHelperManager.getHttpSessionCookieHelper();
            String string2 = string = httpSessionCookieHelper.encodeURL(string, this.getSessionCookies());
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object setValue(HashMap hashMap, Object object, Object object2, Properties properties) {
        Object object3 = null;
        boolean bl = false;
        boolean bl2 = false;
        BindingEvent bindingEvent = null;
        Object object4 = this.mLock;
        synchronized (object4) {
            boolean bl3;
            boolean bl4 = bl3 = this.getValue(hashMap, object) != null;
            if (!bl3) {
                if (object2 != null) {
                    object3 = hashMap.put(object, object2);
                    bindingEvent = this.buildBindingEvent(null);
                    bl = true;
                }
            } else if (bl3 && object2 == null) {
                object3 = hashMap.remove(object);
                bindingEvent = this.buildBindingEvent(null);
                bl2 = true;
            }
        }
        if (bl) {
            this.fireValueBound(object3, bindingEvent);
        } else if (bl2) {
            this.fireValueUnbound(object3, bindingEvent);
        }
        return object3;
    }

    private Object getValue(HashMap hashMap, Object object) {
        return hashMap.get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BindingEvent buildBindingEvent(Properties properties) {
        Object object = this.mLock;
        synchronized (object) {
            BindingEvent bindingEvent = new BindingEvent(this.mContextRef != null ? this.mContextRef : this.mSession);
            if (properties != null) {
                bindingEvent.setUserProperties(properties);
            }
            BindingEvent bindingEvent2 = bindingEvent;
            return bindingEvent2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeValue(HashMap hashMap, Object object, Properties properties, boolean bl) {
        Object object2 = null;
        BindingEvent bindingEvent = null;
        Object object3 = this.mLock;
        synchronized (object3) {
            object2 = hashMap.remove(object);
            bindingEvent = this.buildBindingEvent(properties);
        }
        if (bl && object2 != null) {
            this.fireValueUnbound(object2, bindingEvent);
        }
        return object2;
    }

    private void fireValueUnbound(Object object, BindingEvent bindingEvent) {
        if (object != null && object instanceof BindingListener) {
            ((BindingListener)object).valueUnbound(bindingEvent);
        }
    }

    private void fireValueBound(Object object, BindingEvent bindingEvent) {
        if (object != null && object instanceof BindingListener) {
            ((BindingListener)object).valueBound(bindingEvent);
        }
    }

    private void fireTimeout(Object object, BindingEvent bindingEvent) {
        if (object != null && object instanceof BindingListener) {
            ((BindingListener)object).timeout(bindingEvent);
        }
    }

    private void initialize() {
        if (this.mLock == null) {
            this.mLock = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cookieUpdated() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSession != null) {
                try {
                    try {
                        this.mRefreshingSession = true;
                        this.mSession.putValue(SESSION_CONTEXT_CONTAINER_NAME, (Object)this);
                    }
                    catch (IllegalStateException illegalStateException) {
                        Object var4_3 = null;
                        this.mRefreshingSession = false;
                    }
                    Object var4_2 = null;
                    this.mRefreshingSession = false;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.mRefreshingSession = false;
                    throw throwable;
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (NotActiveException notActiveException) {
            // empty catch block
        }
        this.initialize();
        SessionCookie[] sessionCookieArray = this.getSessionCookies();
        int n = 0;
        while (n < sessionCookieArray.length) {
            sessionCookieArray[n].setSessionCookieListener((SessionCookieListener)this);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SessionCookie findSessionCookie(HttpSession httpSession, String string, String string2, Properties properties) {
        HttpContainer httpContainer = HttpContainer.getInstanceFromSession(httpSession);
        Object object = httpContainer.mLock;
        synchronized (object) {
            boolean bl = false;
            try {
                SessionCookie sessionCookie;
                if (properties != null) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)properties.get("jbo.http.httprequest");
                    try {
                        ServletADFContext.initThreadContext(null, (ServletRequest)httpServletRequest, null);
                        bl = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!bl && Diagnostic.isOn()) {
                    Diagnostic.println("***********WARNING*************:  HttpContainer.findSessionCookie could not instantiate ServletADFContext.");
                    Diagnostic.println("Please pass HttpSessionCookieFactory.PROP_HTTP_REQUEST through the cookieProperties");
                }
                if ((sessionCookie = httpContainer.getSessionCookie(string)) == null) {
                    Properties properties2 = new Properties();
                    properties2.put("jbo.jndi.use_default_context", "true");
                    ApplicationPool applicationPool = JUMetaObjectManager.createPool(string2, properties2);
                    SessionCookieFactory sessionCookieFactory = applicationPool.getSessionCookieFactory();
                    if (PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.pDefault.equals(sessionCookieFactory.getClass().getName())) {
                        applicationPool.setSessionCookieFactory((SessionCookieFactory)new HttpSessionCookieFactory());
                    }
                    HttpSessionCookieProperties httpSessionCookieProperties = new HttpSessionCookieProperties();
                    if (properties != null) {
                        httpSessionCookieProperties.putAll((Map<?, ?>)properties);
                    }
                    if (httpSession != null) {
                        httpSessionCookieProperties.put("jbo.http.httpsession", httpSession);
                    }
                    httpSessionCookieProperties.put("jbo.iswebapp", new Boolean(true));
                    try {
                        sessionCookie = applicationPool.createSessionCookie(string, null, (Properties)httpSessionCookieProperties);
                    }
                    catch (ApplicationPoolException applicationPoolException) {
                        if (!"30012".equals(applicationPoolException.getErrorCode())) {
                            throw applicationPoolException;
                        }
                        sessionCookie = applicationPoolException.getSessionCookie();
                    }
                    httpContainer.setSessionCookie(string, sessionCookie);
                } else {
                    String string3 = JUMetaObjectManager.getConfigName(string2);
                    String string4 = sessionCookie.getEnvConfigurationName();
                    if (string3 != null && string4 != null && string4.indexOf(string3) < 0) {
                        Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = HttpContainer.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                        }
                        throw new ApplicationPoolException(clazz, "30018", new Object[]{sessionCookie.getApplicationId(), sessionCookie.getSessionId(), string4, string3});
                    }
                }
                SessionCookie sessionCookie2 = sessionCookie;
                Object var19_18 = null;
                if (bl) {
                    ServletADFContext.resetThreadContext();
                }
                return sessionCookie2;
            }
            catch (Throwable throwable) {
                Object var19_19 = null;
                if (bl) {
                    ServletADFContext.resetThreadContext();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SessionCookie findSessionCookie(HttpSession httpSession, String string, String string2, String string3, String string4, Properties properties, Properties properties2) {
        HttpContainer httpContainer = HttpContainer.getInstanceFromSession(httpSession);
        Object object = httpContainer.mLock;
        synchronized (object) {
            boolean bl = false;
            try {
                SessionCookie sessionCookie;
                if (properties2 != null) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)properties2.get("jbo.http.httprequest");
                    try {
                        ServletADFContext.initThreadContext(null, (ServletRequest)httpServletRequest, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bl = true;
                }
                if (!bl && Diagnostic.isOn()) {
                    Diagnostic.println("***********WARNING*************:  HttpContainer.findSessionCookie could not instantiate ServletADFContext.");
                    Diagnostic.println("Please pass HttpSessionCookieFactory.PROP_HTTP_REQUEST through the cookieProps");
                }
                String string5 = null;
                if (string3 != null && string4 != null) {
                    string5 = string3 + "." + string4;
                }
                if ((sessionCookie = httpContainer.getSessionCookie(string)) == null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.put("jbo.jndi.use_default_context", "true");
                    ApplicationPool applicationPool = PoolMgr.getInstance().findPool(string2, string3, string4, properties);
                    SessionCookieFactory sessionCookieFactory = applicationPool.getSessionCookieFactory();
                    if (PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.pDefault.equals(sessionCookieFactory.getClass().getName())) {
                        applicationPool.setSessionCookieFactory((SessionCookieFactory)new HttpSessionCookieFactory());
                    }
                    HttpSessionCookieProperties httpSessionCookieProperties = new HttpSessionCookieProperties();
                    if (properties2 != null) {
                        httpSessionCookieProperties.putAll((Map<?, ?>)properties2);
                    }
                    if (httpSession != null) {
                        httpSessionCookieProperties.put("jbo.http.httpsession", httpSession);
                    }
                    try {
                        sessionCookie = applicationPool.createSessionCookie(string, null, (Properties)httpSessionCookieProperties);
                    }
                    catch (ApplicationPoolException applicationPoolException) {
                        if (!"30012".equals(applicationPoolException.getErrorCode())) {
                            throw applicationPoolException;
                        }
                        sessionCookie = applicationPoolException.getSessionCookie();
                    }
                    httpContainer.setSessionCookie(string, sessionCookie);
                } else {
                    String string6 = sessionCookie.getEnvConfigurationName();
                    if (string6 != null && string5 != null && string6.indexOf(string5) < 0) {
                        Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = HttpContainer.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                        }
                        throw new ApplicationPoolException(clazz, "30018", new Object[]{sessionCookie.getApplicationId(), sessionCookie.getSessionId(), string6, string5});
                    }
                }
                SessionCookie sessionCookie2 = sessionCookie;
                Object var21_20 = null;
                if (bl) {
                    ServletADFContext.resetThreadContext();
                }
                return sessionCookie2;
            }
            catch (Throwable throwable) {
                Object var21_21 = null;
                if (bl) {
                    ServletADFContext.resetThreadContext();
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

