/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import com.sun.java.util.collections.HashMap;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Hashtable;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.Row;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.domain.XMLDomainInterface;
import oracle.jbo.domain.XMLDomainWriter;
import oracle.jbo.format.Formatter;
import oracle.jbo.server.AttributeListImpl;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.EntityDefImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DomainAttributeDef
implements AttributeHints,
AttributeDef {
    String mName;
    String mColumnName;
    int mIndex;
    Class mJavaType;
    int mSQLType;
    String mSQLTypeName;
    int mScale;
    int mPrecision;
    boolean mIsMandatory;
    String mRefObjDefName;
    boolean mControlHintsFetched;
    Hashtable mProperties;

    private /* synthetic */ void $init$() {
        this.mControlHintsFetched = false;
    }

    public DomainAttributeDef(String string, String string2, int n, Class clazz, int n2, String string3, int n3, int n4, boolean bl) {
        this.$init$();
        this.mName = string;
        this.mColumnName = string2;
        this.mIndex = n;
        this.mJavaType = clazz;
        this.mSQLType = n2;
        this.mSQLTypeName = string3;
        this.mScale = n3;
        this.mPrecision = n4;
        this.mIsMandatory = bl;
    }

    public DomainAttributeDef(String string, String string2, int n, Class clazz, int n2, String string3, int n3, int n4, boolean bl, String string4) {
        this(string, string2, n, clazz, n2, string3, n3, n4, bl);
        this.mRefObjDefName = string4;
    }

    public byte getAttributeKind() {
        return 0;
    }

    public String getName() {
        return this.mName;
    }

    public String getColumnName() {
        return this.mColumnName;
    }

    public String getColumnNameForQuery() {
        return this.getColumnName();
    }

    public int getIndex() {
        return this.mIndex;
    }

    public String getSQLTypeName() {
        return this.mSQLTypeName;
    }

    public Class getJavaType() {
        return this.mJavaType;
    }

    public int getSQLType() {
        return this.mSQLType;
    }

    public int getScale() {
        return this.mScale;
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public boolean isSelected() {
        return false;
    }

    public boolean isQueriable() {
        return false;
    }

    public byte getUpdateableFlag() {
        return 2;
    }

    public boolean isPrimaryKey() {
        return false;
    }

    public boolean isMandatory() {
        return this.mIsMandatory;
    }

    public Object getProperty(String string) {
        return null;
    }

    public Object refreshProperty(String string) {
        return this.getProperty(string);
    }

    public String getReferencedObjectDefName() {
        return this.mRefObjDefName;
    }

    public Hashtable getProperties() {
        return this.mProperties;
    }

    public static Node getXMLContentNode(Document document, Object object, boolean bl) {
        return DomainAttributeDef.getXMLContentNode(document, object, bl, false);
    }

    public static Node getXMLContentNode(Document document, Object object, boolean bl, boolean bl2) {
        if (object != null) {
            if (bl2 && object instanceof XMLDomainWriter) {
                return ((XMLDomainWriter)object).getSerializedDomainXML(document);
            }
            if (object instanceof XMLDomainInterface) {
                return ((XMLDomainInterface)object).getXMLContentNode(document);
            }
            return bl ? document.createCDATASection(object.toString()) : document.createTextNode(object.toString());
        }
        return null;
    }

    public static String printAttrXMLDefinition(AttributeList attributeList, String string, AttributeDef attributeDef, Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        if (hashtable.get(string) == null) {
            Object object = attributeList.getAttribute(attributeDef.getIndex());
            String string2 = "#PCDATA";
            if (object instanceof XMLDomainInterface) {
                string2 = ((XMLDomainInterface)object).printXMLDefinition(hashtable, printWriter, bl);
            }
            printWriter.println("<!ELEMENT " + string + " (" + string2 + ")>");
            hashtable.put(string, string);
        }
        if (!attributeDef.isPrimaryKey() && !attributeDef.isMandatory()) {
            string = string + "?";
        }
        return string;
    }

    Row getReferencedObject(Object object, Transaction transaction) {
        EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject((String)this.getReferencedObjectDefName());
        if (entityDefImpl != null) {
            AttributeListImpl attributeListImpl = new AttributeListImpl();
            attributeListImpl.setAttribute("REF$", object);
            return entityDefImpl.findByPrimaryKey((DBTransaction)transaction, entityDefImpl.createKey((AttributeList)attributeListImpl));
        }
        return null;
    }

    public Class getElemType() {
        return null;
    }

    public int getElemSQLType() {
        return 0;
    }

    public AttributeHints getUIHelper() {
        return this;
    }

    public String getLocaleName(LocaleContext localeContext, String string) {
        return JboNameUtil.getLocaleName(localeContext, string);
    }

    String getControlHint(LocaleContext localeContext, String string) {
        HashMap hashMap;
        if (string == null) {
            return null;
        }
        if (!this.mControlHintsFetched) {
            this.mControlHintsFetched = true;
            if (this.mProperties == null) {
                Diagnostic.println("No Properties thus far! trying to fetch properties for:" + this.getName());
                return null;
            }
        }
        if (this.mProperties == null) {
            return null;
        }
        String string2 = (String)this.mProperties.get(this.getLocaleName(localeContext, string));
        if (string2 == null) {
            string2 = (String)this.mProperties.get(string);
        }
        if (string2 == null && (hashMap = (HashMap)this.mProperties.get("__bc4j_res__")) != null) {
            String string3 = this.getName() + "_" + string;
            string2 = (String)hashMap.get((Object)string3);
        }
        return string2;
    }

    void setControlHints(Hashtable hashtable) {
        this.mProperties = hashtable;
        this.mControlHintsFetched = true;
    }

    public String getLabel(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "LABEL");
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public String getTooltip(LocaleContext localeContext) {
        return this.getControlHint(localeContext, "TOOLTIP");
    }

    public String getDisplayHint(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYHINT");
        if (string == null) {
            string = "Display";
        }
        return string;
    }

    public int getControlType(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "CONTROLTYPE");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 100;
    }

    public int getDisplayWidth(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYWIDTH");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return this.getPrecision();
    }

    public int getDisplayHeight(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "DISPLAYHEIGHT");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public String getHint(LocaleContext localeContext, String string) {
        if (string.equals("LABEL")) {
            return this.getLabel(localeContext);
        }
        if (string.equals("TOOLTIP")) {
            return this.getTooltip(localeContext);
        }
        if (string.equals("DISPLAYWIDTH")) {
            return Integer.toString(this.getDisplayWidth(localeContext));
        }
        return this.getControlHint(localeContext, string);
    }

    public String getHintValue(LocaleContext localeContext, String string) {
        return this.getControlHint(localeContext, string);
    }

    public String getFormat(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        return this.getControlHint(localeContext, "FMT_FORMAT");
    }

    public Formatter getFormatter(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        String string = this.getFormatterClassName(localeContext);
        String string2 = this.getFormat(localeContext);
        try {
            Formatter formatter;
            Class<?> clazz = Class.forName(string);
            Formatter formatter2 = formatter = (Formatter)clazz.newInstance();
            return formatter2;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public boolean hasFormatInformation(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "FMT_FORMATTER");
        return string != null && !string.equals("");
    }

    public String getFormattedAttribute(AttributeList attributeList, LocaleContext localeContext) {
        Object object = attributeList.getAttribute(this.getIndex());
        if (object == null) {
            return null;
        }
        if (object.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return object.toString();
        }
        try {
            String string;
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            String string3 = string = formatter.format(string2, object);
            return string3;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public Object parseFormattedAttribute(String string, LocaleContext localeContext) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return string;
        }
        try {
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            Object object = formatter.parse(string2, string);
            if (object == null) {
                String string3 = string;
                return string3;
            }
            Object object2 = object;
            return object2;
        }
        catch (ParseException parseException) {
            String string4 = string;
            return string4;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public boolean displayInShortForm(LocaleContext localeContext) {
        String string = this.getControlHint(localeContext, "FORMTYPE");
        if (string == null) {
            return false;
        }
        return string.equals("Summary");
    }

    public String getFormatterClassName(LocaleContext localeContext) {
        return this.getControlHint(localeContext, "FMT_FORMATTER");
    }
}

