/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.jbo.ApplicationModule;
import oracle.jbo.PiggybackException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PiggybackObjectOutputStream;

public class PiggybackOutput {
    Locale mLocale;
    ByteArrayOutputStream bStm;
    ObjectOutput objStm;
    List mEntries;

    private /* synthetic */ void $init$() {
        this.mLocale = null;
        this.bStm = new ByteArrayOutputStream();
    }

    public void reset(List list) {
        this.bStm.reset();
        this.mEntries = list != null ? list : new ArrayList();
    }

    public PiggybackOutput(Locale locale, ApplicationModule applicationModule) {
        this(null, locale, applicationModule, null);
    }

    public PiggybackOutput(List list, Locale locale, ApplicationModule applicationModule) {
        this(list, locale, applicationModule, null);
    }

    public PiggybackOutput(List list, Locale locale, ApplicationModule applicationModule, ObjectMarshaller objectMarshaller) {
        this.$init$();
        this.reset(list);
        this.mLocale = locale;
        try {
            this.objStm = new PiggybackObjectOutputStream(this.bStm, locale, applicationModule, objectMarshaller);
        }
        catch (IOException iOException) {
            if (Diagnostic.isOn()) {
                Diagnostic.printStackTrace(iOException);
            }
            PiggybackException piggybackException = new PiggybackException("JBO-28301: Piggyback create stream error");
            piggybackException.addToDetails(iOException);
            throw piggybackException;
        }
    }

    public void addEntry(Object object) {
        this.mEntries.add(object);
    }

    public void addEntryArr(ArrayList arrayList) {
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.mEntries.add(arrayList.get(n));
                ++n;
            }
        }
    }

    public void addEntries(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.mEntries.add(objectArray[n]);
            ++n;
        }
    }

    public int getNumOfEntries() {
        return this.mEntries.size();
    }

    public int getPiggybackSize() {
        this.getPiggybackStream();
        return this.bStm.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getPiggybackStream() {
        try {
            block12: {
                try {
                    if (this.mEntries.size() <= 0) break block12;
                    int n = this.mEntries.size();
                    this.objStm.writeInt(n);
                    if (n > 0) {
                        this.objStm.writeUTF(this.mEntries.get(0).getClass().getName());
                        int n2 = 0;
                        while (n2 < n) {
                            this.objStm.writeObject(this.mEntries.get(n2));
                            ++n2;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.printStackTrace(iOException);
                    }
                    PiggybackException piggybackException = new PiggybackException("JBO-28302: Piggyback write error");
                    piggybackException.addToDetails(iOException);
                    throw piggybackException;
                }
            }
            Object var9_3 = null;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            try {
                this.objStm.flush();
                throw throwable;
            }
            catch (IOException iOException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.printStackTrace(iOException);
                }
                PiggybackException piggybackException = new PiggybackException("JBO-28302: Piggyback write error");
                piggybackException.addToDetails(iOException);
                throw piggybackException;
            }
        }
        try {}
        catch (IOException iOException) {
            if (Diagnostic.isOn()) {
                Diagnostic.printStackTrace(iOException);
            }
            PiggybackException piggybackException = new PiggybackException("JBO-28302: Piggyback write error");
            piggybackException.addToDetails(iOException);
            throw piggybackException;
        }
        this.objStm.flush();
        return this.bStm.toByteArray();
    }
}

