/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.bc4j;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.adf.model.BindingContext;
import oracle.adf.model.DataControl;
import oracle.adf.model.DataControlFactory;
import oracle.adf.share.ADFContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.ApplicationPoolException;
import oracle.jbo.common.ampool.EnvInfoProvider;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.common.ws.WSApplicationModuleImpl;
import oracle.jbo.uicli.binding.JUApplication;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataControlFactoryImpl
implements DataControlFactory {
    final String CPX;
    final String BATCH;
    final String SYNC;
    public static final String VAL_MODE_REMOTE_STR = "remoteOnly";
    public static final String VAL_MODE_ALWAYS_STR = "always";
    public static final String VAL_MODE_NEVER_STR = "never";
    static final String EXC_MODE_STRING = "ExceptionMode";
    static final String EXC_MODE_DEFERRED = "Deferred";
    static final String EXC_MODE_IMMEDIATE = "Immediate";
    static final String PARAMETER_NAME = "name";
    static final String PARAMETER_VALUE = "value";
    private static int mSessionCounter = 0;
    private static Object mStaticSyncLock = new Object();
    private static /* synthetic */ Class class$oracle$jbo$ApplicationModule;
    private static /* synthetic */ Class class$oracle$jbo$common$ampool$SessionCookie;

    private /* synthetic */ void $init$() {
        this.CPX = "cpx";
        this.BATCH = "Batch";
        this.SYNC = "Sync";
    }

    public DataControlFactoryImpl() {
        this.$init$();
    }

    public DataControl createSession(BindingContext bindingContext, Node node, Map map) {
        String string = null;
        string = node.getAttributes().getNamedItem("Name") != null ? node.getAttributes().getNamedItem("Name").getNodeValue() : node.getAttributes().getNamedItem("id").getNodeValue();
        String string2 = node.getAttributes().getNamedItem("Configuration").getNodeValue();
        String string3 = node.getAttributes().getNamedItem("Package").getNodeValue();
        NodeList nodeList = null;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            nodeList = node2.getChildNodes();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        hashMap.put("Name", string);
        hashMap.put("Configuration", string2);
        hashMap.put("Package", string3);
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node3 = nodeList.item(n);
                if (node3.getNodeName().equalsIgnoreCase("Parameter")) {
                    String string4 = node3.getAttributes().getNamedItem(PARAMETER_NAME).getNodeValue();
                    String string5 = node3.getAttributes().getNamedItem(PARAMETER_VALUE).getNodeValue();
                    hashMap.put(string4, string5);
                }
                ++n;
            }
        }
        return this.createSession(bindingContext, string, map, hashMap);
    }

    private SessionCookie findOrCreateSessionCookie(String string, BindingContext bindingContext, String string2, String string3, String string4, Properties properties, Properties properties2, boolean bl) {
        ADFContext aDFContext = ADFContext.getCurrent();
        SessionCookie sessionCookie = null;
        if (properties == null) {
            properties = new Properties();
        }
        if (aDFContext.getContextType() != 1) {
            properties.put("jbo.jndi.use_default_context", "true");
        }
        if (bl && aDFContext.getContextType() == 1) {
            properties.put("jbo.ejb.useampool", "true");
        }
        ApplicationPool applicationPool = PoolMgr.getInstance().findPool(string2, string3, string4, properties);
        try {
            sessionCookie = applicationPool.createSessionCookie(string, this.generateSessionId(string), properties2);
        }
        catch (ApplicationPoolException applicationPoolException) {
            if ("30012".equals(applicationPoolException.getErrorCode())) {
                sessionCookie = applicationPoolException.getSessionCookie();
            }
            throw applicationPoolException;
        }
        Map map = aDFContext.getStateManager(ADFContext.SESSION_SCOPE, null);
        Object v = map.get(string);
        if (v != null && v instanceof String) {
            sessionCookie.setPassivationId(Integer.parseInt((String)v));
        }
        return sessionCookie;
    }

    public DataControl createSession(BindingContext bindingContext, String string, Map map, Map map2) {
        ADFContext aDFContext = ADFContext.getCurrent();
        String string2 = (String)map2.get("Package");
        String string3 = (String)map2.get("Configuration");
        String string4 = (String)map2.get("Name");
        EnvInfoProvider envInfoProvider = (EnvInfoProvider)bindingContext.get("_envInfo_Provider");
        JUApplication jUApplication = null;
        Properties properties = null;
        Properties properties2 = null;
        if (map != null) {
            properties = (Properties)map.get("_pool_Properties");
            properties2 = (Properties)map.get("_request_context");
        }
        if (properties2 == null) {
            if (aDFContext.getContextType() == 2) {
                try {
                    properties2 = (Properties)JBOClass.forName("oracle.jbo.http.HttpSessionCookieProperties").newInstance();
                }
                catch (Exception exception) {
                    throw new JboException(exception);
                }
                properties2.put("jbo.iswebapp", new Boolean(true));
            } else {
                properties2 = new Properties();
            }
        }
        SessionCookie sessionCookie = this.findOrCreateSessionCookie(string4, bindingContext, string2 + "." + string3, string2, string3, properties, properties2, "Batch".equals(map2.get("syncMode")) || "Batch".equals(map2.get("Sync")));
        if (envInfoProvider != null && sessionCookie.getEnvInfoProvider() == null) {
            sessionCookie.setEnvInfoProvider(envInfoProvider);
        }
        if ("Batch".equals(map2.get("syncMode")) || "Batch".equals(map2.get("Sync"))) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("(oracle.adf.model.bc4j.DataControlFactoryImpl.SyncMode = Batch");
            }
            sessionCookie.setReferenceCounting(true);
            LocaleContext localeContext = bindingContext.getLocaleContext();
            if (localeContext == null) {
                localeContext = new DefLocaleContext(null);
            }
            sessionCookie.setEnvironment((Object)"jbo.sessionlocale", (Object)localeContext.getLocale());
            WSApplicationModuleImpl wSApplicationModuleImpl = new WSApplicationModuleImpl(sessionCookie);
            jUApplication = this.instantiateDataControl(wSApplicationModuleImpl, true);
        } else {
            if (Diagnostic.isOn()) {
                Diagnostic.println("(oracle.adf.model.bc4j.DataControlFactoryImpl.SyncMode = Immediate");
            }
            if (aDFContext.getContextType() == 1) {
                ApplicationModule applicationModule = sessionCookie.useApplicationModule();
                jUApplication = this.instantiateDataControl(applicationModule, true);
            } else {
                jUApplication = this.instantiateDataControl(sessionCookie, false);
            }
        }
        String string5 = (String)map2.get(EXC_MODE_STRING);
        if (aDFContext.getContextType() != 1 && string5 == null) {
            jUApplication.setBundledExceptionMode(1);
        } else if (string5 != null) {
            if (EXC_MODE_DEFERRED.equals(string5)) {
                jUApplication.setBundledExceptionMode(1);
            } else if (EXC_MODE_IMMEDIATE.equals(string5)) {
                jUApplication.setBundledExceptionMode(2);
            }
        }
        string5 = (String)map2.get("ValidateAtBindings");
        if (string5 == null || string5.equals(VAL_MODE_ALWAYS_STR)) {
            jUApplication.setValidationInBinding(-1);
        } else if (string5.equals(VAL_MODE_NEVER_STR)) {
            jUApplication.setValidationInBinding(1);
        } else if (string5.equals(VAL_MODE_REMOTE_STR)) {
            jUApplication.setValidationInBinding(3);
        }
        jUApplication.setName(string4);
        jUApplication.setBindingContext(bindingContext);
        jUApplication.setSessionCookie(sessionCookie);
        if (envInfoProvider != null) {
            bindingContext.put("_envInfo_Provider", (Object)null);
        }
        jUApplication.prepareSession();
        return jUApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateSessionId(String string) {
        int n = 0;
        Object object = mStaticSyncLock;
        synchronized (object) {
            n = mSessionCounter++;
        }
        return string + ':' + System.currentTimeMillis() + ':' + n;
    }

    private JUApplication instantiateDataControl(Object object, boolean bl) {
        JUApplication jUApplication = null;
        try {
            Class clazz = JBOClass.forName(this.getDataControlClassName());
            if (bl) {
                Constructor constructor;
                Class[] classArray = new Class[1];
                Class clazz2 = class$oracle$jbo$ApplicationModule;
                if (clazz2 == null) {
                    clazz2 = classArray[0] = (class$oracle$jbo$ApplicationModule = DataControlFactoryImpl.class$("oracle.jbo.ApplicationModule"));
                }
                if ((constructor = clazz.getConstructor(classArray)) != null) {
                    jUApplication = (JUApplication)constructor.newInstance((ApplicationModule)object);
                }
            } else {
                Constructor constructor;
                Class[] classArray = new Class[1];
                Class clazz3 = class$oracle$jbo$common$ampool$SessionCookie;
                if (clazz3 == null) {
                    clazz3 = classArray[0] = (class$oracle$jbo$common$ampool$SessionCookie = DataControlFactoryImpl.class$("oracle.jbo.common.ampool.SessionCookie"));
                }
                if ((constructor = clazz.getConstructor(classArray)) != null) {
                    jUApplication = (JUApplication)constructor.newInstance((SessionCookie)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jUApplication == null) {
            System.out.println("**********Could not instantiate DataControl:  " + this.getDataControlClassName());
            jUApplication = bl ? new JUApplication((ApplicationModule)object) : new JUApplication((SessionCookie)object);
        }
        return jUApplication;
    }

    protected String getDataControlClassName() {
        return "oracle.jbo.uicli.binding.JUApplication";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

