/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat.xml;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.adf.model.adapter.dataformat.xml.SchemaMetadata;
import oracle.adf.model.adapter.utils.Utility;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaParser {
    private Map mSchemaMetadata;
    private List mDocuments;
    private Map mSchemaList;

    private /* synthetic */ void $init$() {
        this.mSchemaMetadata = new HashMap();
        this.mDocuments = new ArrayList();
        this.mSchemaList = new HashMap();
    }

    public SchemaParser() {
        this.$init$();
    }

    public XMLSchema parse(String string) throws Exception {
        if (string != null) {
            this.addSchema(string);
        }
        return this.parse();
    }

    public XMLSchema parse(URL uRL) throws Exception {
        if (uRL != null) {
            this.addSchema(uRL);
        }
        return this.parse();
    }

    public XMLSchema parse(Reader reader) throws Exception {
        if (reader != null) {
            this.addSchema(reader);
        }
        return this.parse();
    }

    public XMLSchema parse(InputStream inputStream) throws Exception {
        if (inputStream != null) {
            this.addSchema(inputStream);
        }
        return this.parse();
    }

    public void addSchema(String string) throws Exception {
        if (string != null) {
            this.mDocuments.add(this.getReader(string));
        }
    }

    public void addSchema(URL uRL) throws Exception {
        if (uRL != null) {
            this.mDocuments.add(this.getReader(uRL));
        }
    }

    public void addSchema(Reader reader) {
        if (reader != null) {
            this.mDocuments.add(reader);
        }
    }

    public void addSchema(InputStream inputStream) {
        if (inputStream != null) {
            this.mDocuments.add(this.getReader(inputStream));
        }
    }

    public void addSchema(Node node) {
        if (node != null) {
            this.mDocuments.add(node);
        }
    }

    public SchemaMetadata getSchemaMetadata(String string) {
        SchemaMetadata schemaMetadata = null;
        if (string != null && string.length() != 0) {
            schemaMetadata = (SchemaMetadata)this.mSchemaMetadata.get(string);
        }
        return schemaMetadata;
    }

    public XMLSchema parse() throws Exception {
        int n = this.mDocuments.size();
        Utility.ASSERT(n != 0);
        int n2 = 0;
        while (n2 < this.mDocuments.size()) {
            Object e = this.mDocuments.get(n2);
            if (e instanceof Node) {
                this.generateSchemaList((Node)e, null);
            } else if (e instanceof Reader) {
                this.generateSchemaList((Reader)e, null);
            }
            ++n2;
        }
        XSDBuilder xSDBuilder = new XSDBuilder();
        Collection collection = this.mSchemaList.values();
        Object[] objectArray = collection.toArray();
        XMLDocument[] xMLDocumentArray = new XMLDocument[objectArray.length];
        System.arraycopy(objectArray, 0, xMLDocumentArray, 0, objectArray.length);
        return xSDBuilder.build(xMLDocumentArray, null);
    }

    private Object getReader(InputStream inputStream) {
        return new InputStreamReader(inputStream);
    }

    private Reader getReader(String string) throws Exception {
        URL uRL = new URL(string);
        return this.getReader(uRL);
    }

    private Reader getReader(URL uRL) throws Exception {
        InputStream inputStream = uRL.openStream();
        return new InputStreamReader(inputStream);
    }

    private List findNodes(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>(5);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeName().equals(string)) {
                arrayList.add(node2);
            }
            ++n2;
        }
        return arrayList;
    }

    private void generateSchemaList(Reader reader, String string) {
        XMLDocument xMLDocument;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(reader);
            xMLDocument = dOMParser.getDocument();
        }
        catch (Exception exception) {
            return;
        }
        Element element = xMLDocument.getDocumentElement();
        if (string == null) {
            string = Integer.toString(reader.hashCode());
        }
        this.generateSchemaList(element, string);
    }

    private void generateSchemaList(Node node, String string) {
        if (node == null) {
            return;
        }
        if (!this.isSchemaNode(node.getNodeName())) {
            return;
        }
        this.setSchemaMetadata(node);
        if (string != null) {
            this.mSchemaList.put(string, node.getOwnerDocument());
        } else {
            this.mSchemaList.put(Integer.toString(node.hashCode()), node.getOwnerDocument());
        }
        HashSet<String> hashSet = new HashSet<String>();
        NamedNodeMap namedNodeMap = null;
        NodeList nodeList = node.getOwnerDocument().getElementsByTagName("schema");
        if (nodeList.getLength() > 0) {
            namedNodeMap = nodeList.item(0).getAttributes();
        }
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string2;
                Node node2 = namedNodeMap.item(n2);
                String string3 = node2.getNodeName();
                if (string3.startsWith("xmlns") && (string2 = node2.getNodeValue()).compareToIgnoreCase("http://www.w3.org/2001/XMLSchema") != 0 && !this.mSchemaList.containsKey(string2)) {
                    hashSet.add(string2);
                }
                ++n2;
            }
        }
        List list = this.findNodes(node, "import");
        int n = list.size();
        int n3 = 0;
        while (n3 < n) {
            String string4;
            Node node3 = (Node)list.get(n3);
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            Node node4 = namedNodeMap2.getNamedItem("schemaLocation");
            if (node4 == null && (node4 = namedNodeMap2.getNamedItem("namespace")) != null && !this.mSchemaList.containsKey(string4 = node4.getNodeValue())) {
                hashSet.add(string4);
            }
            ++n3;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Reader reader;
            String string5 = (String)iterator.next();
            try {
                reader = this.getReader(string5);
            }
            catch (Exception exception) {
                continue;
            }
            this.generateSchemaList(reader, string5);
        }
    }

    private void setSchemaMetadata(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("targetNamespace");
        String string = null;
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        if (string != null && string.length() != 0) {
            SchemaMetadata schemaMetadata = new SchemaMetadata(string);
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Node node3 = namedNodeMap.item(n);
                String string2 = node3.getNodeName();
                String string3 = node3.getNodeValue();
                if ("attributeFormDefault".equals(string2)) {
                    schemaMetadata.setAttributeFormDefault(string3.equalsIgnoreCase("qualified"));
                } else if ("elementFormDefault".equals(string2)) {
                    schemaMetadata.setAttributeFormDefault(string3.equalsIgnoreCase("qualified"));
                } else if (!"targetNamespace".equals(string2)) {
                    schemaMetadata.setProperty(string2, string3);
                }
                ++n;
            }
        }
    }

    private boolean isSchemaNode(String string) {
        int n = string.length();
        int n2 = string.indexOf(":");
        if (++n2 > n) {
            return false;
        }
        String string2 = string.substring(n2, n);
        return string2.compareTo("schema") == 0;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            return;
        }
        System.setProperty("http.proxyHost", "www-proxy.us.oracle.com");
        System.setProperty("http.proxyPort", "80");
        try {
            SchemaParser schemaParser = new SchemaParser();
            int n = 1;
            while (n < stringArray.length) {
                schemaParser.addSchema(stringArray[n]);
                ++n;
            }
            XMLSchema xMLSchema = schemaParser.parse(stringArray[0]);
            System.out.println("----- XSD Parsed successfully -----");
        }
        catch (Exception exception) {
            Class<?> clazz = exception.getClass();
            String string = clazz.getName();
            System.out.println("EXCEPTION OCCURED:");
            System.out.println(string + ": " + exception.getMessage());
            exception.printStackTrace(System.out);
        }
    }
}

