/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter;

import com.sun.java.util.collections.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import oracle.adf.model.adapter.AdapterContext;
import oracle.adf.model.binding.DCDataControlDef;
import oracle.adf.share.logging.ADFLogger;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.mom.xml.DefElementImpl;
import oracle.jbo.mom.xml.DefNode;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdapterDataControlDef
extends DCDataControlDef {
    public static final String ADAPTER_DC = "AdapterDataControl";
    public static final String IMPL_DEF = "ImplDef";
    public static final String SOURCE = "Source";
    private ADFLogger mDbgLog;

    private /* synthetic */ void $init$() {
        this.mDbgLog = AdapterContext.getDefaultContext().getLogger();
    }

    public AdapterDataControlDef() {
        this.$init$();
    }

    public String getSubType() {
        return null;
    }

    public void init(HashMap hashMap) {
        super.init(hashMap);
        this.put("DTClass", "oracle.adf.dt.datacontrols.JUDTAdapterDataControl");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retrieveFromNode(Node node) {
        block7: {
            block6: {
                try {
                    try {
                        this.mDbgLog.entering(this.getClass().getName(), "retrieveFromNode");
                        this.mDbgLog.fine("Creating a DefElement from the node.");
                        DefElementImpl defElementImpl = this.makeDefElement(node);
                        if (defElementImpl == null) {
                            Object var6_3 = null;
                            break block6;
                        }
                        this.mDbgLog.fine("Retrieving info from the DefElement created.");
                        HashMap hashMap = new HashMap(10);
                        this.retrieveFromXML(defElementImpl, hashMap);
                        this.init(hashMap);
                        break block7;
                    }
                    catch (Exception exception) {
                        this.mDbgLog.info("Failed to retrieve definition: " + exception.getLocalizedMessage());
                        Object var6_5 = null;
                        this.mDbgLog.exiting(this.getClass().getName(), "retrieveFromNode");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.mDbgLog.exiting(this.getClass().getName(), "retrieveFromNode");
                    throw throwable;
                }
            }
            this.mDbgLog.exiting(this.getClass().getName(), "retrieveFromNode");
            return;
        }
        Object var6_4 = null;
        this.mDbgLog.exiting(this.getClass().getName(), "retrieveFromNode");
    }

    protected void retrieveFromXML(DefElement defElement, HashMap hashMap) {
        super.retrieveFromXML(defElement, hashMap);
        AdapterDataControlDef.readXMLString(defElement, IMPL_DEF, hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadChildrenFromXML(DefElement defElement) {
        block7: {
            block6: {
                super.loadChildrenFromXML(defElement);
                try {
                    try {
                        this.mDbgLog.entering(this.getClass().getName(), "loadChildrenFromXML");
                        this.mDbgLog.fine("Loading SOURCE definition.");
                        DefElement defElement2 = defElement.findChildElement(SOURCE);
                        if (defElement2 == null) {
                            this.mDbgLog.info("No 'Source' is defined for the data control.");
                            Object var6_3 = null;
                            break block6;
                        }
                        Node node = this.getNodeFrom(new XMLDocument(), defElement2);
                        this.put(SOURCE, node);
                        break block7;
                    }
                    catch (Exception exception) {
                        this.mDbgLog.log(Level.SEVERE, "Exception => ", (Throwable)exception);
                        Object var6_5 = null;
                        this.mDbgLog.exiting(this.getClass().getName(), "loadChildrenFromXML");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.mDbgLog.exiting(this.getClass().getName(), "loadChildrenFromXML");
                    throw throwable;
                }
            }
            this.mDbgLog.exiting(this.getClass().getName(), "loadChildrenFromXML");
            return;
        }
        Object var6_4 = null;
        this.mDbgLog.exiting(this.getClass().getName(), "loadChildrenFromXML");
    }

    private DefElementImpl makeDefElement(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        DefElementImpl defElementImpl = new DefElementImpl(node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = namedNodeMap.item(n2);
            String string = node2.getNamespaceURI();
            if (string != null && string.length() > 0) {
                defElementImpl.setAttributeNS(string, node2.getNodeName(), node2.getNodeValue());
            } else {
                defElementImpl.setAttribute(node2.getNodeName(), node2.getNodeValue());
            }
            ++n2;
        }
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        int n3 = 0;
        while (n3 < n) {
            Node node3 = nodeList.item(n3);
            defElementImpl.appendChild(node3);
            ++n3;
        }
        return defElementImpl;
    }

    private Node getNodeFrom(XMLDocument xMLDocument, DefElement defElement) {
        String string = defElement.getNamespaceURI();
        if (string != null && string.length() == 0) {
            string = null;
        }
        Element element = xMLDocument.createElementNS(string, defElement.getElementName());
        ArrayList arrayList = defElement.getAttrsList();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = arrayList.get(n2);
            if (object instanceof DefNode) {
                DefNode defNode = (DefNode)object;
                String string2 = defNode.getNodeName();
                String string3 = defNode.getNodeValue();
                element.setAttribute(string2, string3);
            } else {
                XMLAttr xMLAttr = (XMLAttr)object;
                String string4 = xMLAttr.getName();
                String string5 = xMLAttr.getValue();
                element.setAttribute(string4, string5);
            }
            ++n2;
        }
        ArrayList arrayList2 = defElement.getChildrenList();
        n = arrayList2.size();
        int n3 = 0;
        while (n3 < n) {
            DefElement defElement2 = (DefElement)arrayList2.get(n3);
            ArrayList arrayList3 = defElement.getChildrenList(defElement2.getNodeName());
            int n4 = arrayList3.size();
            int n5 = 0;
            while (n5 < n4) {
                DefElement defElement3 = (DefElement)arrayList3.get(n5);
                Node node = this.getNodeFrom(xMLDocument, defElement3);
                element.appendChild(node);
                ++n5;
            }
            ++n3;
        }
        return element;
    }
}

