/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.SequenceToken;

class ViewMonitor
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.ViewMonitor";
    private Distributor parent_;
    private boolean keepRunning_;
    private Vector invalidMembers_;
    private Vector invalidDistributors_;
    private Vector invalidClientEps_;
    private Vector invalidDistributorEps_;
    private boolean isPaused_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.ViewMonitor");

    ViewMonitor(Distributor distributor) {
        this.parent_ = distributor;
        this.keepRunning_ = true;
        this.isPaused_ = false;
        this.invalidMembers_ = new Vector(0);
        this.invalidDistributors_ = new Vector(0);
        this.invalidClientEps_ = new Vector(0);
        this.invalidDistributorEps_ = new Vector(0);
        this.setDaemon(true);
        this.setName("ViewMonitor of " + this.parent_.getID());
    }

    synchronized void toPause(boolean bl) {
        this.isPaused_ = bl;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger_.log(Level.FINE, this.getName() + " is started");
        long l = this.parent_.getConfig().getViewMonitorPause();
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        while (this.keepRunning_) {
            try {
                Thread.sleep(l);
                Object object = this;
                synchronized (object) {
                    if (this.isPaused_) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.parent_.clearExpiredReceipts(l);
                Object object2 = object = this.parent_.getSequenceToken();
                synchronized (object2) {
                    if (((SequenceToken)object).isExpired()) {
                        this.logger_.log(Level.WARNING, "Release expired SequenceToken=" + object);
                        this.parent_.releaseToken();
                    }
                }
                vector = this.parent_.getNonExistClients();
                vector2 = this.parent_.getNonExistDistributors();
                vector3 = this.parent_.getInvalidClientEps();
                vector4 = this.parent_.getInvalidDistributorEps();
                ViewMonitor.updateList(this.invalidMembers_, vector);
                ViewMonitor.updateList(this.invalidDistributors_, vector2);
                ViewMonitor.updateList(this.invalidClientEps_, vector3);
                ViewMonitor.updateList(this.invalidDistributorEps_, vector4);
                this.removeInvalidMembers();
                object2 = this;
                synchronized (object2) {
                    this.invalidMembers_ = vector;
                    this.invalidDistributors_ = vector2;
                }
            }
            catch (Exception exception) {
                if (!this.keepRunning_) continue;
                this.logger_.log(Level.WARNING, "Unexpected view problem", exception);
            }
        }
        this.logger_.log(Level.FINE, this.getName() + " is terminated");
    }

    private synchronized void updateInvalidMemberList(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        ViewMonitor.updateList(this.invalidMembers_, vector);
        ViewMonitor.updateList(this.invalidDistributors_, vector2);
        ViewMonitor.updateList(this.invalidClientEps_, vector3);
        ViewMonitor.updateList(this.invalidDistributorEps_, vector4);
    }

    private static void updateList(Vector vector, Vector vector2) {
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (vector2.contains(e)) continue;
            vector.remove(e);
            --i;
        }
    }

    private synchronized void removeInvalidMembers() throws GroupException, IOException, CloneNotSupportedException {
        Object object;
        int n;
        if (this.parent_.isACoordinator() && (this.invalidMembers_.size() > 0 || this.invalidDistributors_.size() > 0)) {
            this.logger_.log(Level.WARNING, "Identify " + this.invalidMembers_.size() + " non-existing members, " + this.invalidDistributors_.size() + " non-existing distributors");
            for (n = 0; n < this.invalidDistributors_.size(); ++n) {
                this.logger_.log(Level.FINEST, "Invalid " + this.invalidDistributors_.elementAt(n));
            }
            this.parent_.getViewManager().removeMembers(this.invalidMembers_, this.invalidDistributors_, this.parent_.getQueue(1));
        } else if (!this.parent_.isACoordinator() && this.invalidMembers_.size() > 0) {
            this.logger_.log(Level.WARNING, "Identify " + this.invalidMembers_.size() + " non-existing members");
            for (n = 0; n < this.invalidMembers_.size(); ++n) {
                object = (MemberID)this.invalidMembers_.elementAt(n);
                Packet packet = new Packet(2, this.parent_.getID());
                packet.setBlockReceiver();
                packet.setData(((MemberID)object).toBytes());
                this.parent_.forwardToCoordinator(packet);
            }
        }
        if (this.invalidClientEps_.size() > 0 || this.invalidDistributorEps_.size() > 0) {
            this.logger_.log(Level.WARNING, "Identify " + this.invalidClientEps_.size() + " invalid client EndPoints, " + this.invalidDistributorEps_.size() + ", invalid distributor EndPoints");
            for (n = 0; n < this.invalidClientEps_.size(); ++n) {
                object = (EndPointConnection)this.invalidClientEps_.elementAt(n);
                ((EndPointConnection)object).toBeDisconnected();
                ((EndPointConnection)object).close();
            }
            for (n = 0; n < this.invalidDistributorEps_.size(); ++n) {
                object = (EndPointConnection)this.invalidDistributorEps_.elementAt(n);
                ((EndPointConnection)object).toBeDisconnected();
                ((EndPointConnection)object).close();
            }
        }
    }

    synchronized void reset() {
        this.invalidMembers_.clear();
        this.invalidDistributors_.clear();
    }

    void shutdown() {
        this.keepRunning_ = false;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

