/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.Packet;

class Sender
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.Sender";
    private static final String THREAD_NAME = "Connector";
    private Distributor owner_;
    private Address destination_;
    private Packet p_;
    private Packet reply_;
    private Vector doneSenders_;
    private int timeout_;
    private EndPointConnection ep_;
    private boolean terminateExternally_;
    private int id_;
    private boolean persistEp_;
    private Hashtable holder_;
    private int retry_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.Sender");

    Sender(Distributor distributor, Address address, Packet packet, int n, Vector vector, Hashtable hashtable, int n2, boolean bl, int n3) {
        this.owner_ = distributor;
        this.destination_ = address;
        this.p_ = packet;
        this.timeout_ = n;
        this.doneSenders_ = vector;
        this.holder_ = hashtable;
        this.id_ = n2;
        this.persistEp_ = bl;
        this.setDaemon(true);
        String string = " Connector-" + n2 + " to " + this.destination_;
        if (this.persistEp_) {
            this.setName("Tightly-bound " + string);
        } else {
            this.setName("Loosely-bound " + string);
        }
        this.terminateExternally_ = false;
        this.retry_ = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block17: {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, this.getName() + " is started");
            }
            try {
                block16: {
                    try {
                        this.ep_ = this.owner_.connect(this.destination_, this.timeout_, this.retry_);
                        if (this.ep_ == null) break block16;
                        this.ep_.setForDisposed(this.persistEp_);
                        this.ep_.send(this.p_);
                        this.reply_ = this.ep_.read();
                    }
                    catch (GroupException groupException) {
                        if (!this.terminateExternally_ && this.persistEp_ && this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "Unexpected error", groupException);
                        }
                        Object var3_2 = null;
                        if (!this.persistEp_ && this.ep_ != null) {
                            this.ep_.close();
                        }
                        break block17;
                    }
                    catch (Exception exception) {
                        if (!this.terminateExternally_ && this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "Unexpected error", exception);
                        }
                        Object var3_3 = null;
                        if (!this.persistEp_ && this.ep_ != null) {
                            this.ep_.close();
                        }
                    }
                }
                Object var3_1 = null;
                if (!this.persistEp_ && this.ep_ != null) {
                    this.ep_.close();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (!this.persistEp_ && this.ep_ != null) {
                    this.ep_.close();
                }
                throw throwable;
            }
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, this.getName() + " is terminated");
        }
        Vector vector = this.doneSenders_;
        synchronized (vector) {
            this.doneSenders_.addElement(this);
            this.doneSenders_.notifyAll();
        }
        this.holder_.remove(this.destination_);
    }

    Address getDestination() {
        return this.destination_;
    }

    Packet getReply() {
        return this.reply_;
    }

    EndPointConnection getEndPoint() {
        return this.ep_;
    }

    void shutdown() {
        this.terminateExternally_ = true;
        if (this.ep_ != null) {
            try {
                this.ep_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ep_ = null;
        }
        this.interrupt();
    }
}

