/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.MemberID;

class RegistrationInfo
extends GcommSerializable {
    private MemberID mId_;
    private MemberID dId_;
    private Address dAddress_;
    boolean inSameJVMOfDistributor_;
    private String vmId_;
    private String userDefinedId_;
    private String tag_;

    private RegistrationInfo(MemberID memberID, MemberID memberID2, Address address, boolean bl, String string, String string2, String string3) {
        this.mId_ = memberID;
        this.dId_ = memberID2;
        this.dAddress_ = address;
        this.inSameJVMOfDistributor_ = bl;
        this.vmId_ = string;
        this.userDefinedId_ = string2;
        this.tag_ = string3;
    }

    static RegistrationInfo wrap(MemberID memberID, MemberID memberID2, Address address, boolean bl, String string, String string2, String string3) {
        return new RegistrationInfo(memberID, memberID2, address, bl, string, string2, string3);
    }

    static RegistrationInfo parse(byte[] byArray) throws GroupException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        MemberID memberID = GcommSerializable.readMemberIDFrom(byteArrayInputStream);
        MemberID memberID2 = GcommSerializable.readMemberIDFrom(byteArrayInputStream);
        Address address = GcommSerializable.readAddressFrom(byteArrayInputStream);
        boolean bl = GcommSerializable.readBooleanFrom(byteArrayInputStream);
        String string = GcommSerializable.readStringFrom(byteArrayInputStream);
        String string2 = GcommSerializable.readStringFrom(byteArrayInputStream);
        String string3 = GcommSerializable.readStringFrom(byteArrayInputStream);
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RegistrationInfo.wrap(memberID, memberID2, address, bl, string, string2, string3);
    }

    public byte[] toBytes() throws GroupException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GcommSerializable.writeTo(byteArrayOutputStream, this.mId_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.dId_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.dAddress_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.inSameJVMOfDistributor_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.vmId_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.userDefinedId_);
        GcommSerializable.writeTo(byteArrayOutputStream, this.tag_);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public int hashCode() {
        return 0;
    }

    MemberID getMemberID() {
        return this.mId_;
    }

    MemberID getDistributorID() {
        return this.dId_;
    }

    Address getDistributorAddress() {
        return this.dAddress_;
    }

    String getVMId() {
        return this.vmId_;
    }

    String getUserDefinedId() {
        return this.userDefinedId_;
    }

    String getTag() {
        return this.tag_;
    }

    void setDistributorID(MemberID memberID) {
        this.dId_ = memberID;
    }

    void setDistributorAddress(Address address) {
        this.dAddress_ = address;
    }

    void setVMId(String string) {
        this.vmId_ = string;
    }

    void setUserDefinedId(String string) {
        this.userDefinedId_ = string;
    }

    void setTag(String string) {
        this.tag_ = string;
    }

    boolean isInSameJVMOfDistributor() {
        return this.inSameJVMOfDistributor_;
    }

    void setInSameJVMOfDistributor(boolean bl) {
        this.inSameJVMOfDistributor_ = bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        try {
            RegistrationInfo registrationInfo;
            if (object instanceof RegistrationInfo && this.mId_.equals((registrationInfo = (RegistrationInfo)object).getMemberID()) && this.inSameJVMOfDistributor_ == registrationInfo.isInSameJVMOfDistributor() && this.vmId_ != null && this.vmId_.equals(registrationInfo.getVMId())) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Registration Information: ");
        stringBuffer.append("Member ID=");
        stringBuffer.append(this.mId_);
        stringBuffer.append(", inDistributor=");
        stringBuffer.append(this.inSameJVMOfDistributor_);
        stringBuffer.append(", VMID=");
        stringBuffer.append(this.vmId_);
        stringBuffer.append(", UserDefinedID=");
        stringBuffer.append(this.userDefinedId_);
        stringBuffer.append(", Tag=");
        stringBuffer.append(this.tag_);
        return stringBuffer.toString();
    }
}

