/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.HttpPacket;
import oracle.ias.cache.group.Packet;

class HttpHandler {
    static final String LOGGER_NAME = "oracle.ias.cache.group.HttpHandler";
    public static int HEADER_BUFFER_SIZE = 4096;
    private byte[] m_rcv_buf;
    private byte[] m_header_buf;
    private int m_position;
    private int m_header_position;
    private int m_bytes_read;
    private int m_sendBufferSize;
    private int m_recvBufferSize;
    private HashMap m_headers;
    private OutputStream m_os;
    private InputStream m_is;
    private transient GrpCommunication gcomm_;
    private transient Logger logger_ = Logger.getLogger("oracle.ias.cache.group.HttpHandler");

    HttpHandler(GrpCommunication grpCommunication, InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException, GroupException {
        this.gcomm_ = grpCommunication;
        if (outputStream == null || inputStream == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_SOCKETINITFAIL);
        }
        this.m_os = outputStream;
        this.m_is = inputStream;
        this.m_position = 0;
        this.m_header_position = 0;
        this.m_rcv_buf = new byte[n];
        this.m_header_buf = new byte[HEADER_BUFFER_SIZE];
        this.m_bytes_read = 0;
        this.m_headers = new HashMap();
        this.m_sendBufferSize = n2;
        this.m_recvBufferSize = n;
    }

    private void write(byte[] byArray) throws IOException, GroupException {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; i += n) {
            n = byArray.length - i;
            if (n > this.m_sendBufferSize) {
                n = this.m_sendBufferSize;
            }
            this.m_os.write(byArray, i, n);
        }
    }

    void write(HttpPacket httpPacket) throws IOException, GroupException {
        InputStream inputStream = null;
        byte[] byArray = httpPacket.getHeaders();
        this.write(byArray);
        byArray = httpPacket.getPacketBuffer();
        this.write(byArray);
        if (httpPacket.hasAttachedFile() || httpPacket.hasInputStream()) {
            if (httpPacket.hasAttachedFile()) {
                FileInputStream fileInputStream = new FileInputStream(httpPacket.getAttachedFile());
                inputStream = fileInputStream;
            } else if (httpPacket.hasInputStream()) {
                inputStream = httpPacket.getInputStream();
            }
            byArray = new byte[this.m_sendBufferSize];
            while (!this.gcomm_.isTerminated()) {
                int n;
                if (inputStream == null && this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Internal error: InputStream is null");
                }
                if ((n = inputStream.read(byArray)) == -1) break;
                this.m_os.write(byArray, 0, n);
            }
        }
        this.m_os.flush();
    }

    Packet read() throws IOException, GroupException {
        Closeable closeable;
        Object object;
        Packet packet = null;
        int n = 0;
        this.m_headers.clear();
        this.m_header_position = 0;
        while (this.m_header_position < this.m_header_buf.length && (this.m_header_position < 4 || this.m_header_buf[this.m_header_position - 4] != 13 || this.m_header_buf[this.m_header_position - 3] != 10 || this.m_header_buf[this.m_header_position - 2] != 13 || this.m_header_buf[this.m_header_position - 1] != 10)) {
            int n2 = this.m_is.read();
            if (n2 == -1) {
                return null;
            }
            this.m_header_buf[this.m_header_position] = (byte)n2;
            ++this.m_header_position;
        }
        if (this.m_header_position == this.m_recvBufferSize) {
            throw new GroupException(GrpCommunication.EXP_GRP_INVALID_STREAM);
        }
        n += this.m_header_position;
        this.parseHeaders();
        String string = (String)this.m_headers.get(HttpPacket.s_packet_length_header);
        if (string != null) {
            int n3 = new Integer(string);
            n += n3;
            byte[] byArray = new byte[n3];
            this.m_bytes_read = 0;
            while (this.m_bytes_read != n3) {
                int n4 = n3 - this.m_bytes_read;
                int n5 = this.m_is.read(byArray, this.m_bytes_read, n4);
                if (n5 == -1) {
                    throw new GroupException(GrpCommunication.EXP_GRP_INVALID_STREAM);
                }
                this.m_bytes_read += n5;
            }
            object = new ByteArrayInputStream(byArray);
            closeable = new ObjectInputStream((InputStream)object);
            try {
                packet = (Packet)((ObjectInputStream)closeable).readObject();
            }
            catch (Throwable throwable) {
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Can't deserialize the Packet at " + this.gcomm_.getLogID() + ". Root cause:" + throwable.getCause(), throwable);
                }
                packet = new Packet(0, 0, null, null, null, 0L);
            }
        } else {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Packet length header not found.");
            }
            throw new GroupException(GrpCommunication.EXP_GRP_INVALID_STREAM);
        }
        String string2 = (String)this.m_headers.get(HttpPacket.s_file_length_header);
        int n6 = 0;
        if (string2 != null) {
            n6 = new Integer(string2);
        }
        if (n6 != 0) {
            object = this.gcomm_.getTempFilePath();
            closeable = new FileOutputStream((String)object);
            while (n6 > 0) {
                this.m_bytes_read = n6 >= this.m_rcv_buf.length ? this.m_is.read(this.m_rcv_buf) : this.m_is.read(this.m_rcv_buf, 0, n6);
                if (this.m_bytes_read == -1) {
                    throw new GroupException(GrpCommunication.EXP_GRP_INVALID_STREAM);
                }
                n6 -= this.m_bytes_read;
                ((FileOutputStream)closeable).write(this.m_rcv_buf, 0, this.m_bytes_read);
            }
            if (n6 > 0) {
                throw new GroupException(GrpCommunication.EXP_GRP_INVALID_STREAM);
            }
            packet.setAttachedFileName((String)object);
        }
        packet.setTotalLength(n);
        return packet;
    }

    private void parseHeaders() throws IOException, GroupException {
        int n = this.m_position;
        byte[] byArray = new byte[this.m_header_position];
        System.arraycopy(this.m_header_buf, 0, byArray, 0, this.m_header_position);
        String string = new String(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals(HttpPacket.s_request_line)) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Invalid HTTP request information: " + string2);
            }
            throw new GroupException(GrpCommunication.EXP_GRP_INVALID_HTTP);
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, HttpPacket.s_separator);
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            String string5 = string3.substring(string4.length() + 2);
            this.m_headers.put(string4, string5);
        }
    }
}

