/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import oracle.ias.cache.group.SSLManager;
import oracle.ias.cache.group.Transport;

class GroupSocketOpener
implements Runnable {
    static final int IO_BUFFER_SIZE = 16384;
    private String m_host;
    private int m_port;
    private int m_timeout;
    private boolean m_secure;
    private Socket m_socket = null;
    private IOException m_err = null;
    private boolean m_hasTimedOut = false;
    private Transport trans_;

    GroupSocketOpener(Transport transport, InetAddress inetAddress, int n, int n2) {
        this(transport, inetAddress.getHostName(), n, n2);
    }

    GroupSocketOpener(Transport transport, String string, int n, int n2) {
        this(transport, string, n, n2, false);
    }

    GroupSocketOpener(Transport transport, InetAddress inetAddress, int n, int n2, boolean bl) {
        String string = inetAddress.getHostName();
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            string = inetAddress.getHostAddress();
        }
        this.m_host = string;
        this.m_port = n;
        this.m_timeout = n2;
        this.m_secure = bl;
        this.trans_ = transport;
    }

    GroupSocketOpener(Transport transport, String string, int n, int n2, boolean bl) {
        this.trans_ = transport;
        this.m_host = string;
        this.m_port = n;
        this.m_timeout = n2;
        this.m_secure = bl;
    }

    Socket createSocket() throws IOException {
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("Group Socket Opener: " + this.m_host + ":" + this.m_port);
        thread.start();
        try {
            thread.join(this.m_timeout);
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
        if (this.m_err != null) {
            throw this.m_err;
        }
        if (this.m_socket == null) {
            this.m_hasTimedOut = true;
            try {
                thread.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new SocketTimeoutException("Connection time out: " + this.m_host + ":" + this.m_port);
        }
        return this.m_socket;
    }

    public void run() {
        try {
            if (this.m_secure) {
                SSLManager sSLManager = this.trans_.getSSLManager();
                this.m_socket = sSLManager.createSSLSocket(this.m_host, this.m_port);
            } else {
                this.m_socket = new Socket(this.m_host, this.m_port);
            }
            this.m_socket.setReceiveBufferSize(16384);
            this.m_socket.setSendBufferSize(16384);
        }
        catch (IOException iOException) {
            this.m_err = iOException;
        }
        if (this.m_hasTimedOut) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_socket = null;
            this.m_err = null;
        }
    }
}

