/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.Unicaster;

class CoordinatorBroadcast
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.CoordinatorBroadcast";
    static final long DEFAULT_LIFETIME = 3600000L;
    private boolean terminate_ = false;
    private Address myAddress_ = null;
    private InetAddress multicastAddr_ = null;
    private long interval_ = 0L;
    private Object waiter_ = new Object();
    private int port_;
    private MulticastSocket ms_ = null;
    private byte[] msg_ = null;
    private ElectionNotification elec_ = null;
    private long endtime_ = 0L;
    private boolean useMulticast_ = false;
    private Address[] nlAddrs_ = null;
    private GrpCommunication gcomm_ = null;
    private Transport trans_ = null;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.CoordinatorBroadcast");

    CoordinatorBroadcast(GrpCommunication grpCommunication, Transport transport, String string, int n, Address address, long l, boolean bl) throws GroupException {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.useMulticast_ = true;
        this.myAddress_ = address;
        this.interval_ = l;
        this.port_ = n;
        try {
            this.multicastAddr_ = InetAddress.getByName(string);
            this.ms_ = new MulticastSocket(this.port_);
            this.ms_.setTimeToLive(1);
            this.ms_.joinGroup(this.multicastAddr_);
            this.msg_ = this.objectToByte(new ElectionNotification(this.myAddress_, bl));
        }
        catch (Exception exception) {
            throw new GroupException("Unable to broadcast coordinator availability", exception);
        }
        this.endtime_ = 3600000L + System.currentTimeMillis();
        this.setName("Coordinator Election Broadcaster at [" + this.multicastAddr_.getHostAddress() + ":" + this.port_ + "]");
        this.setDaemon(true);
    }

    CoordinatorBroadcast(GrpCommunication grpCommunication, Transport transport, Address[] addressArray, Address address, long l, boolean bl) throws GroupException {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.useMulticast_ = false;
        this.myAddress_ = address;
        this.interval_ = l;
        this.nlAddrs_ = addressArray;
        try {
            this.elec_ = new ElectionNotification(this.myAddress_, bl);
        }
        catch (Exception exception) {
            throw new GroupException("Unable to broadcast coordinator availability", exception);
        }
        this.endtime_ = 3600000L + System.currentTimeMillis();
        this.setName("Coordinator Election Broadcaster");
        this.setDaemon(true);
    }

    MulticastSocket getMulticastSocket() {
        return this.ms_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.terminate_ = true;
        Object object = this.waiter_;
        synchronized (object) {
            this.waiter_.notifyAll();
        }
        if (this.ms_ != null) {
            try {
                this.ms_.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    synchronized void shutdown(long l) {
        this.endtime_ = System.currentTimeMillis() + l;
    }

    private byte[] objectToByte(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void confirmNominee() {
        try {
            this.elec_ = new ElectionNotification(this.myAddress_, true);
            if (this.useMulticast_) {
                this.msg_ = this.objectToByte(this.elec_);
            }
            Object object = this.waiter_;
            synchronized (object) {
                this.waiter_.notifyAll();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Vector<Address> vector = new Vector<Address>();
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is started.");
        }
        while (!this.terminate_ && this.trans_.isNLStarted()) {
            object = this;
            synchronized (object) {
                block23: {
                    if (this.useMulticast_) {
                        DatagramPacket datagramPacket = new DatagramPacket(this.msg_, this.msg_.length, this.multicastAddr_, this.port_);
                        try {
                            this.ms_.send(datagramPacket);
                            if (!this.logger_.isLoggable(Level.FINEST)) break block23;
                            this.logger_.log(Level.FINEST, "Broadcast election vote:" + this.elec_ + " to multicast address:" + this.ms_);
                            break block23;
                        }
                        catch (IOException iOException) {
                            if (this.logger_.isLoggable(Level.FINEST)) {
                                this.logger_.log(Level.FINEST, "Failed to broadcast election vote:" + this.elec_ + " to multicast address:" + this.ms_);
                            }
                            break;
                        }
                    }
                    for (int i = 0; i < this.nlAddrs_.length && !this.terminate_; ++i) {
                        Address address = this.nlAddrs_[i];
                        if (address.equals(this.trans_.getCachedLocalNLAddress()) && this.trans_.isNLStarted() || vector.contains(address)) continue;
                        Unicaster unicaster = new Unicaster(this.gcomm_, this.trans_, address, vector, this.elec_);
                        vector.add(address);
                        unicaster.start();
                    }
                }
                if (this.endtime_ <= System.currentTimeMillis()) {
                    break;
                }
            }
            object = this.waiter_;
            synchronized (object) {
                try {
                    this.waiter_.wait(this.interval_);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        object = vector;
        synchronized (object) {
            if (vector.size() > 0) {
                try {
                    vector.wait(this.trans_.s_timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is terminated.");
        }
    }
}

