/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.Serializable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.Task;
import oracle.ias.cache.ThreadPool;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupPacket;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.commx.PlainMessage;

class TaskQ
implements MessageQueue {
    static final String LOGGER_NAME = "oracle.ias.cache.TaskQ";
    static Logger s_logger = Logger.getLogger("oracle.ias.cache.TaskQ");
    private static TaskQ tq = null;
    private static long seqId = 0L;
    Task head = null;
    Task tail = null;
    int count = 0;
    Vector dMap = new Vector();
    boolean dViewChange = false;
    boolean iamworking = true;

    private TaskQ() {
    }

    static TaskQ getInstance() {
        if (tq == null) {
            tq = new TaskQ();
        }
        return tq;
    }

    synchronized Task getTask() {
        Task task = null;
        while (this.iamworking) {
            int n = ThreadPool.getAcceptPriority();
            do {
                if ((task = task == null ? this.head : task.next) != null && this.isDeliverable(task, n) && this.iamworking) {
                    this.startDeliver(task);
                    this.dequeue(task);
                    break;
                }
                if (task == null || !s_logger.isLoggable(Level.FINEST)) continue;
                s_logger.log(Level.FINEST, "[Mem]  Task ID: " + task.id + " is not " + "deliverable. Priority=" + n);
            } while (task != null && this.iamworking);
            if (task != null) {
                return task;
            }
            this.waitForWork(0);
            if (this.head == null || !s_logger.isLoggable(Level.FINEST)) continue;
            long l = 0L;
            l = this.head.id;
            s_logger.log(Level.FINEST, "[CMg] " + Thread.currentThread().getName() + " is notified by task ID: " + l);
        }
        return null;
    }

    synchronized Task dequeue() {
        if (this.head == null) {
            return null;
        }
        Task task = this.head;
        this.head = this.head.next;
        if (this.head != null) {
            this.head.prev = null;
        } else {
            this.tail = null;
        }
        --this.count;
        return task;
    }

    synchronized void dequeue(Task task) {
        if (task == null) {
            return;
        }
        if (task.prev == null) {
            this.dequeue();
        } else if (task.next == null) {
            this.tail = task.prev;
            this.tail.next = null;
            --this.count;
        } else {
            task.prev.next = task.next;
            task.next.prev = task.prev;
            --this.count;
        }
    }

    synchronized void putTask(Task task) {
        this.enqueue(task, null);
    }

    public synchronized void enqueue(Object object, Object object2) {
        Task task = null;
        if (object instanceof PlainMessage) {
            task = new Task(41, object, (CacheCtx)object2);
        } else if (object instanceof Task) {
            task = (Task)object;
        }
        if (this.head == null) {
            this.head = task;
            this.head.prev = null;
        } else {
            this.tail.next = task;
            task.prev = this.tail;
        }
        task.next = null;
        this.tail = task;
        ++this.count;
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "[CMg] Enqueued: " + task);
        }
        this.wakeup();
    }

    synchronized void waitForWork(int n) {
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void wakeup() {
        this.notify();
    }

    synchronized void wakeupAll() {
        this.notifyAll();
    }

    synchronized void flush() {
        this.head = null;
        this.tail = null;
        this.count = 0;
    }

    synchronized void startDeliver(Task task) {
        if (task.taskType != 41) {
            return;
        }
        PlainMessage plainMessage = (PlainMessage)task.info;
        if (plainMessage.getType() == 1) {
            this.dViewChange = true;
        } else if (plainMessage.getType() == 0) {
            GroupPacket groupPacket = (GroupPacket)plainMessage.getMessageInfo();
            this.dMap.addElement(groupPacket.getSourceAddress());
        }
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "[CMg] " + Thread.currentThread().getName() + " DeliverId=" + ++seqId + " start delivery " + " task: " + task + ", dMap: " + this.dMap);
        }
    }

    synchronized void endDeliver(Task task) {
        if (task.taskType != 41) {
            return;
        }
        PlainMessage plainMessage = (PlainMessage)task.info;
        if (plainMessage.getType() == 1) {
            this.dViewChange = false;
        } else if (plainMessage.getType() == 0) {
            GroupPacket groupPacket = (GroupPacket)plainMessage.getMessageInfo();
            this.dMap.removeElement(groupPacket.getSourceAddress());
        }
        if (this.count > 0) {
            this.wakeup();
        }
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "[CMg] " + Thread.currentThread().getName() + " DeliverId=" + seqId + " End delivery " + " task: " + task + ", dMap:" + this.dMap);
        }
    }

    synchronized boolean isDeliverable(Task task, int n) {
        if (task.taskType != 41) {
            if (task.taskType == 16 || task.taskType == 1 || task.taskType == 8 || task.taskType == 12 || task.taskType == 10) {
                return true;
            }
            return n == 0;
        }
        PlainMessage plainMessage = (PlainMessage)task.info;
        if (plainMessage.getType() == 2) {
            return true;
        }
        if (plainMessage.getType() == 1 && this.dViewChange) {
            return false;
        }
        if (plainMessage.getType() == 1) {
            return true;
        }
        GroupPacket groupPacket = (GroupPacket)plainMessage.getMessageInfo();
        if (!this.isResponse(task, groupPacket) && (this.dMap.contains(groupPacket.getSourceAddress()) || n > 1)) {
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.log(Level.FINEST, "[CMg] " + Thread.currentThread().getName() + " not deliverable, priority=" + n + ", task: " + task + ", dMap=" + this.dMap);
            }
            return false;
        }
        return true;
    }

    private boolean isResponse(Task task, GroupPacket groupPacket) {
        Task task2 = null;
        Serializable serializable = null;
        try {
            serializable = groupPacket.getMessage();
        }
        catch (GroupException groupException) {
            if (s_logger.isLoggable(Level.WARNING)) {
                s_logger.log(Level.WARNING, "[CMg] " + Thread.currentThread().getName() + " Discard unknown packet " + groupPacket);
            }
            return false;
        }
        if (serializable instanceof Task) {
            task2 = (Task)serializable;
            if (task2.taskType == 8 || task2.taskType == 1 || task2.taskType == 10 || task2.taskType == 7 || task2.taskType == 22 || task2.taskType == 21 || task2.taskType == 12) {
                return true;
            }
        }
        return false;
    }

    void rest() {
        this.iamworking = false;
        tq = null;
    }
}

