/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.Cache;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheConfigParsingException;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheLoader;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.CapacityPolicy;
import oracle.ias.cache.ConfigReader;
import oracle.ias.cache.Declarable;
import oracle.ias.cache.GroupDeclaration;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.ObjectDeclaration;
import oracle.ias.cache.RegionDeclaration;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Configurator {
    static final String CACHE_CONFIGURATION = "cache-configuration";
    static final String CACHE = "cache";
    static final String ROOT_REGION = "root-region";
    static final String REGION = "region";
    static final String GROUP = "group";
    static final String CACHED_OBJECT = "cached-object";
    static final String LOGGING = "logging";
    static final String LOCATION = "location";
    static final String DISKSIZE = "disksize";
    static final String LEVEL = "level";
    static final String TOPLOGLEVEL = "topLogLevel";
    static final String OVERRIDELOG = "overrideLogConfiguration";
    static final String LOGCONFIGFILE = "configFileLocation";
    static final String ISDISTRIBUTED = "isDistributed";
    static final String PERSISTENCE = "persistence";
    static final String COMMUNICATION = "communication";
    static final String PRELOAD_FILE = "preload-file";
    static final String MAX_OBJECTS = "max-objects";
    static final String MAX_SIZE = "max-size";
    static final String CLEAN_INTERVAL = "clean-interval";
    static final String PING_INTERVAL = "ping-interval";
    static final String DMS = "dms";
    static final String COORDINATOR = "coordinator";
    static final String DISCOVERER = "discoverer";
    static final String LISTENER = "listener";
    static final String NETWORKID = "networkId";
    static final String IP_ADDRESS = "ip";
    static final String DISCOVERYPORT = "discovery-port";
    static final String TRANSPORT = "transport";
    static final String LOGGERCLASSNAME = "logger";
    static final String USESSL = "useSSL";
    static final String KEYSTORE = "keyStore";
    static final String SSLCONFIGFILE = "sslConfigFile";
    static final String LOCALADDRESS = "localAddress";
    static final String CACHENAME = "cacheName";
    static final String ELECTION = "coordinatorElection";
    static final String MULTICAST = "useMulticast";
    static final String UPDATE_INTERVAL = "updateInterval";
    static final String RESOLUTION_INTERVAL = "resolutionInterval";
    static final String MULTICAST_ADDR = "multicastAddress";
    static final String PORT = "port";
    static final String MULTICAST_TTL = "TTL";
    static final String PRIORITYORDER = "usePriorityOrder";
    static final String PRIORITY_INDEX = "order";
    static final String LOWER = "lower";
    static final String UPPER = "upper";
    static final String CAPACITYBUFFER = "capacity-buffer";
    static final String PROVIDER = "provider";
    static final String NAME = "name";
    static final String CLASSNAME = "classname";
    static final String PARAMETER = "parameter";
    static final String STRING_NAME = "string-name";
    static final String OBJECT_NAME = "object-name";
    static final String OBJECT = "object";
    static final String INIT_METHOD = "init";
    static final String ATTRIBUTES = "attributes";
    static final String TIME_TO_LIVE = "time-to-live";
    static final String DEFAULT_TTL = "default-ttl";
    static final String IDLE_TIME = "idle-time";
    static final String CACHE_LOADER = "cache-loader";
    static final String CACHE_EVENT_LISTENER = "event-listener";
    static final String VERSION = "version";
    static final String MAXCOUNT = "max-count";
    static final String PRIORITY = "priority";
    static final String SIZE = "size";
    static final String FLAGS = "flag";
    static final String CAPACITYPOLICY = "capacity-policy";
    static final String USERDEFINED = "user-defined";
    static final String DISTRIBUTE = "distribute";
    static final String REPLY = "reply";
    static final String SYNCHRONIZE = "synchronize";
    static final String SPOOL = "spool";
    static final String GROUP_TTL_DESTROY = "group_ttl_destroy";
    static final String ORIGINAL = "original";
    static final String SYNCHRONIZE_DEFAULT = "synchronize-default";
    static final String ALLOWNULL = "allownull";
    static final String MEASURE = "measure";
    static final String TIMEINV_LOCALONLY = "timebase-inv-localonly";
    static final String HANDLE_EVENT = "handle-event";
    static final String OBJECT_INVALIDATED = "object-invalidated";
    static final String OBJECT_UPDATED = "object-updated";
    static final String DEFAULT = "default";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String TMP = ".tmp";
    static final int TAB = 3;
    private static final int IO_BUFFER_SIZE = 8192;
    private RegionDeclaration[] regionDeclarations_;
    private CacheAttributes cattr_;
    private String preload_file_;
    private String configFile_;
    private XMLDocument doc_;
    private Hashtable preLoadDocs;
    private boolean loadDeclare_;

    public Configurator(String string) throws CacheConfigParsingException, InvalidArgumentException, CacheException {
        this.init(string, true);
    }

    public Configurator(String string, boolean bl) throws CacheConfigParsingException, InvalidArgumentException, CacheException {
        this.init(string, bl);
    }

    private void init(String string, boolean bl) throws CacheConfigParsingException, InvalidArgumentException, CacheException {
        this.configFile_ = string;
        this.preLoadDocs = new Hashtable();
        this.loadDeclare_ = bl;
        this.parseConfig(ConfigReader.getReader(string));
    }

    RegionDeclaration[] getRegionDeclarations() {
        return this.regionDeclarations_;
    }

    private void parseConfig(ConfigReader configReader) throws CacheConfigParsingException, InvalidArgumentException, CacheException {
        this.doc_ = (XMLDocument)configReader.getDocument();
        this.parseConfig(this.doc_);
    }

    private void parseConfig(XMLDocument xMLDocument) throws CacheConfigParsingException, InvalidArgumentException, CacheException {
        for (Node node = xMLDocument.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeName().equals(CACHE) && this.loadDeclare_) {
                this.parseCacheNode(node);
                continue;
            }
            if (!node.getNodeName().equals(CACHE_CONFIGURATION)) continue;
            this.cattr_ = new CacheAttributes();
            this.parseConfigurationNode(node);
        }
    }

    private void parseConfigurationNode(Node node) throws CacheConfigParsingException, InvalidArgumentException, CacheException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (string.equals(LOGGING)) {
                this.parseConfigLoggingNode(node2);
                continue;
            }
            if (string.equals(COMMUNICATION)) {
                this.parseConfigCommunicationNode(node2);
                continue;
            }
            if (string.equals(PERSISTENCE)) {
                this.parseConfigPersistenceNode(node2);
                continue;
            }
            if (string.equals(PRELOAD_FILE)) {
                this.preload_file_ = this.getNodeTextValue(node2);
                if (this.preload_file_ == null) continue;
                File file = new File(this.preload_file_);
                if (!file.exists()) {
                    this.preload_file_ = Configurator.getAbsoluteParent(this.configFile_) + File.separator + this.preload_file_;
                }
                XMLDocument xMLDocument = (XMLDocument)ConfigReader.getReader(this.preload_file_).getDocument();
                this.preLoadDocs.put(this.preload_file_, xMLDocument);
                this.parseConfig(xMLDocument);
                continue;
            }
            if (string.equals(MAX_OBJECTS)) {
                this.cattr_.setMaxObjects(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (string.equals(MAX_SIZE)) {
                this.cattr_.setMaxSize(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (string.equals(CLEAN_INTERVAL)) {
                this.cattr_.setCleanInterval(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (string.equals(PING_INTERVAL)) {
                this.cattr_.setPingInterval(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (string.equals(CACHENAME)) {
                this.cattr_.setCacheName(this.getNodeTextValue(node2));
                continue;
            }
            if (string.equals(CAPACITYPOLICY)) {
                this.cattr_.setCapacityPolicy(this.getNodeTextValue(node2));
                continue;
            }
            if (string.equals(CAPACITYBUFFER)) {
                this.cattr_.setCapacityBuffer(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (!string.equals(DMS)) continue;
            this.cattr_.setDms(Boolean.valueOf(this.getNodeTextValue(node2)));
        }
    }

    private static String getAbsoluteParent(String string) {
        File file = new File(string);
        return file.getAbsoluteFile().getParent();
    }

    private void parseConfigLoggingNode(Node node) {
        HashMap hashMap = this.getNodeAttributes(node);
        String string = (String)hashMap.get(OVERRIDELOG);
        if (string != null) {
            this.cattr_.setOverrideLogconfiguration(Boolean.valueOf(string));
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeName().equals(LOCATION)) {
                String string2 = this.getNodeTextValue(node2);
                File file = new File(string2);
                if (!file.isAbsolute()) {
                    string2 = Configurator.getAbsoluteParent(this.configFile_) + File.separator + string2;
                }
                this.cattr_.setLogFileName(string2);
                continue;
            }
            if (node2.getNodeName().equals(LEVEL)) {
                this.cattr_.setLogSeverity(CacheLogger.parseLogSeverity(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(TOPLOGLEVEL)) {
                this.cattr_.setLogLevel(Level.parse(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(LOGGERCLASSNAME)) {
                this.cattr_.setLogger(this.getNodeTextValue(node2));
                continue;
            }
            if (!node2.getNodeName().equals(LOGCONFIGFILE)) continue;
            this.cattr_.setLoggerConfigurationFileName(this.getNodeTextValue(node2));
        }
    }

    private void parseConfigPersistenceNode(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeName().equals(LOCATION)) {
                String string = this.getNodeTextValue(node2);
                File file = new File(string);
                if (!file.isAbsolute()) {
                    string = Configurator.getAbsoluteParent(this.configFile_) + File.separator + string;
                }
                this.cattr_.setDiskPath(string);
                continue;
            }
            if (!node2.getNodeName().equals(DISKSIZE)) continue;
            this.cattr_.setDiskSize(Integer.parseInt(this.getNodeTextValue(node2)));
        }
    }

    private void parseConfigCommunicationNode(Node node) throws CacheConfigParsingException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string;
            String string2;
            Object object;
            Object object2;
            Object object3;
            if (node2.getNodeName().equals(PROVIDER)) {
                object3 = this.getNodeTextValue(node2);
                try {
                    object2 = Class.forName((String)object3);
                    object = (GroupCommunication)((Class)object2).newInstance();
                    this.cattr_.gconfig = object.getDefaultConfiguration();
                    continue;
                }
                catch (Exception exception) {
                    throw new CacheConfigParsingException((String)object3, exception);
                }
            }
            if (node2.getNodeName().equals(ISDISTRIBUTED)) {
                this.cattr_.setDistribute(Boolean.valueOf(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(TRANSPORT)) {
                this.cattr_.setTransport(CacheAttributes.parseTransportInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(USESSL)) {
                this.cattr_.setEnableSSL(Boolean.valueOf(this.getNodeTextValue(node2)));
                this.cattr_.isSSLEnabled = this.cattr_.getGroupConfig().isSSLEnabled();
                continue;
            }
            if (node2.getNodeName().equals(KEYSTORE) && this.cattr_.getGroupConfig().isSSLEnabled()) {
                object3 = this.getNodeTextValue(node2);
                object2 = new File((String)object3);
                if (!((File)object2).isAbsolute()) {
                    object3 = Configurator.getAbsoluteParent(this.configFile_) + File.separator + (String)object3;
                }
                this.cattr_.setKeyStore((String)object3);
                continue;
            }
            if (node2.getNodeName().equals(SSLCONFIGFILE) && this.cattr_.getGroupConfig().isSSLEnabled()) {
                object3 = this.getNodeTextValue(node2);
                object2 = new File((String)object3);
                if (!((File)object2).isAbsolute()) {
                    object3 = Configurator.getAbsoluteParent(this.configFile_) + File.separator + (String)object3;
                }
                this.cattr_.setSSLConfigFile((String)object3);
                this.cattr_.sslConfigFilePath = object3;
                continue;
            }
            if (node2.getNodeName().equals(LOCALADDRESS)) {
                object3 = this.getNodeTextValue(node2);
                this.cattr_.setLocalAddress((String)object3);
                continue;
            }
            if (node2.getNodeName().equals(COORDINATOR) || node2.getNodeName().equals(DISCOVERER)) {
                object3 = this.getNodeAttributes(node2);
                object2 = (String)((HashMap)object3).get(IP_ADDRESS);
                object = (String)((HashMap)object3).get(DISCOVERYPORT);
                string2 = (String)((HashMap)object3).get(ORIGINAL);
                string = (String)((HashMap)object3).get(PRIORITY_INDEX);
                String string3 = (String)((HashMap)object3).get(USESSL);
                String string4 = (String)((HashMap)object3).get(NETWORKID);
                boolean bl = Boolean.valueOf(string3);
                int n = 1;
                if (string4 != null) {
                    n = Integer.parseInt(string4);
                }
                boolean bl2 = false;
                if (string2 != null) {
                    bl2 = Boolean.valueOf(string2);
                }
                if (object == null) continue;
                InetAddress inetAddress = null;
                try {
                    inetAddress = object2 == null ? (this.cattr_.getLocalAddress() != null ? InetAddress.getByName(this.cattr_.getLocalAddress()) : InetAddress.getLocalHost()) : InetAddress.getByName((String)object2);
                    int n2 = 0;
                    if (string != null) {
                        n2 = Integer.parseInt(string);
                    }
                    this.cattr_.getGroupConfig().addCacheAddr(inetAddress, Integer.parseInt((String)object), false, bl2, n2, bl, n);
                }
                catch (UnknownHostException unknownHostException) {}
                continue;
            }
            if (node2.getNodeName().equals(LISTENER)) {
                object3 = this.getNodeAttributes(node2);
                object2 = (String)((HashMap)object3).get(IP_ADDRESS);
                object = (String)((HashMap)object3).get(DISCOVERYPORT);
                string2 = (String)((HashMap)object3).get(USESSL);
                string = (String)((HashMap)object3).get(NETWORKID);
                boolean bl = Boolean.valueOf(string2);
                int n = Integer.parseInt(string);
                if (object == null) continue;
                InetAddress inetAddress = null;
                try {
                    if (object2 != null) {
                        inetAddress = InetAddress.getByName((String)object2);
                    }
                    this.cattr_.getGroupConfig().addListener(inetAddress, Integer.parseInt((String)object), bl, n);
                }
                catch (UnknownHostException unknownHostException) {}
                continue;
            }
            if (node2.getNodeName().equals(ELECTION)) {
                this.parseElectionNode(node2);
                continue;
            }
            if (!node2.getNodeName().equals(PORT)) continue;
            object3 = this.getNodeAttributes(node2);
            object2 = (String)((HashMap)object3).get(LOWER);
            object = (String)((HashMap)object3).get(UPPER);
            if (object2 != null) {
                this.cattr_.setLowerPortBoundry(Integer.parseInt((String)object2));
            }
            if (object == null) continue;
            this.cattr_.setUpperPortBoundry(Integer.parseInt((String)object));
        }
    }

    private void parseElectionNode(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeName().equals(MULTICAST)) {
                this.cattr_.gconfig.setMulticast(Boolean.valueOf(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(UPDATE_INTERVAL)) {
                this.cattr_.gconfig.setMulticastInterval(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(RESOLUTION_INTERVAL)) {
                this.cattr_.gconfig.setResolutionInterval(Long.parseLong(this.getNodeTextValue(node2)));
                continue;
            }
            if (node2.getNodeName().equals(MULTICAST_ADDR)) {
                HashMap hashMap = this.getNodeAttributes(node2);
                String string = (String)hashMap.get(IP_ADDRESS);
                String string2 = (String)hashMap.get(PORT);
                if (string != null) {
                    this.cattr_.gconfig.setMulticastAddress(string);
                }
                if (string2 == null) continue;
                this.cattr_.gconfig.setMulticastPort(Integer.parseInt(string2));
                continue;
            }
            if (node2.getNodeName().equals(MULTICAST_TTL)) {
                this.cattr_.gconfig.setMulticastTTL(Integer.parseInt(this.getNodeTextValue(node2)));
                continue;
            }
            if (!node2.getNodeName().equals(PRIORITYORDER)) continue;
            this.cattr_.gconfig.enablePriorityOrder(Boolean.valueOf(this.getNodeTextValue(node2)));
        }
    }

    private void parseCacheNode(Node node) throws CacheConfigParsingException, InvalidArgumentException {
        Vector<RegionDeclaration> vector = new Vector<RegionDeclaration>(1);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!node2.getNodeName().equals(REGION)) continue;
            RegionDeclaration regionDeclaration = this.parseRegionNode(node2);
            vector.addElement(regionDeclaration);
        }
        if (vector.size() > 0) {
            this.regionDeclarations_ = new RegionDeclaration[vector.size()];
            vector.toArray(this.regionDeclarations_);
        }
    }

    private RegionDeclaration parseRegionNode(Node node) throws CacheConfigParsingException, InvalidArgumentException {
        RegionDeclaration regionDeclaration = new RegionDeclaration();
        HashMap hashMap = this.getNodeAttributes(node);
        regionDeclaration.setName((String)hashMap.get(NAME));
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (string.equals(ATTRIBUTES)) {
                regionDeclaration.setAttributes(this.parseAttributesNode(node2));
                continue;
            }
            if (string.equals(REGION)) {
                regionDeclaration.addRegionDeclaration(this.parseRegionNode(node2));
                continue;
            }
            if (string.equals(GROUP)) {
                regionDeclaration.addGroupDeclaration(this.parseGroupNode(node2));
                continue;
            }
            if (!string.equals(CACHED_OBJECT)) continue;
            regionDeclaration.addObjectDeclaration(this.parseCachedObjectNode(node2));
        }
        return regionDeclaration;
    }

    private GroupDeclaration parseGroupNode(Node node) throws CacheConfigParsingException, InvalidArgumentException {
        GroupDeclaration groupDeclaration = new GroupDeclaration();
        HashMap hashMap = this.getNodeAttributes(node);
        groupDeclaration.setName((String)hashMap.get(NAME));
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (string.equals(ATTRIBUTES)) {
                groupDeclaration.setAttributes(this.parseAttributesNode(node2));
                continue;
            }
            if (string.equals(GROUP)) {
                groupDeclaration.addGroupDeclaration(this.parseGroupNode(node2));
                continue;
            }
            if (!string.equals(CACHED_OBJECT)) continue;
            groupDeclaration.addObjectDeclaration(this.parseCachedObjectNode(node2));
        }
        return groupDeclaration;
    }

    private ObjectDeclaration parseCachedObjectNode(Node node) throws CacheConfigParsingException, InvalidArgumentException {
        ObjectDeclaration objectDeclaration = new ObjectDeclaration();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            if (string.equals(NAME)) {
                objectDeclaration.setName(this.parseObjectNameNode(node2));
                continue;
            }
            if (string.equals(ATTRIBUTES)) {
                objectDeclaration.setAttributes(this.parseAttributesNode(node2));
                continue;
            }
            if (!string.equals(OBJECT)) continue;
            objectDeclaration.setObject(this.parseObjectNode(node2));
        }
        return objectDeclaration;
    }

    private void setUserDefined(Attributes attributes, Node node) throws CacheConfigParsingException, InvalidArgumentException {
        String string = null;
        String string2 = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string3 = node2.getNodeName();
            if (string3.equals(KEY)) {
                string = this.getNodeTextValue(node2);
                continue;
            }
            if (!string3.equals(VALUE)) continue;
            string2 = this.getNodeTextValue(node2);
        }
        attributes.setUserAttribute(string, string2);
    }

    private HashMap getNodeAttributes(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                hashMap.put(attr.getNodeName(), attr.getNodeValue());
            }
        }
        return hashMap;
    }

    private String getNodeTextValue(Node node) {
        Node node2 = node.getFirstChild();
        return node2.getNodeValue().trim();
    }

    private void setAttributes(Attributes attributes, Node node) throws CacheConfigParsingException, InvalidArgumentException {
        String string = node.getNodeName();
        if (string.equals(TIME_TO_LIVE)) {
            attributes.setTimeToLive(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(DEFAULT_TTL)) {
            attributes.setDefaultTimeToLive(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(IDLE_TIME)) {
            attributes.setIdleTime(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(VERSION)) {
            attributes.setVersion(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(MAXCOUNT)) {
            attributes.setMaxCount(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(PRIORITY)) {
            attributes.setPriority(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(SIZE)) {
            attributes.setSize(Integer.parseInt(this.getNodeTextValue(node)));
        } else if (string.equals(FLAGS)) {
            String string2 = this.getNodeTextValue(node);
            if (string2.equalsIgnoreCase(DISTRIBUTE)) {
                attributes.setFlags(attributes.getFlags() | 1L);
            } else if (string2.equalsIgnoreCase(REPLY)) {
                attributes.setFlags(attributes.getFlags() | 2L);
            } else if (string2.equalsIgnoreCase(SYNCHRONIZE)) {
                attributes.setFlags(attributes.getFlags() | 4L);
            } else if (string2.equalsIgnoreCase(SPOOL)) {
                attributes.setFlags(attributes.getFlags() | 8L);
            } else if (string2.equalsIgnoreCase(GROUP_TTL_DESTROY)) {
                attributes.setFlags(attributes.getFlags() | 0x10L);
            } else if (string2.equalsIgnoreCase(ORIGINAL)) {
                attributes.setFlags(attributes.getFlags() | 0x20L);
            } else if (string2.equalsIgnoreCase(SYNCHRONIZE_DEFAULT)) {
                attributes.setFlags(attributes.getFlags() | 0x40L);
            } else if (string2.equalsIgnoreCase(ALLOWNULL)) {
                attributes.setFlags(attributes.getFlags() | 0x200L);
            } else if (string2.equalsIgnoreCase(MEASURE)) {
                attributes.setFlags(attributes.getFlags() | 0x400L);
            } else if (string2.equalsIgnoreCase(TIMEINV_LOCALONLY)) {
                attributes.setFlags(attributes.getFlags() | 0x800L);
            }
        } else if (string.equals(CACHE_LOADER)) {
            attributes.setLoader((CacheLoader)this.parseObjectNode(node));
        } else if (string.equals(CAPACITYPOLICY)) {
            attributes.setCapacityPolicy((CapacityPolicy)this.parseObjectNode(node));
        } else if (string.equals(USERDEFINED)) {
            this.setUserDefined(attributes, node);
        } else if (string.equals(CACHE_EVENT_LISTENER)) {
            String string3 = null;
            String string4 = null;
            int n = -1;
            boolean bl = false;
            HashMap hashMap = this.getNodeAttributes(node);
            string3 = (String)hashMap.get(HANDLE_EVENT);
            string4 = (String)hashMap.get(DEFAULT);
            if (string3 != null) {
                if (string3.equalsIgnoreCase(OBJECT_INVALIDATED)) {
                    n = 0;
                } else if (string3.equalsIgnoreCase(OBJECT_UPDATED)) {
                    n = 1;
                }
            }
            if (string4 != null) {
                bl = Boolean.valueOf(string4);
            }
            if (n != -1) {
                attributes.setCacheEventListener(n, (CacheEventListener)this.parseObjectNode(node), bl);
            }
        }
    }

    private String[] parseNameValuePairNode(Node node) {
        String[] stringArray = new String[]{(String)this.getNodeAttributes(node).get(NAME), this.getNodeTextValue(node)};
        return stringArray;
    }

    private Object parseObjectNameNode(Node node) throws CacheConfigParsingException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeName().equals(STRING_NAME)) {
                return this.getNodeTextValue(node2);
            }
            if (!node2.getNodeName().equals(OBJECT_NAME)) continue;
            return this.parseObjectNode(node2);
        }
        throw new CacheConfigParsingException(node.getNodeName());
    }

    private Object parseObjectNode(Node node) throws CacheConfigParsingException {
        Object object;
        String string = null;
        Properties properties = new Properties();
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeName().equals(CLASSNAME)) {
                string = this.getNodeTextValue((Node)object);
                continue;
            }
            if (!object.getNodeName().equals(PARAMETER)) continue;
            String[] stringArray = this.parseNameValuePairNode((Node)object);
            properties.put(stringArray[0], stringArray[1]);
        }
        if (string != null) {
            try {
                object = Class.forName(string);
                Object t = ((Class)object).newInstance();
                if (t instanceof Declarable) {
                    Method method = null;
                    Class[] classArray = new Class[]{Class.forName("java.util.Properties")};
                    method = ((Class)object).getMethod(INIT_METHOD, classArray);
                    Object[] objectArray = new Object[]{properties};
                    method.invoke(t, objectArray);
                }
                return t;
            }
            catch (Exception exception) {
                throw new CacheConfigParsingException(node.getNodeName(), exception);
            }
        }
        throw new CacheConfigParsingException("Class not found: " + node.getNodeName());
    }

    private Attributes parseAttributesNode(Node node) throws CacheConfigParsingException, InvalidArgumentException {
        Attributes attributes = new Attributes();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String string = node2.getNodeName();
            this.setAttributes(attributes, node2);
        }
        return attributes;
    }

    private void updateDocument(CacheAttributes cacheAttributes) throws CacheConfigParsingException {
        for (Node node = this.doc_.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals(CACHE_CONFIGURATION)) continue;
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Object object;
                String string = node2.getNodeName();
                if (!string.equals(COMMUNICATION)) continue;
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (!object.getNodeName().equals(LOCALADDRESS)) continue;
                    node2.removeChild((Node)object);
                    object = node2.getFirstChild();
                }
                if (cacheAttributes.getLocalAddress() != null) {
                    object = (XMLElement)this.doc_.createElement(LOCALADDRESS);
                    object.addText(cacheAttributes.getLocalAddress());
                    node2.appendChild((Node)object);
                }
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (!object.getNodeName().equals(COORDINATOR) && !object.getNodeName().equals(DISCOVERER)) continue;
                    node2.removeChild((Node)object);
                    object = node2.getFirstChild();
                }
                object = cacheAttributes.getAddrList();
                if (object == null || ((Vector)object).size() <= 0) continue;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    NetworkAddress networkAddress = (NetworkAddress)((Vector)object).elementAt(i);
                    String string2 = networkAddress.getFullyQualifiedHostName();
                    int n = networkAddress.getPort();
                    boolean bl = networkAddress.isOriginal();
                    XMLElement xMLElement = (XMLElement)this.doc_.createElement(DISCOVERER);
                    if (!bl) {
                        xMLElement.setAttribute(IP_ADDRESS, string2);
                    }
                    xMLElement.setAttribute(DISCOVERYPORT, String.valueOf(n));
                    xMLElement.setAttribute(ORIGINAL, String.valueOf(bl));
                    node2.appendChild((Node)xMLElement);
                }
            }
        }
    }

    public CacheAttributes getCacheAttributes() {
        return this.cattr_;
    }

    public void defineDeclarable(boolean bl) throws CacheException {
        if (this.regionDeclarations_ != null) {
            for (int i = 0; i < this.regionDeclarations_.length; ++i) {
                this.regionDeclarations_[i].declare(null, bl);
            }
        }
    }

    public void defineDeclarable() throws CacheException {
        this.defineDeclarable(false);
    }

    public void updateFile(CacheAttributes cacheAttributes) throws CacheConfigParsingException {
        this.updateDocument(cacheAttributes);
        try {
            File file = new File(this.configFile_ + TMP);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.doc_.print((OutputStream)bufferedOutputStream);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            fileOutputStream.close();
            this.outputFormatedFile(file);
            file.delete();
        }
        catch (IOException iOException) {
            throw new CacheConfigParsingException("Unable to update configuration file", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputFormatedFile(File file) throws IOException {
        FileInputStream fileInputStream;
        block15: {
            fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            char c = '\n';
            char c2 = '\t';
            char c3 = ' ';
            char c4 = '\r';
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            boolean bl = false;
            boolean bl2 = false;
            byte[] byArray = new byte[8192];
            try {
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(this.configFile_);
                while (n != -1) {
                    int n4 = 0;
                    while (!this.bufferFull(n4, n3)) {
                        n2 = n;
                        n = fileInputStream.read();
                        if ((char)n == '<') {
                            n2 = n;
                            n = fileInputStream.read();
                            if ((byte)n == 47) {
                                --n3;
                                if (!bl) {
                                    n4 -= 3;
                                }
                            } else {
                                ++n3;
                            }
                            if (bl) {
                                byArray[n4++] = c;
                                n4 += this.indent(n3, byArray, n4);
                                bl = false;
                            }
                            byArray[n4++] = (byte)n2;
                            byArray[n4++] = (byte)n;
                            bl2 = false;
                            continue;
                        }
                        if ((char)n == '>') {
                            if (n2 == 47) {
                                --n3;
                            }
                            byArray[n4++] = (byte)n;
                            byArray[n4++] = c;
                            n4 += this.indent(n3, byArray, n4);
                            bl = false;
                            bl2 = true;
                            continue;
                        }
                        if (n == -1) break;
                        if ((char)n == c) {
                            bl2 = true;
                            continue;
                        }
                        if ((char)n == c4 || bl2 && ((char)n == c2 || (char)n == c3)) continue;
                        byArray[n4++] = (byte)n;
                        bl2 = false;
                        bl = true;
                    }
                    fileOutputStream.write(byArray, 0, n4);
                }
                fileOutputStream.close();
                fileInputStream.close();
                fileOutputStream = null;
                fileInputStream = null;
                Object var16_15 = null;
                if (fileOutputStream == null) break block15;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw throwable;
            }
            fileOutputStream.close();
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
    }

    private int indent(int n, byte[] byArray, int n2) {
        int n3 = 3 * n;
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i = n2; i < n2 + n3; ++i) {
            byArray[i] = 32;
        }
        return n3;
    }

    private boolean bufferFull(int n, int n2) {
        int n3 = 5;
        int n4 = 3 * n;
        if (n4 < 0) {
            n4 = 0;
        }
        return n2 + n4 + n3 >= 8192;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.cattr_ != null) {
            stringBuffer.append(this.cattr_.toString());
            stringBuffer.append("\n");
        }
        if (this.regionDeclarations_ != null) {
            for (int i = 0; i < this.regionDeclarations_.length; ++i) {
                stringBuffer.append(this.regionDeclarations_[i].toString());
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            Configurator configurator = new Configurator(stringArray[0]);
            CacheAttributes cacheAttributes = configurator.getCacheAttributes();
            System.out.println(cacheAttributes);
            System.out.println("");
            System.out.println(configurator);
            Cache.open();
            CacheInternal.dump(null);
            Cache.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

