/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

public class AggregateStatus {
    public static final int LOW = 0;
    public static final int AVG = 1;
    public static final int HIGH = 2;
    private static final int ARRSIZE = 3;
    int pass;
    int groupsToDo;
    int objCount;
    long[] priority = new long[3];
    long[] accessCount = new long[3];
    long[] size = new long[3];
    long[] lastAccess = new long[3];
    long[] loadTime = new long[3];
    long[] createTime = new long[3];
    AggregateStatus newStats;
    AggregateStatus next;
    AggregateStatus diskStatus;

    AggregateStatus() {
        this.clear();
    }

    public long getPriority(int n) {
        if (n >= 3 || n < 0) {
            return -1L;
        }
        return this.priority[n];
    }

    public long getAccessCount(int n) {
        if (n >= 3 || n < 0) {
            return -1L;
        }
        return this.accessCount[n];
    }

    public long getSize(int n) {
        if (n >= 3 || n < 0) {
            return -1L;
        }
        return this.size[n];
    }

    public long getLastAccessTime(int n) {
        if (n >= 3 || n < 0) {
            return -1L;
        }
        return this.lastAccess[n];
    }

    public long getLoadTime(int n) {
        if (n >= 3 || n < 0) {
            return -1L;
        }
        return this.loadTime[n];
    }

    public long getCreateTime(int n) {
        if (n >= 3 || n < 0) {
            return -1L;
        }
        return this.createTime[n];
    }

    public int getObjectCount() {
        return this.objCount;
    }

    public AggregateStatus getDiskStatus() {
        return this.diskStatus;
    }

    void setDiskStatus(AggregateStatus aggregateStatus) {
        this.diskStatus = aggregateStatus;
    }

    AggregateStatus getNewStats() {
        if (this.newStats == null) {
            this.newStats = new AggregateStatus();
        }
        return this.newStats;
    }

    void clear() {
        this.reset();
        this.next = null;
    }

    void reset() {
        this.objCount = 0;
        this.pass = 0;
        this.groupsToDo = 0;
        this.priority[0] = Long.MAX_VALUE;
        this.priority[1] = 0L;
        this.priority[2] = Long.MIN_VALUE;
        this.accessCount[0] = Long.MAX_VALUE;
        this.accessCount[1] = 0L;
        this.accessCount[2] = 0L;
        this.size[0] = Long.MAX_VALUE;
        this.size[1] = 0L;
        this.size[2] = 0L;
        this.lastAccess[0] = Long.MAX_VALUE;
        this.lastAccess[1] = 0L;
        this.lastAccess[2] = 0L;
        this.loadTime[0] = Long.MAX_VALUE;
        this.loadTime[1] = 0L;
        this.loadTime[2] = 0L;
        this.createTime[0] = Long.MAX_VALUE;
        this.createTime[1] = 0L;
        this.createTime[2] = 0L;
        this.diskStatus = null;
    }

    void clone(AggregateStatus aggregateStatus) {
        aggregateStatus.objCount = this.objCount;
        aggregateStatus.pass = this.pass;
        System.arraycopy(this.priority, 0, aggregateStatus.priority, 0, 3);
        System.arraycopy(this.accessCount, 0, aggregateStatus.accessCount, 0, 3);
        System.arraycopy(this.size, 0, aggregateStatus.size, 0, 3);
        System.arraycopy(this.lastAccess, 0, aggregateStatus.lastAccess, 0, 3);
        System.arraycopy(this.loadTime, 0, aggregateStatus.loadTime, 0, 3);
        System.arraycopy(this.createTime, 0, aggregateStatus.createTime, 0, 3);
    }

    public String toString() {
        return "Pass " + this.pass + " count " + this.objCount + "\nPriority " + this.priority[0] + " " + this.priority[1] + " " + this.priority[2] + "\nAccessCount " + this.accessCount[0] + " " + this.accessCount[1] + " " + this.accessCount[2] + "\nSize " + this.size[0] + " " + this.size[1] + " " + this.size[2] + "\nLastAccess " + this.lastAccess[0] + " " + this.lastAccess[1] + " " + this.lastAccess[2] + "\nLoadTime " + this.loadTime[0] + " " + this.loadTime[1] + " " + this.loadTime[2] + "\nCreateTime " + this.createTime[0] + " " + this.createTime[1] + " " + this.createTime[2];
    }
}

