/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import javax.swing.SwingUtilities;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.dss.graph.Graph;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.uicli.binding.JUCtrlRangeBinding;
import oracle.jbo.uicli.graph.BIBeanDataAccessAdapter;
import oracle.jbo.uicli.graph.ColumnCountHelper;
import oracle.jbo.uicli.graph.GraphConstants;

public abstract class JUGraphBinding
extends JUCtrlRangeBinding
implements GraphConstants {
    protected static final String emptyString = "";
    private static ColumnCountHelper columnCountHelper;

    public JUGraphBinding(Graph graph, DCIteratorBinding dCIteratorBinding, String[] stringArray) {
        super((Object)graph, dCIteratorBinding, stringArray);
    }

    protected abstract String getColumnLabel(int var1);

    protected abstract int getColumnCount();

    protected abstract String getRowLabel(int var1);

    protected abstract long getRowCount();

    protected abstract Object getValue(int var1, int var2);

    protected boolean isControlQueriable() {
        return false;
    }

    public static int getNumberOfColumnPerMarker(int n) {
        if (columnCountHelper == null) {
            columnCountHelper = new ColumnCountHelper();
        }
        return columnCountHelper.findNumberOfColumnsFor(n);
    }

    protected int rowIndexToRangeIndex(int n) {
        RowSetIterator rowSetIterator = (RowSetIterator)this.getRowIterator();
        if (rowSetIterator != null) {
            int n2 = rowSetIterator.getRangeStart();
            if (n2 <= 0) {
                return n;
            }
            return n - n2;
        }
        return n;
    }

    public boolean isDirty() {
        return false;
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
    }

    public Object getValueAt(int n, int n2) {
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public void updateValuesFromRows(Row[] rowArray, boolean bl) {
        this.notifyView();
    }

    public void updateRowInserted(InsertEvent insertEvent) {
        this.notifyView();
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
        this.notifyView();
    }

    private boolean isFindMode() {
        return this.getBindingContainer().isFindMode();
    }

    protected abstract void notifyView();

    protected void refreshBIBeanAdapter(final BIBeanDataAccessAdapter bIBeanDataAccessAdapter) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (!this.isFindMode()) {
                        bIBeanDataAccessAdapter.refresh();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public static String[] buildAttributeListWithLabel(String[] stringArray, String string) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        stringArray2[n] = new String(string);
        return stringArray2;
    }
}

