/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.LoggingConfigurationException;
import oracle.core.ojdl.logging.ODLLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class LoggingConfigurationImpl {
    private static final String CONFIG_FILE_PROP = "oracle.core.ojdl.logging.config.file";
    private static final String DTD_PATH = "/oracle/core/ojdl/logging/logging-config.dtd";
    private File m_referenceDir;
    private Map m_handlers = new HashMap();
    private Map m_loggers = new HashMap();
    static /* synthetic */ Class class$java$util$logging$Filter;
    static /* synthetic */ Class class$java$util$logging$ErrorManager;
    static /* synthetic */ Class class$java$util$logging$Formatter;

    public LoggingConfigurationImpl() throws LoggingConfigurationException {
        String string = System.getProperty(CONFIG_FILE_PROP);
        if (string == null) {
            throw new LoggingConfigurationException(this.getClass().getName() + " error: property " + CONFIG_FILE_PROP + " must be defined");
        }
        this.m_referenceDir = new File(string).getParentFile();
        LogManager.getLogManager().reset();
        this.configure(this.parse(string), true);
    }

    public LoggingConfigurationImpl(String string) throws LoggingConfigurationException {
        this.m_referenceDir = new File(string).getParentFile();
        this.configure(this.parse(string), true);
    }

    public LoggingConfigurationImpl(Document document) throws LoggingConfigurationException {
        this.configure(document, false);
    }

    public void reset() {
        Object object;
        Iterator<Object> iterator = this.m_handlers.values().iterator();
        while (iterator.hasNext()) {
            object = (Handler)iterator.next();
            try {
                ((Handler)object).close();
            }
            catch (Exception exception) {}
        }
        iterator = this.m_loggers.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Logger logger = Logger.getLogger((String)object);
            LoggerState loggerState = (LoggerState)this.m_loggers.get(object);
            for (int i = 0; i < loggerState.m_handlers.size(); ++i) {
                logger.removeHandler((Handler)loggerState.m_handlers.get(i));
            }
            if (loggerState.m_changedLevel) {
                logger.setLevel(loggerState.m_level);
            }
            if (loggerState.m_changedFilter) {
                logger.setFilter(null);
            }
            logger.setUseParentHandlers(loggerState.m_useParentHandlers);
        }
        this.m_handlers = new HashMap();
        this.m_loggers = new HashMap();
    }

    private Properties initVarBindings() {
        String string;
        Properties properties = new Properties();
        String string2 = System.getProperty("oracle.home");
        if (string2 == null) {
            string2 = System.getProperty("oracle.ons.oraclehome");
        }
        if (string2 != null) {
            properties.setProperty("ORACLE_HOME", string2);
        }
        if ((string = System.getProperty("oracle.ons.indexid")) != null) {
            int n = 0;
            int n2 = string.indexOf(46);
            if (n2 >= 0) {
                String string3 = string.substring(n, n2);
                n = n2 + 1;
                if ((n2 = string.indexOf(46, n)) >= 0) {
                    String string4 = string.substring(n, n2);
                    String string5 = string.substring(n2 + 1);
                    properties.setProperty("OPMN_PROC_TYPE", string3);
                    properties.setProperty("OPMN_PROC_SET", string4);
                    properties.setProperty("OPMN_PROC_INDEX", string5);
                }
            }
        }
        return properties;
    }

    private void configure(Document document, boolean bl) throws LoggingConfigurationException {
        try {
            this.configure(this.getRootElement(document, bl));
        }
        catch (LoggingConfigurationException loggingConfigurationException) {
            this.reset();
            throw loggingConfigurationException;
        }
    }

    private void configure(Element element) throws LoggingConfigurationException {
        Object object;
        Object object2;
        Properties properties = this.getLoggingProperties(element);
        if (properties.size() > 0) {
            try {
                object2 = new ByteArrayOutputStream(1024);
                properties.store((OutputStream)object2, null);
                object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                LogManager.getLogManager().readConfiguration((InputStream)object);
            }
            catch (IOException iOException) {
                throw new LoggingConfigurationException(iOException);
            }
        }
        this.m_handlers = object2 = this.getHandlers(element);
        object = element.getElementsByTagName("loggers");
        if (object.getLength() != 1) {
            throw new LoggingConfigurationException("Expecting one element 'loggers'");
        }
        Element element2 = (Element)object.item(0);
        object = element2.getElementsByTagName("logger");
        for (int i = 0; i < object.getLength(); ++i) {
            Element element3 = (Element)object.item(i);
            String string = element3.getAttribute("name");
            Level level = this.getLevelAttribute(element3);
            boolean bl = false;
            boolean bl2 = false;
            String string2 = element3.getAttribute("useParentHandlers");
            if (string2 != null && string2.length() > 0) {
                bl = true;
                bl2 = string2.equalsIgnoreCase("true");
            }
            String string3 = element3.getAttribute("filter");
            Logger logger = Logger.getLogger(string);
            LoggerState loggerState = new LoggerState();
            this.m_loggers.put(string, loggerState);
            if (level != null) {
                loggerState.m_changedLevel = true;
                loggerState.m_level = logger.getLevel();
                logger.setLevel(level);
            }
            loggerState.m_useParentHandlers = logger.getUseParentHandlers();
            if (bl) {
                logger.setUseParentHandlers(bl2);
            }
            if (string3 != null && string3.length() > 0) {
                loggerState.m_changedFilter = true;
                logger.setFilter((Filter)this.getInstance(string3, class$java$util$logging$Filter == null ? LoggingConfigurationImpl.class$("java.util.logging.Filter") : class$java$util$logging$Filter));
            }
            NodeList nodeList = element3.getElementsByTagName("handler");
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element element4 = (Element)nodeList.item(j);
                String string4 = element4.getAttribute("name");
                Handler handler = (Handler)object2.get(string4);
                if (handler == null) {
                    throw new LoggingConfigurationException("Cannot find handler: " + string4);
                }
                logger.addHandler(handler);
                loggerState.m_handlers.add(handler);
            }
        }
    }

    private Properties getLoggingProperties(Element element) throws LoggingConfigurationException {
        Properties properties = new Properties();
        NodeList nodeList = element.getElementsByTagName("logging_properties");
        if (nodeList.getLength() == 0) {
            return properties;
        }
        Element element2 = (Element)nodeList.item(0);
        nodeList = element2.getElementsByTagName("property");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            String string2 = this.expandProperties(element2.getAttribute("value"));
            properties.setProperty(string, string2);
        }
        return properties;
    }

    private Map getHandlers(Element element) throws LoggingConfigurationException {
        HashMap<String, Handler> hashMap = new HashMap<String, Handler>();
        NodeList nodeList = element.getElementsByTagName("log_handlers");
        if (nodeList.getLength() == 0) {
            return hashMap;
        }
        Properties properties = this.initVarBindings();
        Element element2 = (Element)nodeList.item(0);
        nodeList = element2.getElementsByTagName("log_handler");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            String string2 = element2.getAttribute("class");
            Level level = this.getLevelAttribute(element2);
            String string3 = element2.getAttribute("errorManager");
            String string4 = element2.getAttribute("filter");
            String string5 = element2.getAttribute("formatter");
            String string6 = element2.getAttribute("encoding");
            NodeList nodeList2 = element2.getElementsByTagName("property");
            Properties properties2 = new Properties();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                node = nodeList2.item(j);
                Element element3 = (Element)nodeList2.item(j);
                String string7 = element3.getAttribute("name");
                String string8 = element3.getAttribute("value");
                string8 = this.replaceVars(string8, properties);
                string8 = this.expandProperties(string8);
                if (string7.equals("path")) {
                    string8 = this.resolveRelativePath(string8);
                }
                properties2.put(string7, string8);
            }
            Handler handler = this.getHandler(string2, properties2);
            if (level != null) {
                handler.setLevel(level);
            }
            if (string3 != null && string3.length() > 0) {
                handler.setErrorManager((ErrorManager)this.getInstance(string3, class$java$util$logging$ErrorManager == null ? LoggingConfigurationImpl.class$("java.util.logging.ErrorManager") : class$java$util$logging$ErrorManager));
            }
            if (string4 != null && string4.length() > 0) {
                handler.setFilter((Filter)this.getInstance(string4, class$java$util$logging$Filter == null ? LoggingConfigurationImpl.class$("java.util.logging.Filter") : class$java$util$logging$Filter));
            }
            if (string5 != null && string5.length() > 0) {
                handler.setFormatter((Formatter)this.getInstance(string5, class$java$util$logging$Formatter == null ? LoggingConfigurationImpl.class$("java.util.logging.Formatter") : class$java$util$logging$Formatter));
            }
            if (string6 != null && string6.length() > 0) {
                try {
                    handler.setEncoding(string6);
                }
                catch (Exception exception) {
                    throw new LoggingConfigurationException(exception);
                }
            }
            hashMap.put(string, handler);
        }
        return hashMap;
    }

    private Handler getHandler(String string, Properties properties) throws LoggingConfigurationException {
        Class clazz = this.getClass("oracle.core.ojdl.logging.HandlerFactory");
        Class clazz2 = this.getClass("java.util.logging.Handler");
        Class clazz3 = this.getClass(string);
        if (clazz.isAssignableFrom(clazz3)) {
            try {
                return ((HandlerFactory)clazz3.newInstance()).create(properties);
            }
            catch (Exception exception) {
                throw new LoggingConfigurationException(exception);
            }
        }
        if (clazz2.isAssignableFrom(clazz3)) {
            try {
                return (Handler)clazz3.newInstance();
            }
            catch (Exception exception) {
                throw new LoggingConfigurationException(exception);
            }
        }
        throw new LoggingConfigurationException("Invalid class: " + string);
    }

    private Level getLevelAttribute(Element element) throws LoggingConfigurationException {
        String string = element.getAttribute("level");
        if (string != null && string.length() > 0) {
            try {
                return ODLLevel.parse(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ODLLevel.parse(string.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new LoggingConfigurationException(illegalArgumentException.toString());
                }
            }
        }
        return null;
    }

    private Class getClass(String string) throws LoggingConfigurationException {
        try {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            throw new LoggingConfigurationException("Cannot find class: " + string, exception);
        }
        catch (LinkageError linkageError) {
            throw new LoggingConfigurationException("Cannot load or link class '" + string + "': " + linkageError.toString(), linkageError);
        }
    }

    private Object getInstance(String string, Class clazz) throws LoggingConfigurationException {
        Class clazz2 = this.getClass(string);
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new LoggingConfigurationException("Class '" + string + "' is not of expected type '" + clazz.getName() + "'");
        }
        try {
            return clazz2.newInstance();
        }
        catch (Throwable throwable) {
            throw new LoggingConfigurationException("Cannot create instance of class '" + string + "': " + throwable.toString(), throwable);
        }
    }

    private String resolveRelativePath(String string) {
        File file;
        if (this.m_referenceDir != null && !(file = new File(string)).isAbsolute()) {
            return new File(this.m_referenceDir, string).getPath();
        }
        return string;
    }

    private String expandProperties(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = this.replaceNextVar(string, n, stringBuffer, "${", "}", null)) > 0) {
        }
        return stringBuffer.toString();
    }

    private String replaceVars(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = this.replaceNextVar(string, n, stringBuffer, "%", "%", properties)) > 0) {
        }
        return stringBuffer.toString();
    }

    private int replaceNextVar(String string, int n, StringBuffer stringBuffer, String string2, String string3, Properties properties) {
        int n2 = string.indexOf(string2, n);
        if (n2 < 0) {
            stringBuffer.append(string.substring(n));
            return -1;
        }
        int n3 = string.indexOf(string3, n2 + string2.length());
        if (n3 < 0) {
            stringBuffer.append(string.substring(n));
            return -1;
        }
        stringBuffer.append(string.substring(n, n2));
        String string4 = string.substring(n2 + string2.length(), n3);
        String string5 = null;
        if (properties != null) {
            string5 = properties.getProperty(string4);
        } else if (string4.length() > 0) {
            string5 = System.getProperty(string4);
        }
        if (string5 == null) {
            stringBuffer.append(string.substring(n2, n3 + string3.length()));
        } else {
            stringBuffer.append(string5);
        }
        return n3 + string3.length();
    }

    private Element getRootElement(Document document, boolean bl) throws LoggingConfigurationException {
        if (bl) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("logging_configuration");
            return (Element)nodeList.item(0);
        }
        return document.getDocumentElement();
    }

    private Document parse(String string) throws LoggingConfigurationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(this.getWrapper(string));
        }
        catch (SAXParseException sAXParseException) {
            throw new LoggingConfigurationException("Unable to process file '" + string + "', XML parse exception (line: " + sAXParseException.getLineNumber() + ", column: " + sAXParseException.getColumnNumber() + "): " + sAXParseException.toString(), sAXParseException);
        }
        catch (Exception exception) {
            throw new LoggingConfigurationException("Unable to process file '" + string + "', caught exception: " + exception.toString(), exception);
        }
    }

    private InputSource getWrapper(String string) throws IOException, MalformedURLException, LoggingConfigurationException {
        String string2;
        InputStream inputStream = this.getClass().getResourceAsStream(DTD_PATH);
        if (inputStream == null) {
            throw new LoggingConfigurationException("Unable to find resource /oracle/core/ojdl/logging/logging-config.dtd");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<!DOCTYPE root [ <!ENTITY file SYSTEM \"");
        stringBuffer.append(new File(string).toURL().toString());
        stringBuffer.append("\"> <!ELEMENT root (logging_configuration)>");
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("]> <root>&file;</root>");
        return new InputSource(new StringReader(stringBuffer.toString()));
    }

    private static class LoggerState {
        public boolean m_changedLevel = false;
        public Level m_level = null;
        public boolean m_changedFilter = false;
        public boolean m_useParentHandlers = false;
        public ArrayList m_handlers = new ArrayList();

        private LoggerState() {
        }
    }
}

