/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import oracle.jdbc.OracleResultSet;
import oracle.sqlj.runtime.OraConsts;
import oracle.sqlj.runtime.OraEntryInfo;
import oracle.sqlj.runtime.OraProfile;
import oracle.sqlj.runtime.OraTypeClosure;
import oracle.sqlj.runtime.OraTypeInfo;
import oracle.sqlj.runtime.error.OraCustomizationErrors;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTResultSetWrapper;

public class OraRTResultSet
extends RTResultSetWrapper
implements OraConsts {
    private int[] m_columnMap;
    private EntryInfo m_entry;
    private OraEntryInfo m_oraEntry;
    protected OracleResultSet m_oRs;
    private OraProfile m_profile;
    private int m_numCols;
    private Hashtable m_columnNames = null;
    private int rowidCol = Integer.MAX_VALUE;

    public OraRTResultSet(RTResultSet rTResultSet, OraEntryInfo oraEntryInfo, OraProfile oraProfile) throws SQLException {
        super(rTResultSet);
        int n;
        this.m_profile = oraProfile;
        this.m_oraEntry = oraEntryInfo;
        this.m_entry = oraEntryInfo.getEntryInfo();
        this.m_numCols = rTResultSet.getColumnCount();
        this.m_columnMap = new int[this.m_numCols + 1];
        this.m_oRs = (OracleResultSet)rTResultSet.getJDBCResultSet();
        if (this.m_entry.getResultSetType() == 32) {
            n = this.m_entry.getResultSetCount();
            int n2 = 1;
            while (n2 <= n) {
                int n3 = this.findColumn(this.m_entry.getResultSetInfo(n2).getName());
                this.m_columnMap[n3] = n2++;
            }
        } else {
            for (n = 1; n <= this.m_numCols; ++n) {
                this.m_columnMap[n] = n;
            }
        }
        if (this.m_entry.getResultSetType() == 64) {
            try {
                n = rTResultSet.findColumn("sjT_rowid");
                this.setRowidCol(n);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    OraProfile getOraProfile() {
        return this.m_profile;
    }

    public OracleResultSet getOracleResultSet() {
        return this.m_oRs;
    }

    public int findColumn(String string) throws SQLException {
        Object object;
        string = string.toUpperCase();
        if (this.m_columnNames == null) {
            object = new Hashtable(this.m_numCols * 2, 0.75f);
            ResultSetMetaData resultSetMetaData = this.m_oRs.getMetaData();
            for (int i = this.m_numCols; i > 0; --i) {
                String string2 = resultSetMetaData.getColumnName(i).toUpperCase();
                ((Hashtable)object).put((String)string2, (Integer)new Integer(i));
            }
            this.m_columnNames = object;
        }
        if ((object = this.m_columnNames.get(string)) != null) {
            return (Integer)object;
        }
        OraCustomizationErrors.raise_INVALID_COLUMN_NAME(string);
        return -1;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (n > this.getRowidCol()) {
            ++n;
        }
        return this.m_oRs.getBigDecimal(n, 0);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        OraTypeInfo oraTypeInfo = this.getResultSetInfo(n);
        OraTypeClosure oraTypeClosure = this.m_profile.getTypeClosure(oraTypeInfo);
        if (n > this.getRowidCol()) {
            ++n;
        }
        return oraTypeClosure.getObject(this, n, clazz, oraTypeInfo);
    }

    public OraTypeInfo getResultSetInfo(int n) {
        return this.m_oraEntry.getResultSetInfo(this.m_columnMap[n]);
    }

    public AsciiStream getAsciiStreamWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getAsciiStreamWrapper(n);
    }

    public BinaryStream getBinaryStreamWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getBinaryStreamWrapper(n);
    }

    public Blob getBlob(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getBlob(n);
    }

    public boolean getBooleanNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getBooleanNoNull(n);
    }

    public Boolean getBooleanWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getBooleanWrapper(n);
    }

    public byte getByteNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getByteNoNull(n);
    }

    public Byte getByteWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getByteWrapper(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getBytes(n);
    }

    public Clob getClob(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getClob(n);
    }

    public int getColumnCount() throws SQLException {
        if (this.getRowidCol() < Integer.MAX_VALUE) {
            return this.rs.getColumnCount() - 1;
        }
        return this.rs.getColumnCount();
    }

    public Date getDate(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getDate(n);
    }

    public double getDoubleNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getDoubleNoNull(n);
    }

    public Double getDoubleWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getDoubleWrapper(n);
    }

    public float getFloatNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getFloatNoNull(n);
    }

    public Float getFloatWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getFloatWrapper(n);
    }

    public int getIntNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getIntNoNull(n);
    }

    public Integer getIntWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getIntWrapper(n);
    }

    public long getLongNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getLongNoNull(n);
    }

    public Long getLongWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getLongWrapper(n);
    }

    public Ref getRef(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getRef(n);
    }

    public short getShortNoNull(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getShortNoNull(n);
    }

    public Short getShortWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getShortWrapper(n);
    }

    public String getString(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getString(n);
    }

    public Time getTime(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getTimestamp(n);
    }

    public UnicodeStream getUnicodeStreamWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getUnicodeStreamWrapper(n);
    }

    protected void setRowidCol(int n) {
        this.rowidCol = n;
    }

    protected int getRowidCol() {
        return this.rowidCol;
    }

    public CharacterStream getCharacterStreamWrapper(int n) throws SQLException {
        if (n >= this.getRowidCol()) {
            ++n;
        }
        return this.rs.getCharacterStreamWrapper(n);
    }
}

