/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import oracle.core.ojdl.LogMessage;
import oracle.dms.address.OHSBase64Encoder;
import oracle.dms.instrument.DMSFileUtil;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDumpListener;
import oracle.dms.instrument.State;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.TransTraceIntf;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;

public class TransTrace
implements TransTraceIntf,
NounDumpListener {
    private static boolean s_dollarStrippingEnabled = true;
    private static boolean s_dumpEnabled = false;
    private static boolean s_debugEnabled = false;
    private static boolean s_transTraceEnabled = false;
    private static boolean s_ecidEnabled = true;
    private static int s_maxdumps;
    private static int s_maxrecords;
    private static int s_maxtraces;
    private static int s_maxaggregates;
    private static int s_dumpinterval;
    private static String s_dumpdestination;
    private static String s_debugdestination;
    private static Cookie s_cookie;
    private static String s_cookieString;
    private static String s_portStr;
    static String NOUN_PATHNAME;

    public void init(String string, String string2) {
        StringBuffer stringBuffer;
        Object object;
        int n;
        String string3 = "oracle.dms";
        String string4 = string3 + ".transtrace";
        String string5 = string4 + ".enabled";
        String string6 = string4 + ".ecidenabled";
        String string7 = string4 + ".dumpenabled";
        String string8 = string4 + ".debugenabled";
        String string9 = string4 + ".maxrecords";
        String string10 = string4 + ".maxtraces";
        String string11 = string4 + ".maxaggregates";
        String string12 = string4 + ".maxdumps";
        String string13 = string4 + ".dollarstrippingenabled";
        String string14 = string4 + ".dumpdestination";
        String string15 = string4 + ".debugdestination";
        String string16 = string4 + ".dumpinterval";
        String string17 = string4 + ".dumpdetail";
        String string18 = DMSProperties.getProperty(string5);
        if (string18 != null && string18.equalsIgnoreCase("true")) {
            s_transTraceEnabled = true;
            s_dumpEnabled = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("oracle.jdbc.DMSStatementMetrics", "true");
                    return null;
                }
            });
            System.err.println("NOTIFICATION: " + string5 + "=" + string18);
        }
        if (s_transTraceEnabled) {
            s_ecidEnabled = true;
        } else {
            string18 = DMSProperties.getProperty(string6);
            if (string18 != null) {
                s_ecidEnabled = !string18.equalsIgnoreCase("false");
            }
        }
        string18 = DMSProperties.getProperty(string7);
        if (string18 != null) {
            s_dumpEnabled = !string18.equalsIgnoreCase("false");
        }
        if ((string18 = DMSProperties.getProperty(string8)) != null) {
            s_debugEnabled = !string18.equalsIgnoreCase("false");
        }
        if ((string18 = DMSProperties.getProperty(string16)) != null) {
            try {
                n = Integer.parseInt(string18);
                if (n >= 1) {
                    s_dumpinterval = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string18 = DMSProperties.getProperty(string12)) != null) {
            try {
                n = Integer.parseInt(string18);
                if (n > 0) {
                    s_maxdumps = n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string18 = DMSProperties.getProperty(string9)) != null) {
            try {
                int n2 = Integer.parseInt(string18);
                if (n2 >= 1) {
                    s_maxrecords = n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string18 = DMSProperties.getProperty(string10)) != null) {
            try {
                int n3 = Integer.parseInt(string18);
                if (n3 >= 1) {
                    s_maxtraces = n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string18 = DMSProperties.getProperty(string11)) != null) {
            try {
                int n4 = Integer.parseInt(string18);
                if (n4 >= 1) {
                    s_maxaggregates = n4;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string18 = DMSProperties.getProperty(string14)) != null) {
            s_dumpdestination = string18;
        }
        if ((string18 = DMSProperties.getProperty(string15)) != null) {
            s_debugdestination = string18;
        }
        if ((string18 = DMSProperties.getProperty(string13)) != null && string18.equalsIgnoreCase("false")) {
            s_dollarStrippingEnabled = false;
        }
        if (s_dumpEnabled) {
            File file;
            if (s_dumpdestination != null) {
                file = new File(s_dumpdestination);
                DMSFileUtil.mkdirs(file);
            } else {
                object = DMSProperties.getProperty("oracle.home");
                if (object == null) {
                    object = ".";
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append((String)object);
                stringBuffer.append(File.separator);
                stringBuffer.append("diagnostics");
                file = new File(stringBuffer.toString());
                DMSFileUtil.mkdir(file);
                stringBuffer.append(File.separator);
                stringBuffer.append("transtrace");
                file = new File(stringBuffer.toString());
                DMSFileUtil.mkdir(file);
                s_dumpdestination = stringBuffer.toString();
            }
            if (string != null) {
                s_dumpdestination = s_dumpdestination + File.separator + string;
                file = new File(s_dumpdestination);
                DMSFileUtil.mkdir(file);
            }
        }
        if (s_debugEnabled) {
            File file;
            if (s_debugdestination != null) {
                file = new File(s_debugdestination);
                DMSFileUtil.mkdir(file);
            } else {
                object = DMSProperties.getProperty("oracle.home");
                if (object == null) {
                    object = ".";
                }
                stringBuffer = new StringBuffer();
                stringBuffer.append((String)object);
                stringBuffer.append(File.separator);
                stringBuffer.append("diagnostics");
                file = new File(stringBuffer.toString());
                DMSFileUtil.mkdir(file);
                stringBuffer.append(File.separator);
                stringBuffer.append("transtrace");
                file = new File(stringBuffer.toString());
                DMSFileUtil.mkdir(file);
                stringBuffer.append(File.separator);
                stringBuffer.append("debug");
                file = new File(stringBuffer.toString());
                DMSFileUtil.mkdir(file);
                s_debugdestination = stringBuffer.toString();
            }
            if (string != null) {
                s_debugdestination = s_debugdestination + File.separator + string;
                file = new File(s_debugdestination);
                DMSFileUtil.mkdir(file);
            }
        }
        s_portStr = string2;
        if (s_dumpEnabled) {
            try {
                object = Noun.create(NOUN_PATHNAME, "n/a");
                string18 = DMSProperties.getProperty(string17);
                if (string18 != null && string18.equalsIgnoreCase("full")) {
                    object = Noun.getRoot();
                }
                ((Noun)object).enableDumping(s_dumpinterval, s_dumpdestination, s_maxdumps, this);
            }
            catch (Exception exception) {
                TransTrace.debug("WARNING: DMS exception ignored initializing aggregate dumping: " + exception);
                exception.printStackTrace();
            }
        }
        TransTrace.recordConfigParams();
    }

    private static void initRoutingCookie() {
        if (s_cookie == null) {
            String string = DMSUtil.getLocalHostname();
            int n = 0;
            try {
                n = Integer.parseInt(s_portStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            State state = (State)State.get("/oc4j/opmnInfo/vmId");
            String string2 = null;
            if (state == null) {
                return;
            }
            string2 = (String)state.getValue();
            String string3 = OHSBase64Encoder.createCookie(string, n, string2);
            s_cookie = new Cookie("fake-JSESSIONID", string3);
            s_cookieString = "fake-JSESSIONID=" + string3;
            s_cookie.setPath("/");
        }
    }

    public boolean isEnabled() {
        return s_transTraceEnabled;
    }

    public static boolean _isEnabled() {
        return s_transTraceEnabled;
    }

    public boolean isEcidEnabled() {
        return s_ecidEnabled;
    }

    public static boolean _isEcidEnabled() {
        return s_ecidEnabled;
    }

    public boolean isDumpEnabled() {
        return s_dumpEnabled;
    }

    public static boolean _isDumpEnabled() {
        return s_dumpEnabled;
    }

    public static boolean _isDebugEnabled() {
        return s_debugEnabled;
    }

    public static String _getDebugDestination() {
        return s_debugdestination;
    }

    public static boolean _isDollarStrippingEnabled() {
        return s_dollarStrippingEnabled;
    }

    public int getMaxRecords() {
        return s_maxrecords;
    }

    public static int _getMaxRecords() {
        return s_maxrecords;
    }

    public static int getMaxTraces() {
        return s_maxtraces;
    }

    public static int _getMaxTraces() {
        return s_maxtraces;
    }

    public static int getMaxAggregates() {
        return s_maxaggregates;
    }

    public static int _getMaxAggregates() {
        return s_maxaggregates;
    }

    public void servletRequestStart(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (!s_ecidEnabled) {
            return;
        }
        try {
            String string;
            Cookie cookie;
            String string2;
            String string3;
            Object object;
            LogMessage.InstanceId instanceId = null;
            Cookie[] cookieArray = null;
            String string4 = null;
            String string5 = null;
            ExecutionContext executionContext = ExecutionContext.get();
            string4 = httpServletRequest.getHeader("Oracle-ECID");
            String string6 = null;
            if (string4 != null) {
                string5 = string4;
            } else {
                cookieArray = httpServletRequest.getCookies();
                if (cookieArray != null) {
                    for (int i = 0; i < cookieArray.length; ++i) {
                        object = cookieArray[i];
                        string3 = object.getName();
                        if (!string3.equals("Oracle-ECID")) continue;
                        string5 = string6 = object.getValue();
                        break;
                    }
                }
            }
            if (string5 != null) {
                instanceId = ExecutionContext.parseECID(string5);
            }
            if (instanceId != null) {
                executionContext.setECID(instanceId);
                executionContext.incrementECIDSequenceNumber();
            } else {
                instanceId = executionContext.getECID();
            }
            if (!s_transTraceEnabled) {
                return;
            }
            if (string5 == null) {
                string5 = executionContext.getECIDasString();
            }
            if (string5 != null && string6 == null) {
                Cookie cookie2 = new Cookie("Oracle-ECID", string5);
                cookie2.setPath("/");
                httpServletResponse.addCookie(cookie2);
            }
            if ((string2 = httpServletRequest.getRemoteUser()) != null) {
                executionContext.setAttribute("ClientID", string2);
            }
            if (executionContext.getAttributeMap().get("URI") == null) {
                object = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
                if (object != null && (string3 = httpServletRequest.getQueryString()) != null) {
                    ((StringBuffer)object).append("?");
                    ((StringBuffer)object).append(string3);
                }
                string3 = ((StringBuffer)object).toString();
                executionContext.getAttributeMap().put("URI", string3);
            }
            object = null;
            string3 = null;
            Object object2 = null;
            object = httpServletRequest.getHeader("Oracle-TraceTrigger");
            if (object != null) {
                object2 = object;
            } else {
                if (cookieArray != null || (cookieArray = httpServletRequest.getCookies()) != null) {
                    for (int i = 0; i < cookieArray.length; ++i) {
                        cookie = cookieArray[i];
                        String string7 = cookie.getName();
                        if (!string7.equals("Oracle-TraceTrigger")) continue;
                        string3 = cookie.getValue();
                        break;
                    }
                }
                if (string3 != null) {
                    object2 = string3;
                }
            }
            if (object2 != null) {
                Tracer tracer = executionContext.getTracer();
                tracer.setTriggered(true);
                if (!(object == null || string3 != null && ((String)object).equals(string3))) {
                    cookie = new Cookie("Oracle-TraceTrigger", (String)object);
                    cookie.setPath("/");
                    httpServletResponse.addCookie(cookie);
                }
                httpServletResponse.addCookie(this.getRoutingCookie());
            }
            if ((string = httpServletRequest.getHeader("Oracle-TraceContext")) != null) {
                executionContext.getAttributeMap().put("Oracle-TraceContext", string);
            }
        }
        catch (Exception exception) {
            TransTrace.debug("WARNING: DMS TransTrace caught (and ignored) exception: " + exception);
            exception.printStackTrace();
        }
    }

    private static void debug(String string) {
        System.err.println(string);
    }

    public void servletRequestStop(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
    }

    public void requestStart() {
        ExecutionContext executionContext = ExecutionContext.get();
        if (!s_transTraceEnabled) {
            return;
        }
        Tracer tracer = executionContext.getTracer();
        tracer.beginRequest();
    }

    public void requestStop() {
        if (!s_ecidEnabled) {
            return;
        }
        ExecutionContext executionContext = ExecutionContext.get();
        if (s_transTraceEnabled) {
            Tracer tracer = executionContext.getTracer();
            tracer.endRequest();
        }
        executionContext.reset();
    }

    public Cookie getRoutingCookie() {
        return TransTrace._getRoutingCookie();
    }

    public static Cookie _getRoutingCookie() {
        TransTrace.initRoutingCookie();
        return s_cookie;
    }

    public void preNounDump(Noun noun) {
    }

    public void postNounDump(Noun noun) {
        Noun noun2 = Noun.get(NOUN_PATHNAME);
        if (noun2 != null) {
            noun2.invalidateSubtree();
        }
    }

    private static void recordConfigParams() {
        Noun noun = Noun.create("/DMS-Internal/transtrace", "transtrace info");
        State.create(noun, "s_transTraceEnabled", "", "indicates whether transtrace feature is enabled", (Object)(s_transTraceEnabled ? "true" : "false"));
        State.create(noun, "s_ecidEnabled", "", "indicates whether ECID feature is enabled", (Object)(s_ecidEnabled ? "true" : "false"));
        if (s_transTraceEnabled) {
            State.create(noun, "s_maxrecords", "trace records", "max records allowed per trace", s_maxrecords);
            State.create(noun, "s_maxtraces", "traces", "max traces allowed in memory", s_maxtraces);
            State.create(noun, "s_dollarStrippingEnabled", "", "if true then URIs will be stripped after dollar $ char", (Object)(s_dollarStrippingEnabled ? "true" : "false"));
        }
        State.create(noun, "s_dumpEnabled", "", "true if aggregate dumping enabled", (Object)(s_dumpEnabled ? "true" : "false"));
        if (s_dumpEnabled) {
            State.create(noun, "s_dumpdestination", "", "destination for aggregate dumps", (Object)s_dumpdestination);
            State.create(noun, "s_maxdumps", "dumps", "max dumps allowed on disk", s_maxdumps);
            State.create(noun, "s_maxaggregates", "URIs", "max URIs allowed in memory", s_maxaggregates);
            State.create(noun, "s_dumpinterval", "secs", "time delay between dumps", s_dumpinterval);
        }
        State.create(noun, "s_debugEnabled", "", "true if transtrace debugging enabled", (Object)(s_debugEnabled ? "true" : "false"));
        if (s_debugEnabled) {
            State.create(noun, "s_debugdestination", "", "destination for debug info", (Object)s_debugdestination);
        }
    }

    static synchronized void shutdown() {
        s_dollarStrippingEnabled = true;
        s_dumpEnabled = false;
        s_debugEnabled = false;
        s_transTraceEnabled = false;
        s_ecidEnabled = true;
        s_maxdumps = 8;
        s_maxrecords = 5000;
        s_maxtraces = 5;
        s_maxaggregates = 500;
        s_dumpinterval = 900;
        s_dumpdestination = null;
        s_cookie = null;
        s_cookieString = null;
        s_portStr = null;
        NOUN_PATHNAME = "/oc4j/URIs";
    }

    static {
        String string = DMSProperties.getProperty("oracle.dms.transtrace.ecidenabled");
        if (string != null && string.equalsIgnoreCase("false")) {
            s_ecidEnabled = false;
        }
        s_maxdumps = 8;
        s_maxrecords = 5000;
        s_maxtraces = 5;
        s_maxaggregates = 500;
        s_dumpinterval = 900;
        s_dumpdestination = null;
        s_debugdestination = null;
        s_cookie = null;
        s_cookieString = null;
        s_portStr = null;
        NOUN_PATHNAME = "/oc4j/URIs";
    }
}

