/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.clock;

import java.io.PrintStream;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockDescription;
import oracle.dms.clock.SimpleClockDescription;
import oracle.dms.clock.SimpleTimestamp;
import oracle.dms.clock.Timestamp;

public class SimpleClock
implements Clock {
    protected String _name;
    protected ClockDescription _desc;
    protected String _units;
    protected long _maxFrequency;
    protected long _reportedFrequency;
    protected long _lastTime = 0L;

    public SimpleClock() {
        this._name = "default";
        this._desc = new SimpleClockDescription();
        this._reportedFrequency = 1000L;
        this._maxFrequency = 1000L;
        this._units = "msecs";
        this.start();
    }

    SimpleClock(String string) {
        this._name = string;
    }

    final void start() {
        this._desc.discover(this);
        this.reset();
    }

    public void reset() {
    }

    public long getTime() {
        long l = System.currentTimeMillis();
        if (l > this._lastTime) {
            this._lastTime = l;
        }
        return this._lastTime;
    }

    public Timestamp getTimestamp() {
        return new SimpleTimestamp(this.getTime(), this);
    }

    public String toString() {
        return this.getTimestamp().toString();
    }

    public long convertTime(long l, long l2) {
        if (l2 > this._reportedFrequency) {
            long l3 = l2 / this._reportedFrequency;
            return l * l3;
        }
        if (l2 < this._reportedFrequency) {
            long l4 = this._reportedFrequency / l2;
            return l / l4;
        }
        return l;
    }

    public ClockDescription getDescription() {
        return this._desc;
    }

    public String getName() {
        return this._name;
    }

    public String getUnits() {
        return this._units;
    }

    public long getReportedFrequency() {
        return this._reportedFrequency;
    }

    public long getMaxFrequency() {
        return this._maxFrequency;
    }

    public long getMeasuredFrequency() {
        return this._desc.getMeasuredFrequency();
    }

    public double getOverhead() {
        return this._desc.getOverhead();
    }

    public void print(PrintStream printStream) {
        printStream.println("Clock: " + this._name);
        printStream.println("    units: " + this.getUnits());
        printStream.println("    reportedFrequency: " + this.getReportedFrequency() + " ticks per second");
        printStream.println("    maxFrequency: " + this.getMaxFrequency() + " ticks per second");
        printStream.println("    measuredFrequency: " + this.getMeasuredFrequency() + " ticks per second");
        printStream.println("    measuredResolution: " + this._desc.getResolution() + " " + this.getUnits() + " is the minimum nonzero time between calls");
        printStream.println("    overhead per call: " + this.getOverhead() + " " + this.getUnits());
    }
}

