<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" 
  xmlns:java="http://xml.apache.org/xslt/java" 
  exclude-result-prefixes="java" extension-element-prefixes="barcode" 
  xmlns:cal="xalan://java.util.GregorianCalendar"> 
  
  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <xsl:decimal-format decimal-separator="," grouping-separator="."/>

  <!-- Variaveis de ambiente de execucao -->
  <xsl:param name="PATH_IMAGENS" select="'imagens/'"/>
  <xsl:param name="PATH_REMESSA" select="'remessa/'"/>
  <xsl:param name="debug" select="'off'"/><!-- on OU off -->
  <xsl:param name="ocultar" select="'off'"/><!-- on OU off -->
  <xsl:param name="excluir" select="'off'"/><!-- on OU off -->

  <!-- ######### Styles para os textos do documento ######### -->
  <xsl:attribute-set name="bordas"> 
	  <xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
	  <xsl:attribute name="border-after-style">solid</xsl:attribute>
	  <xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
	  <xsl:attribute name="border-before-style">solid</xsl:attribute>
	  <xsl:attribute name="border-left-width">0pt</xsl:attribute>
	  <xsl:attribute name="border-left-style">solid</xsl:attribute>
	  <xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
	  <xsl:attribute name="border-right-style">solid</xsl:attribute>
	  <!-- <xsl:attribute name="border-after-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-after-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-before-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-before-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-left-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-left-style">solid</xsl:attribute> 
  	  <xsl:attribute name="border-right-width">1pt</xsl:attribute> 
  	  <xsl:attribute name="border-right-style">solid</xsl:attribute>--> 
  </xsl:attribute-set>
    
	<xsl:attribute-set name="bordasUltColuna">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>
    
  <xsl:attribute-set name="cabecalhoLeftCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRightCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoLeft">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRight">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinza">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinzaEscuro">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegrito">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoLeft">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoBig">
	<xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoItalico">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="total">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="totalLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

 <xsl:attribute-set name="cabecalho">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoCenter">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeftShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeftShort2">
    <xsl:attribute name="font-size">7.2pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBigCur">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenter">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenterBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRight">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRightShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRightBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="linhaTotal">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="border-top-style">solid</xsl:attribute>
	<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtQuadroTce">
    <xsl:attribute name="font-size">7.0pt</xsl:attribute>
    <xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
    <xsl:attribute name="space-before">0pt</xsl:attribute>
    <xsl:attribute name="space-after">0pt</xsl:attribute>
    <xsl:attribute name="padding-top">1pt</xsl:attribute>
    <xsl:attribute name="padding-bottom">1pt</xsl:attribute>
  </xsl:attribute-set>
  

	<!-- ### variaveis globais ### -->

	<xsl:variable name="diaMesFinal">
		<xsl:choose>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 1">31</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 2">
				<xsl:choose>
					<xsl:when test="(rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29</xsl:when>
					<xsl:otherwise>28</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 3">31</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 4">30</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 5">31</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 6">30</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 7">31</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 8">31</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 9">30</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 10">31</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 11">30</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 12">31</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="tipoRelatorio">
		<xsl:value-of select="rve/Cabecalho/CabecalhoRow/TP_RELATORIO"/>
	</xsl:variable>

	<xsl:variable name="periodoFinal">
		<xsl:choose>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES != ''"><xsl:value-of select="$diaMesFinal"/>/<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES &lt; 10">0</xsl:if><xsl:value-of select="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES"/>/</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
				<xsl:if test="(rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
				<xsl:if test="(rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
			</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:when>
			<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:when>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="periodoFinalCabecalho">
		<xsl:choose>
			<xsl:when test="$tipoRelatorio = 'RVE_LIGHT'"><xsl:value-of select="substring(rve/Cabecalho/CabecalhoRow/DT_FINAL_COMPL, 9, 2)"/>/<xsl:value-of select="substring(rve/Cabecalho/CabecalhoRow/DT_FINAL_COMPL, 6, 2)"/>/</xsl:when>
			<xsl:otherwise> 
				<xsl:value-of select="$periodoFinal"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="mesInformacaoEhPar" select="(rve/Cabecalho/CabecalhoRow/MES_INFORMACOES mod 2) = 0"/>

	<xsl:variable name="ehEntregaLrf" select="(
			(rve/IdentificacaoAdministrador/IdentificacaoAdministradorRow/TP_ENTREGA='Q' and
				(rve/Cabecalho/CabecalhoRow/MES_INFORMACOES=4 or
					rve/Cabecalho/CabecalhoRow/MES_INFORMACOES=8 or
					rve/Cabecalho/CabecalhoRow/MES_INFORMACOES=12 ))
			or
			(rve/IdentificacaoAdministrador/IdentificacaoAdministradorRow/TP_ENTREGA='S' and
				(rve/Cabecalho/CabecalhoRow/MES_INFORMACOES=6 or
					rve/Cabecalho/CabecalhoRow/MES_INFORMACOES=12 ))
			)"/>

	<xsl:variable name="bimestre">
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES"/>
	</xsl:variable>

	<xsl:variable name="anoAtual">
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	</xsl:variable>

	<xsl:variable name="anoAnterior">
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/>
	</xsl:variable>

	<xsl:variable name="mesNome">
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 1">Janeiro</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 2">Fevereiro</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 3">Mar&#231;o</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 4">Abril</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 5">Maio</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 6">Junho</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 7">Julho</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 8">Agosto</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 9">Setembro</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 10">Outubro</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 11">Novembro</xsl:if>
		<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 12">Dezembro</xsl:if>
	</xsl:variable>

	<xsl:variable name="mesInformacoes">
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/MES_INFORMACOES"/>
	</xsl:variable>
	<!--
	<xsl:variable name="bimestre">
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES"/>
	</xsl:variable>
	-->
	<xsl:variable name="anoAtual">
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	</xsl:variable>
	<xsl:variable name="isFechamentoDeExercicio" select="$mesInformacoes = 12"/>

	<!-- ### /variaveis globais ### -->

<!--
#############################################
TEMPLATES GENERICOS
#############################################
-->

<xsl:template name="TabelaLinhasGenerica">
	<xsl:param name="contasList"/>

	<xsl:for-each select="$contasList[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
		<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">
			<xsl:choose>
				<xsl:when test="CD_CONTA_FULL != ''">
					<xsl:value-of select="CD_CONTA_FULL"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="CD_CONTA"/>
				</xsl:otherwise>
			</xsl:choose>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-left="5pt">
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="DS_CONTA"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		</fo:table-row>
	</xsl:for-each>
</xsl:template>

<xsl:template name="TabelaGenerica">
	<xsl:param name="labelTitulo" select="''"/>
	<xsl:param name="labelDebug" select="''"/>
	<xsl:param name="labelCodigo" select="'C&#243;d. Conta'"/>
	<!--
	<xsl:param name="labelCodigo" select="'C&#243;digo'"/>
	-->
	<xsl:param name="labelDescricao" select="'Descri&#231;&#227;o'"/>
	<xsl:param name="labelValor1" select="'Valor Cont&#225;bil'"/>
	<xsl:param name="labelValor2" select="'Adi&#231;&#227;o/Exclus&#227;o'"/>
	<xsl:param name="labelValor3" select="'Valor Ajustado'"/>

	<xsl:param name="labelSubtotal" select="'SUBTOTAL'"/>
	<xsl:param name="contasList"/>
	<xsl:param name="contasListSubtotal" select="$contasList"/>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<xsl:if test="$labelTitulo != ''">
		<fo:block xsl:use-attribute-sets="totalLeft">
			<xsl:value-of select="$labelTitulo"/>
			<xsl:if test="$debug = 'on' and $labelDebug != ''">
				<fo:inline color="red">
					<xsl:value-of select="$labelDebug"/>
				</fo:inline>
			</xsl:if>
		</fo:block>
	</xsl:if>
	<xsl:if test="$labelTitulo = '' and $debug = 'on' and $labelDebug != ''">
		<fo:block xsl:use-attribute-sets="totalLeft" color="red">
			<xsl:value-of select="$labelDebug"/>
		</fo:block>
	</xsl:if>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="110pt"/>
		<fo:table-column column-number="2" column-width="212pt"/>
		<fo:table-column column-number="3" column-width="78pt"/>
		<fo:table-column column-number="4" column-width="78pt"/>
		<fo:table-column column-number="5" column-width="78pt"/>

		<fo:table-header>
			<fo:table-row>
			<xsl:choose>
			<xsl:when test="$labelCodigo != ''">
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold"><xsl:value-of select="$labelCodigo" /> </fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold"><xsl:value-of select="$labelDescricao" /> </fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold"><xsl:value-of select="$labelDescricao" /> </fo:block>
				</fo:table-cell>
			</xsl:otherwise>
			</xsl:choose>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold"><xsl:value-of select="$labelValor1" /> </fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold"><xsl:value-of select="$labelValor2" /> </fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold"><xsl:value-of select="$labelValor3" /> </fo:block>
			</fo:table-cell>
			</fo:table-row>
		</fo:table-header>

		<fo:table-body>
			<xsl:for-each select="$contasList">
			<!--
			<xsl:for-each select="$contasList[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
			-->
				<fo:table-row>
				<xsl:choose>
				<xsl:when test="$labelCodigo != ''">
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft">
							<xsl:value-of select="CD_CONTA"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell padding-left="5pt">
						<fo:block xsl:use-attribute-sets="txtLeft">
							<xsl:value-of select="DS_CONTA"/>
						</fo:block>
					</fo:table-cell>
				</xsl:when>
				<xsl:otherwise>
					<fo:table-cell number-columns-spanned="2" padding-left="5pt">
						<fo:block xsl:use-attribute-sets="txtLeft">
							<xsl:value-of select="DS_CONTA"/>
						</fo:block>
					</fo:table-cell>
				</xsl:otherwise>
				</xsl:choose>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor1 != ''">
							<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor2 != ''">
							<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor3 != ''">
							<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>

			<xsl:if test="$labelSubtotal != ''">
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="totalLeft"><xsl:value-of select="$labelSubtotal" /></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total">
						<xsl:if test="$labelValor1 != ''">
							<xsl:value-of select="format-number(sum($contasListSubtotal/VLR_CONTABIL), '###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total">
						<xsl:if test="$labelValor2 != ''">
							<xsl:value-of select="format-number(sum($contasListSubtotal/VLR_AJUSTE), '###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total">
						<xsl:if test="$labelValor3 != ''">
							<xsl:value-of select="format-number(sum($contasListSubtotal/VLR_AJUSTADO), '###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			</xsl:if>

		</fo:table-body>

	</fo:table>

</xsl:template>

<xsl:template name="TabelaGenericaAutoManual">
	<xsl:param name="labelTitulo" select="''"/>
	<xsl:param name="labelDebug" select="''"/>
	<xsl:param name="labelCodigo" select="'C&#243;d. Conta'"/>
	<!--
	<xsl:param name="labelCodigo" select="'C&#243;digo'"/>
	-->
	<xsl:param name="labelDescricao" select="'Descri&#231;&#227;o'"/>
	<xsl:param name="labelValor1" select="'Valor Cont&#225;bil'"/>
	<xsl:param name="labelValor2" select="'Adi&#231;&#227;o/Exclus&#227;o'"/>
	<xsl:param name="labelValor3" select="'Valor Ajustado'"/>

	<xsl:param name="labelSubtotal" select="'SUBTOTAL'"/>
	<xsl:param name="contasList"/>
	<xsl:param name="contasListSubtotal" select="$contasList"/>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<xsl:if test="$labelTitulo != ''">
		<fo:block xsl:use-attribute-sets="totalLeft">
			<xsl:value-of select="$labelTitulo"/>
			<xsl:if test="$debug = 'on' and $labelDebug != ''">
				<fo:inline color="red">
					<xsl:value-of select="$labelDebug"/>
				</fo:inline>
			</xsl:if>
		</fo:block>
	</xsl:if>
	<xsl:if test="$labelTitulo = '' and $debug = 'on' and $labelDebug != ''">
		<fo:block xsl:use-attribute-sets="totalLeft" color="red">
			<xsl:value-of select="$labelDebug"/>
		</fo:block>
	</xsl:if>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="100pt"/>
		<fo:table-column column-number="2" column-width="222pt"/>
		<fo:table-column column-number="3" column-width="78pt"/>
		<fo:table-column column-number="4" column-width="78pt"/>
		<fo:table-column column-number="5" column-width="78pt"/>

		<fo:table-header>
			<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold"><xsl:value-of select="$labelCodigo" /> </fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold"><xsl:value-of select="$labelDescricao" /> </fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold"><xsl:value-of select="$labelValor1" /> </fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold"><xsl:value-of select="$labelValor2" /> </fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold"><xsl:value-of select="$labelValor3" /> </fo:block>
			</fo:table-cell>
			</fo:table-row>
		</fo:table-header>

		<fo:table-body>
			<xsl:if test="count($contasList[AUTOMATICA='S']) &gt; 0">
				<fo:table-row>
					<fo:table-cell number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="txtLeft">SELEO AUTOMTICA</fo:block>
					</fo:table-cell>
					<fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
					<fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
					<fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
				</fo:table-row>
			</xsl:if>
			<xsl:for-each select="$contasList[AUTOMATICA='S']">
			<!--
			<xsl:for-each select="$contasList[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
			-->
				<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtLeft">
						<xsl:value-of select="CD_CONTA"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell padding-left="5pt">
					<fo:block xsl:use-attribute-sets="txtLeft">
						<xsl:value-of select="DS_CONTA"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor1 != ''">
							<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor2 != ''">
							<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
			<xsl:if test="count($contasList[AUTOMATICA='N']) &gt; 0">
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="txtLeft">SELEO MANUAL</fo:block>
				</fo:table-cell>
				<fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
				<fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
				<fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
			</fo:table-row>
			</xsl:if>
			<xsl:for-each select="$contasList[AUTOMATICA='N']">
			<!--
			<xsl:for-each select="$contasList[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
			-->
				<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtLeft">
						<xsl:value-of select="CD_CONTA"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell padding-left="5pt">
					<fo:block xsl:use-attribute-sets="txtLeft">
						<xsl:value-of select="DS_CONTA"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor1 != ''">
							<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:if test="$labelValor2 != ''">
							<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>

			<xsl:if test="$labelSubtotal != ''">
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="totalLeft"><xsl:value-of select="$labelSubtotal" /></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total">
						<xsl:if test="$labelValor1 != ''">
							<xsl:value-of select="format-number(sum($contasListSubtotal/VLR_CONTABIL), '###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total">
						<xsl:if test="$labelValor2 != ''">
							<xsl:value-of select="format-number(sum($contasListSubtotal/VLR_AJUSTE), '###.###.##0,00')"/>
						</xsl:if>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum($contasListSubtotal/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
				</fo:table-cell>
			</fo:table-row>
			</xsl:if>

		</fo:table-body>

	</fo:table>

</xsl:template>

<xsl:template name="TabelaGenerica1Linha">
	<xsl:param name="cdConta" select="''"/>
	<xsl:param name="dsConta" select="''"/>
	<xsl:param name="vlrContabil" select="0"/>
	<xsl:param name="vlrAjuste" select="0"/>
	<xsl:param name="vlrAjustado" select="$vlrContabil + $vlrAjuste"/>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="100pt"/>
		<fo:table-column column-number="2" column-width="222pt"/>
		<fo:table-column column-number="3" column-width="78pt"/>
		<fo:table-column column-number="4" column-width="78pt"/>
		<fo:table-column column-number="5" column-width="78pt"/>
		
		<!--
		<fo:table-header>
			<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Conta </fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-header>
		-->
		
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$cdConta"/></fo:block>
				</fo:table-cell>
				<fo:table-cell padding-left="5pt">
					<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$dsConta"/></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number($vlrContabil,'###.###.##0,00')"/></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number($vlrAjuste,'###.###.##0,00')"/></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number($vlrAjustado,'###.###.##0,00')"/></fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
	</fo:table>
</xsl:template>

<xsl:template name="TabelaGenerica1LinhaTotal">
	<xsl:param name="dsTotal" select="''"/>
	<xsl:param name="vlrContabil" select="''"/>
	<xsl:param name="vlrAjuste" select="''"/>
	<xsl:param name="vlrTotal" select="0"/>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="100pt"/>
		<fo:table-column column-number="2" column-width="222pt"/>
		<fo:table-column column-number="3" column-width="78pt"/>
		<fo:table-column column-number="4" column-width="78pt"/>
		<fo:table-column column-number="5" column-width="78pt"/>
		
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="totalLeft"><xsl:value-of select="$dsTotal"/></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<xsl:if test="$vlrContabil != ''">
						<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($vlrContabil,'###.###.##0,00')"/></fo:block>
					</xsl:if>
				</fo:table-cell>
				<fo:table-cell>
					<xsl:if test="$vlrAjuste != ''">
						<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($vlrAjuste,'###.###.##0,00')"/></fo:block>
					</xsl:if>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($vlrTotal,'###.###.##0,00')"/></fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
	</fo:table>
</xsl:template>

<xsl:template name="TituloGenerico">
	<xsl:param name="idTitulo" select="'RVE_X_Y_Z'"/>
	<xsl:param name="labelTitulo" select="'X.Y.Z T&#237;tulo Gen&#233;rico'"/>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1"/>
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="titFCinza">
						<xsl:attribute name="id">
							<xsl:value-of select="$idTitulo"/>
						</xsl:attribute>
						<xsl:value-of select="$labelTitulo"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
	</fo:table>

</xsl:template>

<xsl:template name="JustificativasGenerico">

	<xsl:param name="labelTitulo" select="'X.Y.Z T&#237;tulo Gen&#233;rico'"/>
	<xsl:param name="justificativasList"/>

	<!--
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TituloGenerico">
		<xsl:with-param name="idTitulo">RVE_XXX</xsl:with-param>
		<xsl:with-param name="labelTitulo">
			X.X.X ...
		</xsl:with-param>
	</xsl:call-template>
	-->

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="256pt"/>
		<fo:table-column column-number="2" column-width="300pt"/>

		<fo:table-body>
			<xsl:for-each select="$justificativasList">
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="txtLeft">
						<fo:inline font-weight="bold" padding-right="3pt">Nome da Planilha: </fo:inline>
						<xsl:value-of select="NOME_PLANILHA"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell number-columns-spanned="2">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
						<fo:inline font-weight="bold" padding-right="3pt">Justificativa: </fo:inline>
						<xsl:value-of select="TEXTO"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			</xsl:for-each>
		</fo:table-body>
	</fo:table>

</xsl:template>

<!--
#############################################
FIM TEMPLATES GENERICOS
#############################################
-->

<xsl:template match="/">
  <fo:root>
    <fo:layout-master-set>
      <!-- ******* Define a configuracao da pagina (Folha) ******* -->
      <fo:simple-page-master master-name="default-master" page-height="29.6cm" page-width="21cm" margin-top="15pt" 	 margin-left="20pt" margin-right="20pt" margin-bottom="15pt">

        <!-- ******* Parte central da pagina (Margens) ******* -->
        <fo:region-body column-count="1" margin-top="1.45in" margin-bottom="0.5in"/>

        <!-- ******* Cabecaalho (Margens) ******* -->
        <fo:region-before border-after-style="solid" extent="1.45in" margin-bottom="0.2in"/>

        <!-- ******* Rodape (Margens) ******* -->
        <fo:region-after border-before-style="solid" extent="0.2in" margin-bottom="0.2in"/>
      </fo:simple-page-master>
    </fo:layout-master-set>

    <!-- Body page -->
    <!-- ******* Corpo da pagina (Conteudo) ******* -->
    <fo:page-sequence master-reference="default-master">

      <!-- ******* Definindo o conteudo do cabecalho ******* -->
      <fo:static-content flow-name="xsl-region-before">
		<xsl:apply-templates select="rve/Cabecalho"/>
      </fo:static-content>

      <!-- ******* Definindo o conteudo do rodape ******* -->
      <fo:static-content flow-name="xsl-region-after">

		<!-- ******* Variaveis locais ******* -->
		<!-- variaveis para obter a data e hora atual -->
      	<xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')"/>
      	<xsl:variable name="tmp" select="cal:new()"/>
      	<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)"/>
		<!-- ******* ******* -->

		<fo:table text-align="center" width="556pt" table-layout="fixed">
		<fo:table-column column-width="115pt"/>
		<fo:table-column column-width="126pt"/>
		<fo:table-column column-width="115pt"/>
		
		 <fo:table-body>
		   <fo:table-row>
			<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
			  <fo:block>
			  </fo:block>
			</fo:table-cell>
		  </fo:table-row>
		  <fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), java:java.util.Date.new())"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtCenter">
					P&#225;gina <fo:page-number/> de <fo:page-number-citation ref-id="last-page"/>
				</fo:block>
			</fo:table-cell>
<!--			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtRight">
					<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('HH:mm:ss'), java:java.util.Date.new())"/>
				</fo:block>
			</fo:table-cell> -->
      <xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')"/>
      <xsl:variable name="tmp" select="cal:new()"/>
      <xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)"/>

			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtRight">
                <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('HH:mm:ss'), cal:getTime())"/>
          <!--xsl:value-of select="cal:get($tmp, 11)" />:<xsl:value-of select="cal:get($tmp, 12)" />:<xsl:value-of select="cal:get($tmp, 13)" /--> 
				</fo:block>
			</fo:table-cell>
    </fo:table-row>      
		 </fo:table-body>
		</fo:table>
      </fo:static-content>

	  <!-- ******* Definindo o conteudo do corpo da pagina ******* -->
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="7.0pt" font-family="serif">
		
		<!-- ************* Variaveis locais **************-->
		<!-- Variavel que determina se eh camara integrada(S) ou nao(N) -->
		<xsl:variable name="isCamaraIntegrada">
			<xsl:choose>
			  <xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
			  <xsl:otherwise>N</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- Variavel que determina se eh Folha Pagamento camara integrada(S) ou nao(N) -->
		<xsl:variable name="isFolhaCamaraIntegrada">
			<xsl:choose>
			  <xsl:when test="/rve/ListaDocumentacaoComplementar/ListaDocumentacaoComplementarRow[DS_TIPO='PAD']/SOLICITADO = 'N'">S</xsl:when>
			  <xsl:otherwise>N</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="pmPossuiCamaraIntegrada">
			<xsl:choose>
				<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTAPM='S'">S</xsl:when>
				<xsl:otherwise>N</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- Variavel que determina se o periodo eh Q ou S -->
		<xsl:variable name="tipoEntrega">
			<xsl:value-of select="rve/IdentificacaoAdministrador/IdentificacaoAdministradorRow/TP_ENTREGA"/>
		</xsl:variable>

		<xsl:variable name="isRveLightSemPAD">
			<xsl:choose>
				<xsl:when test="/rve/ListaDocumentacaoComplementar/ListaDocumentacaoComplementarRow[DS_TIPO='PAD']/SOLICITADO = 'N'">S</xsl:when>
				<xsl:otherwise>N</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- ************* Variaveis locais **************-->

		<xsl:variable name="periodoInicial">
			<xsl:choose>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES != ''">01/<xsl:if test="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES &lt; 10">0</xsl:if><xsl:value-of select="rve/Cabecalho/CabecalhoRow/MES_INFORMACOES"/>/</xsl:when>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">01/01/</xsl:when>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">01/03/</xsl:when>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">01/05/</xsl:when>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">01/07/</xsl:when>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">01/09/</xsl:when>
				<xsl:when test="rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">01/11/</xsl:when>
			</xsl:choose>
		</xsl:variable>

		<!--
		<xsl:variable name="ehEntidadePM" select="(
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"/>
		-->

		<xsl:variable name="ehEntidadeDeContabilidadePublica" select="(
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C')"/>

		<xsl:variable name="ehEntidadeIndiretaDeContabilidadePublica" select="(
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M')"/>

		<xsl:variable name="ehEntidadeQueConsolida" select="(
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M')"/>

		<xsl:variable name="ehEntidadeIndiretaQueConsolida" select="(
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M')"/>

		<xsl:variable name="ehEntidadeDeContabilidadePrivada" select="(
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O' or
			rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T')"/>

		<!-- ########## CORPO DOS RELATORIOS ######### -->
		  <!--#### UC074-01 -->
		  <xsl:if test="rve/ListaDocumentacao!='' and $tipoRelatorio != 'RVE_LIGHT'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ListaDocumentacao"/>
		  </xsl:if>
                  
           <xsl:if test="$isFolhaCamaraIntegrada='N' and rve/ListaDocumentacaoComplementar!='' and $tipoRelatorio = 'RVE_LIGHT'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ListaDocumentacaoComplementar"/>
		  </xsl:if>
		  
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [1] - INICIO xxxxxxxxxxx-->
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_0">1. Informa&#231;&#245;es da Entidade </fo:block>
		  
		  <!--#### UC074-02 -->
		  <xsl:if test="rve/IdentificacaoAdministrador!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/IdentificacaoAdministrador"/>
		  </xsl:if>

		  <!--#### UC074-03 -->		  
		  <xsl:if test="rve/PrestadoraServicosInformatica!='' and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C' or $isCamaraIntegrada!='S')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/PrestadoraServicosInformatica"/>
		  </xsl:if>

		  <!--#### UC074-04 -->		  
		  <xsl:if test="rve/SistemasInformatizados!='' and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C' or $isCamaraIntegrada!='S')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/SistemasInformatizados"/>
		  </xsl:if>

		  <!--#### UC074-88 - SOMENTE PREFEITURA-->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P') and (rve/ConsorcioPublico != '')">
		   		<fo:block><fo:leader leader-pattern="space" /></fo:block>
		   		<xsl:apply-templates select="rve/Consorcios"/>
		  </xsl:if>

		  <!--#### UC074-05 -->
		  <!--<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P') 
		  		and rve/DadosIniciasPM!=''
          and $tipoRelatorio != 'RVE_LIGHT'">
 		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/DadosIniciasPM"/>
		  </xsl:if>-->
       	  <xsl:if test="($ehEntidadeIndiretaQueConsolida)
		   		and (rve/DadosIniciaisAut/DadosAut!='' or rve/DadosIniciaisAut/JustificaAut!='')
          and $tipoRelatorio != 'RVE_LIGHT'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/DadosIniciaisAut"/>
		  </xsl:if>

  		  <!--#### UC074-69 -->
		  <xsl:if test="($ehEntidadeDeContabilidadePrivada)
		  		and rve/DadosIniciais6404!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/DadosIniciais6404"/>
		  </xsl:if>

		  <!--#### UC074-13 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/EntidadeIndiretasSelPad"/>
		  </xsl:if>

		  <!--#### UC074-14 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/EntidadesIndiretasSelEntidade"/>
		  </xsl:if>

		  <!--#### UC074-15 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P') 
		  		and rve/JustificaEntIndireta!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/JustificaEntIndireta"/>
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [1] - FIM xxxxxxxxxxx-->
        	

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [2] - INICIO xxxxxxxxxxx-->
		  <xsl:if test="$isRveLightSemPAD='N' and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C' or $isCamaraIntegrada='N' and $isFolhaCamaraIntegrada != 'S')">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_0">2. Informa&#231;&#245;es Cont&#225;beis </fo:block>
		  </xsl:if>
		
		  <!--xxxxxxxxxxx SUBITEM [2] xxxxxxxxxxx-->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaDeContabilidadePublica and $isFolhaCamaraIntegrada != 'S'">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_1">2.1 Contas de Receita </fo:block>
		  </xsl:if>

		  <!--#### UC074-16 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaDeContabilidadePublica)
		  				and rve/ContasReceita!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ContasReceita"/>
		  </xsl:if>

        		<!--xxxxxxxxxxx SUBITEM [2] xxxxxxxxxxx-->
		  <xsl:if test="((rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaDeContabilidadePublica) or
		  				(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N') and $isFolhaCamaraIntegrada != 'S') and $isRveLightSemPAD='N'">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_2">2.2 Contas de Despesa </fo:block>
		  </xsl:if>

  	  	  <!--#### UC074-18 -->
		  <xsl:if test="($ehEntidadeDeContabilidadePublica)
		  				and rve/ContasDespesa!='' and $isRveLightSemPAD='N'">
 		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ContasDespesa"/>
		  </xsl:if>

		  <!--#### UC074-19 -->
		  <xsl:if test="$isRveLightSemPAD='N' and ($ehEntidadeDeContabilidadePublica)">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/AberturaCreditosAdicionais"/>
		  </xsl:if>

	      <!--#### UC074-50 -->
		  <!--<xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'
		  		and rve/DadosDespesa!='' and $isFolhaCamaraIntegrada != 'S'">
	        	     <fo:block><fo:leader leader-pattern="space" /></fo:block>
		     <xsl:apply-templates select="rve/DadosDespesa"/>
		  </xsl:if>-->

		  <!--xxxxxxxxxxx SUBITEM [2] xxxxxxxxxxx-->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C') and $isFolhaCamaraIntegrada != 'S'">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_3">2.3 Contas de Verifica&#231;&#227;o </fo:block>
		  </xsl:if>

		  <!--#### UC074-20 -->
		  <xsl:if test="($ehEntidadeDeContabilidadePublica)
		  				and rve/ContasVerificacao!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ContasVerificacao"/>
		  </xsl:if>

		  <!--#### UC074-21 -->
		  <!--<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
		  				and rve/RestosServicosSentencas!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/RestosServicosSentencas"/>
		  </xsl:if>-->

		  <!--#### UC074-23 -->		  
		  <xsl:if test="($ehEntidadeDeContabilidadePublica)
		  				and rve/DisponibilidadeFinanceira!='' and $isRveLightSemPAD='N'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/DisponibilidadeFinanceira"/>
		  </xsl:if>

		  <!--#### UC074-68 -->
	   	  <xsl:if test="($ehEntidadeDeContabilidadePrivada)
		  				and $isRveLightSemPAD='N'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/BalVerMoviment"/>
	      	   </xsl:if>

		  <!--#### UC074-22 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaDeContabilidadePublica)
		  				and rve/JustificaContas!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/JustificaContas"/>
		  </xsl:if>

	  	  <!--#### UC074-34 -->
          <xsl:if test="($ehEntidadeDeContabilidadePublica)
		  				and rve/ValoresExercicioAnterior!='' and $isFolhaCamaraIntegrada != 'S'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ValoresExercicioAnterior"/>
		  </xsl:if>
          
          <!--#### UC074-83 -->
          <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/CertidaoDecisaoTituloExecutivo"/>
		   
		   <!--#### UC074-82 -->
		   <xsl:apply-templates select="rve/JustificaCertidaoDecisaoTituloExecutivo"/>
		  </xsl:if>
          
		  <!--LIVRO_DIARIO-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and
		  				($ehEntidadeDeContabilidadePublica)">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_7">2.7 Arquivo Livro Di&#225;rio Geral (TCE_4111) </fo:block>

		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/LivroDiarioGeral"/>
		  </xsl:if>
          
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [2] - FIM xxxxxxxxxxx-->

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [3] - INICIO xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and
						(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C') or 
		  				(($ehEntidadeIndiretaQueConsolida) and (
						  rve/Educacao/DespMdeFundefRecursos!='' or rve/Educacao/DespMdeFundefContas/DespMdeFundefContasPrefeitura!='' or 
						  rve/Educacao/DespMdeFundefContas/DespMdeFundefContasOutras!='' or rve/Educacao/ContrapartidaEducacao!='' or
						  rve/Saude/GastoSaudeRecursos!='' or rve/Saude/GastoSaudeContas/GastoSaudeContasPrefeitura!='' or rve/Saude/GastoSaudeContas/GastoSaudeContasOutras!='' or
						  rve/Saude/ContrapartidaSaude!='' or rve/Saude/JustificaSaude!='' ))">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_0">3. &#205;ndices Constitucionais </fo:block>

		<xsl:if test="$tipoRelatorio != 'RVE_LIGHT'
			and $ehEntidadeQueConsolida
			and $mesInformacoes = 12">
			<fo:block><fo:leader leader-pattern="space" /></fo:block>
			<fo:block><fo:leader leader-pattern="space" /></fo:block>
			<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_1">3.1 Clculo da Suficincia/Insuficincia Financeira referente aos RPNP do exerccio para fins do Gasto Constitucional com Educao e Sade </fo:block>
			<fo:block><fo:leader leader-pattern="space" /></fo:block>
			<xsl:apply-templates select="rve/Educacao" mode="educacao"/>
		</xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [3] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and
						rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_1">3.1 &#205;ndices Constitucionais do Poder Legislativo </fo:block>
		  </xsl:if>

		  <!--#### UC074-08 -->		  
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
		  				and rve/LimitesConstitucionaisLegislativo!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/LimitesConstitucionaisLegislativo"/>
		  </xsl:if>

		  <!--#### UC074-09 -->		  
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
		  				and rve/LimiteLegalIncisoVI!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/LimiteLegalIncisoVI"/>
		  </xsl:if>

		

		  <!--#### UC074-11 -->		  
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT'
						and rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
		  				and rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 12 ">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/RemuneracaoVereadores"/>
		  </xsl:if>

		  <!--#### UC074-12 -->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
		  				and rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 12 
						and rve/LimiteLegalIncisoVII!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/LimiteLegalIncisoVII"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [3] xxxxxxxxxxx-->
		  <xsl:if test="$ocultar = 'off'">
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT'
						and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P') or (($ehEntidadeIndiretaQueConsolida)
		  				and (rve/Educacao/DespMdeFundefRecursos!='' or rve/Educacao/DespMdeFundefContas/DespMdeFundefContasPrefeitura!='' or 
						  rve/Educacao/DespMdeFundefContas/DespMdeFundefContasOutras!='' or rve/Educacao/ContrapartidaEducacao!=''))">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_2">3.2 &#205;ndices Constitucionais Referentes &#224; Educa&#231;&#227;o (MDE+FUNDEB) </fo:block>

		  <xsl:choose>
		  <xsl:when test="rve/Educacao/RecMdeFundefContas!='' or
		                  rve/Educacao/RecMdeFundefRecursos!='' or
		                  rve/Educacao/DespMdeFundefRecursos!='' or
		                  rve/Educacao/DespMdeFundefContas/DespMdeFundefContasPrefeitura!='' or
		                  rve/Educacao/DespMdeFundefContas/DespMdeFundefContasOutras!='' or
		                  rve/Educacao/ContrapartidaEducacao!=''">
		                
		  <!--#### UC074-24 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
		  				<!--and rve/Educacao/RecMdeFundefContas!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/RecMdeFundefContas"/>
		  </xsl:if>

  		  <!--#### UC074-25 -->
		  <!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
		  				<!- -and rve/Educacao/RecMdeFundefRecursos!=''">- ->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/RecMdeFundefRecursos"/>
		  </xsl:if>
		  -->

		  <!--#### UC074-26 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)"> 
		  				<!--and rve/Educacao/DespMdeFundefRecursos!=''"-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/DespMdeFundefRecursos"/>
		  </xsl:if>

		  <!--#### UC074-27 -->
		  <!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and (rve/Educacao/DespMdeFundefContas/DespMdeFundefContasPrefeitura!='' or rve/Educacao/DespMdeFundefContas/DespMdeFundefContasOutras!='')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/DespMdeFundefContas"/>
		  </xsl:if>
		  -->
		<!--
			<xsl:if test="$excluir = 'off'">
			<!- -#### UC074-79 - ->
        	<xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida"> 
							<!- -and rve/Educacao/ContrapartidaEducacao!=''"- -> 
	        	<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        	<xsl:apply-templates select="rve/Educacao/ContrapartidaEducacao"/>
	        </xsl:if>
	        </xsl:if>
		-->
	      </xsl:when>
	      <xsl:otherwise>
	        	<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        	<fo:block><fo:inline font-style="italic">&#205;ndices Constitucionais referentes &#224; Educa&#231;&#227;o (MDE+FUNDEB) n&#227;o calculados</fo:inline></fo:block>
	      </xsl:otherwise>
	      </xsl:choose>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [3] xxxxxxxxxxx-->
		  <xsl:if test="($tipoRelatorio != 'RVE_LIGHT' and rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_3">3.3 &#205;ndices Constitucionais Referentes ao FUNDEB </fo:block>

		  <xsl:choose>
		  <xsl:when test="rve/Educacao/RecFUNDEF/FUNDEBContas!='' or
		                  rve/Educacao/RecFundefRecursos!='' or
		                  rve/Educacao/DespFundefRecursos!='' or
		                  rve/Educacao/DespFundefContas!='' or
		                  rve/Educacao/BaseCalcAplicRec!='' or
		                  rve/Educacao/AplicRecFundeb!='' or
		                  rve/Educacao/BaseCalcSuperavit!='' or
		                  rve/Educacao/DespLiquRecSupFundeb!=''">

		  <!--#### UC074-28 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
		  				<!--and rve/Educacao/RecFUNDEF/FUNDEBContas!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <xsl:apply-templates select="rve/Educacao/RecFundefContas2"/>
		  </xsl:if>

		  <!--#### UC074-29 -->
		  <!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/RecFundefRecursos"/>
		  </xsl:if>
		  -->

		  <!--#### UC074-72 -->
		<!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		  				<!- -and rve/Educacao/DespFundefRecursos!=''">- ->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/DespFundefRecursos"/>
		  </xsl:if>
		-->

		  <!--#### UC074-73 -->
		<!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		  				<!- -and rve/Educacao/DespFundefContas!=''">- ->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/DespFundefContas"/>
		  </xsl:if>
		-->

		<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')">
			<fo:block><fo:leader leader-pattern="space" /></fo:block>
			<xsl:call-template name="Itens3.3.3"/>
		</xsl:if>

		  <!-- Removido este item no bug 3591 (2a parte) -->
		  <!--xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"--> 
		  				<!--and rve/Educacao/DespFundefContas!=''">-->
			<!--fo:block xsl:use-attribute-sets="txtLeft">
				<fo:basic-link internal-destination="RVE_3_3_4">3.3.4 C&#225;lculo da Despesa Constitucional com FUNDEB, Contabilizada nas Contas Patrimoniais</fo:basic-link>
			</fo:block>		  
		  </xsl:if-->
		  
		  <!--#### UC074-84 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		  				<!--and rve/Educacao/AplicRecFundeb!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/BaseCalcAplicRec"/>
		   <xsl:apply-templates select="rve/Educacao/AplicRecFundeb"/>
		  </xsl:if>
		  
		  <!--#### UC074-85 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		  				<!--and rve/Educacao/DespLiquRecSupFundeb!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/BaseCalcSuperavit"/>
		   <xsl:apply-templates select="rve/Educacao/DespLiquRecSupFundeb"/>
		  </xsl:if>

		  </xsl:when>
		  <xsl:otherwise>
		    	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		    	<fo:block><fo:inline font-style="italic">&#205;ndices Constitucionais referentes ao FUNDEB n&#227;o calculados</fo:inline></fo:block>
		  </xsl:otherwise>
		  </xsl:choose>
		  </xsl:if>
		  
		  <!--#### UC074-74 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
		  				and rve/Educacao/JustificaEducacao!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Educacao/JustificaEducacao"/>
		  </xsl:if>

		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [3] xxxxxxxxxxx-->
		  <xsl:if test="$ocultar = 'off'">
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT'
						and ((rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P') or (
							($ehEntidadeIndiretaQueConsolida) and 
			  				(rve/Saude/GastoSaudeRecursos!='' or rve/Saude/GastoSaudeContas/GastoSaudeContasPrefeitura!='' or rve/Saude/GastoSaudeContas/GastoSaudeContasOutras!='' or
						rve/Saude/ContrapartidaSaude!='' or rve/Saude/JustificaSaude!='')))">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_5">3.5 &#205;ndices Constitucionais Referentes &#224; Sa&#250;de - ASPS </fo:block>


		  <xsl:choose>
		  <xsl:when test="rve/Saude/CalculoReceitaContas!='' or
		                  rve/Saude/CalculoReceitaRecursos!='' or
		                  rve/Saude/GastoSaudeRecursos!='' or
		                  rve/Saude/GastoSaudeContas/GastoSaudeContasPrefeitura!='' or
		                  rve/Saude/GastoSaudeContas/GastoSaudeContasOutras!='' or
		                  rve/Saude/ContrapartidaSaude!=''">

		  <!--#### UC074-30 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		  				<!--and rve/Saude/CalculoReceitaContas!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Saude/CalculoReceitaContas"/>
		  </xsl:if>

		  <!--#### UC074-31 -->
		  <!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Saude/CalculoReceitaRecursos"/>
		  </xsl:if>
		  -->

		  <!--#### UC074-32 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)"> 
		  				<!--and rve/Saude/GastoSaudeRecursos!=''"-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Saude/GastoSaudeRecursos"/>
		   <xsl:apply-templates select="rve/Saude/GastoSaudeContas"/>
		  </xsl:if>

		  <!--#### UC074-75 -->
		<!--
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and (rve/Saude/GastoSaudeContas/GastoSaudeContasPrefeitura!='' or rve/Saude/GastoSaudeContas/GastoSaudeContasOutras!='')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Saude/GastoSaudeContas"/>
		  </xsl:if>
		-->
		<!--
			<xsl:if test="$excluir = 'off'">
	    	<!- -#### UC074-80 - ->
        	<xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida"> 
							<!- -and rve/Saude/ContrapartidaSaude!=''"- ->
        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
        		<xsl:apply-templates select="rve/Saude/ContrapartidaSaude"/>
        	</xsl:if>
        	</xsl:if>
		-->
	  	  <!--#### UC074-33 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
		  				and rve/Saude/JustificaSaude!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Saude/JustificaSaude"/>
		  </xsl:if>
		  
		  </xsl:when>
		  <xsl:otherwise>
		    	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		    	<fo:block><fo:inline font-style="italic">&#205;ndices Constitucionais referentes &#224; Sa&#250;de - ASPS n&#227;o calculados</fo:inline></fo:block>
		  </xsl:otherwise>
		  </xsl:choose>
		  </xsl:if>
		  </xsl:if>
		    <!--#### UC074-10 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C') 
		  				and rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 12 
						and rve/ReceitasMunicipioIncisoVII!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/ReceitasMunicipioIncisoVII"/>
		  </xsl:if>
		  
		  </xsl:if>
		  
          <xsl:if test="count(rve/DespesasReceitasArt167A/DespesasReceitasArt167ARow) &gt; 0">
              <fo:block><fo:leader leader-pattern="space" /></fo:block>
              <fo:block><fo:leader leader-pattern="space" /></fo:block>
              <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_8">3.8 Apurao das Despesas Correntes e das Receitas Correntes para verificao do Art. 167-A da Constituio Federal</fo:block>
              <xsl:apply-templates select="rve/DespesasReceitasArt167A"/>
          </xsl:if>
		  
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [3] - FIM xxxxxxxxxxx-->

	      	<!--xxxxxxxxxxx ITEM PRINCIPAL [4] - INICIO xxxxxxxxxxx-->
		  <!--#### UC074-35 -->
		  	<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C' or $isCamaraIntegrada='N' and $isFolhaCamaraIntegrada != 'S') and $isRveLightSemPAD != 'S'">
		  <!--<xsl:if test="rve/ErrosAvisos!=''">-->
                   <fo:block><fo:leader leader-pattern="space" /></fo:block>
                   <fo:block><fo:leader leader-pattern="space" /></fo:block>
                   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_4">4. Avisos Exibidos na Verifica&#231;&#227;o dos Arquivos Texto</fo:block>
                   <xsl:apply-templates select="rve/ErrosAvisos"/>
                   <xsl:if test="rve/ErrosAvisosJustificativas!='' and $isFolhaCamaraIntegrada != 'S'">
                        <xsl:apply-templates select="rve/ErrosAvisosJustificativas"/>
                   </xsl:if>
		  <!--</xsl:if>-->
			</xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [4] - FIM xxxxxxxxxxx-->

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [5] - INICIO xxxxxxxxxxx-->
        		<xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and
							(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' or $ehEntidadeIndiretaQueConsolida)">
                    			<!--and $ehEntregaLrf">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_0">5. Informa&#231;&#245;es Referentes &#224; Gest&#227;o Fiscal </fo:block>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
			 <xsl:if test="$tipoRelatorio != 'RVE_LIGHT'
				  and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or
				(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and
				$ehEntregaLrf ))">
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
		  	<fo:block><fo:leader leader-pattern="space" /></fo:block>
			<xsl:choose>
				<xsl:when test="$anoAtual > 2010 or ($anoAtual = 2010 and $bimestre &gt;= 4)">
					<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_1">5.1 Transpar&#234;ncia da Gest&#227;o Fiscal</fo:block>
				</xsl:when>
				<xsl:otherwise>
					<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_1">5.1 Data e Forma de Publica&#231;&#227;o dos Relat&#243;rios da Lei de Responsabilidade Fiscal </fo:block>
				</xsl:otherwise>
			</xsl:choose>
		  </xsl:if>

		  <!--#### UC074-06 -->		  
		  <xsl:if test="$mesInformacaoEhPar">
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P')"> 
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/PublicacaoRelatoriosResumidos"/>
		  </xsl:if>
		  </xsl:if>

		  <!--#### UC074-07 -->		  
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P') and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/PublicacaoGestaoFiscalExec"/>
		  </xsl:if>

		  <!--#### UC074-70 -->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/PublicacaoGestaoFiscalLegis"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
				  <!-- 5.1.4 Disponibilizacao das Informacoes na Internet, em tempo real -->
				  <xsl:if test="$anoAtual > 2010 or ($anoAtual = 2010 and $bimestre &gt;= 4)">

                  <!-- UC074-71--> <!-- item 5.1.3 , antigo 5.4 , bug 4526 -->
                  <xsl:if test="$mesInformacaoEhPar">
                  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
                        <fo:block><fo:leader leader-pattern="space" /></fo:block>
                        <xsl:apply-templates select="rve/DataAudienciaPublica"/>
                  </xsl:if>
                  </xsl:if>
                  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
                        <fo:block><fo:leader leader-pattern="space" /></fo:block>
                        <xsl:apply-templates select="rve/DisponibilizacaoInfoTempoReal"/>
                  </xsl:if>

				  </xsl:if>

		<!-- <xsl:if test="rve/CusteioCompetenciaOutrosEntes/Custeio/CusteioRow"> -->
		<xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' and $mesInformacoes = 12">
			<xsl:apply-templates select="rve/CusteioCompetenciaOutrosEntes" />
		</xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT'
						and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' or $ehEntidadeIndiretaQueConsolida)
		                and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2">5.2 Demonstrativos da Lei de Responsabilidade Fiscal </fo:block>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->

			<xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and ( rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or  $ehEntidadeIndiretaQueConsolida ) and
				    $ehEntregaLrf">
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
				<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_1">5.2.1 Modelo 1 - Demonstrativo da Receita Corrente L&#237;quida </fo:block>
			</xsl:if>

		  <!--#### UC074-36 -->
		  <xsl:if test="$ehEntregaLrf">
			  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
							and (($tipoEntrega='Q' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=2 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=4)) or ($tipoEntrega='S' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=3)))">
							<!--and rve/Modelo1/ExAnterior!=''">-->
			   <fo:block><fo:leader leader-pattern="space" /></fo:block>
			   <xsl:apply-templates select="rve/Modelo1/ExAnterior"/>
			  </xsl:if>
		  </xsl:if>
		  <!--#### UC074-37 - SEM CAMARA--> 
		  <xsl:if test="$ehEntregaLrf">
		  	<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)">
		   		<!--and rve/Modelo1/ExAtual!=''">-->
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
		   		<xsl:apply-templates select="rve/Modelo1/ExAtual"/>
			</xsl:if>
		  </xsl:if>

		  <!--#### UC074-87 - SOMENTE CAMARA-->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N')
		                and $ehEntregaLrf">
		   		<fo:block><fo:leader leader-pattern="space" /></fo:block>
		   		<xsl:apply-templates select="rve/Modelo1/Legislativo"/>
			</xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and 
						(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
		                and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_2">5.2.2 Modelo 2 - Demonstrativo da Despesa com Pessoal (Executivo) </fo:block>
		  </xsl:if>

		  <!--#### UC074-38 -->
		  <xsl:if test="$ehEntregaLrf">
			  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
							and (($tipoEntrega='Q' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=2 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=4)) or ($tipoEntrega='S' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=3)))">
							<!--and rve/Modelo2/ExAnterior!=''">-->
			   <fo:block><fo:leader leader-pattern="space" /></fo:block>
			   <xsl:apply-templates select="rve/Modelo2/ExAnterior"/>
			  </xsl:if>
		  </xsl:if>
		  <!--#### UC074-39 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
		  				<!--and rve/Modelo2/ExAtual!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo2/ExAtual"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and 
						(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida or
						 rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C') and
						$isFechamentoDeExercicio">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_3">5.2.3 Modelo 3 - Demonstrativo da Disponibilidade de Caixa </fo:block>
		  </xsl:if>

		  <!--#### UC074-40 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $isFechamentoDeExercicio">
						<!--and rve/Modelo3/Executivo!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo3/Executivo"/>
		  </xsl:if>
          
          <!--#### UC074-86 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C') 
		  				and $isFechamentoDeExercicio">
						<!--and rve/Modelo3/Legislativo!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo3/Legislativo"/>
		  </xsl:if>

		  <!--#### UC074-41 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or
		  				$ehEntidadeIndiretaQueConsolida) 
		  				and $isFechamentoDeExercicio">
						<!--and rve/Modelo3/Rpps!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo3/Rpps"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or			
						$ehEntidadeIndiretaQueConsolida)
		                and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4">5.2.4 Modelo 4 - Demonstrativo da D&#237;vida Consolidada </fo:block>
		  </xsl:if>

		  <!--#### UC074-42 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo4/DividaConsolidada!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo4/DividaConsolidada"/>
		  </xsl:if>

		  <!--#### UC074-43 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo4/AtivoCirculante!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo4/AtivoCirculante"/>
		  </xsl:if>

		  <!--#### UC074-44 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo4/ObrigacoesFinanceiras!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo4/ObrigacoesFinanceiras"/>
		  </xsl:if>

		  <!--#### UC074-45 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo4/OutrasObrigacoes!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo4/OutrasObrigacoes"/>
		  </xsl:if>
        	
	        	<!--#### UC074-55 -->
	        	<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
	        		and $ehEntregaLrf">
	        		<!--and rve/Modelo4/DividaConsolidada!=''">-->
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<xsl:apply-templates select="rve/Modelo4/DividaConsolidadaRPPS"/>
	        	</xsl:if>
	        	
	        	<!--#### UC074-56 -->
	        	<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
	        		and $ehEntregaLrf">
	        		<!--and rve/Modelo4/AtivoCirculante!=''">-->
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<xsl:apply-templates select="rve/Modelo4/AtivoCirculanteRPPS"/>
	        	</xsl:if>
	        	
	        	<!--#### UC074-58 -->
	        	<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
	        		and $ehEntregaLrf">
	        		<!--and rve/Modelo4/ObrigacoesFinanceiras!=''">-->
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<xsl:apply-templates select="rve/Modelo4/ObrigacoesFinanceirasRPPS"/>
	        	</xsl:if>
	        	
	        	<!--#### UC074-59 -->
	        	<xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
	        		and $ehEntregaLrf">
	        		<!--and rve/Modelo4/OutrasObrigacoes!=''">-->
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<xsl:apply-templates select="rve/Modelo4/OutrasObrigacoesRPPS"/>
	        	</xsl:if>        	

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and 
						(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
		                and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_5">5.2.5 Modelo 5 - Demonstrativo das Garantias e Contragarantias de Valores </fo:block>
		  </xsl:if>

		  <!--#### UC074-46 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo5/Garantias!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo5/Garantias"/>
		  </xsl:if>

		  <!--#### UC074-47 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo5/ContraGarantias!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo5/ContraGarantias"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and
						(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
		                and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_6">5.2.6 Modelo 6 - Demonstrativo das Opera&#231;&#245;es de Cr&#233;dito - Internas e Externas </fo:block>
		  </xsl:if>

		  <!--#### UC074-48 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo6/OperacoesCredito!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo6/OperacoesCredito"/>
		  </xsl:if>

		  <!--#### UC074-49 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
						<!--and rve/Modelo6/AntecipacaoReceita!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo6/AntecipacaoReceita"/>
		  </xsl:if>

		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo6/DividaConsolidadaOutrasOperacoes"/>
		  </xsl:if>

		  <!--#### UC074-52 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		  				and $isFechamentoDeExercicio">
						<!--and (rve/Modelo7/ExAnterior!='' or rve/Modelo7/ExAtual!='' or rve/Modelo7/RestosProcs!='' or rve/Modelo7/RestosNProcs!='' or rve/Modelo7/Disponibilidade!='')">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo7"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' 
						and	rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'
		                and $ehEntregaLrf">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_8">5.2.8 Modelo 10 - Demonstrativo da Despesa com Pessoal (Legislativo) </fo:block>
		  </xsl:if>

		  <!--#### UC074-53 -->
		  <xsl:if test="$ehEntregaLrf">
				  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
				  	and (($tipoEntrega='Q' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=2 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=4)) or ($tipoEntrega='S' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=3)))">
				  	<!--and (($tipoEntrega='Q' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=2 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=4)) or ($tipoEntrega='S' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=3)))">
								and rve/Modelo10/ExAnterior!=''">-->            
				   <xsl:apply-templates select="rve/Modelo10/ExAnterior"/>
				  </xsl:if>
		  </xsl:if>
		  <!--#### UC074-54 -->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
  			and $ehEntregaLrf">
			<!--and rve/Modelo10/ExAtual!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo10/ExAtual"/>
		  </xsl:if>

		  <!--#### UC074-57 -->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
  			and rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">
  			<!--and (rve/modelo11/modelo11Camara/ExAnterior!='' or rve/modelo11/modelo11Camara/ExAtual!='' or rve/modelo11/modelo11Camara/RestosProcs!='' or rve/modelo11/modelo11Camara/RestosNProcs!='' or rve/modelo11/modelo11Camara/Disponibilidade!='' or rve/modelo11/modelo11Prefeitura/ExAnterior!='' or rve/modelo11/modelo11Prefeitura/ExAtual!='' or rve/modelo11/modelo11Prefeitura/RestosProcs!='' or rve/modelo11/modelo11Prefeitura/RestosNProcs!='' or rve/modelo11/modelo11Prefeitura/Disponibilidade!='')">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/modelo11"/>
		  </xsl:if>

		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
		  <xsl:if test="$ehEntregaLrf">
			  <xsl:if test="
						$tipoRelatorio != 'RVE_LIGHT' and (
						((rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
							and ((rve/Cabecalho/CabecalhoRow/TP_ENTREGA = 'Q' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6)) or
	                   (rve/Cabecalho/CabecalhoRow/TP_ENTREGA = 'S' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6))))
	              or  ((rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C') and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6))
	                   )">
			   <fo:block><fo:leader leader-pattern="space" /></fo:block>
			   <fo:block><fo:leader leader-pattern="space" /></fo:block>
			   <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_10">5.2.10 Modelo 13 - Demonstrativos dos Gastos Totais do Legislativo </fo:block>
			  </xsl:if>
		  </xsl:if>
		  <!--#### UC074-60 -->
		  <xsl:if test="$ehEntregaLrf">
			  <xsl:if test="(
	                  ((rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
			  				and ((rve/Cabecalho/CabecalhoRow/TP_ENTREGA = 'Q' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6)) or
	                   (rve/Cabecalho/CabecalhoRow/TP_ENTREGA = 'S' and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3 or rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6))))
	              or  ((rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N') and (rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6))
	                   )">
			  				<!--and rve/Modelo13/ReceitaExAnterior!=''">-->
			   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		 	   <xsl:apply-templates select="rve/Modelo13/ReceitaExAnterior"/>
			  </xsl:if>
		  </xsl:if>
		  <!--#### UC074-61 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)
					and $ehEntregaLrf
					">
						<!--and rve/Modelo13/ReceitaCorrigida!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo13/ReceitaCorrigida"/>
		  </xsl:if>

		  <!--#### UC074-62 -->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
		  				and rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">
						<!--and rve/Modelo13/GastosTotais!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo13/GastosTotais"/>
		  </xsl:if>

		  <!--#### UC074-63 -->
		  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' 
		  				and rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">
						<!--and rve/Modelo13/FolhaPagamento!=''">-->
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Modelo13/FolhaPagamento"/>
		  </xsl:if>

		  <!--#### UC074-64 -->
		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' or $ehEntidadeIndiretaQueConsolida) 
  				and $ehEntregaLrf
				and rve/JustificativaAjustes!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/JustificativaAjustes"/>
		  </xsl:if>
	        	  
        		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
        		  <!--#### UC074-17 -->
	        	  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
	        		and rve/MetasArrecadacao!=''">
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<xsl:apply-templates select="rve/MetasArrecadacao"/>
	        	  </xsl:if>

        		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
        		  <!-- UC074-71-->
				  <xsl:if test="not( $anoAtual > 2010 or ($anoAtual = 2010 and $bimestre &gt;= 4) )">
                  <xsl:if test="$mesInformacaoEhPar">
	        	  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        	  	<xsl:apply-templates select="rve/DataAudienciaPublica"/>
	        	  </xsl:if>
	        	  </xsl:if>
				  </xsl:if>

        		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
        		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' 
				  and (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'  or $ehEntidadeIndiretaQueConsolida)">
	        		<!--and rve/Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=6">-->
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
        		  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_5">5.5 Informa&#231;&#245;es para Emiss&#227;o de Certid&#227;o - Art. 21 da Resolu&#231;&#227;o do Senado Federal n.&#186; 43/2001 </fo:block>
        		  </xsl:if>   
        	
        		  <!-- UC074-76-->
        		  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida)">
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<xsl:apply-templates select="rve/EmissaoCertidao/Prefeitura"/>
	    	  </xsl:if>
      	
        		  <!-- UC074-77-->
	      	  <xsl:if test="rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
	      		<fo:block><fo:leader leader-pattern="space" /></fo:block>
        			<xsl:apply-templates select="rve/EmissaoCertidao/Camara"/>
	      	  </xsl:if>              	
        		
        		  <!--xxxxxxxxxxx SUBITEM [5] xxxxxxxxxxx-->
                  <!-- UC074-78-->
	        	  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT' and
	        	                (rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) and
	        	                $isFechamentoDeExercicio">
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        	  	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_6">5.6 Opera&#231;&#245;es de Cr&#233;dito e Despesas de Capital </fo:block>
                    <fo:block><fo:leader leader-pattern="space" /></fo:block>
                    <xsl:apply-templates select="rve/OperacoesCredito"/>
                  </xsl:if>
        	
        		          	
        		  <!-- UC074-81-->
	        	  <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		        	  	and rve/OperacoesCredito/JustificaOperacoes!=''  ">
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        	  	<xsl:apply-templates select="rve/OperacoesCredito/JustificaOperacoes"/>
	        	  
	        	  </xsl:if>  
	        	  
	        	   <xsl:if test="(rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P' or $ehEntidadeIndiretaQueConsolida) 
		        	  	and  rve/OperacoesCredito/JustificaOperacoes203C!='' ">
	        		<fo:block><fo:leader leader-pattern="space" /></fo:block>
	        	  	<xsl:apply-templates select="rve/OperacoesCredito/JustificaOperacoes203C"/>
	        	  
	        	  </xsl:if>          	
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [5] - FIM xxxxxxxxxxx-->

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [6] - INICIO xxxxxxxxxxx-->
		  <!-- CADASTROS SO PAD -->
		  <xsl:if test="$tipoRelatorio != 'RVE_LIGHT'">
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block xsl:use-attribute-sets="titFCinza">6. Cadastro de Administradores da Entidade </fo:block>
                  </xsl:if>
      <!-- Retirado temporariamente bug 4485 -->
      <!--xsl:if test="rve/JustificaCadastroResponsaveisPad=''">
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block><fo:leader leader-pattern="space" /></fo:block>
			  <fo:block xsl:use-attribute-sets="txtLeft">Foi utilizado o Sistema On-Line de Cadastro de Responsaveis para preenchimento do Cadastro de Administradores da Entidade.</fo:block>
		  </xsl:if-->

		  <!--#### UC074-66 -->
		  <!-- CADASTROS SO PAD -->
		  <!-- Retirado temporariamente bug 4485 -->
		  <!--xsl:if test="(rve/Administradores/Administrador!='' or rve/Administradores/Substituto!='') and $isCamaraIntegrada='N' and rve/JustificaCadastroResponsaveisPad!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/Administradores"/>
		   <xsl:apply-templates select="rve/JustificaCadastroResponsaveisPad"/>
		  </xsl:if-->
		  <xsl:if test="(rve/Administradores/Administrador!='' or rve/Administradores/Substituto!='') and $isCamaraIntegrada='N'">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/Administradores"/>
		   <!--xsl:apply-templates select="rve/JustificaCadastroResponsaveisPad"/-->
		  </xsl:if>

		  <!--#### UC074-67 -->
		  <!-- CADASTROS SO PAD -->
		  <!-- Retirado temporariamente bug 4485 -->
		  <!--xsl:if test="($isCamaraIntegrada='S' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C')
		                and (rve/AdmLegislativo/Administrador!='' or rve/AdmLegislativo/Substituto!='') and rve/JustificaCadastroResponsaveisPad!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/AdmLegislativo"/>
		   <xsl:apply-templates select="rve/JustificaCadastroResponsaveisPad"/>
		  </xsl:if-->
		  <xsl:if test="($isCamaraIntegrada='S' or rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C')
		                and (rve/AdmLegislativo/Administrador!='' or rve/AdmLegislativo/Substituto!='')">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/AdmLegislativo"/>
		   <!--xsl:apply-templates select="rve/JustificaCadastroResponsaveisPad"/-->
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [6] - FIM xxxxxxxxxxx-->

		  <!--xxxxxxxxxxx ITEM PRINCIPAL [7] - INICIO xxxxxxxxxxx-->
		  <!--#### UC074-65 -->
		  <xsl:if test="rve/ObservacoesEntidade!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
	  	   <xsl:apply-templates select="rve/ObservacoesEntidade"/>
		  </xsl:if>

		  <!-- QUEBRA DE PAGINA -->
		  <fo:block break-after="page"/>
                  
                  
              <!--=========== MENSAGEM FOLHA PAGAMENTO CAMARA INTEGRADA============-->
                  <xsl:if test="$isRveLightSemPAD='S' and $isCamaraIntegrada='S' and rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
                  <!--  xsl:if test="/rve/ListaDocumentacaoComplementar/ListaDocumentacaoComplementarRow[DS_TIPO='PAD']/SOLICITADO = 'N'"-->
                  
                      <fo:block><fo:leader leader-pattern="space" /></fo:block>
                      <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
                            <fo:table-column column-number="1"/>
                            <fo:table-body>
                                    <fo:table-row>
                                            <fo:table-cell padding-left="50pt">
                                                    <fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
                                                           DECLARAMOS que o Poder Legislativo entrega em conjunto com o Poder Executivo a remessa gerada pelo PAD, portanto n&#227;o foram exibidos no relat&#243;rio
                                                    </fo:block>
                                            </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                            <fo:table-cell>
                                                    <fo:block xsl:use-attribute-sets="txtLeft">
                                                           os valores referentes &#224;s Despesas.
                                                    </fo:block>
                                            </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row>
                                            <fo:table-cell>
                                                    <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
                                            </fo:table-cell>
                                    </fo:table-row> 
                            </fo:table-body>
                      </fo:table>
                      <fo:block><fo:leader leader-pattern="space" /></fo:block>
                  </xsl:if>
		  <!--=========== MENSAGEM FOLHA PAGAMENTO CAMARA INTEGRADA ============-->

		  <!--=========== MENSAGEM ============-->
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  			<fo:table-column column-number="1"/>
  
  			<fo:table-body>
   				<fo:table-row>
					<fo:table-cell padding-left="50pt">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt" id="RVE_7_1">
							CERTIFICAMOS, com base nos registros constantes na Entidade, a consist&#234;ncia das informa&#231;&#245;es apresentadas neste relat&#243;rio com as
							<!--enviadas ao TCE.-->
						</fo:block>
    				</fo:table-cell>
   				</fo:table-row>
   				<fo:table-row>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft">
							enviadas ao TCE.
						</fo:block>
    				</fo:table-cell>
   				</fo:table-row> 
   				<fo:table-row>
					<fo:table-cell>
				  		<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    				</fo:table-cell>
   				</fo:table-row> 
  			</fo:table-body>
 		  </fo:table>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <!--=========== MENSAGEM ============-->

	  	  <!--#### UC074-51 -->
		  <xsl:if test="rve/Assinaturas!=''">
 		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="rve/Assinaturas"/>
		  </xsl:if>
		  <!--xxxxxxxxxxx ITEM PRINCIPAL [7] - FIM xxxxxxxxxxx-->

		  <fo:block id="last-page"/>

        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<!--
##########################
#### CABECALHO
##########################
-->
<xsl:template match="Cabecalho">
 <xsl:variable name="tipoRelatorio">
	<xsl:value-of select="CabecalhoRow/TP_RELATORIO"/>
 </xsl:variable>

 <xsl:variable name="isCamaraIntegrada">
    <xsl:choose>
    	<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
    	<xsl:otherwise>N</xsl:otherwise>
    </xsl:choose>
 </xsl:variable>
 <!-- Variavel que determina se eh Folha Pagamento camara integrada(S) ou nao(N) -->
<xsl:variable name="isFolhaCamaraIntegrada">
        <xsl:choose>
          <xsl:when test="/rve/ListaDocumentacaoComplementar/ListaDocumentacaoComplementarRow[DS_TIPO='PAD']/SOLICITADO = 'N'">S</xsl:when>
          <xsl:otherwise>N</xsl:otherwise>
        </xsl:choose>
</xsl:variable>
 <!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
 <xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao"/> 
 <xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
 <xsl:variable name="horario" select="substring($dataHora, 12, 8)"/>
 <xsl:variable name="dia" select="substring($data, 9, 2)"/>
 <xsl:variable name="mes" select="substring($data, 6, 2)"/>
 <xsl:variable name="ano" select="substring($data, 1, 4)"/>
 <xsl:variable name="hora" select="substring($horario, 1, 2)"/>
 <xsl:variable name="minuto" select="substring($horario, 4, 2)"/>
 <xsl:variable name="segundo" select="substring($horario, 7, 2)"/>
 
 <fo:block>
   <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	<fo:table-column column-width="42pt"/>
	<fo:table-column column-width="442pt"/>
	<fo:table-column column-width="72pt"/>
	
	<fo:table-body>
	 
	 <fo:table-row>
	  <fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt"><fo:block></fo:block>
	 </fo:table-cell>
    </fo:table-row>

	<fo:table-row>
	 <fo:table-cell padding-bottom="3pt" >
	  <fo:block>
		<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}"/>
	  </fo:block>
	 </fo:table-cell>

	 <fo:table-cell >
	  <fo:block padding-bottom="1pt">
		<fo:table table-layout="fixed">
			<fo:table-column column-width="300pt"/>
			<fo:table-column column-width="112pt"/>
				
			<fo:table-body>
			  <fo:table-row>
				<fo:table-cell padding-left="15pt" padding-top="1pt" >
				  <fo:block xsl:use-attribute-sets="txtLeft">ESTADO DO RIO GRANDE DO SUL</fo:block>
				</fo:table-cell>
			   </fo:table-row>

				<fo:table-row>
					<fo:table-cell padding-left="15pt" >
						<fo:block text-align="left" xsl:use-attribute-sets="txtLeft">
							<xsl:text>TRIBUNAL DE CONTAS DO ESTADO</xsl:text>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell padding-left="15pt" number-columns-spanned="0" >
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SIAPC - Sistema de Informa&#231;&#245;es para Auditoria e Presta&#231;&#227;o de Contas</fo:block>
					</fo:table-cell>
				<!-- BARCODE -->
				<fo:table-cell number-rows-spanned="3" text-align="center">
				      <fo:block>
                        <xsl:if test="$isCamaraIntegrada='N'">
                            <fo:instream-foreign-object>
                              <barcode:barcode 
                                xmlns:barcode="http://barcode4j.krysalis.org/ns"
                                message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-rve}">
                                <barcode:code128>
                                  <barcode:height>15mm</barcode:height>
                                </barcode:code128>
                              </barcode:barcode>
                            </fo:instream-foreign-object>
                        </xsl:if>
                        <xsl:if test="$isCamaraIntegrada = 'S'">
                            <fo:instream-foreign-object>
                              <barcode:barcode 
                                xmlns:barcode="http://barcode4j.krysalis.org/ns"
                                message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-rve-leg}">
                                <barcode:code128>
                                  <barcode:height>15mm</barcode:height>
                                </barcode:code128>
                              </barcode:barcode>
                            </fo:instream-foreign-object>
                        </xsl:if>
				      </fo:block>
				</fo:table-cell>
				<!-- BARCODE -->
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell number-columns-spanned="2" padding-left="90pt">
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
							Programa Autenticador de Dados - PAD Vers&#227;o:
							<xsl:value-of select="CabecalhoRow/VERSAO_PAD"/>
							<!--# <xsl:value-of select="java:br.gov.rs.tce.pad.modelo.ConstantesDC.VERSAO_PAD_TESTID"/>-->
							<xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell padding-left="40pt" number-columns-spanned="0" >                                        
                        <xsl:choose>
							<xsl:when test="$tipoRelatorio = 'RVE_LIGHT'">
								<fo:block xsl:use-attribute-sets="txtLeft" font-weight="normal">Relat&#243;rio de Valida&#231;&#227;o e Encaminhamento - RVE - Solicita&#231;&#227;o Formal</fo:block>
							</xsl:when>
							<xsl:otherwise>
								<xsl:if test="$isCamaraIntegrada = 'N'">
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="normal">Relat&#243;rio de Valida&#231;&#227;o e Encaminhamento - RVE</fo:block>
								</xsl:if>
								<xsl:if test="$isCamaraIntegrada = 'S'">
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="normal">Relat&#243;rio de Valida&#231;&#227;o e Encaminhamento - RVE - Extra&#237;do da PM</fo:block>
								</xsl:if>
							</xsl:otherwise>
                        </xsl:choose>

					</fo:table-cell>
				</fo:table-row>
			  </fo:table-body>
			</fo:table>
		  </fo:block>
		</fo:table-cell>

		<fo:table-cell padding-top="5pt" text-align="right">
		  <!-- <fo:block>
		    <fo:table text-align="center" table-layout="fixed">
		      <fo:table-column column-width="35pt"/>
		      <fo:table-column column-width="35pt"/>
		      
		      <fo:table-body>
		        <fo:table-row>
		          <fo:table-cell number-columns-spanned="2" border-style="solid" border-width="0.25pt" space-before="0pt" space-after="0pt">
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Para uso do</fo:block>
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Tribunal de Contas</fo:block>
		          </fo:table-cell>
		        </fo:table-row>
		        <fo:table-row>
		          <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Fl.</fo:block>
		            <fo:block xsl:use-attribute-sets="txtQuadroTce"></fo:block>
		          </fo:table-cell>
		          <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		            <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Rubrica</fo:block>
		            <fo:block xsl:use-attribute-sets="txtQuadroTce"></fo:block>
		          </fo:table-cell>
		        </fo:table-row>
		      </fo:table-body>
		    </fo:table>
		 </fo:block> -->
		 <fo:block>
		   <fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}" width="42pt"/>
		 </fo:block>
		 <fo:block xsl:use-attribute-sets="txtRightShort">
		   <xsl:value-of select="$dia"/>/<xsl:value-of select="$mes"/>/<xsl:value-of select="$ano"/> - <xsl:value-of select="$hora"/>:<xsl:value-of select="$minuto"/>:<xsl:value-of select="$segundo"/>
		 </fo:block>     
		</fo:table-cell>
	 </fo:table-row>
			   
	 <fo:table-row>
	  <fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
	   <fo:block>
	    <fo:table text-align="center" width="556pt" table-layout="fixed">
			<fo:table-column column-width="281pt"/>
			<fo:table-column column-width="90pt"/>
			<fo:table-column column-width="90pt"/>
                        <fo:table-column column-width="95pt"/>
						
			<fo:table-body>
			 <fo:table-row>
			  <fo:table-cell padding-left="60pt">
                           <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CabecalhoRow/NOME"/></fo:block>
			  </fo:table-cell>
                          <fo:table-cell padding-left="5pt">
			   <fo:block xsl:use-attribute-sets="txtLeft">ORG&#195;O N&#186;: <xsl:value-of select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade"/></fo:block>
		  	  </fo:table-cell>
			  <fo:table-cell padding-left="5pt">
			   <fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="CabecalhoRow/CNPJ"/></fo:block>
		  	  </fo:table-cell>
			  <fo:table-cell>
			   <fo:block xsl:use-attribute-sets="txtRight">
			 	01/01/<xsl:value-of select="CabecalhoRow/ANO_EXERCICIO"/> a <xsl:value-of select="$periodoFinalCabecalho"/><xsl:value-of select="CabecalhoRow/ANO_EXERCICIO"/>
			   </fo:block>
			  </fo:table-cell>
		     </fo:table-row>
			</fo:table-body>
		</fo:table>
	  </fo:block>
	</fo:table-cell>
   </fo:table-row>

	  </fo:table-body>
	 </fo:table>
    </fo:block>
</xsl:template>
<!-- #### FIM - CABE&#199;ALHO ####-->

<!--
#############################################
#### UC074-01
############################################# 
-->
<xsl:template match="ListaDocumentacao">
	<!-- ************* Variaveis locais **************-->
	<xsl:variable name="isCamaraIntegrada">
		<xsl:if test="../DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:if>
		<xsl:if test="../DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'N'">N</xsl:if>
	</xsl:variable>
	
	<xsl:variable name="pmPossuiCamaraIntegrada">
		<xsl:choose>
			<xsl:when test="../DadosIniciasPM/DadosIniciasPMRow/RESPOSTAPM='S'">S</xsl:when>
			<xsl:otherwise>N</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:variable name="tipoSetorGovernamental">
		<xsl:value-of select="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV"/>
	</xsl:variable> 	

	<xsl:variable name="ehEntidadeIndiretaQueConsolida" select="(
		/rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' or
		/rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or
		/rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M')"/>

	<xsl:variable name="tipoEntregaPeriodo">
		<xsl:if test="../IdentificacaoAdministrador/IdentificacaoAdministradorRow/TP_ENTREGA='Q'">
			<xsl:if test="../Cabecalho/CabecalhoRow/MES_INFORMACOES=4 or ../Cabecalho/CabecalhoRow/MES_INFORMACOES=8 or ../Cabecalho/CabecalhoRow/MES_INFORMACOES=12">S</xsl:if>
		</xsl:if>
		<xsl:if test="../IdentificacaoAdministrador/IdentificacaoAdministradorRow/TP_ENTREGA='S'">
			<xsl:if test="../Cabecalho/CabecalhoRow/MES_INFORMACOES=6 or ../Cabecalho/CabecalhoRow/MES_INFORMACOES=12">S</xsl:if>
		</xsl:if>
	</xsl:variable>
        <xsl:variable name="isFolhaCamaraIntegrada">
                <xsl:choose>
                  <xsl:when test="../ListaDocumentacaoComplementar/ListaDocumentacaoComplementarRow[DS_TIPO='PAD']/SOLICITADO = 'N'">S</xsl:when>
                  <xsl:otherwise>N</xsl:otherwise>
                </xsl:choose>
        </xsl:variable>
	<!-- ************* Variaveis locais **************-->
	
	<!--
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	-->

	<fo:block>
		<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="120pt"/>
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="120pt"/>
			<fo:table-body>
 			  <xsl:for-each select="ListaDocumentacaoRow">
			    <xsl:if test="$isCamaraIntegrada='S' or $tipoSetorGovernamental='P' or $tipoSetorGovernamental='C' or $ehEntidadeIndiretaQueConsolida">
				<fo:table-row>
					<fo:table-cell padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left" id="RVE_0_1"><xsl:text>Neste RVE est&#227;o inclu&#237;dos:</xsl:text></fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtCenter"><xsl:text>Sim</xsl:text></fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtCenter"><xsl:text>N&#227;o</xsl:text></fo:block>
					</fo:table-cell>
				</fo:table-row>
				</xsl:if>

				<xsl:if test="$tipoSetorGovernamental='P'">
				<fo:table-row>
					<fo:table-cell padding-left="20pt">
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>Modelos da LRF do Executivo</xsl:text></fo:block>
					</fo:table-cell>
					<xsl:if test="LRF_EXECUTIVO='S' and $tipoEntregaPeriodo='S'">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
					<xsl:if test="LRF_EXECUTIVO='S' and $tipoEntregaPeriodo=''">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
					<xsl:if test="LRF_EXECUTIVO='N'">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
				 </fo:table-row>
				 </xsl:if>
				
				 <xsl:if test="$tipoSetorGovernamental='C'">
				 <fo:table-row>
					<fo:table-cell padding-left="20pt">
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>Modelos da LRF do Legislativo</xsl:text></fo:block>
					</fo:table-cell>
					<xsl:if test="LRF_LEGISLATIVO='S'">
						<xsl:if test="($isCamaraIntegrada='S' or $isCamaraIntegrada='') and ($tipoEntregaPeriodo='S' or $tipoEntregaPeriodo='Q')">
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
							</fo:table-cell>
						</xsl:if>
						<xsl:if test="($isCamaraIntegrada='S' or $isCamaraIntegrada='') and $tipoEntregaPeriodo=''">
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
							</fo:table-cell>
						</xsl:if>
						<xsl:if test="$isCamaraIntegrada='N'">
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
							</fo:table-cell>
						</xsl:if>
					</xsl:if>
					<xsl:if test="LRF_LEGISLATIVO='N'">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
			 	 </fo:table-row>
				 </xsl:if>

				 <xsl:if test="$ehEntidadeIndiretaQueConsolida">
				 <fo:table-row>
					<fo:table-cell padding-left="20pt">
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>Modelos da LRF de Autarquia, Funda&#231;&#227;o, Empresa P&#250;blica - Regida pela Lei 4.320/64</xsl:text></fo:block>
					</fo:table-cell>
					<xsl:if test="AUTARQUIA_FUNDACAO='S' and $tipoEntregaPeriodo='S'">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
					<xsl:if test="AUTARQUIA_FUNDACAO='S' and $tipoEntregaPeriodo=''">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
					<xsl:if test="AUTARQUIA_FUNDACAO='N'">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
				 </fo:table-row>
				 </xsl:if>

				 <xsl:if test="$tipoSetorGovernamental='P' or $ehEntidadeIndiretaQueConsolida">
				 <fo:table-row>
					<fo:table-cell padding-left="20pt">
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>Dever&#225; ser consolidado para fins de LRF</xsl:text></fo:block>
					</fo:table-cell>
					<xsl:if test="CONSOLIDA='S'">
						<xsl:choose>
						 <xsl:when test="$tipoEntregaPeriodo='S'">
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
							</fo:table-cell>
						 </xsl:when>
						 <xsl:otherwise>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
							</fo:table-cell>
						 </xsl:otherwise>
						</xsl:choose>
					</xsl:if>
					<xsl:if test="CONSOLIDA='N'">
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
						</fo:table-cell>
					</xsl:if>
				 </fo:table-row>
				</xsl:if>
			  </xsl:for-each>
			</fo:table-body>
		</fo:table>
	</fo:block>
</xsl:template>
<!-- #### FIM - UC074-01 ####-->


<xsl:template match="ListaDocumentacaoComplementar">
	<fo:block>
		<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="120pt"/>
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="30pt"/>
		<fo:table-column column-width="60pt"/>
		<fo:table-column column-width="60pt"/>
		<fo:table-body>
		 
			<fo:table-row>
				<fo:table-cell padding-left="10pt">
					<fo:block xsl:use-attribute-sets="titNegrito" text-align="left" id="RVE_0_1"><xsl:text>Neste RVE est&#227;o inclu&#237;dos:</xsl:text></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><xsl:text>Sim</xsl:text></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><xsl:text>N&#227;o</xsl:text></fo:block>
				</fo:table-cell>
			</fo:table-row>	

		 <xsl:for-each select="ListaDocumentacaoComplementarRow">	
			
			<xsl:variable name="checkSim">
				<xsl:if test="SOLICITADO='S'">check.jpg</xsl:if>
				<xsl:if test="SOLICITADO='N'">uncheck.jpg</xsl:if>
			</xsl:variable>
			<xsl:variable name="checkNao">
				<xsl:if test="SOLICITADO='S'">uncheck.jpg</xsl:if>
				<xsl:if test="SOLICITADO='N'">check.jpg</xsl:if>
			</xsl:variable>
	
			<fo:table-row>
				<fo:table-cell padding-left="20pt">
					<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_TIPO"/></fo:block>
				</fo:table-cell>					
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS, $checkSim)}"/></fo:block>
				</fo:table-cell>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:external-graphic space-after.optimum="1pt" space-before.optimum="1pt" content-width="10px" alignment-baseline="before-edge" src="{concat($PATH_IMAGENS, $checkNao)}"/></fo:block>
				</fo:table-cell>
				<!-- <xsl:if test="SOLICITADO='S'">
					<xsl:variable name="formatter" select="java:java.text.SimpleDateFormat.new('yyyy-MM-dd')" />
					<xsl:variable name="data" select="java:parse($formatter, DT_SOLICITACAO)"/>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>Solicitacao Formal Nro: </xsl:text>
						<xsl:value-of select="NR_SOLICITACAO"/>	</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:text>Data: </xsl:text>
						<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), $data)"/>
						</fo:block>
					</fo:table-cell>
				</xsl:if>-->
			 </fo:table-row>
			
           </xsl:for-each>  

         </fo:table-body>
       </fo:table>
	</fo:block>
</xsl:template>

<!--
#############################################
#### UC074-02
############################################# 
-->
<xsl:template match="IdentificacaoAdministrador">
 <!-- ************* Variaveis locais **************-->
 <xsl:variable name="isCamaraIntegrada">
	<xsl:choose>
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
 </xsl:variable>  
<!-- Variavel que determina se eh Folha Pagamento camara integrada(S) ou nao(N) -->
<xsl:variable name="isFolhaCamaraIntegrada">
        <xsl:choose>
          <xsl:when test="/rve/ListaDocumentacaoComplementar/ListaDocumentacaoComplementarRow[DS_TIPO='PAD']/SOLICITADO = 'N'">S</xsl:when>
          <xsl:otherwise>N</xsl:otherwise>
        </xsl:choose>
</xsl:variable>
 <xsl:variable name="presidenteCamara">
 	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'C'"><xsl:value-of select="IdentificacaoAdministradorRow/NOME_RESPONSAVEL"/></xsl:if>
 	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'P' and ../DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'"><xsl:value-of select="IdentificacaoAdministradorRow/NOME_PRESIDENTE_CAM"/></xsl:if>
 </xsl:variable>

 <xsl:variable name="tipoRelatorio">
	<xsl:value-of select="../Cabecalho/CabecalhoRow/TP_RELATORIO"/>
 </xsl:variable>
 
 <xsl:variable name="tpEntrega">
 	<xsl:if test="IdentificacaoAdministradorRow/TP_ENTREGA = 'S'">Semestral</xsl:if>
	<xsl:if test="IdentificacaoAdministradorRow/TP_ENTREGA = 'Q'">Quadrimestral</xsl:if>
 </xsl:variable>
 
 <!-- <xsl:variable name="periodoFinal">
  <xsl:choose> 
    <xsl:when test="$tipoRelatorio = 'RVE_LIGHT'"><xsl:value-of select="substring(IdentificacaoAdministradorRow/DT_FINAL_COMPL, 9, 2)"/>/<xsl:value-of select="substring(IdentificacaoAdministradorRow/DT_FINAL_COMPL, 6, 2)"/>/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/></xsl:when>
        <xsl:otherwise> 
          <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 1">
                <xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
                <xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
          </xsl:if>
          <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 2">30/04/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
          <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 3">30/06/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
          <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 4">31/08/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
          <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 5">31/10/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
          <xsl:if test="IdentificacaoAdministradorRow/PERIODO_INFORMACOES = 6">31/12/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> - <xsl:value-of select="IdentificacaoAdministradorRow/PERIODO_INFORMACOES"/>&#186; Bimestre</xsl:if>
       </xsl:otherwise> 
    </xsl:choose>
 </xsl:variable> -->
 
 <!-- ************* Variaveis locais **************-->

	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_1">1.1 Dados Cadastrais da Administra&#231;&#227;o Atual</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="IdentificacaoAdministradorRow/CNPJ"/></fo:block>
	
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="278pt"/>
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">Per&#237;odo: 01/01/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> a <xsl:value-of select="$periodoFinalCabecalho"/><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/></fo:block>
			</fo:table-cell>	
			<fo:table-cell>
				<xsl:if test="($tipoRelatorio != 'RVE_LIGHT' and 
                                                           (../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'P' or
						  	   ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'C' or
							   ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'A' or
							   ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'F' or
							   isCamaraIntegrada='S')
							  and $ehEntregaLrf)">
					<fo:block xsl:use-attribute-sets="txtLeft">Tipo de entrega: <xsl:value-of select="$tpEntrega"/></fo:block>
				</xsl:if>
			</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	
	
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A' 
	              or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'
	              or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
		<fo:block xsl:use-attribute-sets="txtLeft">Munic&#237;pio: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_MUNICIPIO"/></fo:block>
	</xsl:if>  

	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
		<fo:block xsl:use-attribute-sets="txtLeft">Prefeitura: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block xsl:use-attribute-sets="txtLeft">C&#226;mara: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A'">
		<fo:block xsl:use-attribute-sets="txtLeft">Autarquia: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F' or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'">
		<fo:block xsl:use-attribute-sets="txtLeft">Funda&#231;&#227;o: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E' or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M'">
		<fo:block xsl:use-attribute-sets="txtLeft">Empresa: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O' or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
		<fo:block xsl:use-attribute-sets="txtLeft">Cons&#243;rcio: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_ENTIDADE"/></fo:block>
	</xsl:if>
	
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="48pt"/>
		<fo:table-column column-width="120pt"/>
		<fo:table-column column-width="110pt"/>

	<fo:table-body>
	<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Logradouro: <xsl:value-of select="IdentificacaoAdministradorRow/LOGRADOURO"/></fo:block>	
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">nr: <xsl:value-of select="IdentificacaoAdministradorRow/NR"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">compl: <xsl:value-of select="IdentificacaoAdministradorRow/COMPL"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Telefone: <xsl:value-of select="IdentificacaoAdministradorRow/TELEFONE"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="278pt"/>
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">HomePage: <xsl:value-of select="IdentificacaoAdministradorRow/HOMEPAGE"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">E-Mail: <xsl:value-of select="IdentificacaoAdministradorRow/EMAIL"/></fo:block>
			</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	
		
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
		<fo:block xsl:use-attribute-sets="txtLeft">Prefeito Municipal: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_RESPONSAVEL"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='A'
	              or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='F'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='E'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='M'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='O'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='T'
				  or ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='S'">
		<fo:block xsl:use-attribute-sets="txtLeft">Respons&#225;vel: <xsl:value-of select="IdentificacaoAdministradorRow/NOME_RESPONSAVEL"/></fo:block>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block xsl:use-attribute-sets="txtLeft">Presidente da C&#226;mara Municipal: <xsl:value-of select="$presidenteCamara"/></fo:block>
	</xsl:if>

	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="278pt"/>
		<fo:table-column column-width="278pt"/>
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">Contabilista: <xsl:value-of select="IdentificacaoAdministradorRow/CONTABILISTA"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#250;mero do CRC: <xsl:value-of select="IdentificacaoAdministradorRow/CRC"/></fo:block>
			</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
	</fo:table>	
	
	<fo:block><fo:leader leader-pattern="space" /></fo:block>
</xsl:template>
<!-- #### FIM - UC074-02 ####-->

<!--
#############################################
#### UC074-03
############################################# 
-->
<xsl:template match="PrestadoraServicosInformatica">

	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_2">1.2 Prestadora de Servi&#231;os de Inform&#225;tica</fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>
		
	<xsl:if test="PrestadoraServicosInformaticaRow/NAO_POSSUI='S'">
		<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
			<fo:table-column column-width="16pt"  column-number="1"/>
			<fo:table-column column-width="270pt" column-number="2"/>
			<fo:table-column column-width="270pt" column-number="3"/>
		<fo:table-body>	
		<fo:table-row>
			<fo:table-cell number-columns-spanned="1">
				<fo:block xsl:use-attribute-sets="txtLeft"><fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
			</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Possui Prestadora de Servi&#231;os de Inform&#225;tica</fo:block>
			</fo:table-cell>
		</fo:table-row>
	   </fo:table-body>
	  </fo:table>
	</xsl:if>
	<xsl:if test="PrestadoraServicosInformaticaRow/NAO_POSSUI='N'">
		<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
			<fo:table-column column-width="16pt"  column-number="1"/>
			<fo:table-column column-width="270pt" column-number="2"/>
			<fo:table-column column-width="270pt" column-number="3"/>
		<fo:table-body>	
		<fo:table-row>
			<fo:table-cell number-columns-spanned="1">
				<fo:block xsl:use-attribute-sets="txtLeft"><fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></fo:block>
			</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Possui Prestadora de Servi&#231;os de Inform&#225;tica</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell>
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
			</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft">Nome: <xsl:value-of select="PrestadoraServicosInformaticaRow/NOME"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell>
				<fo:block><fo:leader leader-pattern="space" /></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="PrestadoraServicosInformaticaRow/CNPJ"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">Telefone: <xsl:value-of select="PrestadoraServicosInformaticaRow/TELEFONE"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell>
				<fo:block><fo:leader leader-pattern="space"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">Respons&#225;vel: <xsl:value-of select="PrestadoraServicosInformaticaRow/RESPONSAVEL"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">E-Mail: <xsl:value-of select="PrestadoraServicosInformaticaRow/EMAIL"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
	  </fo:table-body>
	 </fo:table>
	</xsl:if>
	
	<fo:block><fo:leader leader-pattern="space" /></fo:block>
</xsl:template>
<!-- #### FIM - UC074-03 ####-->

<!--
#############################################
#### UC074-04
############################################# 
-->
<xsl:template match="SistemasInformatizados">

	<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_3">1.3 Sistemas Informatizados</fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
		
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	 <fo:table-column column-width="16pt"  column-number="1"/>
	 <fo:table-column column-width="340pt" column-number="2"/>
	 <fo:table-column column-width="200pt" column-number="3"/>

	<fo:table-body>	
	  <xsl:for-each select="SistemasInformatizadosRow">
		<fo:table-row border-bottom-width="0.001pt" border-top-width="0.001pt">
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:if test="RESPOSTA='S'">
		    <xsl:if test="PERGUNTA='Outros' and TEXTO='N'"><fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/></xsl:if>
			<xsl:if test="PERGUNTA='Outros' and TEXTO!='N'"><fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></xsl:if>
			<xsl:if test="PERGUNTA!='Outros'"><fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></xsl:if>
		   </xsl:if>
		   <xsl:if test="RESPOSTA='N'">
			<fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/>
		   </xsl:if>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
 	       <fo:inline>
		    <xsl:value-of select="PERGUNTA"/>
		    <xsl:if test="PERGUNTA='Outros' and TEXTO!='N'">: <xsl:value-of select="TEXTO"/></xsl:if>
		   </fo:inline>
		  </fo:block>
		 </fo:table-cell>
		</fo:table-row>
	  </xsl:for-each>
	 </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-04 ####-->

<!--
#############################################
#### UC074-05
############################################# 
-->
<!--########## PREFEITURA ##############-->
<xsl:template match="DadosIniciasPM">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_4_DESATIVADO">
	  <xsl:text>1.4 Dados Iniciais </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="543pt"/>
  <fo:table-body>
   <xsl:for-each select="DadosIniciasPMRow">
	<fo:table-row>
	 <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
	  <fo:block xsl:use-attribute-sets="txtLeft">
	   <xsl:if test="RESPOSTAPM='S'">
		 <fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/>
	   </xsl:if>
	   <xsl:if test="RESPOSTAPM='N'">
		<fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/>
	   </xsl:if>
		<xsl:text> As informa&#231;&#245;es do Poder Legislativo est&#227;o sendo geradas junto com as do Poder Executivo e constam no 'RVE da CM Extra&#237;do da PM'.</xsl:text>
	  </fo:block>
	 </fo:table-cell>
	</fo:table-row>
   </xsl:for-each>
  </fo:table-body>
 </fo:table>

</xsl:template>

<!--########## AUTARQUIA ou FUNDACAO ##############-->
<xsl:template match="DadosIniciaisAut">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_4">
	  <xsl:text>1.4 Dados Iniciais </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
 	<fo:table-column column-number="1" column-width="556pt"/>

  	<fo:table-body>
  	 <xsl:for-each select="DadosAut/DadosAutRow">
    	<fo:table-row>
     		<fo:table-cell border-width="0.5pt">
	  			<fo:block xsl:use-attribute-sets="txtLeft">
	   				<xsl:if test="RESPOSTA='S'">
	     				<fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/>
	   				</xsl:if>
	   				<xsl:if test="RESPOSTA='N'">
	 					<fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'uncheck.jpg')}"/>
	   				</xsl:if>
	   				<xsl:text> A entidade &#233; Regime Pr&#243;prio de Previd&#233;ncia (RPPS).</xsl:text>
	  			</fo:block>
	 		</fo:table-cell>
    	</fo:table-row>
	 </xsl:for-each>
   	
	<xsl:if test="DadosAut!='' and JustificaAut!=''">
     <fo:table-row>
    	<fo:table-cell border-width="0.5pt">
	  		<fo:block xsl:use-attribute-sets="txtLeft">
	  			<xsl:text>JUSTIFICATIVAS: </xsl:text>
	  		</fo:block>
	 	</fo:table-cell>
     </fo:table-row>

     <xsl:for-each select="JustificaAut/JustificaAutRow">
     <fo:table-row>
    	<fo:table-cell border-width="0.5pt">
	   		<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
				<xsl:value-of select="TEXTO"/>
	   		</fo:block>
	  	</fo:table-cell>
     </fo:table-row>
     </xsl:for-each>
    </xsl:if>
  </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-05 ####-->

<!--
#############################################
#### UC074-06
############################################# 
-->
<xsl:template match="PublicacaoRelatoriosResumidos">
 <!-- ************* Variaveis locais **************-->
 <!--
 <xsl:variable name="bimestre">
	<xsl:value-of select="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES"/>
 </xsl:variable>
 -->
 <!-- ************* Variaveis locais **************-->

 <fo:block  xsl:use-attribute-sets="titFCinza" id="RVE_5_1_1">5.1.1 Data e Forma de Publica&#231;&#227;o dos Relat&#243;rios Resumidos da Execu&#231;&#227;o Or&#231;ament&#225;ria  - art. 52 da LRF</fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="256pt"/>

	<fo:table-body>
	 <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="titNegritoLeft">Per&#237;odo</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="titNegritoLeft">Tipo</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="titNegritoLeft">Data</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="titNegritoLeft">Forma Publica&#231;&#227;o</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	
	 <!--### 1 BIMESTRE ###-->	 
	  <xsl:if test="$bimestre &gt;= 1">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">1&#186; Bimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='M']/PERIODO=1 and PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		  </xsl:when>
		  <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='J']/PERIODO=1 and PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		  </xsl:when>
		  <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='I']/PERIODO=1 and PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=1 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>
	  </xsl:if>
 
	  <!--### 2 BIMESTRE ###-->
	  <xsl:if test="$bimestre &gt;= 2">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">2&#186; Bimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='M']/PERIODO=2 and PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='J']/PERIODO=2 and PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='I']/PERIODO=2 and PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=2 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	  </xsl:if>
	  
	  <!--### 3 BIMESTRE ###-->
	  <xsl:if test="$bimestre &gt;= 3">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">3&#186; Bimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='M']/PERIODO=3 and PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='J']/PERIODO=3 and PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='I']/PERIODO=3 and PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=3 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	  </xsl:if>
	  
	  <!--### 4 BIMESTRE ###-->
	  <xsl:if test="$bimestre &gt;= 4">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">4&#186; Bimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='M']/PERIODO=4 and PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='J']/PERIODO=4 and PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='I']/PERIODO=4 and PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=4 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>
	  </xsl:if>
	  
	  <!--### 5 BIMESTRE ###-->
	  <xsl:if test="$bimestre &gt;= 5">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">5&#186; Bimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='M']/PERIODO=5 and PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='J']/PERIODO=5 and PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='I']/PERIODO=5 and PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=5 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>
	  </xsl:if>
	  
	  <!--### 6 BIMESTRE ###-->
	  <xsl:if test="$bimestre &gt;= 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">6&#186; Bimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='M']/PERIODO=6 and PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='J']/PERIODO=6 and PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='I']/PERIODO=6 and PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoRelatoriosResumidosRow[PERIODO=6 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>
	  </xsl:if>

	</fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-06 ####-->

<!--
#############################################
#### UC074-07
############################################# 
-->
<xsl:template match="PublicacaoGestaoFiscalExec">
 <!-- ************* Variaveis locais **************-->
 <!--
 <xsl:variable name="bimestre">
	<xsl:value-of select="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES"/>
 </xsl:variable>
 -->

 <xsl:variable name="tipoEntrega">
	<xsl:value-of select="../IdentificacaoAdministrador/IdentificacaoAdministradorRow/TP_ENTREGA"/>
 </xsl:variable>
 <!-- ************* Variaveis locais **************-->

 <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_1_2">5.1.2 Data e forma de Publica&#231;&#227;o dos Relat&#243;rios da Gest&#227;o Fiscal - Poder Executivo e Indiretas - &#167; 2&#186; do art. 55 da LRF</fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="256pt"/>

	<fo:table-body>
		<fo:table-row>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="titNegritoLeft">Per&#237;odo</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="titNegritoLeft">Tipo</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="titNegritoLeft">Data</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="titNegritoLeft">Forma Publica&#231;&#227;o</fo:block>
			</fo:table-cell>
		</fo:table-row>
 	  
	  <!--###### SEMESTRE ######-->
	  <xsl:if test="$tipoEntrega = 'S'">

	   <!--###### 3, 4 e 6 BIMESTRE ######-->
	   <xsl:if test="$bimestre = 3 or $bimestre = 4 or $bimestre = 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">1&#186; Semestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	   </xsl:if>

	  <!--### 6 BIMESTRE ###-->
	   <xsl:if test="$bimestre = 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">2&#186; Semestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=2]/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=2]/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=2]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=2]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=2]/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=2]/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=2]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=2]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=2]/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=2]/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=2]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=2]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	   </xsl:if>

	   <xsl:if test="$bimestre = 3 or $bimestre = 4 or $bimestre = 6">
	   <!--*** 1 QUADRIMESTRE ***-->
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">1&#186; Quadrimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=1]/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=1]/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=1]/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	
	   </xsl:if>

	   <xsl:if test="$bimestre = 6">
	   <!--*** 2 QUADRIMESTRE ***-->
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">2&#186; Quadrimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=2]/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=2]/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=2]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='M' and PERIODO=2]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=2]/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=2]/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=2]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='J' and PERIODO=2]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=2]/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=2]/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=2]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and TP_PUBLICACAO='I' and PERIODO=2]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	   </xsl:if>
	  </xsl:if>
	  <!--###### SEMESTRE ######-->


	  <!--###### QUADRIMESTRE ######-->
	  <xsl:if test="$tipoEntrega = 'Q'">
	  
	  <!--*** semestres ***-->
	  <!--### 3 BIMESTRE ###-->
	  <xsl:if test="$bimestre = 3 or $bimestre = 4 or $bimestre = 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">1&#186; Semestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='M' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='J' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='S' and TP_PUBLICACAO='I' and PERIODO=1]/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	   </xsl:if>
	   
	   <!--*** quadrimestres ***-->
	   <!--### 2 BIMESTRE ###-->
	   <xsl:if test="$bimestre = 2 or $bimestre = 3 or $bimestre = 4 or $bimestre = 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">1&#186; Quadrimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='M']/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='J']/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='I']/PERIODO=1 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=1 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>	  
	   </xsl:if>
	   	  
	  <!--### 4 BIMESTRE ###-->
	  <xsl:if test="$bimestre = 4 or $bimestre = 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">2&#186; Quadrimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='M']/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='J']/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='I']/PERIODO=2 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=2 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>
	  </xsl:if>
  
	  <!--### 6 BIMESTRE ###-->
	  <xsl:if test="$bimestre = 6">
	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">3&#186; Quadrimestre</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Mural</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='M']/PERIODO=3 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='M']/TP_PUBLICACAO='M'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='M']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='M']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Jornal</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='J']/PERIODO=3 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='J']/TP_PUBLICACAO='J'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='J']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='J']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">Internet</fo:block>
		</fo:table-cell>
		 <xsl:choose>
       	  <xsl:when test="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='I']/PERIODO=3 and PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='I']/TP_PUBLICACAO='I'">
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='I']/DT_PUBLICACAO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt"><xsl:value-of select="PublicacaoGestaoFiscalExecRow[TP_PERIODO='Q' and PERIODO=3 and TP_PUBLICACAO='I']/DESCRICAO"/></fo:block>
			</fo:table-cell>
		 </xsl:when>
		 <xsl:otherwise>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="txtLeft">N&#227;o Publicado</fo:block>
			</fo:table-cell>
		  </xsl:otherwise>
		 </xsl:choose>
	   </fo:table-row>
	  </xsl:if>
	  </xsl:if>

	</fo:table-body>
  </fo:table>
</xsl:template>
<!-- #### FIM - UC074-07 ####-->

<!--
#############################################
#### UC074-08
############################################# 
-->
<xsl:template match="LimitesConstitucionaisLegislativo">
	<fo:block  xsl:use-attribute-sets="titFCinza" id="RVE_3_1_1">3.1.1 Limites Constitucionais do Legislativo - artigo 29 da CF/88 </fo:block>
 	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<fo:block xsl:use-attribute-sets="txtLeft">N&#250;mero de Habitantes: <xsl:value-of select="LimitesConstitucionaisLegislativoRow/NRO_HABITANTES"/></fo:block>
	<fo:block xsl:use-attribute-sets="txtLeft">N&#250;mero  da Lei que Fixou o Subs&#237;dio: <xsl:value-of select="LimitesConstitucionaisLegislativoRow/NRO_LEI_SUBSIDIO"/></fo:block>
	<fo:block xsl:use-attribute-sets="txtLeft">N&#250;mero de Vereadores: <xsl:value-of select="LimitesConstitucionaisLegislativoRow/QTD_VEREADORES"/></fo:block>
	<fo:block xsl:use-attribute-sets="txtLeft">Fonte: <xsl:value-of select="LimitesConstitucionaisLegislativoRow/FONTE"/></fo:block>
</xsl:template>
<!-- #### FIM - UC074-08 ####-->

<!--
#############################################
#### UC074-09
############################################# 
-->
<xsl:template match="LimiteLegalIncisoVI">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodo" select="../Cabecalho/CabecalhoRow/MES_INFORMACOES"/>
<!-- <xsl:variable name="periodo">
 <xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=1">2</xsl:if>
 <xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=2">4</xsl:if>
 <xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=3">6</xsl:if>
 <xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=4">8</xsl:if>
 <xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=5">10</xsl:if>
 <xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=6">12</xsl:if>
</xsl:variable> -->
<!-- ************* Variaveis locais **************-->

 <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_1_2">3.1.2 Verifica&#231;&#227;o do Limite Legal conforme disposto no inciso VI do artigo 29 da CF </fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" table-layout="fixed" margin-left="2pt" margin-right="2pt">
  <fo:table-column column-number="1" column-width="50pt"/>
  <fo:table-column column-number="2" column-width="101pt"/>
  <fo:table-column column-number="3" column-width="101pt"/>
  <fo:table-column column-number="4" column-width="101pt"/>
  <fo:table-column column-number="5" column-width="101pt"/>
  <fo:table-column column-number="6" column-width="101pt"/>
 <fo:table-body>
	<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				<xsl:text>M&#233;s</xsl:text>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				<xsl:text>Subs&#237;dio Dep. Estadual RS (A)</xsl:text>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				<xsl:text>Subs&#237;dio M&#225;ximoVereador (B) </xsl:text><xsl:value-of select="format-number(LimiteLegalIncisoVIRow/PERCENTUAL,'###.###.##0,00')"/><xsl:text>% sobre (A)</xsl:text>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				<xsl:text>Subs&#237;dio Fixado - Presidente / 13&#186; subs&#237;dio (C)</xsl:text>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				<xsl:text>Subs&#237;dio Fixado - Vereador / 13&#186; subs&#237;dio (D)</xsl:text>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				<xsl:text>Excesso ao Subs&#237;dio M&#225;ximo (E) [C > B]</xsl:text>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<xsl:for-each select="LimiteLegalIncisoVIRow[MES &lt;= $periodo]">
	  <fo:table-row>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:if test="MES=1">Janeiro</xsl:if>
				<xsl:if test="MES=2">Fevereiro</xsl:if>
				<xsl:if test="MES=3">Mar&#231;o</xsl:if>
				<xsl:if test="MES=4">Abril</xsl:if>
				<xsl:if test="MES=5">Maio</xsl:if>
				<xsl:if test="MES=6">Junho</xsl:if>
				<xsl:if test="MES=7">Julho</xsl:if>
				<xsl:if test="MES=8">Agosto</xsl:if>
				<xsl:if test="MES=9">Setembro</xsl:if>
				<xsl:if test="MES=10">Outubro</xsl:if>
				<xsl:if test="MES=11">Novembro</xsl:if>
				<xsl:if test="MES=12">Dezembro</xsl:if>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_SUBSIDIO_DEPUTADO,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_SUBSIDIO_VEREADOR_CALC,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_SUBSIDIO_PRESIDENTE,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(VLR_SUBSIDIO_VEREADOR,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(EXCESSO_SUBSIDIO,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
	  </fo:table-row>
	</xsl:for-each>

	<fo:table-row>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft">
			<xsl:text>13o. Subs&#237;dio</xsl:text></fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(LimiteLegalIncisoVIRow[MES = 12]/VLR_13_DEPUTADO,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(LimiteLegalIncisoVIRow[MES = 12]/VLR_13_VEREADOR_CALC,'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(sum(LimiteLegalIncisoVIRow[MES &lt;= $periodo]/VLR_13_PRESIDENTE),'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="format-number(sum(LimiteLegalIncisoVIRow[MES &lt;= $periodo]/VLR_13_VEREADOR),'###.###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell padding-right="10pt">
			<xsl:if test="sum(LimiteLegalIncisoVIRow[MES &lt;= $periodo]/VLR_13_PRESIDENTE) &gt; LimiteLegalIncisoVIRow[MES = 12]/VLR_13_VEREADOR_CALC">
				<fo:block xsl:use-attribute-sets="txtRight">
					<xsl:value-of select="format-number((sum(LimiteLegalIncisoVIRow[MES &lt;= $periodo]/VLR_13_PRESIDENTE)-LimiteLegalIncisoVIRow[MES = 12]/VLR_13_VEREADOR_CALC),'###.###.##0,00')"/>
				</fo:block>
			</xsl:if>
			<xsl:if test="sum(LimiteLegalIncisoVIRow[MES &lt;= $periodo]/VLR_13_PRESIDENTE) &lt;= LimiteLegalIncisoVIRow[MES = 12]/VLR_13_VEREADOR_CALC">
				<fo:block xsl:use-attribute-sets="txtRight">
					<xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
				</fo:block>
			</xsl:if>
		</fo:table-cell>
	</fo:table-row>
 </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-09 ####-->

<!--
#############################################
#### UC074-10
############################################# 
-->
<xsl:template match="ReceitasMunicipioIncisoVII">
 <!-- ************* Variaveis locais **************-->
 <xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="DeducoesPM/DeducoesPMRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
 </xsl:variable>

 <xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="DeducoesPM/DeducoesPMRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
 </xsl:variable>
	<xsl:variable name="isCamaraIntegrada">
		<xsl:choose>
			<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
			<xsl:otherwise>N</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
 <!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_7_1">
	  <xsl:text>3.7.1 Receita do Munic&#237;pio - Base de c&#225;lculo do inciso VII do artigo 29 da CF </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Cod. Conta </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
	  <xsl:for-each select="ContasPM/ContasPMRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:value-of select="CD_CONTA"/>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell padding-left="5pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:value-of select="DSCONTA"/>
		 </fo:block>
	    </fo:table-cell>	    
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </xsl:for-each>

	  <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="totalLeft">Subtotal I</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_CONTABIL)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_AJUSTADO)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  <fo:table-row>
	    <fo:table-cell>
	      <fo:block><fo:leader leader-pattern="space"/></fo:block>
	    </fo:table-cell>
	  </fo:table-row>

	  <xsl:if test="DeducoesPM/DeducoesPMRow/AUTOMATICA='S'">
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:text>DEDU&#199;&#213;ES DA RECEITA</xsl:text>
		 </fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Cod. Conta </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(DeducoesPM/DeducoesPMRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="DeducoesPM/DeducoesPMRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	 </xsl:if>

	  <xsl:if test="DeducoesPM/DeducoesPMRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:text>DEDU&#199;&#213;ES DA RECEITA</xsl:text>
		 </fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Cod. Conta </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	    <xsl:for-each select="DeducoesPM/DeducoesPMRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>
	  <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="totalLeft">Subtotal II</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((- sum(DeducoesPM/DeducoesPMRow/VLR_CONTABIL)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((- sum(DeducoesPM/DeducoesPMRow/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((- sum(DeducoesPM/DeducoesPMRow/VLR_AJUSTADO)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  <fo:table-row>
	    <fo:table-cell>
	      <fo:block><fo:leader leader-pattern="space"/></fo:block>
	    </fo:table-cell>
	  </fo:table-row>

	  <!--
      <xsl:if test="count(PerdasPM/PerdasPMRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="totalLeft">Subtotal</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_CONTABIL) - sum(DeducoesPM/DeducoesPMRow/VLR_CONTABIL)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_AJUSTE) - sum(DeducoesPM/DeducoesPMRow/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_AJUSTADO) - sum(DeducoesPM/DeducoesPMRow/VLR_AJUSTADO)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
      </xsl:if>
	  -->
	   
	   
	   	<xsl:for-each select="PerdasPM/PerdasPMRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<!--xsl:value-of select="CD_CONTA"/-->
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="totalLeft">Receita Total do Municpio</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_CONTABIL) - sum(DeducoesPM/DeducoesPMRow/VLR_CONTABIL) + sum(PerdasPM/PerdasPMRow/VLR_CONTABIL)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_AJUSTE) - sum(DeducoesPM/DeducoesPMRow/VLR_AJUSTE) + sum(PerdasPM/PerdasPMRow/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(ContasPM/ContasPMRow/VLR_AJUSTADO) - sum(DeducoesPM/DeducoesPMRow/VLR_AJUSTADO) + sum(PerdasPM/PerdasPMRow/VLR_AJUSTADO) ), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>
 </xsl:if>

 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="100pt"/>
	  <fo:table-column column-number="2" column-width="100pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	    	<xsl:if test="$isCamaraIntegrada='N'">
				<fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Valor Digitado</fo:block>
			</xsl:if>
			<xsl:if test="$isCamaraIntegrada='S'">
				<fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Valor extra&#237;do da PM</fo:block>
			</xsl:if>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	  <fo:table-body>
		<xsl:for-each select="ContasCM/ContasCMRow">
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:value-of select="DS_CONTA"/>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
		</fo:table-row>
		</xsl:for-each>
	 </fo:table-body>
	</fo:table>
 </xsl:if>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
  <xsl:if test="count(Justificativa/JustificativaRow) &gt; 0 and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
    <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
      <fo:table-column column-number="1"/>
      <fo:table-body>
        <fo:table-row>
          <fo:table-cell>
            <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_1_3_1">
              <xsl:text>3.1.3.1 Justificativa da Sele&#231;&#227;o/Ajuste na Receita do Munic&#237;pio </xsl:text>
            </fo:block>
          </fo:table-cell>
        </fo:table-row>
      </fo:table-body>
    </fo:table>
    
    <fo:block><fo:leader leader-pattern="space"/></fo:block>
    
    <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
      <fo:table-column column-number="1" column-width="316pt"/>
      <fo:table-column column-number="2" column-width="240pt"/>
  
      <fo:table-body>
        <xsl:for-each select="Justificativa/JustificativaRow">
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="TEXTO"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:for-each>
      </fo:table-body>
    </fo:table>
  </xsl:if>

</xsl:template>
<!-- #### FIM - UC074-10 ####-->

<!--
#############################################
#### UC074-11
############################################# 
-->
<xsl:template match="RemuneracaoVereadores">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='S' and CD_TIPO='20' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='N' and CD_TIPO='20' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='S' and CD_TIPO!='22' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual2">
	<xsl:variable name="aux4">			
		<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='N' and CD_TIPO='22' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux4!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_1_4">
	  <xsl:text>3.1.4 Remunera&#231;&#227;o dos Vereadores</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;digo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Especifica&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
	  <xsl:if test="RemuneracaoVereadoresRow/AUTOMATICA='S'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(RemuneracaoVereadoresRow[AUTOMATICA='S' and CD_TIPO='20' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
	    <xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='S' and CD_TIPO='20' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>

	  <xsl:if test="RemuneracaoVereadoresRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='N' and CD_TIPO='20' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>
	   
	   <fo:table-row>
	    <fo:table-cell>		
			<fo:block><fo:leader leader-pattern="space"/></fo:block>
		</fo:table-cell>
	   </fo:table-row>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE DESPESA </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow[CD_TIPO='20']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow[CD_TIPO='20']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow[CD_TIPO='20']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

    <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="100pt"/>
	  <fo:table-column column-number="2" column-width="222pt"/>
	  <fo:table-column column-number="3" column-width="78pt"/>
	  <fo:table-column column-number="4" column-width="78pt"/>
	  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;digo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Especifica&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
	  <xsl:if test="RemuneracaoVereadoresRow/AUTOMATICA='S'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(RemuneracaoVereadoresRow[AUTOMATICA='S' and CD_TIPO='22' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='S' and CD_TIPO='22' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>

	  <xsl:if test="RemuneracaoVereadoresRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="RemuneracaoVereadoresRow[AUTOMATICA='N' and CD_TIPO='22' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

	   <fo:table-row>
	    <fo:table-cell>		
			<fo:block><fo:leader leader-pattern="space"/></fo:block>
		</fo:table-cell>
	   </fo:table-row>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DE RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow[CD_TIPO='22']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow[CD_TIPO='22']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow[CD_TIPO='22']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

    <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="100pt"/>
	  <fo:table-column column-number="2" column-width="222pt"/>
	  <fo:table-column column-number="3" column-width="78pt"/>
	  <fo:table-column column-number="4" column-width="78pt"/>
	  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-body>
	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA REMUNERA&#199;&#195;O DE VEREADORES </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RemuneracaoVereadoresRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-11 ####-->

<!--
#############################################
#### UC074-12
############################################# 
-->
<xsl:template match="LimiteLegalIncisoVII">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_1_5">
	  <xsl:text>3.1.5 Verifica&#231;&#227;o do Limite Legal conforme disposto no inciso VII do artigo 29 da CF </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="240pt"/>

	  <fo:table-body>

	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft" number-columns-spanned="1">
		  <xsl:text>Receita total do Munic&#237;pio</xsl:text>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
					<xsl:value-of select="format-number(LimiteCM/LimiteCMRow/RECEITA_TOTAL_MUNICIPIO,'###.###.##0,00')"/>
     			</xsl:if>
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
					<xsl:value-of select="format-number(LimitePM/LimitePMRow/RECEITA_TOTAL_MUNICIPIO,'###.###.##0,00')"/>
     			</xsl:if>
	 		</fo:block>
    	</fo:table-cell>
	  </fo:table-row>

	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:text>Limite Legal - inciso VII do art. 29 da Constitui&#231;&#227;o Federal</xsl:text>
		 </fo:block>
	    </fo:table-cell>
	  </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:text>(5% s/ Receita Total do Munic&#237;pio)</xsl:text>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
					<xsl:value-of select="format-number(LimiteCM/LimiteCMRow/LIMITE_LEGAL,'###.###.##0,00')"/>
     			</xsl:if>
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
					<xsl:value-of select="format-number(LimitePM/LimitePMRow/LIMITE_LEGAL,'###.###.##0,00')"/>
     			</xsl:if>
	 		</fo:block>
    	</fo:table-cell>
	  </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:text>Total da Remunera&#231;&#227;o de Vereadores</xsl:text>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
					<xsl:value-of select="format-number(LimiteCM/LimiteCMRow/TOTAL_REMUNERACAO_VEREADORES,'###.###.##0,00')"/>
     			</xsl:if>
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
					<xsl:value-of select="format-number(LimitePM/LimitePMRow/TOTAL_REMUNERACAO_VEREADORES,'###.###.##0,00')"/>
     			</xsl:if>
	 		</fo:block>
    	</fo:table-cell>
	  </fo:table-row>

	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeft">
		  <xsl:text>Percentual do Total da Remunera&#231;&#227;o de Vereadores sobre a Receita total do Munic&#237;pio</xsl:text>
		 </fo:block>
	    </fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
					<xsl:value-of select="format-number(LimiteCM/LimiteCMRow/PERC_REMUNERACAO_VEREADORES,'###0,00')"/><xsl:text>%</xsl:text>
     			</xsl:if>
				<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
					<xsl:value-of select="format-number(LimitePM/LimitePMRow/PERC_REMUNERACAO_VEREADORES,'###0,00')"/><xsl:text>%</xsl:text>
     			</xsl:if>
	 		</fo:block>
    	</fo:table-cell>
	  </fo:table-row>
    <xsl:if test="Resposta/RespostaRow/RESPOSTA = 'S'">
      <fo:table-row>
        <fo:table-cell>
          <fo:block xsl:use-attribute-sets="txtLeft">
            <xsl:text>O total da remunera&#231;&#227;o de Vereadores no exerc&#237;cio de </xsl:text><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> &#233; zero.</xsl:text>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </xsl:if>
    <xsl:for-each select="Justifica/JustificaRow">
      <fo:table-row>
        <fo:table-cell>
          <fo:block xsl:use-attribute-sets="txtLeft">
            <fo:inline font-weight="bold" padding-right="3pt">Justificativa: </fo:inline>
            <xsl:value-of select="TEXTO"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </xsl:for-each>
	 </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-12 ####-->

<!--
#############################################
#### UC074-13
############################################# 
-->
<xsl:template match="EntidadeIndiretasSelPad">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_6">
	  <xsl:text>1.6 Entidades da Administra&#231;&#227;o Indireta selecionadas pelo PAD </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="100pt"/>
	  <fo:table-column column-number="2" column-width="200pt"/>
	  <fo:table-column column-number="3" column-width="100pt"/>
	  <fo:table-column column-number="4" column-width="50pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">CNPJ </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Nome </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Tipo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">&#233; RPPS </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	  <fo:table-body>
	   <xsl:for-each select="EntidadeIndiretasSelPadRow">
		<fo:table-row>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="CNPJ"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="NOME_ENTIDADE"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		  	<xsl:if test="TIPO_ENTIDADE='A'">Autarquia</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='F'">Funda&#231;&#227;o</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='E'">Empresa P&#250;blica</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SA'">Sociedade An&#244;nima</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SL'">Sociedade Limitada</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='CA'">Cons&#243;rcio Administrativo</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SS'">Servi&#231;os Sociais Aut&#244;nomos</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='AS'">Associa&#231;&#227;o</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SE'">Sociedade de Economia Mista</xsl:if>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="RPPS"/>
		  </fo:block>
		 </fo:table-cell>
		</fo:table-row>
	   </xsl:for-each>
	 </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-13 ####-->

<!--
#############################################
#### UC074-14
############################################# 
-->
<xsl:template match="EntidadesIndiretasSelEntidade">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_7">
	  <xsl:text>1.7 Entidades da Administra&#231;&#227;o Indireta selecionadas pela Entidade </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="100pt"/>
	  <fo:table-column column-number="2" column-width="200pt"/>
	  <fo:table-column column-number="3" column-width="100pt"/>
	  <fo:table-column column-number="4" column-width="50pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">CNPJ </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Nome </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Tipo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">&#233; RPPS </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	  <fo:table-body>
	   <xsl:for-each select="EntidadesIndiretasSelEntidadeRow">
		<fo:table-row>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="CNPJ"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="NOME_ENTIDADE"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		  	<xsl:if test="TIPO_ENTIDADE='A'">Autarquia</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='F'">Funda&#231;&#227;o</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='E'">Empresa P&#250;blica</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SA'">Sociedade An&#244;nima</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SL'">Sociedade Limitada</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='CA'">Cons&#243;rcio Administrativo</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SS'">Servi&#231;os Sociais Aut&#244;nomos</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='AS'">Associa&#231;&#227;o</xsl:if>
			<xsl:if test="TIPO_ENTIDADE='SE'">Sociedade de Economia Mista</xsl:if>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="RPPS"/>
		  </fo:block>
		 </fo:table-cell>
		</fo:table-row>
	   </xsl:for-each>
	 </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-14 ####-->

<!--
#############################################
#### UC074-15
###############################icaEntIndireta">
-->
<xsl:template match="JustificaEntIndireta">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" />
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_8">
	  <xsl:text>1.8 Justificativa das altera&#231;&#245;es no cadastro de Entidades da Administra&#231;&#245;o Indireta</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
 <fo:table-column column-number="1" column-width="556pt"/>
	  
 <fo:table-body >	
 	<xsl:for-each select="JustificaEntIndiretaRow">	
	 <fo:table-row>								
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
				<xsl:value-of select="NOME_PLANILHA"/>
			</fo:block>
		</fo:table-cell>
	 </fo:table-row> 					
	 <fo:table-row>								
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
				Justificativa: <xsl:value-of select="TEXTO"/>
			</fo:block>
		</fo:table-cell>
	 </fo:table-row>   	
	 <fo:table-row>								
		<fo:table-cell>
	  		<fo:block><fo:leader leader-pattern="space"/></fo:block>
		</fo:table-cell>
	 </fo:table-row>   	
	</xsl:for-each>	 	
 </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-15 ####-->

<!--
#############################################
#### UC074-16
############################################# 
-->
<xsl:template match="ContasReceita">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_1_1">
	  <xsl:text>2.1.1 Resumo por Grupos </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

<fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-body>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">ESPECIFICA&#199;&#195;O DAS CONTAS DE RECEITA</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">OR&#199;ADA</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">REALIZADA</fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-body>
	</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft">RECEITAS CORRENTES</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" ></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight"></fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="ContasReceitaRow[GRUPO_CONTA='1']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>SOMA DAS RECEITAS CORRENTES</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='1']/VL_ORCADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='1']/VL_REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft">RECEITAS CORRENTES INTRA-OR&#199;AMENT&#193;RIAS</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" ></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight"></fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="ContasReceitaRow[GRUPO_CONTA='7']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>SOMA DAS RECEITAS CORRENTES INTRA-OR&#199;AMENT&#193;RIAS</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='7']/VL_ORCADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='7']/VL_REALIZADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft">RECEITAS DE CAPITAL</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" ></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight"></fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="ContasReceitaRow[GRUPO_CONTA='2']">
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>SOMA DAS RECEITAS DE CAPITAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='2']/VL_ORCADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='2']/VL_REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft">RECEITAS DE CAPITAL INTRA-OR&#199;AMENT&#193;RIAS</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" ></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight"></fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="ContasReceitaRow[GRUPO_CONTA='8']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>SOMA DAS RECEITAS DE CAPITAL INTRA-OR&#199;AMENT&#193;RIAS</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='8']/VL_ORCADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='8']/VL_REALIZADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>

	<!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>
		<fo:table-body>	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>DEDU&#199;&#213;ES DE RECEITA</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='9']/VL_ORCADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow[GRUPO_CONTA='9']/VL_REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>
	-->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>
		<fo:table-body>	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL DAS RECEITAS</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow/VL_ORCADO),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitaRow/VL_REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-16 ####-->

<!--
#############################################
#### UC074-17
############################################# 
-->
<xsl:template match="MetasArrecadacao">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_3">
	  <xsl:text>5.3 Metas de Arrecada&#231;&#227;o</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">RECEITAS CORRENTES</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">META</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">REALIZADA</fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="MetasArrecadacaoRow[CONTA='RECEITAS CORRENTES']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="BIMESTRE"/>&#186; Bimestre</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(META,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS CORRENTES']/META),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS CORRENTES']/REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">RECEITAS CORRENTES INTRA-OR&#199;AMENT&#193;RIAS</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">META</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">REALIZADA</fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="MetasArrecadacaoRow[CONTA='RECEITAS CORRENTES INTRA-ORCAMENTARIAS']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="BIMESTRE"/>&#186; Bimestre</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(META,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS CORRENTES INTRA-ORCAMENTARIAS']/META),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS CORRENTES INTRA-ORCAMENTARIAS']/REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>

	  <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

		  <fo:table-header>
		   <fo:table-row>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">RECEITAS DE CAPITAL</fo:block>
		    </fo:table-cell>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">META</fo:block>
		    </fo:table-cell>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">REALIZADA</fo:block>
		    </fo:table-cell>
		    </fo:table-row>
		  </fo:table-header>

	  <fo:table-body >	
  	 	<xsl:for-each select="MetasArrecadacaoRow[CONTA='RECEITAS DE CAPITAL']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="BIMESTRE"/>&#186; Bimestre</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(META,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	   
	 </xsl:for-each>

		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS DE CAPITAL']/META),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS DE CAPITAL']/REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>				
	  </fo:table-body>
	</fo:table>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">RECEITAS DE CAPITAL INTRA-OR&#199;AMENT&#193;RIAS</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">META</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">REALIZADA</fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="MetasArrecadacaoRow[CONTA='RECEITAS DE CAPITAL INTRA-ORCAMENTARIAS']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="BIMESTRE"/>&#186; Bimestre</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(META,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>
	 </xsl:for-each>
		 <fo:table-row>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS DE CAPITAL INTRA-ORCAMENTARIAS']/META),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='RECEITAS DE CAPITAL INTRA-ORCAMENTARIAS']/REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>
	  </fo:table-body>
	</fo:table>

	  <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

		  <fo:table-header>
		   <fo:table-row>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">DEDU&#199;&#213;ES DA RECEITA</fo:block>
		    </fo:table-cell>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">META</fo:block>
		    </fo:table-cell>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">REALIZADA</fo:block>
		    </fo:table-cell>
		    </fo:table-row>
		  </fo:table-header>

	  <fo:table-body >	
  	 	<xsl:for-each select="MetasArrecadacaoRow[CONTA='DEDUCAO RECEITA']">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="BIMESTRE"/>&#186; Bimestre</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(META,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(REALIZADO,'###.###.##0,00')"/></fo:block>
		 </fo:table-cell>
		</fo:table-row>   	   
	 </xsl:for-each>

		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='DEDUCAO RECEITA']/META),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow[CONTA='DEDUCAO RECEITA']/REALIZADO),'###.###.##0,00')"/></fo:block>						
			</fo:table-cell>
	    </fo:table-row>				
	  </fo:table-body>
	</fo:table>

	  <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

		  <fo:table-body>
		   <fo:table-row>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA</fo:block>
		    </fo:table-cell>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="total" ><xsl:value-of select="format-number(sum(MetasArrecadacaoRow/META),'###.###.##0,00')"/> </fo:block>
		    </fo:table-cell>
		    <fo:table-cell>
		     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(MetasArrecadacaoRow/REALIZADO),'###.###.##0,00')"/> </fo:block>
		    </fo:table-cell>
		    </fo:table-row>
		  </fo:table-body>
	</fo:table>
 </xsl:template>
<!-- #### FIM - UC074-17 ####-->

<!--
#############################################
#### UC074-18
############################################# 
-->
<xsl:template match="ContasDespesa">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="isCamaraIntegrada">
	<xsl:choose>
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
</xsl:variable>
<xsl:variable name="tipoSetorGov">
	<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/TIPO_SETOR_GOV"/>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_2_1">
	  <xsl:text>2.2.1 Resumo do Balancete da Despesa </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

  <fo:table-body>
   
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">DISCRIMINA&#199;&#195;O </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">VALOR </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Dota&#231;&#227;o Inicial</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_DOTACAO_INICIAL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Atualiza&#231;&#227;o Monet&#225;ria</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_ATUALIZACAO_MONETARIA,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Cr&#233;ditos Suplementares</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_CREDITOS_SUPLEMENTARES,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Cr&#233;ditos Especiais</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_CREDITOS_ESPECIAIS,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Cr&#233;ditos Extraordin&#225;rios</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_CREDITOS_EXTRAORDINARIOS,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Redu&#231;&#227;o de Dota&#231;&#245;es</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_REDUCAO_DOTACAO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Transfer&#234;ncias</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
       <xsl:value-of select="format-number(Despesa/DespesaRow/VL_TRANSFERENCIA,'###.###.##0,00')"/>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Transposi&#231;&#245;es</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
       <xsl:value-of select="format-number(Despesa/DespesaRow/VL_TRANSPOSICAO,'###.###.##0,00')"/>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Remanejamentos</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
       <xsl:value-of select="format-number(Despesa/DespesaRow/VL_REMANEJAMENTO,'###.###.##0,00')"/>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">DOTA&#199;&#195;O COM ALTERA&#199;&#213;ES</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
	  <xsl:value-of select="format-number((
							Despesa/DespesaRow/VL_DOTACAO_INICIAL
							+ Despesa/DespesaRow/VL_ATUALIZACAO_MONETARIA
							+ Despesa/DespesaRow/VL_CREDITOS_SUPLEMENTARES
							+ Despesa/DespesaRow/VL_CREDITOS_ESPECIAIS
							+ Despesa/DespesaRow/VL_CREDITOS_EXTRAORDINARIOS
							- Despesa/DespesaRow/VL_REDUCAO_DOTACAO
							+ Despesa/DespesaRow/VL_TRANSFERENCIA
							+ Despesa/DespesaRow/VL_TRANSPOSICAO
							+ Despesa/DespesaRow/VL_REMANEJAMENTO
							),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">DESPESAS NO EXERC&#205;CIO ATUAL </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">VALOR </fo:block>
    </fo:table-cell>
   </fo:table-row>

	<xsl:if test="$tipoSetorGov != 'C'">
	   <fo:table-row>
		<fo:table-cell padding="1pt" padding-left="8pt" border-width="0.5pt" number-columns-spanned="3">
		 <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">PODER EXECUTIVO </fo:block>
		</fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
		 <fo:block xsl:use-attribute-sets="txtLeft">Empenhado</fo:block>
		</fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
		 <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_EMPENHADO_E,'###.###.##0,00')"/>
		 </fo:block>
		</fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
		 <fo:block xsl:use-attribute-sets="txtLeft">Liquidado</fo:block>
		</fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
		 <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_LIQUIDADO_E,'###.###.##0,00')"/>
		 </fo:block>
		</fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
		 <fo:block xsl:use-attribute-sets="txtLeft">Pago</fo:block>
		</fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
		 <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_PAGO_E,'###.###.##0,00')"/>
		 </fo:block>
		</fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
		 <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A LIQUIDAR</fo:block>
		</fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
		 <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
		  <xsl:value-of select="format-number((Despesa/DespesaRow/VL_EMPENHADO_E - Despesa/DespesaRow/VL_LIQUIDADO_E),'###.###.##0,00')"/>
		 </fo:block>
		</fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
		 <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A PAGAR</fo:block>
		</fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
		 <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
		  <xsl:value-of select="format-number((Despesa/DespesaRow/VL_LIQUIDADO_E - Despesa/DespesaRow/VL_PAGO_E),'###.###.##0,00')"/>
		 </fo:block>
		</fo:table-cell>
	   </fo:table-row>
	</xsl:if>

	<xsl:if test="$tipoSetorGov = 'C'">
	   <fo:table-row>
		<fo:table-cell padding="1pt" padding-left="8pt" border-width="0.5pt" number-columns-spanned="3">
	     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">PODER LEGISLATIVO </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">Empenhado</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_EMPENHADO_L,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">Liquidado</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_LIQUIDADO_L,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">Pago</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_PAGO_L,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A LIQUIDAR</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
		  <xsl:value-of select="format-number((Despesa/DespesaRow/VL_EMPENHADO_L - Despesa/DespesaRow/VL_LIQUIDADO_L),'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A PAGAR</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
		  <xsl:value-of select="format-number((Despesa/DespesaRow/VL_LIQUIDADO_L - Despesa/DespesaRow/VL_PAGO_L),'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	</xsl:if>

	<!--
	   <fo:table-row>
		<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
	 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
	    </fo:table-cell>	    
	   </fo:table-row>
	
	   <fo:table-row>
		<fo:table-cell padding="1pt" padding-left="8pt" border-width="0.5pt" number-columns-spanned="3">
	     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">TOTAL DO EXECUTIVO E LEGISLATIVO </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">Empenhado</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_EMPENHADO_E+Despesa/DespesaRow/VL_EMPENHADO_L,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">Liquidado</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_LIQUIDADO_E+Despesa/DespesaRow/VL_LIQUIDADO_L,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft">Pago</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight">
		  <xsl:value-of select="format-number(Despesa/DespesaRow/VL_PAGO_E+Despesa/DespesaRow/VL_PAGO_L,'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A LIQUIDAR</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
		  <xsl:value-of select="format-number((Despesa/DespesaRow/VL_EMPENHADO_E + Despesa/DespesaRow/VL_EMPENHADO_L) - (Despesa/DespesaRow/VL_LIQUIDADO_E + Despesa/DespesaRow/VL_LIQUIDADO_L),'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	   <fo:table-row>
		<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="16pt">
	     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A PAGAR</fo:block>
	    </fo:table-cell>
		<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
		  <xsl:value-of select="format-number((Despesa/DespesaRow/VL_LIQUIDADO_E + Despesa/DespesaRow/VL_LIQUIDADO_L) - (Despesa/DespesaRow/VL_PAGO_E + Despesa/DespesaRow/VL_PAGO_L),'###.###.##0,00')"/>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	-->

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">DESPESAS EM EXERC&#205;CIOS ANTERIORES </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">VALOR </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Empenhado</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:if test="EmpenhadoAnt!=''">
	  	<xsl:value-of select="format-number(EmpenhadoAnt/EmpenhadoAntRow/EMPENHADO_ANT,'###.###.##0,00')"/>
	  </xsl:if>
	  <xsl:if test="EmpenhadoAnt=''">
	  	<xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	  </xsl:if>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Liquidado</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:if test="LiquidadoAnt!=''">
	  	<xsl:value-of select="format-number(LiquidadoAnt/LiquidadoAntRow/LIQUIDADO_ANT,'###.###.##0,00')"/>
	  </xsl:if>
	  <xsl:if test="LiquidadoAnt=''">
	  	<xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	  </xsl:if>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Pago</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:if test="PagoAnt!=''">
	  	<xsl:value-of select="format-number(PagoAnt/PagoAntRow/PAGO_ANT,'###.###.##0,00')"/>
	  </xsl:if>
	  <xsl:if test="PagoAnt=''">
	  	<xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	  </xsl:if>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A LIQUIDAR = EMPENHADO (-) LIQUIDADO</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
	  <xsl:if test="EmpenhadoAnt!='' or LiquidadoAnt!=''">
	  	<xsl:value-of select="format-number(( sum(EmpenhadoAnt/EmpenhadoAntRow/EMPENHADO_ANT) - sum(LiquidadoAnt/LiquidadoAntRow/LIQUIDADO_ANT) ),'###.###.##0,00')"/>
	  </xsl:if>
	  <xsl:if test="EmpenhadoAnt='' and LiquidadoAnt=''">
	  	<xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	  </xsl:if>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" padding-left="8pt">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">SALDO A PAGAR = LIQUIDADO (-) PAGO</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
	  <xsl:if test="PagoAnt!='' or LiquidadoAnt!=''">
	  	<xsl:value-of select="format-number(( sum(LiquidadoAnt/LiquidadoAntRow/LIQUIDADO_ANT) - sum(PagoAnt/PagoAntRow/PAGO_ANT) ),'###.###.##0,00')"/>
	  </xsl:if>
	  <xsl:if test="PagoAnt='' and LiquidadoAnt=''">
	  	<xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	  </xsl:if>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

</xsl:template>
<!-- #### FIM - UC074-18 ####-->

<!--
#############################################
#### UC074-19
############################################# 
-->
<xsl:template match="AberturaCreditosAdicionais">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_2_2">
	  <xsl:text>2.2.2 Recursos para Abertura de Cr&#233;ditos Adicionais</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="320pt"/>
	  <fo:table-column column-number="2" column-width="236pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">ORIGEM DO RECURSO</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold"></fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body>
		<xsl:for-each select="AberturaCreditosAdicionaisRow">
		 <fo:table-row>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="ORIGEM_RECURSO"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(SOMA_CREDITO_ADICIONAL,'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		</fo:table-row>
		</xsl:for-each>
	
		<!--
		 <fo:table-row>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AberturaCreditosAdicionaisRow/SOMA_CREDITO_ADICIONAL),'###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		-->
	 </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-19 ####-->

<!--
#############################################
#### UC074-20
############################################# 
-->
<xsl:template match="ContasVerificacao">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->
<!-- ************* Variaveis locais **************-->
<xsl:variable name="asterix">
	<xsl:for-each select="ContasVerificacaoRow">
		<xsl:if test="starts-with(DESCRICAO,'*')">S</xsl:if>
	</xsl:for-each>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_3_1">
	  <xsl:text>2.3.1 Resumo por Grupos </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block ></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Inicial</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Final</fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="ContasVerificacaoRow">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DESCRICAO"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(SALDO_INICIAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(SALDO_INICIAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(SALDO_INICIAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(SALDO_INICIAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(SALDO_INICIAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(SALDO_INICIAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(SALDO_INICIAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		  </fo:table-cell>
		 <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(SALDO_FINAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(SALDO_FINAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(SALDO_FINAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(SALDO_FINAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(SALDO_FINAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(SALDO_FINAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(SALDO_FINAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		 </fo:table-cell>
		</fo:table-row> 
	   </xsl:for-each>	 	
	   <xsl:if test="starts-with($asterix,'S')">
		<fo:table-row>
		 <fo:table-cell number-columns-spanned="3">
		  <fo:block xsl:use-attribute-sets="txtLeft">* Houve sele&#231;&#227;o manual de contas</fo:block>
		 </fo:table-cell>
		</fo:table-row> 
	   </xsl:if>
	  </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-20 ####-->

<!--
#############################################
#### UC074-21
############################################# 
-->
<xsl:template match="RestosServicosSentencas">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->
<!-- ************* Variaveis locais **************-->
<xsl:variable name="asterix">
	<xsl:if test="RestosServicosSentencasRow/AUTOMATICA='N'">S</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_3_2">
	  <xsl:text>2.3.2 Restos a Pagar, Servi&#231;o da D&#237;vida e Senten&#231;as Judiciais</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block ></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Inicial</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Final</fo:block>
	    </fo:table-cell>
	    </fo:table-row>
	  </fo:table-header>
	  <fo:table-body >	
	 	 
		 <fo:table-row>								
	 	  <fo:table-cell>
        	<xsl:variable name="ast1">
				<xsl:if test="RestosServicosSentencasRow[ORDEM=1]/AUTOMATICA='N'">S</xsl:if>
			</xsl:variable>

			<xsl:if test="$ast1='S'">
				<fo:block xsl:use-attribute-sets="txtLeft" >*RESTOS A PAGAR PROCESSADOS</fo:block>
			</xsl:if>
        	<xsl:if test="$ast1=''">
				<fo:block xsl:use-attribute-sets="txtLeft" >RESTOS A PAGAR PROCESSADOS</fo:block>
			</xsl:if>
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=1]/SALDO_INICIAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=1]/SALDO_FINAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		 </fo:table-row>  
		  	    						                         						 						
	 	 <fo:table-row>								
	 	  <fo:table-cell>
        	<xsl:variable name="ast2">
				<xsl:if test="RestosServicosSentencasRow[ORDEM=2]/AUTOMATICA='N'">S</xsl:if>
			</xsl:variable>

			<xsl:if test="$ast2='S'">
				<fo:block xsl:use-attribute-sets="txtLeft" >*RESTOS A PAGAR N&#195;O PROCESSADOS</fo:block>
			</xsl:if>
        	<xsl:if test="$ast2=''">
				<fo:block xsl:use-attribute-sets="txtLeft" >RESTOS A PAGAR N&#195;O PROCESSADOS</fo:block>
			</xsl:if>
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=2]/SALDO_INICIAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=2]/SALDO_FINAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		 </fo:table-row>
		  
	 	 <fo:table-row>								
	 	  <fo:table-cell >
        	<xsl:variable name="ast3">
				<xsl:if test="RestosServicosSentencasRow[ORDEM=3]/AUTOMATICA='N'">S</xsl:if>
			</xsl:variable>

			<xsl:if test="$ast3='S'">
				<fo:block xsl:use-attribute-sets="txtLeft" >*SERVI&#199;O DA D&#205;VIDA A PAGAR</fo:block>
			</xsl:if>
        	<xsl:if test="$ast3=''">
				<fo:block xsl:use-attribute-sets="txtLeft" >SERVI&#199;O DA D&#205;VIDA A PAGAR</fo:block>
			</xsl:if>
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=3]/SALDO_INICIAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=3]/SALDO_FINAL),'###.###.##0,00')"/></fo:block>
		  </fo:table-cell>
		 </fo:table-row> 

	 	 <fo:table-row>								
	 	  <fo:table-cell >
        	<xsl:variable name="ast4">
				<xsl:if test="RestosServicosSentencasRow[ORDEM=4]/AUTOMATICA='N'">S</xsl:if>
			</xsl:variable>

			<xsl:if test="$ast4='S'">
				<fo:block xsl:use-attribute-sets="txtLeft" >*SENTEN&#199;AS JUDICIAIS</fo:block>
			</xsl:if>
        	<xsl:if test="$ast4=''">
				<fo:block xsl:use-attribute-sets="txtLeft" >SENTEN&#199;AS JUDICIAIS</fo:block>
			</xsl:if>
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=4]/SALDO_INICIAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		  <fo:table-cell >
        	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RestosServicosSentencasRow[ORDEM=4]/SALDO_FINAL),'###.###.##0,00')"/></fo:block>      
		  </fo:table-cell>
		 </fo:table-row>      

	   <xsl:if test="$asterix='S'">
		<fo:table-row>
		 <fo:table-cell number-columns-spanned="3">
		  <fo:block xsl:use-attribute-sets="txtLeft">* Houve sele&#231;&#227;o manual de contas</fo:block>
		 </fo:table-cell>
		</fo:table-row> 
	   </xsl:if>

	  </fo:table-body>
	</fo:table>
</xsl:template>
<!-- #### FIM - UC074-21 ####-->

<!--
#############################################
#### UC074-22
############################################# 
-->
<xsl:template match="JustificaContas">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
 <fo:table-column column-number="1"/>
 <fo:table-body>
 	<fo:table-row>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_4">
	  			<xsl:text>2.4 Justificativa das Contas Selecionadas Manualmente </xsl:text>
	 		</fo:block>
    	</fo:table-cell>
   	</fo:table-row>
 </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="256pt"/>
  <fo:table-column column-number="2" column-width="300pt"/>

  <!--<fo:table-header>
  	<fo:table-row>
		<fo:table-cell>
	    	<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold"></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	    	<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Texto </fo:block>
	    </fo:table-cell>
	</fo:table-row>
  </fo:table-header>-->

  <fo:table-body>
	<xsl:for-each select="JustificaContasRow">
	<fo:table-row>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft">
		   		<fo:inline font-weight="bold" padding-right="3pt">Nome da Planilha: </fo:inline>
				<xsl:value-of select="NOME_PLANILHA"/>
		  	</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
				<fo:inline font-weight="bold" padding-right="3pt">Justificativa: </fo:inline>
		   		<xsl:value-of select="TEXTO"/>
		  	</fo:block>
		</fo:table-cell>
	</fo:table-row>
	</xsl:for-each>
  </fo:table-body>
  </fo:table>
</xsl:template>
<!-- #### FIM - UC074-22 ####-->

<!--
#############################################
#### UC074-23
############################################# 
-->
<xsl:template match="DisponibilidadeFinanceira">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_3_3">
	  <xsl:text>2.3.3 Disponibilidade Financeira</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV != 'C'">
  <xsl:if test="PoderExecutivo != ''">
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

   <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">PODER EXECUTIVO</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Inicial</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Final</fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	 </fo:table-header>

	 <fo:table-body >	
  	 	<xsl:for-each select="PoderExecutivo/PoderExecutivoRow">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>
	  	 	
	 <fo:table-row>								
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL PODER EXECUTIVO</xsl:text></fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="total">
				<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL),'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="total">
				<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL),'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>				
			</fo:block>						
		</fo:table-cell>
     </fo:table-row>					
    </fo:table-body>
   </fo:table>
  </xsl:if>

  <xsl:if test="Rpps != ''">
   <fo:block><fo:leader leader-pattern="space"/></fo:block>

   <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">RPPS</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Inicial</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Final</fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	 <fo:table-body >	
  	 	<xsl:for-each select="Rpps/RppsRow">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	

		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL RPPS</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(Rpps/RppsRow/VL_SALDO_INICIAL),'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(Rpps/RppsRow/VL_SALDO_FINAL),'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	</fo:table>
   </xsl:if>
   </xsl:if>

	<xsl:if test="PoderLegislativo != ''">
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV = 'C'">
	<fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">PODER LEGISLATIVO</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Inicial</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Final</fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	 <fo:table-body >	
  	 	<xsl:for-each select="PoderLegislativo/PoderLegislativoRow">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL PODER LEGISLATIVO</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>
					</xsl:if>
				</fo:block>
			</fo:table-cell>			
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL),'###.###.##0,00')"/>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	 </fo:table>
	</xsl:if>
	</xsl:if>

	<xsl:if test="Outros != ''">
	 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">OUTROS</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Inicial</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoRight" font-weight="bold">Saldo Final</fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
	 <fo:table-body >	
  	 	<xsl:for-each select="Outros/OutrosRow">													 	
	 	 <fo:table-row>								
	 	  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtLeft" margin-left="5mm"><xsl:value-of select="DS_CONTA"/></fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_INICIAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_INICIAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_INICIAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		  </fo:table-cell>
		  <fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')!='0,00'">
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)='-'">
						<xsl:value-of select="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'),2)"/>D
					</xsl:if>
					<xsl:if test="substring(format-number(VL_SALDO_FINAL,'###.###.##0,00'), 1, 1)!='-'">
						<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/>C
					</xsl:if>
				</xsl:if>
				<xsl:if test="format-number(VL_SALDO_FINAL,'###.###.##0,00')='0,00'">
					<xsl:value-of select="format-number(VL_SALDO_FINAL,'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
				</xsl:if>
			</fo:block>
		 </fo:table-cell>
		</fo:table-row>   	    						                         						 						
	  </xsl:for-each>	 	
		 <fo:table-row>								
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="totalLeft"><xsl:text>TOTAL OUTROS</xsl:text></fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
					</xsl:if>
				</fo:block>
			</fo:table-cell>			
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')"/><fo:inline color="#FFFFFF">x</fo:inline>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
	    </fo:table-row>					
	  </fo:table-body>
	 </fo:table>
	</xsl:if>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="316pt"/>
	  <fo:table-column column-number="2" column-width="120pt"/>
	  <fo:table-column column-number="3" column-width="120pt"/>

	  <fo:table-body>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="totalLeft" font-weight="bold">TOTAL</fo:block>
	    </fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_INICIAL)+sum(Rpps/RppsRow/VL_SALDO_INICIAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_INICIAL)+sum(Outros/OutrosRow/VL_SALDO_INICIAL),'###.###.##0,00')"/>
					</xsl:if>
				</fo:block>
			</fo:table-cell>			
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')!='0,00'">
						<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)='-'">
							<xsl:value-of select="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00'),2)"/>D
						</xsl:if>
						<xsl:if test="substring(format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00'), 1, 1)!='-'">
							<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')"/>C
						</xsl:if>
					</xsl:if>
					<xsl:if test="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')='0,00'">
						<xsl:value-of select="format-number(sum(PoderExecutivo/PoderExecutivoRow/VL_SALDO_FINAL)+sum(Rpps/RppsRow/VL_SALDO_FINAL)+sum(PoderLegislativo/PoderLegislativoRow/VL_SALDO_FINAL)+sum(Outros/OutrosRow/VL_SALDO_FINAL),'###.###.##0,00')"/>
					</xsl:if>
				</fo:block>
			</fo:table-cell>
	    </fo:table-row>
	  </fo:table-body>
	</fo:table>

</xsl:template>
<!-- #### FIM - UC074-23 ####-->

<!--
#############################################
#### UC074-24
############################################# 
-->
<xsl:template match="RecMdeFundefContas">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="RecMdeFundefContasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="RecMdeFundefContasRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_2_1">
	  <xsl:text>3.2.1 Base de C&#225;lculo Constitucional da Receita da Educa&#231;&#227;o (MDE + FUNDEB) </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Conta </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

 	  <fo:table-body>
	  <xsl:if test="RecMdeFundefContasRow/AUTOMATICA='S'">
	   
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(RecMdeFundefContasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="RecMdeFundefContasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>

	  <xsl:if test="RecMdeFundefContasRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="RecMdeFundefContasRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefContasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefContasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefContasRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-body>
	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="4">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL - Base Receita Educa&#231;&#227;o (MDE + FUNDEB) - 25% da Receita Ajustada</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefContasRow/VLR_AJUSTADO) * 0.25, '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-24 ####-->

<!--
#############################################
#### UC074-25
############################################# 
-->
<xsl:template match="RecMdeFundefRecursos">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_2_2">
	  <xsl:text>3.2.2 Base de C&#225;lculo Constitucional da Receita da Educa&#231;&#227;o (MDE + FUNDEB), a Partir dos Recursos Vinculados </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Recurso </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
		<xsl:for-each select="RecMdeFundefRecursosRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL II </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefRecursosRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefRecursosRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecMdeFundefRecursosRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

  <xsl:if test="(sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)*0.25)-sum(RecMdeFundefRecursosRow/VLR_AJUSTADO) &gt;= 10.00 ">
  	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1"/>
	  <fo:table-body>
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeftShort">
		  <xsl:text>Valor Total da Base Constitucional da Receita da Educa&#231;&#227;o calculada pelas contas diferente do Valor Total da Base Constitucional da Receita da Educa&#231;&#227;o calculada pelos recursos vinculados </xsl:text>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
  </xsl:if>
</xsl:template>
<!-- #### FIM - UC074-25 ####-->

<!--
#############################################
#### UC074-26
############################################# 
-->
<xsl:template match="DespMdeFundefRecursos">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_2_3">
	  <xsl:text>3.2.3 C&#225;lculo da Despesa Constitucional com Educa&#231;&#227;o (MDE + FUNDEB) </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">FR / CO </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o da Subfun&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
		<xsl:for-each select="DespMdeFundefRecursosRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_RECURSO"/> /
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL I</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefRecursosRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefRecursosRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefRecursosRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">Despesas N&#227;o Comput&#225;veis
			<xsl:if test="$debug = 'on'">
				(CD_TIPO=1026 or CD_TIPO=1028)
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo">FR + CO</xsl:with-param>
		<xsl:with-param name="labelDescricao">Natureza de Despesa</xsl:with-param>
		<xsl:with-param name="labelSubtotal">SUBTOTAL II</xsl:with-param>
		<xsl:with-param name="contasList" select="../DespNaoComputaveis/DespNaoComputaveisRow[CD_TIPO=1026 or CD_TIPO=1028]"/>
	</xsl:call-template>

	<!--
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">Total das Despesas Custeadas com Supervit do FUNDEB (1 quadrimestre)
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=1210]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo">Cd. Fonte</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelValor1"/>
		<xsl:with-param name="labelValor2"/>
		<xsl:with-param name="labelValor3">Valor Ajustado</xsl:with-param>
		<xsl:with-param name="labelSubtotal">SUBTOTAL III</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoRV/GenericoRVRow[CD_TIPO=1210]"/>
	</xsl:call-template>
	-->

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			Cancelamento, no exerccio, de Restos a Pagar inscritos com disponibilidade financeira
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=1211]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo">FR / CO</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelValor1"/>
		<xsl:with-param name="labelValor2"/>
		<xsl:with-param name="labelValor3">Valor Digitado</xsl:with-param>
		<xsl:with-param name="labelSubtotal">SUBTOTAL III</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1211]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			Cancelamento, no exerccio, de Restos a Pagar inscritos com disponibilidade financeira
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=1212]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo">C&#243;d. Fonte</xsl:with-param>
		<xsl:with-param name="labelValor1"/>
		<xsl:with-param name="labelValor2"/>
		<xsl:with-param name="labelValor3" select="'Valor Digitado'"/>
		<xsl:with-param name="labelSubtotal">SUBTOTAL IV</xsl:with-param>
		<xsl:with-param name="contasList" select="/rve/GenericoRV/GenericoRVRow[CD_TIPO=1212]"/>
	</xsl:call-template>
	
	<xsl:if test="/rve/Cabecalho/CabecalhoRow/MES_INFORMACOES != 12">
	<xsl:variable name="cdTipo" select="1215"/>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=<xsl:value-of select="$cdTipo"/>]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo"/>
		<xsl:with-param name="labelValor1"/>
		<xsl:with-param name="labelValor2"/>
		<xsl:with-param name="labelSubtotal">SUBTOTAL V</xsl:with-param>
		<xsl:with-param name="contasList" select="/rve/GenericoConta/GenericoContaRow[CD_TIPO=$cdTipo]"/>
	</xsl:call-template>
	</xsl:if>

	<xsl:if test="/rve/Cabecalho/CabecalhoRow/MES_INFORMACOES = 12">
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">RPNP do Exerccio Atual com Insuficincia Financeira *
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=1029]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo">FR / CO</xsl:with-param>
		<xsl:with-param name="labelValor1"/>
		<xsl:with-param name="labelValor2"/>
		<xsl:with-param name="labelValor3">Valor Contbil</xsl:with-param>
		<xsl:with-param name="labelSubtotal">SUBTOTAL V</xsl:with-param>
		<xsl:with-param name="contasList" select="/rve/Educacao/RpnpInsuficiencia/RpnpInsuficienciaRow[CD_TIPO=1029]"/>
	</xsl:call-template>

	<fo:leader leader-pattern="space"/>
	<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
		(*) Observao: Clculo ser efetuado apenas em DEZEMBRO.
	</fo:block>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=1216]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelCodigo"/>
		<xsl:with-param name="labelValor1"/>
		<xsl:with-param name="labelValor2"/>
		<xsl:with-param name="labelValor3">Valor Contbil</xsl:with-param>
		<xsl:with-param name="labelSubtotal">SUBTOTAL VI</xsl:with-param>
		<xsl:with-param name="contasList" select="/rve/GenericoConta/GenericoContaRow[CD_TIPO=1216]"/>
	</xsl:call-template>
	</xsl:if>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-body>
  	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	  <xsl:for-each select="../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=0 or CD_CONTA=1 or CD_CONTA=2]">
		 <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

  	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
	  <xsl:for-each select="../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]">
		 <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

	<!--
		<fo:table-row>
			<fo:table-cell number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL V</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
					sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=0]/VLR_CONTABIL)
					- sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_CONTABIL)
					+ sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_CONTABIL)
					, '###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
					sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=0]/VLR_AJUSTE)
					- sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTE)
					+ sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTE)
					, '###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
					sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=0]/VLR_AJUSTADO)
					- sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)
					+ sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO)
					, '###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
	-->

    </fo:table-body>
   </fo:table>

	<xsl:variable name="vlrAplicado">
		<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
			<xsl:value-of select="sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO)
				+ sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO)
				- sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)
				- sum(../DespNaoComputaveis/DespNaoComputaveisRow[CD_TIPO=1026 or CD_TIPO=1028]/VLR_AJUSTADO)
				- sum(/rve/Educacao/RpnpInsuficiencia/RpnpInsuficienciaRow[CD_TIPO=1029]/VLR_AJUSTADO)
				+ sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1210]/VLR_AJUSTADO)
				+ sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1215]/VLR_AJUSTADO)
				+ sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1216]/VLR_AJUSTADO)
				- sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1211]/VLR_AJUSTADO)
				- sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1212]/VLR_AJUSTADO)
				"/>
		</xsl:if>
		<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
			<xsl:value-of select="sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO)
				+ sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO)
				- sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO)
				- sum(../DespNaoComputaveis/DespNaoComputaveisRow[CD_TIPO=1026 or CD_TIPO=1028]/VLR_AJUSTADO)
				- sum(/rve/Educacao/RpnpInsuficiencia/RpnpInsuficienciaRow[CD_TIPO=1029]/VLR_AJUSTADO)
				+ sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1210]/VLR_AJUSTADO)
				+ sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1215]/VLR_AJUSTADO)
				+ sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1216]/VLR_AJUSTADO)
				- sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1211]/VLR_AJUSTADO)
				- sum(../../GenericoConta/GenericoContaRow[CD_TIPO=1212]/VLR_AJUSTADO)
				"/>
		</xsl:if>
	</xsl:variable>

	<xsl:variable name="vlrAplicadoFinal">
		<xsl:choose>
			<xsl:when test="$vlrAplicado &lt;= 0">0</xsl:when>
			<xsl:otherwise><xsl:value-of select="$vlrAplicado"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:variable name="vlrDivisor">
		<xsl:value-of select="sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)" />
	</xsl:variable>

	<!--
	<fo:block xsl:use-attribute-sets="txtLeft">
		vlrAplicado: <xsl:value-of select="$vlrAplicado" />
	</fo:block>
	<fo:block xsl:use-attribute-sets="txtLeft">
		vlrDivisor: <xsl:value-of select="$vlrDivisor" />
	</fo:block>
	-->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-body>
	     <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
		        <fo:block xsl:use-attribute-sets="txtLeft"/>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
        			<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='A' and
				      			  ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='F'">
						<xsl:text>% de Aplica&#231;&#227;o</xsl:text>
        			</xsl:if>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="txtRight">
					<xsl:text>Valor Aplicado</xsl:text>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>

	     <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="totalLeft">
					<xsl:text>TOTAL - Gastos Constitucionais com Educa&#231;&#227;o (MDE + FUNDEB)</xsl:text>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="total">
        			<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='A' and
				      			  ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='F'">
						<xsl:value-of select="format-number($vlrAplicadoFinal * 100 div $vlrDivisor, '###.###.##0,00')"/>
        			</xsl:if>
					<!--
					<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
						<xsl:if test="$vlrAplicado &lt;= 0">
							<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/>
						</xsl:if>
					  <xsl:if test="((sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) div (sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &lt;= 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
						</xsl:if>
						<xsl:if test="((sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) div (sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &gt; 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) div (sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100, '###.###.##0,00')"/></fo:block>
						</xsl:if>
					</xsl:if>
					<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and
					              ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='A' and
								  ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='F'">
				    <xsl:if test="((sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &lt;= 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
						</xsl:if>
						<xsl:if test="((sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &gt; 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100, '###.###.##0,00')"/></fo:block>
						</xsl:if>
					</xsl:if>
					-->
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="total">
					<xsl:value-of select="format-number($vlrAplicadoFinal, '###.###.##0,00')"/>
				    <!--<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) &lt;= 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
              </xsl:if>
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) &gt; 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
              </xsl:if>
            </xsl:if>
            <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO)) &lt;= 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
              </xsl:if>
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO)) &gt; 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(../DespMdeFundefContas/DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
              </xsl:if>              
            </xsl:if>-->
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	 </fo:table-body>
	</fo:table>

</xsl:template>
<!-- #### FIM - UC074-26 ####-->

<!--
#############################################
#### UC074-27
############################################# 
-->
<xsl:template match="DespMdeFundefContas">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
  <xsl:variable name="aux1"><xsl:value-of select="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV"/>
	1<!--<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
		<xsl:for-each select="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[AUTOMATICA='S' and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:if>
  	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
		<xsl:for-each select="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[AUTOMATICA='S' and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
  	</xsl:if>-->
  </xsl:variable>
  <xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
  <xsl:variable name="aux2">			
	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
		<xsl:for-each select="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[AUTOMATICA='N' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:if>
  	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
		<xsl:for-each select="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[AUTOMATICA='N' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
  	</xsl:if>
  </xsl:variable>
  <xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_2_4">
	  <xsl:text>3.2.4 C&#225;lculo da Despesa Constitucional com Educa&#231;&#227;o (MDE + FUNDEB), Contabilizada nas Contas Patrimoniais </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header>
   <fo:table-row>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell>
     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
	<fo:table-body>
	 <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	  <xsl:if test="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow/AUTOMATICA='S'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[AUTOMATICA='S' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[AUTOMATICA='S' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>
     </xsl:if>

	 <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
	  <xsl:if test="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow/AUTOMATICA='S'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[AUTOMATICA='S' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and  (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[AUTOMATICA='S' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and  (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>
     </xsl:if>
     
	 <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	  <xsl:if test="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[AUTOMATICA='N' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>
	 </xsl:if>

	 <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
	  <xsl:if test="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[AUTOMATICA='N' and CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2 and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>
	 </xsl:if>

	 <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL II</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	 </xsl:if>

	 <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL II</fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	 </xsl:if>

	 </fo:table-body>
	</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-body>
  	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
	  <xsl:for-each select="DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=0 or CD_CONTA=1 or CD_CONTA=2]">
		 <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

  	<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
	  <xsl:for-each select="DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]">
		 <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>
    </fo:table-body>
   </fo:table>


 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-body>
	     <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
		        <fo:block xsl:use-attribute-sets="txtLeft"/>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
        			<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='A' and
				      			  ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='F'">
						<xsl:text>% de Aplica&#231;&#227;o</xsl:text>
        			</xsl:if>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="txtRight">
					<xsl:text>Valor Aplicado</xsl:text>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	     <fo:table-row>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="totalLeft">
					<xsl:text>TOTAL III - Gastos Constitucionais com Educa&#231;&#227;o (MDE + FUNDEB)</xsl:text>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="total">
					<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
					  <xsl:if test="((sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) div (sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &lt;= 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
						</xsl:if>
						<xsl:if test="((sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) div (sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &gt; 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) div (sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100, '###.###.##0,00')"/></fo:block>
						</xsl:if>
					</xsl:if>
					<xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and
					              ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='A' and
								  ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='F'">
				    <xsl:if test="((sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &lt;= 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
						</xsl:if>
						<xsl:if test="((sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100) &gt; 0.00">
							<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../RecMdeFundefContas/RecMdeFundefContasRow/VLR_AJUSTADO)) * 100, '###.###.##0,00')"/></fo:block>
						</xsl:if>
					</xsl:if>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell number-columns-spanned="2">
	     		<fo:block xsl:use-attribute-sets="total">
				    <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) &lt;= 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
              </xsl:if>
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO)) &gt; 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=1 or CD_CONTA=2]/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
              </xsl:if>
            </xsl:if>
            <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P'">
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO)) &lt;= 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(0.00, '###.###.##0,00')"/></fo:block>
              </xsl:if>
              <xsl:if test="(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO)) &gt; 0.00">
                <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../DespMdeFundefRecursos/DespMdeFundefRecursosRow/VLR_AJUSTADO) + sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA!=0 and CD_CONTA!=1 and CD_CONTA!=2]/VLR_AJUSTADO) - sum(DespMdeFundefContasOutras/DespMdeFundefContasOutrasRow[CD_CONTA=2]/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
              </xsl:if>              
            </xsl:if>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	 </fo:table-body>
	</fo:table>

  <!--<xsl:if test="format-number(sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA=2]/VLR_AJUSTADO), '###.###.##0,00') != format-number(sum(DespMdeFundefContasPrefeitura/DespMdeFundefContasPrefeituraRow[CD_CONTA!=2]/VLR_AJUSTADO), '###.###.##0,00') 
  			    and ../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
  	
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1"/>
	  <fo:table-body>
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeftShort">
		  <xsl:text>Valor da Contribui&#231;&#227;o para o FUNDEF, calculada a partir da diferen&#231;a entre o retorno e a reten&#231;&#227;o, est&#225; diferente do valor empenhado, liquidado e pago na rubrica 3370419901 ou n&#227;o foi encontrado empenho, liquida&#231;&#227;o e pagamento na rubrica 3370419901 </xsl:text>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
  </xsl:if>-->
</xsl:template>
<!-- #### FIM - UC074-27 ####-->

<!--
#############################################
#### UC074-28
############################################# 
-->
<xsl:template match="RecFundefContas2">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="RecFundefContas2Row[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="RecFundefContas2Row[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->


 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_3_1">
	  <xsl:text>3.3.1  Base de C&#225;lculo Constitucional da Receita do FUNDEB </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Conta </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	  <fo:table-body>
	  <xsl:if test="RecFundefContas2Row/AUTOMATICA='S'">
	   
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(RecFundefContas2Row[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="RecFundefContas2Row[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>

	  <xsl:if test="RecFundefContas2Row/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="RecFundefContas2Row[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefContas2Row/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefContas2Row/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefContas2Row/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-body>
	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="4">
	     <fo:block xsl:use-attribute-sets="totalLeft">Total - Base Receita do FUNDEB - 20% da Receita Ajustada </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefContas2Row/VLR_AJUSTADO) * 0.20, '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>   
 </xsl:template>  
<!-- #### FIM - UC074-28 ####-->

<!--
#############################################
#### UC074-29
############################################# 
-->
<xsl:template match="RecFundefRecursos">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_3_2">
	  <xsl:text>3.3.2 Base de C&#225;lculo Constitucional da Receita do FUNDEB, a Partir dos Recursos </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Recurso </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
		<xsl:for-each select="RecFundefRecursosRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL II </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefRecursosRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefRecursosRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RecFundefRecursosRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

  <xsl:if test="(sum(../RecFundefContas2/RecFundefContas2Row/VLR_AJUSTADO)*0.2)-(sum(RecFundefRecursosRow/VLR_AJUSTADO)) &gt;= 10.00">
  	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1"/>
	  <fo:table-body>
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeftShort">
		  <xsl:text>Total da Base Constitucional da Receita do FUNDEB calculada pelas contas diferente do Valor Total da Base Constitucional da Receita do FUNDEB calculada pelos recursos vinculados</xsl:text>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
  </xsl:if>
</xsl:template>
<!-- #### FIM - UC074-29 ####-->

<!--
#############################################
#### UC074-30
############################################# 
-->
<xsl:template match="CalculoReceitaContas">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="CalculoReceitaContasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="CalculoReceitaContasRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_5_1">
	  <xsl:text>3.5.1 Base de C&#225;lculo Constitucional da Receita da Sa&#250;de (ASPS) </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Conta </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
	  <xsl:if test="CalculoReceitaContasRow/AUTOMATICA='S'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
	   <xsl:choose>
	   <xsl:when test="count(CalculoReceitaContasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<xsl:for-each select="CalculoReceitaContasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	    </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>
	  </xsl:if>

	  <xsl:if test="CalculoReceitaContasRow/AUTOMATICA='N'">
	   <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
	    </fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	     <fo:table-cell><fo:block linefeed-treatment="preserve"/></fo:table-cell>
	   </fo:table-row>
		<xsl:for-each select="CalculoReceitaContasRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
		 <fo:table-row>
			<fo:table-cell>
	      		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
	     		<fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>
	  </xsl:if>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaContasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaContasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaContasRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>


  <fo:block><fo:leader leader-pattern="space"/></fo:block>

 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-body>
	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="4">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL - Base Receita Sa&#250;de (ASPS) - 15% da Receita Ajustada </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaContasRow/VLR_AJUSTADO) * 0.15, '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-30 ####-->

<!--
#############################################
#### UC074-31
############################################# 
-->
<xsl:template match="CalculoReceitaRecursos">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_5_2">
	  <xsl:text>3.5.2 Base de C&#225;lculo Constitucional da Receita da Sa&#250;de (ASPS), a Partir dos Recursos Vinculados </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. Recurso </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
		<xsl:for-each select="CalculoReceitaRecursosRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL II </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaRecursosRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaRecursosRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(CalculoReceitaRecursosRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>CalculoReceitaContasRow
	</fo:table>

  <xsl:if test="(sum(../CalculoReceitaContas/CalculoReceitaContasRow/VLR_AJUSTADO)*0.15)-(sum(CalculoReceitaRecursosRow/VLR_AJUSTADO)) &gt;= 10.00">
  	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1"/>
	  <fo:table-body>
	   <fo:table-row>
		<fo:table-cell>
	     <fo:block xsl:use-attribute-sets="txtLeftShort">
		  <xsl:text>Valor Total da Base Constitucional da Receita da Sa&#250;de calculada pelas contas diferente do Valor Total da Base Constitucional da Receita da Sa&#250;de calculada pelos recursos vinculados</xsl:text>
		 </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-body>
	 </fo:table>
  </xsl:if>
</xsl:template>
<!-- #### FIM - UC074-31 ####-->

<!--
#############################################
#### UC074-32
############################################# 
-->
<xsl:template match="GastoSaudeRecursos">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_5_3">
	  <xsl:text>3.5.3 C&#225;lculo da Despesa Constitucional com Sa&#250;de (ASPS) </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">C&#243;d. FR / CO </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Descri&#231;&#227;o da Subfun&#231;&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Cont&#225;bil </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="cabecalho" font-weight="bold">Valor Ajustado </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>
 
	  <fo:table-body>
		<xsl:for-each select="GastoSaudeRecursosRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="CD_RECURSO"/> /
					<xsl:value-of select="CD_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft">
					<xsl:value-of select="DS_CONTA"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight">
		  			<xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
		 		</fo:block>
	    	</fo:table-cell>
	  	</fo:table-row>
	   </xsl:for-each>

	   <fo:table-row>
	    <fo:table-cell number-columns-spanned="2">
	     <fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL I </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(GastoSaudeRecursosRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(GastoSaudeRecursosRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
		 <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(GastoSaudeRecursosRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
	    </fo:table-cell>
	   </fo:table-row>

	 </fo:table-body>
	</fo:table>

	<xsl:variable name="cdTipo" select="1600"/>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			Execuo do Consrcio Pblico
			<xsl:if test="$debug = 'on'">
				[CD_TIPO=<xsl:value-of select="$cdTipo"/>]
			</xsl:if>
		</xsl:with-param>
		<xsl:with-param name="labelSubtotal">SUBTOTAL II</xsl:with-param>
		<xsl:with-param name="contasList" select="/rve/GenericoConta/GenericoContaRow[CD_TIPO=$cdTipo]"/>
	</xsl:call-template>
	
</xsl:template>
<!-- #### FIM - UC074-32 ####-->

<!--
#############################################
#### UC074-33
############################################# 
-->
<xsl:template match="JustificaSaude">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
 <fo:table-column column-number="1"/>
 <fo:table-body>
 	<fo:table-row>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="titFCinza" id="RVE_3_6">
	  			<xsl:text>3.6 Justificativa de Sele&#231;&#227;o/Ajustes nas Contas da Sa&#250;de </xsl:text>
	 		</fo:block>
    	</fo:table-cell>
   	</fo:table-row>
 </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="256pt"/>
  <fo:table-column column-number="2" column-width="300pt"/>

  <!--<fo:table-header>
  	<fo:table-row>
		<fo:table-cell>
	    	<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Planilha </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	    	<fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Justificativa </fo:block>
	    </fo:table-cell>
	</fo:table-row>
  </fo:table-header>-->

  <fo:table-body>
   <xsl:for-each select="JustificaSaudeRow">
	<fo:table-row>
	 	<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft">
				<fo:inline font-weight="bold" padding-right="3pt">Nome da Planilha: </fo:inline>
		 		<xsl:value-of select="NOME_PLANILHA"/>
		  	</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
				<fo:inline font-weight="bold" padding-right="3pt">Justificativa: </fo:inline>
				<xsl:value-of select="TEXTO"/>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
   </xsl:for-each>
  </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-33 ####-->

<!--
#############################################
#### UC074-34
############################################# 
-->
<xsl:template match="ValoresExercicioAnterior">
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->
<xsl:variable name="tipoSetorGovernamental">
  <xsl:value-of select="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV"/>
</xsl:variable>

 <!-- INICIO DA TABELA -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_5">
	  <xsl:text>2.5 Valores do Exerc&#237;cio Anterior </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="130pt"/>
  <fo:table-column column-number="2" column-width="142pt"/>
  <fo:table-column column-number="3" column-width="142pt"/>
  <fo:table-column column-number="4" column-width="142pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">CONTAS DE DESPESA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Empenhado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Liquidado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Pago </fo:block>
    </fo:table-cell>    
   </fo:table-row>
  </fo:table-header>

 <fo:table-body>
  <xsl:for-each select="ContasDespesas/ContasDespesasRow">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="BIMESTRE"/>&#186; Bimestre
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_EMPENHADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_LIQUIDADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_PAGO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>
  </fo:table-body>
 </fo:table>

<xsl:if test="$tipoSetorGovernamental!='C'">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="130pt"/>
  <fo:table-column column-number="2" column-width="142pt"/>
  <fo:table-column column-number="3" column-width="142pt"/>
  <fo:table-column column-number="4" column-width="142pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
	<fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Or&#231;ado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Realizado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

 <fo:table-body>
 
 <xsl:choose>
 <xsl:when test="ContasReceitas/ContasReceitasRow/DS_CONTA='RECEITAS CORRENTES'">
  <xsl:for-each select="ContasReceitas/ContasReceitasRow[DS_CONTA='RECEITAS CORRENTES']">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:when>
 <xsl:otherwise>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">RECEITAS CORRENTES</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
 </xsl:otherwise>
 </xsl:choose>

 <xsl:choose>
 <xsl:when test="ContasReceitas/ContasReceitasRow/DS_CONTA='RECEITAS CORRENTES INTRA-ORCAMENTARIA'">
  <xsl:for-each select="ContasReceitas/ContasReceitasRow[DS_CONTA='RECEITAS CORRENTES INTRA-ORCAMENTARIA']">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  RECEITAS CORRENTES INTRA-OR&#199;AMENT&#193;RIAS
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:when>
 <xsl:otherwise>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">RECEITAS CORRENTES INTRA-OR&#199;AMENT&#193;RIAS</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
 </xsl:otherwise>
 </xsl:choose>
 
 <xsl:choose>
 <xsl:when test="ContasReceitas/ContasReceitasRow/DS_CONTA='RECEITAS DE CAPITAL'">
  <xsl:for-each select="ContasReceitas/ContasReceitasRow[DS_CONTA='RECEITAS DE CAPITAL']">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:when>
 <xsl:otherwise>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">RECEITAS DE CAPITAL</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
 </xsl:otherwise>
 </xsl:choose>
 
 <xsl:choose>
 <xsl:when test="ContasReceitas/ContasReceitasRow/DS_CONTA='RECEITAS DE CAPITAL INTRA-ORCAMENTARIA'">
  <xsl:for-each select="ContasReceitas/ContasReceitasRow[DS_CONTA='RECEITAS DE CAPITAL INTRA-ORCAMENTARIA']">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  RECEITAS DE CAPITAL INTRA-OR&#199;AMENT&#193;RIAS
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:when>
 <xsl:otherwise>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">RECEITAS DE CAPITAL INTRA-OR&#199;AMENT&#193;RIAS</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
 </xsl:otherwise>
 </xsl:choose>
 
</fo:table-body>
</fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="130pt"/>
  <fo:table-column column-number="2" column-width="142pt"/>
  <fo:table-column column-number="3" column-width="142pt"/>
  <fo:table-column column-number="4" column-width="142pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
	<fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES DA RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Or&#231;ado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtRight">Realizado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

<fo:table-body>
 <xsl:choose>
 <xsl:when test="ContasReceitas/ContasReceitasRow/DS_CONTA='DEDUCOES'">
  <xsl:for-each select="ContasReceitas/ContasReceitasRow[DS_CONTA='DEDUCOES']">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_ORCADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VL_REALIZADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:when>
 <xsl:otherwise>
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">DEDUCOES</fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(0.00,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:otherwise>
  </xsl:choose>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="130pt"/>
  <fo:table-column column-number="2" column-width="142pt"/>
  <fo:table-column column-number="3" column-width="142pt"/>
  <fo:table-column column-number="4" column-width="142pt"/>
    <fo:table-body>
     <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
         <fo:block xsl:use-attribute-sets="totalLeft">TOTAL CONTAS DE RECEITA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
         <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitas/ContasReceitasRow/VL_ORCADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
         <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContasReceitas/ContasReceitasRow/VL_REALIZADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
 </fo:table>
</xsl:if>
<!-- FIM DA TABELA -->
</xsl:template>
<!-- #### FIM - UC074-34 ####-->

<!--
#############################################
#### UC074-35
############################################# 
-->
<xsl:template match="ErrosAvisos">
 <fo:block><fo:leader leader-pattern="space" /></fo:block>
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_4_1">
	  <xsl:text>4.1 Avisos Exibidos </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 	 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	  <fo:table-column column-number="1" column-width="80pt"/>
	  <fo:table-column column-number="2" column-width="55pt"/>
	  <fo:table-column column-number="3" column-width="28pt"/>
	  <fo:table-column column-number="4" column-width="33pt"/>
	  <fo:table-column column-number="5" column-width="35pt"/>
	  <fo:table-column column-number="6" column-width="325pt"/>

	  <fo:table-header>
	   <fo:table-row>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Nome do Arquivo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">C&#243;d. de Erro </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Linha </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Campo </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Status </fo:block>
	    </fo:table-cell>
	    <fo:table-cell>
	     <fo:block xsl:use-attribute-sets="titNegritoLeft" font-weight="bold">Descri&#231;&#227;o </fo:block>
	    </fo:table-cell>
	   </fo:table-row>
	  </fo:table-header>

	  <fo:table-body>
	   <xsl:for-each select="ErrosAvisosRow[NOME_ARQUIVO!='']">
		<fo:table-row>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="NOME_ARQUIVO"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="CD_ERRO"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="LINHA"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:value-of select="CAMPO"/>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeft">
		   <xsl:if test="STATUS='E'">ERRO</xsl:if>
		   <xsl:if test="STATUS='J'">JUSTIF.</xsl:if>
		   <xsl:if test="STATUS='W'">AVISO</xsl:if>
		   <xsl:if test="STATUS='A'">ALERTA</xsl:if>
		   <xsl:if test="STATUS='I'">INFO</xsl:if>
		  </fo:block>
		 </fo:table-cell>
		 <fo:table-cell>
		  <fo:block xsl:use-attribute-sets="txtLeftShort2">
		   <xsl:value-of select="DESCRICAO"/>
		  </fo:block>
		 </fo:table-cell>
		</fo:table-row>
	   </xsl:for-each>
	 </fo:table-body>
	</fo:table>
</xsl:template>
    
<xsl:template match="ErrosAvisosJustificativas">
    <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
       <fo:table-column column-number="1"/>
       <fo:table-body>
       <fo:table-row>
            <fo:table-cell>
            <fo:block><fo:leader leader-pattern="space" /></fo:block>
            <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_4_2">
              <xsl:text>4.2 Avisos Justificados pela Entidade </xsl:text>
            </fo:block>
        </fo:table-cell>
       </fo:table-row>
      </fo:table-body>
     </fo:table>
     <fo:block><fo:leader leader-pattern="space"/></fo:block>
     <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
         <fo:table-column column-number="1" column-width="256pt"/>
         <fo:table-column column-number="2" column-width="300pt"/>

          <fo:table-body>
           <xsl:for-each select="ErrosAvisosJustificativasRow">
                <fo:table-row>
                        <fo:table-cell number-columns-spanned="2">
                                <fo:block xsl:use-attribute-sets="txtLeft">
                                        <fo:inline font-weight="bold" padding-right="3pt">Descri&#231;&#227;o: </fo:inline>
                                        <xsl:value-of select="NOME_PLANILHA"/>
                                </fo:block>
                        </fo:table-cell>
                </fo:table-row>
                <fo:table-row>
                        <fo:table-cell number-columns-spanned="2">
                                <fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
                                        <fo:inline font-weight="bold" padding-right="3pt">Justificativa: </fo:inline>
                                        <xsl:value-of select="TEXTO"/>
                                </fo:block>
                        </fo:table-cell>
                </fo:table-row>
           </xsl:for-each>
          </fo:table-body>
         </fo:table>        
</xsl:template>
<!-- #### FIM - UC074-35 ####-->

<!--
#############################################
#### UC074-36
############################################# 
-->
<xsl:template match="Modelo1/ExAnterior">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoInicial">
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">01/01/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">01/03/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">01/05/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">01/07/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">01/09/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">01/11/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<!--
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
	-->
	<xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_1_1">
	  <xsl:text>5.2.1.1 Modelo 1 - Demonstrativo da Receita Corrente L&#237;quida - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/><xsl:text> - </xsl:text><xsl:value-of select="$periodoInicial"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/><xsl:text> a 31/12/</xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="120pt"/>
  <fo:table-column column-number="2" column-width="202pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <xsl:for-each select="ExAnteriorRow[CD_TIPO='11']">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Subtotal I </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>DEDU&#199;&#213;ES DA RECEITA - Natureza de Receita</xsl:text>
	 </fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="3"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:choose>
  <xsl:when test="count(../ExAnteriorExtra/ExAnteriorExtraRow[AUTOMATICA='S' and CD_TIPO='70' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
   <xsl:for-each select="../ExAnteriorExtra/ExAnteriorExtraRow[AUTOMATICA='S' and CD_TIPO='70' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
	   </xsl:when>
	   <xsl:otherwise>
	     <fo:table-row>
			<fo:table-cell>
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell padding-left="5pt">
		        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
			<fo:table-cell>
	     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
	    	</fo:table-cell>
	  	 </fo:table-row>
	   </xsl:otherwise>
	   </xsl:choose>

  <xsl:if test="count(ExAnteriorRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft">
	DEDU&#199;&#213;ES DA RECEITA - Natureza de Receita
   </fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  
  <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Subtotal II </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../ExAnteriorExtra/ExAnteriorExtraRow[CD_TIPO='70']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../ExAnteriorExtra/ExAnteriorExtraRow[CD_TIPO='70']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(../ExAnteriorExtra/ExAnteriorExtraRow[CD_TIPO='70']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  
  <xsl:if test="count(ExAnteriorRow[CD_TIPO='75' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
    
    <fo:table-row border-width="0.5pt">
      <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
        <fo:block xsl:use-attribute-sets="totalLeft">Subtotal </fo:block>
      </fo:table-cell>
      <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
      </fo:table-cell>
      <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
      </fo:table-cell>
      <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
      </fo:table-cell>
    </fo:table-row>
   
    <xsl:for-each select="ExAnteriorRow[CD_TIPO='75' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
      <fo:table-row>
        <fo:table-cell padding="1pt" border-width="0.5pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><!--xsl:value-of select="CD_CONTA"/--></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="1pt" border-width="0.5pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DSCONTA"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="1pt" border-width="0.5pt" >
          <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="1pt" border-width="0.5pt" >
          <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="1pt" border-width="0.5pt" >
          <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
    </xsl:for-each>
  
  </xsl:if>

  <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5">
     <fo:block xsl:use-attribute-sets="totalLeft"> &#160; </fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE LQUIDA (Ex. Anterior) </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

</fo:table-body>
</fo:table>

<!--
1307 - Deducoes Art. 166 - EC 86/2015
-->

<!--
	<xsl:if test="count(../DeducoesCfArt199/DeducoesCfArt199Row[(CD_TIPO=1307) and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="5">
				<fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">
					<xsl:text>DEDU&#199;&#213;ES PREVISTAS NO ART. 166 DA CF</xsl:text>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:call-template name="TabelaLinhasGenerica">
			<xsl:with-param name="contasList" select="../DeducoesCfArt199/DeducoesCfArt199Row[(CD_TIPO=1307) and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]"/>
		</xsl:call-template>
	</xsl:if>

-->
<!--
1303 - Emendas Parlamentares Individuais - Ex. Anterior
-->
<!--
  <xsl:if test="count(../DeducoesCfArt199/DeducoesCfArt199Row[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]) &gt; 0">
  
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">
      <xsl:text>Dedues da Receita - Emendas Parlamentares Individuais</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1303') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1303') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1303' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1303' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  </xsl:if>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5">
     <fo:block xsl:use-attribute-sets="totalLeft"> &#160; </fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (Ex. Anterior) - ENDIVIDAMENTO</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_CONTABIL)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTE)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTADO)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
-->

<!--
1304 - Emendas Parlamentares de Bancada - Ex. Anterior
-->
<!--
  <xsl:if test="count(../DeducoesCfArt199/DeducoesCfArt199Row[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]) &gt; 0">
  
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">
      <xsl:text>Dedues da Receita - Emendas Parlamentares de Bancada</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1304') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1304') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1304' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1304' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  </xsl:if>


 </fo:table-body>
 </fo:table>
-->

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES DA RECEITA - EMENDAS PARLAMENTARES INDIVIDUAIS
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1303]</xsl:with-param>
		<xsl:with-param name="labelCodigo">CO / Cod. Conta</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES DA RECEITA - EMENDAS PARLAMENTARES INDIVIDUAIS</xsl:with-param>

		<xsl:with-param name="contasList" select="../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO=1303]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (Ex. Anterior) - ENDIVIDAMENTO</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(ExAnteriorRow[CD_TIPO='11']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_CONTABIL)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303']/VLR_CONTABIL)"/>
		<xsl:with-param name="vlrAjuste" select="sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTE)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303']/VLR_AJUSTE)"/>
		<xsl:with-param name="vlrTotal" select="sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTADO)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303']/VLR_AJUSTADO)"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES DA RECEITA - EMENDAS PARLAMENTARES DE BANCADA
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1304]</xsl:with-param>
		<xsl:with-param name="labelCodigo">CO / Cod. Conta</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES DA RECEITA - EMENDAS PARLAMENTARES DE BANCADA</xsl:with-param>

		<xsl:with-param name="contasList" select="../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO=1304]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES DA RECEITA - FONTES DE RECURSO
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1309]</xsl:with-param>
		<xsl:with-param name="labelCodigo">FR / Cod. Conta</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES DA RECEITA - FONTES DE RECURSO</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1309]"/>
	</xsl:call-template>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="120pt"/>
  <fo:table-column column-number="2" column-width="202pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-body>
	<fo:table-row>
		<fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
	</fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (Ex. Anterior) - DESPESA COM PESSOAL</fo:block>
     <!--<fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA AJUSTADA - EC 86/2015 - Ex. Anterior</fo:block>-->
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_CONTABIL)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1304' or CD_TIPO='1307' or CD_TIPO='1309']/VLR_CONTABIL) , '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTE)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1304' or CD_TIPO='1307' or CD_TIPO='1309']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='11']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)+sum(ExAnteriorRow[CD_TIPO='75']/VLR_AJUSTADO)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1304' or CD_TIPO='1307' or CD_TIPO='1309']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-36 ####-->

<!--
#############################################
#### UC074-37  - SEM CAMARA
############################################# 
-->
<xsl:template match="Modelo1/ExAtual">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text>
	<!-- <xsl:variable name="aux1">
		1<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if> -->
</xsl:variable>

<xsl:variable name="manual">
	<xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
	<!-- <xsl:variable name="aux2">
		<xsl:for-each select="ExAtualRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if> -->
</xsl:variable>

 <!-- VARIAVEIS USADAS NA COLUNA TOTAL -->
 <xsl:variable name="recContabil">
  <xsl:if test="ExAtualRow/CD_TIPO='12'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='12']/VLR_CONTABIL)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="recAjuste">
  <xsl:if test="ExAtualRow/CD_TIPO='12'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='12']/VLR_AJUSTE)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="recAjustado">
  <xsl:if test="ExAtualRow/CD_TIPO='12'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='12']/VLR_AJUSTADO)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="receitasContabil">
  <xsl:if test="$recContabil=''">0.00</xsl:if>
  <xsl:if test="$recContabil!=''"><xsl:value-of select="$recContabil"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="receitasAjuste">
  <xsl:if test="$recAjuste=''">0.00</xsl:if>
  <xsl:if test="$recAjuste!=''"><xsl:value-of select="$recAjuste"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="receitasAjustado">
  <xsl:if test="$recAjustado=''">0.00</xsl:if>
  <xsl:if test="$recAjustado!=''"><xsl:value-of select="$recAjustado"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="dedContabil">
  <xsl:if test="ExAtualRow/CD_TIPO='72'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='72']/VLR_CONTABIL)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="dedAjuste">
  <xsl:if test="ExAtualRow/CD_TIPO='72'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='72']/VLR_AJUSTE)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="dedAjustado">
  <xsl:if test="ExAtualRow/CD_TIPO='72'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='72']/VLR_AJUSTADO)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="dedFRContabil">0.00</xsl:variable>
 <xsl:variable name="dedFRAjuste">0.00</xsl:variable>
 <xsl:variable name="dedFRAjustado">0.00</xsl:variable>

 <!--
 <xsl:variable name="dedFRContabil">
  <xsl:choose>
   <xsl:when test="count(../../GenericoConta/GenericoContaRow[CD_TIPO='1308']) &gt; 0">
    <xsl:value-of select="sum(../../GenericoConta/GenericoContaRow[CD_TIPO='1308']/VLR_CONTABIL)"></xsl:value-of>
   </xsl:when>
   <xsl:otherwise>
   0.00
   </xsl:otherwise>
  </xsl:choose>
 </xsl:variable>

 <xsl:variable name="dedFRAjuste">
  <xsl:choose>
   <xsl:when test="count(../../GenericoConta/GenericoContaRow[CD_TIPO='1308']) &gt; 0">
    <xsl:value-of select="sum(../../GenericoConta/GenericoContaRow[CD_TIPO='1308']/VLR_AJUSTE)"></xsl:value-of>
   </xsl:when>
   <xsl:otherwise>
   0.00
   </xsl:otherwise>
  </xsl:choose>
 </xsl:variable>

 <xsl:variable name="dedFRAjustado">
  <xsl:choose>
   <xsl:when test="count(../../GenericoConta/GenericoContaRow[CD_TIPO='1308']) &gt; 0">
    <xsl:value-of select="sum(../../GenericoConta/GenericoContaRow[CD_TIPO='1308']/VLR_AJUSTADO)"></xsl:value-of>
   </xsl:when>
   <xsl:otherwise>
   0.00
   </xsl:otherwise>
  </xsl:choose>
 </xsl:variable>
 -->

 <xsl:variable name="deducaoContabil">
  <xsl:if test="$dedContabil=''">0.00</xsl:if>
  <xsl:if test="$dedContabil!=''"><xsl:value-of select="$dedContabil"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="deducaoAjuste">
  <xsl:if test="$dedAjuste=''">0.00</xsl:if>
  <xsl:if test="$dedAjuste!=''"><xsl:value-of select="$dedAjuste"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="deducaoAjustado">
  <xsl:if test="$dedAjustado=''">0.00</xsl:if>
  <xsl:if test="$dedAjustado!=''"><xsl:value-of select="$dedAjustado"></xsl:value-of></xsl:if>
 </xsl:variable>
 
 <xsl:variable name="perdContabil">
  <xsl:if test="ExAtualRow/CD_TIPO='73'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='73']/VLR_CONTABIL)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="perdAjuste">
  <xsl:if test="ExAtualRow/CD_TIPO='73'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='73']/VLR_AJUSTE)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="perdAjustado">
  <xsl:if test="ExAtualRow/CD_TIPO='73'">
   <xsl:value-of select="sum(ExAtualRow[CD_TIPO='73']/VLR_AJUSTADO)"></xsl:value-of>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="perdasContabil">
  <xsl:if test="$perdContabil=''">0.00</xsl:if>
  <xsl:if test="$perdContabil!=''"><xsl:value-of select="$perdContabil"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="perdasAjuste">
  <xsl:if test="$perdAjuste=''">0.00</xsl:if>
  <xsl:if test="$perdAjuste!=''"><xsl:value-of select="$perdAjuste"></xsl:value-of></xsl:if>
 </xsl:variable>

 <xsl:variable name="perdasAjustado">
  <xsl:if test="$perdAjustado=''">0.00</xsl:if>
  <xsl:if test="$perdAjustado!=''"><xsl:value-of select="$perdAjustado"></xsl:value-of></xsl:if>
 </xsl:variable>
 
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_1_2">
	  <xsl:text>5.2.1.2 Modelo 1 - Demonstrativo da Receita Corrente L&#237;quida - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="120pt"/>
  <fo:table-column column-number="2" column-width="202pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <xsl:for-each select="ExAtualRow[CD_TIPO='12' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  <!--<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES != 6">-->
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">Subtotal I </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasContabil, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasAjuste, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasAjustado, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  <!--</xsl:if>-->

   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>DEDU&#199;&#213;ES DA RECEITA - Naturezas de Receita</xsl:text>
	 </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:choose>
  <xsl:when test="count(../ExAtualExtra/ExAtualExtraRow[CD_TIPO!='12' and CD_TIPO!='73' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
   <xsl:for-each select="../ExAtualExtra/ExAtualExtraRow[CD_TIPO!='12' and CD_TIPO!='73' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
	</xsl:when>
	<xsl:otherwise>
	 <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	 </fo:table-row>
	</xsl:otherwise>
	</xsl:choose>

  <xsl:choose>
  <xsl:when test="count(../ExAtualExtra/ExAtualExtraRow[CD_TIPO!='12' and CD_TIPO!='73' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>DEDU&#199;&#213;ES DA RECEITA - Naturezas de Receita</xsl:text>
	 </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:for-each select="../ExAtualExtra/ExAtualExtraRow[CD_TIPO!='12' and CD_TIPO!='73' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
	</xsl:when>
	<!--<xsl:otherwise>
	 <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	 </fo:table-row>
	</xsl:otherwise>-->
	</xsl:choose>

  <!--<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES != 6">-->
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">Subtotal II </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($deducaoContabil, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($deducaoAjuste, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($deducaoAjustado, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  <!--</xsl:if>-->


  <xsl:if test="count(ExAtualRow[CD_TIPO='73' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">Subtotal </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasContabil - $deducaoContabil, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasAjuste - $deducaoAjuste, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasAjustado - $deducaoAjustado, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:if>
  
  <xsl:for-each select="ExAtualRow[CD_TIPO='73' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <!--xsl:value-of select="CD_CONTA"/-->
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DSCONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <!--
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">FR / Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>DEDU&#199;&#213;ES DA RECEITA - Fonte de Recurso</xsl:text>
	 </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:choose>
  <xsl:when test="count(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO='1308' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
   <xsl:for-each select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO='1308' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
	</xsl:when>
	<xsl:otherwise>
	 <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell>
	 		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	 </fo:table-row>
	</xsl:otherwise>
	</xsl:choose>

  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES != 6">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">Subtotal III</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number( $dedFRContabil, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($dedFRAjuste, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($dedFRAjustado, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:if>
  -->

  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES != 6">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (Ex Atual)</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasContabil - $deducaoContabil + $perdasContabil, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasAjuste - $deducaoAjuste + $perdasAjuste, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($receitasAjustado - $deducaoAjustado + $perdasAjustado, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:if>
  
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (12 Meses)</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_CONTABIL)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL))+($receitasContabil - $deducaoContabil + $perdasContabil), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTE)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE))+($receitasAjuste - $deducaoAjuste + $perdasAjuste), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTADO)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO))+($receitasAjustado - $deducaoAjustado + $perdasAjustado), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

<!--
1305 - Emendas Parlamentares Individuais - Ex. Atual
-->

<!--
  <xsl:if test="count(../DeducoesCfArt199/DeducoesCfArt199Row[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]) &gt; 0">
  
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">
      <xsl:text>Dedues da Receita - Emendas Parlamentares Individuais</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1305') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1305') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1305' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1305' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Total das Dedues da Receita - Emendas Parlamentares Individuais </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_CONTABIL)), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_AJUSTADO)), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </xsl:if>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA - ENDIVIDAMENTO (12 MESES)</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_CONTABIL)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_CONTABIL))+($receitasContabil - $deducaoContabil - $dedFRContabil + $perdasContabil), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTE)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_AJUSTE))+($receitasAjuste - $deducaoAjuste - $dedFRAjuste + $perdasAjuste), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTADO)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_AJUSTADO))+($receitasAjustado - $deducaoAjustado - $dedFRAjustado + $perdasAjustado), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

-->
<!--
1306 - Emendas Parlamentares de Bancada - Ex. Atual
-->

<!--
  <xsl:if test="count(../DeducoesCfArt199/DeducoesCfArt199Row[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]) &gt; 0">
  
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" xsl:use-attribute-sets="txtLeft">
      <xsl:text>Dedues da Receita - Emendas Parlamentares de Bancada</xsl:text>
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1306') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='S' and (CD_TIPO='1306') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>
  
  <xsl:if test="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1306' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
  <xsl:for-each select="../DeducoesCfArt199/DeducoesCfArt199Row[AUTOMATICA='N' and CD_TIPO='1306' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_COMPL_RECURSO"/>
	  <xsl:text> / </xsl:text>
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:if>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Total das Dedues da Receita - Emendas Parlamentares de Bancada </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1304' or CD_TIPO='1306']/VLR_CONTABIL)), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1304' or CD_TIPO='1306']/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number((sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1304' or CD_TIPO='1306']/VLR_AJUSTADO)), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </xsl:if>
-->

 </fo:table-body>
 </fo:table>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES DA RECEITA - EMENDAS PARLAMENTARES INDIVIDUAIS
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1305]</xsl:with-param>
		<xsl:with-param name="labelCodigo">CO / Cod. Conta</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES DA RECEITA - EMENDAS PARLAMENTARES INDIVIDUAIS</xsl:with-param>

		<xsl:with-param name="contasList" select="../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO=1305]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (Janeiro - <xsl:value-of select="$mesNome"/>) - ENDIVIDAMENTO</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=12]/VLR_CONTABIL) - sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=72 or CD_TIPO=1305]/VLR_CONTABIL)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=12]/VLR_AJUSTE) - sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=72 or CD_TIPO=1305]/VLR_AJUSTE)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=12]/VLR_AJUSTADO)  -sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=72 or CD_TIPO=1305]/VLR_AJUSTADO)"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (12 Meses) - ENDIVIDAMENTO</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_CONTABIL)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_CONTABIL) + ($receitasContabil - $deducaoContabil - $dedFRContabil + $perdasContabil)"/>
		<xsl:with-param name="vlrAjuste" select="sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTE)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_AJUSTE) + ($receitasAjuste - $deducaoAjuste - $dedFRAjuste + $perdasAjuste)"/>
		<xsl:with-param name="vlrTotal" select="sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTADO)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)-sum(../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO='1303' or CD_TIPO='1305']/VLR_AJUSTADO) + ($receitasAjustado - $deducaoAjustado - $dedFRAjustado + $perdasAjustado)"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES DA RECEITA - EMENDAS PARLAMENTARES DE BANCADA
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1306]</xsl:with-param>
		<xsl:with-param name="labelCodigo">CO / Cod. Conta</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES DA RECEITA - EMENDAS PARLAMENTARES DE BANCADA</xsl:with-param>

		<xsl:with-param name="contasList" select="../DeducoesCfArt199/DeducoesCfArt199Row[CD_TIPO=1306]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES DA RECEITA - FONTES DE RECURSO
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1308]</xsl:with-param>
		<xsl:with-param name="labelCodigo">FR / Cod. Conta</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES DA RECEITA - FONTES DE RECURSO</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1308]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (Janeiro - <xsl:value-of select="$mesNome"/>) - DESPESA COM PESSOAL</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=12]/VLR_CONTABIL) - sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=72 or CD_TIPO=1305 or CD_TIPO=1306 or CD_TIPO=1308]/VLR_CONTABIL)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=12]/VLR_AJUSTE) - sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=72 or CD_TIPO=1305 or CD_TIPO=1306 or CD_TIPO=1308]/VLR_AJUSTE)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=12]/VLR_AJUSTADO)  -sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=72 or CD_TIPO=1305 or CD_TIPO=1306 or CD_TIPO=1308]/VLR_AJUSTADO)"/>
	</xsl:call-template>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="120pt"/>
  <fo:table-column column-number="2" column-width="202pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA RECEITA CORRENTE L&#205;QUIDA (12 Meses) - DESPESA COM PESSOAL</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_CONTABIL)
		-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_CONTABIL)
		-sum(../DeducoesCfArt199/DeducoesCfArt199Row/VLR_CONTABIL)
		-sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1308]/VLR_CONTABIL)
		+($receitasContabil - $deducaoContabil - $dedFRContabil + $perdasContabil)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTE)
		-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTE)
		-sum(../DeducoesCfArt199/DeducoesCfArt199Row/VLR_AJUSTE)
		-sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1308]/VLR_AJUSTE)
		+($receitasAjuste - $deducaoAjuste - $dedFRAjuste + $perdasAjuste)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(../ExAnterior/ExAnteriorRow[CD_TIPO='11' or CD_TIPO='75']/VLR_AJUSTADO)
		-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='70']/VLR_AJUSTADO)
		-sum(../DeducoesCfArt199/DeducoesCfArt199Row/VLR_AJUSTADO)
		-sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1308]/VLR_AJUSTADO)
		+($receitasAjustado - $deducaoAjustado - $dedFRAjustado + $perdasAjustado)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   
 </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-37 ####-->
	
<!--
#############################################
#### UC074-87 - SOMENTE CAMARA
############################################# 
-->	
<xsl:template match="Modelo1/Legislativo">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
	  <fo:block xsl:use-attribute-sets="titFCinza" id="5.2.1.3">
	  	5.2.1.3 Modelo 1 - Demonstrativo da Receita Corrente L&#237;quida do Munic&#237;pio - Valor Digitado 
	  </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="226pt"/>
  <fo:table-column column-number="2" column-width="330pt"/>
  
  <fo:table-body>
  <xsl:for-each select="LegislativoRow">
   <fo:table-row>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  RECEITA CORRENTE L&#205;QUIDA - DESPESA COM PESSOAL
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="1pt" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-87 ####-->

<!--
#############################################
#### UC074-88
############################################# 
-->
<xsl:template match="Consorcios">

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_1_4">
	  <xsl:text>1.4 Participa&#231;&#227;o com Cons&#243;rcio P&#250;blico </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <xsl:if test="count(ConsorciosRow) = 0">
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-width="16pt"  column-number="1"/>
		<fo:table-column column-width="540pt" column-number="2"/>
		<fo:table-body>	
			<fo:table-row>
				<fo:table-cell number-columns-spanned="1">
					<fo:block xsl:use-attribute-sets="txtLeft"><fo:external-graphic alignment-baseline="before-edge" src="{concat($PATH_IMAGENS,'check.jpg')}"/></fo:block>
				</fo:table-cell>
				<fo:table-cell number-columns-spanned="1">
					<fo:block xsl:use-attribute-sets="txtLeft">O Munic&#237;pio n&#227;o faz parte de nenhum Cons&#243;rcio P&#250;blico regido pela lei federal 11.107/2005</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
	</fo:table>
 </xsl:if>

 <xsl:if test="count(ConsorciosRow) &gt; 0">
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
 	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="100pt"/>
		<fo:table-column column-number="2" column-width="350pt"/>

		<fo:table-header>
			<fo:table-row>
				<fo:table-cell>
				 <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">CNPJ </fo:block>
				</fo:table-cell>
				<fo:table-cell>
				 <fo:block xsl:use-attribute-sets="cabecalhoLeft" font-weight="bold">Nome </fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-header>

		<fo:table-body>
		   <xsl:for-each select="ConsorciosRow">
			<fo:table-row>
			 <fo:table-cell>
			  <fo:block xsl:use-attribute-sets="txtLeft">
			   <xsl:value-of select="CGC_CONSORCIO"/>
			  </fo:block>
			 </fo:table-cell>
			 <fo:table-cell>
			  <fo:block xsl:use-attribute-sets="txtLeft">
			   <xsl:value-of select="NM_CONSORCIO"/>
			  </fo:block>
			 </fo:table-cell>
			</fo:table-row>
		   </xsl:for-each>
		</fo:table-body>
	</fo:table>
 </xsl:if>

</xsl:template>
<!-- #### FIM - UC074-88 ####-->

<!--
#############################################
#### UC074-38
############################################# 
-->
<xsl:template match="Modelo2/ExAnterior">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoInicial">
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">01/01/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">01/03/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">01/05/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">01/07/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">01/09/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">01/11/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExAnteriorRow[CD_TIPO='60' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExAnteriorRow[CD_TIPO='60' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='61' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual2">
	<xsl:variable name="aux4">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='61' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux4!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica3">
	<xsl:variable name="aux5">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='62' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux5!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual3">
	<xsl:variable name="aux6">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='62' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux6!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica4">
	<xsl:variable name="aux7">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='63' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux7!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual4">
	<xsl:variable name="aux8">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='63' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux8!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1"/>
    
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell>
          <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_2_1">
            <xsl:text>5.2.2.1 Modelo 2 - Demonstrativo da Despesa com Pessoal (Executivo) - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/><xsl:text> - </xsl:text><xsl:value-of select="$periodoInicial"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/><xsl:text> a 31/12/</xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
  </fo:table>
  
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
  <!-- 1o bloco do relat&#243;rio -->
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block font-weight="bold" text-align="left">DESPESA LIQUIDADA </fo:block>
        </fo:table-cell>
        </fo:table-row>   
        <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>
      <xsl:for-each select="ExAnteriorRow[CD_TIPO='59' and AUTOMATICA='S']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA DESPESA LIQUIDADA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='59']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='59']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='59']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
        <!--<fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>-->
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAnteriorRow[CD_TIPO='60' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAnteriorRow[CD_TIPO='60' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAnteriorRow[CD_TIPO='60' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS DEDU&#199;&#213;ES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='60']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='60']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='60']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
      
    </fo:table-body>
  </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 2o bloco do relat&#243;rio --> 
 <!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='61' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='61' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='61' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='61']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='61']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='61']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES POR FONTE DE RECURSO
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1701]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DE DEDUES POR FONTE DE RECURSO</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES POR FONTE DE RECURSO - FR 605 (Pisos salariais dos enfermeiros)
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1702]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DE DEDUES POR FONTE DE RECURSO - FR 605 (Pisos salariais dos enfermeiros)</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1702]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">
			Deduo permitida em
			<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/> -
			<!--<xsl:value-of select="format-number(
				/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702]/VLR_INDICE[1]*100
				, '###.###.##0,00')"/>-->
			90% do Total
		</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702]/VLR_CONTABIL_MULT)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702]/VLR_AJUSTE_MULT)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702]/VLR_AJUSTADO_MULT)"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 3o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica3"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='62' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='62' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual3"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='62' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='62']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='62']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='62']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- 4o bloco do relat&#243;rio --> 
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS</fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>
 
    <fo:table-body>
    
      <xsl:for-each select="ExAnteriorRow[CD_TIPO='68' and AUTOMATICA='S']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DOS RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='68']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='68']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='68']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA - RPNP</fo:block>
        </fo:table-cell>
        <!--<fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>-->
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='63' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='63' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='63' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DEDU&#199;&#213;ES POR NATUREZA DE DESPESA - RPNP </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='63']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='63']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='63']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES POR FONTE DE RECURSO - RPNP
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1703]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DE DEDUES POR FONTE DE RECURSO - RPNP</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1703]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES POR FONTE DE RECURSO - FR 605 (Pisos salariais dos enfermeiros) - RPNP
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1704]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DE DEDUES POR FONTE DE RECURSO - FR 605 (Pisos salariais dos enfermeiros) - RPNP</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1704]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">
			Deduo permitida em
			<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/> -
			<!--<xsl:value-of select="format-number(
				/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1704]/VLR_INDICE[1]*100
				, '###.###.##0,00')"/>-->
			90% do Total
		</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1704]/VLR_CONTABIL_MULT)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1704]/VLR_AJUSTE_MULT)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1704]/VLR_AJUSTADO_MULT)"/>
	</xsl:call-template>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>
    
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">Total da Despesa c/ Pessoal Ex. Anterior </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='59' or CD_TIPO='62' or CD_TIPO='68']/VLR_CONTABIL)
                -sum(ExAnteriorRow[CD_TIPO='60' or CD_TIPO='61' or CD_TIPO='63']/VLR_CONTABIL)
                -sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701 or CD_TIPO=1703]/VLR_CONTABIL)
                -sum(../../GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702 or CD_TIPO=1704]/VLR_CONTABIL_MULT)
                , '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='59' or CD_TIPO='62' or CD_TIPO='68']/VLR_AJUSTE)
                -sum(ExAnteriorRow[CD_TIPO='60' or CD_TIPO='61' or CD_TIPO='63']/VLR_AJUSTE)
                -sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701 or CD_TIPO=1703]/VLR_AJUSTE)
                -sum(../../GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702 or CD_TIPO=1704]/VLR_AJUSTE_MULT)
                , '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='59' or CD_TIPO='62' or CD_TIPO='68']/VLR_AJUSTADO)
                -sum(ExAnteriorRow[CD_TIPO='60' or CD_TIPO='61' or CD_TIPO='63']/VLR_AJUSTADO)
                -sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701 or CD_TIPO=1703]/VLR_AJUSTADO)
                -sum(../../GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702 or CD_TIPO=1704]/VLR_AJUSTADO_MULT)
                , '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
    
    </fo:table-body>
  </fo:table>
</xsl:template>
<!-- #### FIM - UC074-38 ####-->

<!--
#############################################
#### UC074-39
############################################# 
-->	
<xsl:template match="Modelo2/ExAtual">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExAtualRow[CD_TIPO='64' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExAtualRow[CD_TIPO='64' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='65' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual2">
	<xsl:variable name="aux4">			
		<xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='65' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux4!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica3">
	<xsl:variable name="aux5">
		1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='66' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux5!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual3">
	<xsl:variable name="aux6">			
		<xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='66' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux6!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica4">
	<xsl:variable name="aux7">
		1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='67' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux7!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual4">
	<xsl:variable name="aux8">			
		<xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='67' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux8!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica5">
	<xsl:variable name="aux9">
		1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='1150' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux9!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual5">
	<xsl:variable name="aux10">			
		<xsl:for-each select="ExAtualRow[AUTOMATICA='N' and (CD_TIPO='1150' or CD_TIPO='1151') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux10!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1"/>
   
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_2_2">
            <xsl:text>5.2.2.2 Modelo 2 - Demonstrativo da Despesa com Pessoal (Executivo) - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
  </fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <!-- 1o bloco do relat&#243;rio -->
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block font-weight="bold" text-align="left">DESPESA LIQUIDADA </fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>
      <xsl:for-each select="ExAtualRow[CD_TIPO='69' and AUTOMATICA='S']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA DESPESA LIQUIDADA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='69']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='69']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='69']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt" font-weight="bold" text-align="left" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="totalLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAtualRow[CD_TIPO='64' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAtualRow[CD_TIPO='64' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAtualRow[CD_TIPO='64' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS DEDU&#199;&#213;ES POR NATUREZA DE DESPESA  </fo:block>
        </fo:table-cell>
        <!--
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='69']/VLR_CONTABIL)-sum(ExAtualRow[CD_TIPO='64']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='69']/VLR_AJUSTE)-sum(ExAtualRow[CD_TIPO='64']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='69']/VLR_AJUSTADO)-sum(ExAtualRow[CD_TIPO='64']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        -->
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='64']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='64']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='64']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">DEDUES POR FONTE DE RECURSO
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=76]</xsl:with-param>
		<xsl:with-param name="labelCodigo">Cd. Fonte / Conta</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES POR FONTE DE RECURSO</xsl:with-param>
		
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=76]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">DEDUES POR FONTE DE RECURSO - FR 605 </xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1705]</xsl:with-param>
		<xsl:with-param name="labelCodigo">Cd. Fonte / Conta</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DEDUES POR FONTE DE RECURSO - FR 605</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1705]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">
			Deduo permitida em
			<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> -
			<!--<xsl:value-of select="format-number(
				/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_INDICE[1]*100
				, '###.###.##0,00')"/>-->
			80% do Total
		</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_CONTABIL_MULT)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_AJUSTE_MULT)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_AJUSTADO_MULT)"/>
	</xsl:call-template>

	<!--
	<fo:block xsl:use-attribute-sets="total" text-align="left">
		Deduo permitida em
		<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> -
		<xsl:value-of select="format-number(
			/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_INDICE[1]*100
			, '###.###.##0,00')"/>% do Total
	</fo:block>
	-->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 2o bloco do relat&#243;rio -->
 <!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and CD_TIPO='65' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='65' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='65' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='65']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='65']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='65']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <!-- 3o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica3"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and CD_TIPO='66' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='66' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual3"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='66' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='66']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='66']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='66']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

	<xsl:if test="count(../../GenericoConta/GenericoContaRow[CD_TIPO=71]) > 0">
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			RESTOS A PAGAR NO PROCESSADOS
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=71]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DOS RESTOS A PAGAR NO PROCESSADOS</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoConta/GenericoContaRow[CD_TIPO=71]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES POR NATUREZA DE DESPESA
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=67]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES POR NATUREZA DE DESPESA</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoConta/GenericoContaRow[CD_TIPO=67]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">
			DEDUES POR FONTE DE RECURSO
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=77]</xsl:with-param>
		<xsl:with-param name="labelCodigo">C&#243;d. Fonte / Conta</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS DEDUES POR FONTE DE RECURSO</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=77]"/>
	</xsl:call-template>
	</xsl:if>

	<xsl:if test="$isFechamentoDeExercicio">
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">DEDUES POR FONTE DE RECURSO - FR 605 </xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1706]</xsl:with-param>
		<xsl:with-param name="labelCodigo">Cd. Fonte / Conta</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DEDUES POR FONTE DE RECURSO - FR 605</xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=1706]"/>
	</xsl:call-template>

	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">
			Deduo permitida em
			<xsl:value-of select="/rve/Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> -
			<!--<xsl:value-of select="format-number(
				/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1706]/VLR_INDICE[1]*100
				, '###.###.##0,00')"/>-->
			80% do Total
		</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1706]/VLR_CONTABIL_MULT)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1706]/VLR_AJUSTE_MULT)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1706]/VLR_AJUSTADO_MULT)"/>
	</xsl:call-template>
	</xsl:if>
	
	<!--
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">TOTAL DOS RESTOS A PAGAR NO PROCESSADOS</xsl:with-param>
		<xsl:with-param name="vlrTotal" select="
			sum(../../GenericoConta/GenericoContaRow[CD_TIPO=71]/VLR_AJUSTADO)
			- sum(../../GenericoConta/GenericoContaRow[CD_TIPO=67]/VLR_AJUSTADO)
			- sum(../../GenericoContaRV/GenericoContaRVRow[CD_TIPO=77]/VLR_AJUSTADO)
			"/>
	</xsl:call-template>
	-->

  <!-- 4o bloco do relat&#243;rio --> 
  <!--
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=6">
            <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
          </xsl:if>
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES!=6">
            <fo:block font-weight="bold" text-align="left">EMPENHOS N&#195;O LIQUIDADOS </fo:block>
          </xsl:if>
        </fo:table-cell>
      </fo:table-row>   
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>
      <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='71']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES </fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and CD_TIPO='67' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='67' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
          <fo:table-cell>
            <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
          </fo:table-cell>
          <fo:table-cell padding-left="5pt">
            <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
          </fo:table-cell>
          <fo:table-cell>
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell>
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell>
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='67' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES!=6">
            <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DOS EMPENHOS N&#195;O LIQUIDADOS </fo:block>
          </xsl:if>
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=6">
            <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DOS RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
          </xsl:if>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='71']/VLR_CONTABIL)-sum(ExAtualRow[CD_TIPO='67']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='71']/VLR_AJUSTE)-sum(ExAtualRow[CD_TIPO='67']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='71']/VLR_AJUSTADO)-sum(ExAtualRow[CD_TIPO='67']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
  -->

  <!-- 5o bloco do relat&#243;rio [1051] --> 

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">CONTAS CONTBEIS DE CONTROLE - Exerccio Anterior </xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1151]</xsl:with-param>
		<!--<xsl:with-param name="labelCodigo">Cd. Fonte / Conta</xsl:with-param>-->
		<xsl:with-param name="labelSubtotal">TOTAL DAS CONTAS CONTBEIS DE CONTROLE - Exerccio Anterior </xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoConta/GenericoContaRow[CD_TIPO=1151]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica">
		<xsl:with-param name="labelTitulo">CONTAS CONTBEIS DE CONTROLE - Exerccio Atual </xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=1150]</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS CONTAS CONTBEIS DE CONTROLE - Exerccio Atual </xsl:with-param>
		<xsl:with-param name="contasList" select="../../GenericoConta/GenericoContaRow[CD_TIPO=1150]"/>
	</xsl:call-template>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<xsl:call-template name="TabelaGenerica1LinhaTotal">
		<xsl:with-param name="dsTotal">
			TOTAL DAS CONTAS CONTBEIS DE CONTROLE
		</xsl:with-param>
		<xsl:with-param name="vlrContabil" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=1151 or CD_TIPO=1150]/VLR_CONTABIL)"/>
		<xsl:with-param name="vlrAjuste" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=1151 or CD_TIPO=1150]/VLR_AJUSTE)"/>
		<xsl:with-param name="vlrTotal" select="sum(/rve/GenericoConta/GenericoContaRow[CD_TIPO=1151 or CD_TIPO=1150]/VLR_AJUSTADO)"/>
	</xsl:call-template>

<!--
 <xsl:if test="count(ExAtualRow[(CD_TIPO='1150' or CD_TIPO='1151') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS CONT&#193;BEIS DE CONTROLE</fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica5"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and (CD_TIPO='1150' or CD_TIPO='1151') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and (CD_TIPO='1150' or CD_TIPO='1151') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual5"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and (CD_TIPO='1150' or CD_TIPO='1151') and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS CONT&#193;BEIS DE CONTROLE</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>
 </xsl:if>
-->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 6o BLOCO -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>
    
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>

   <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES!=6">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Total da Despesa c/ Pessoal Ex. Atual </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151' or CD_TIPO='66' or CD_TIPO='69' or CD_TIPO='71']/VLR_CONTABIL)
		-sum(ExAtualRow[CD_TIPO='64' or CD_TIPO='65' or CD_TIPO='67' or CD_TIPO='76']/VLR_CONTABIL)
		-sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_CONTABIL_MULT)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151' or CD_TIPO='66' or CD_TIPO='69' or CD_TIPO='71']/VLR_AJUSTE)
		-sum(ExAtualRow[CD_TIPO='64' or CD_TIPO='65' or CD_TIPO='67' or CD_TIPO='76']/VLR_AJUSTE)
		-sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_AJUSTE_MULT)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151' or CD_TIPO='66' or CD_TIPO='69' or CD_TIPO='71']/VLR_AJUSTADO)
		-sum(ExAtualRow[CD_TIPO='64' or CD_TIPO='65' or CD_TIPO='67' or CD_TIPO='76']/VLR_AJUSTADO)
		-sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1705]/VLR_AJUSTADO_MULT)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:if>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Total da Despesa com Pessoal </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(../ExAnterior/ExAnteriorRow[CD_TIPO='59' or CD_TIPO='62' or CD_TIPO='68']/VLR_CONTABIL)
		-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='60' or CD_TIPO='61' or CD_TIPO='63']/VLR_CONTABIL)
		-sum(/rve/GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701 or CD_TIPO=1703]/VLR_CONTABIL)
		+sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151' or CD_TIPO='66' or CD_TIPO='69' or CD_TIPO='71']/VLR_CONTABIL)
		-sum(ExAtualRow[CD_TIPO='64' or CD_TIPO='65' or CD_TIPO='67' or CD_TIPO='76' or CD_TIPO='77']/VLR_CONTABIL)
		-sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702 or CD_TIPO=1704 or CD_TIPO=1705 or CD_TIPO=1706]/VLR_CONTABIL_MULT)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(../ExAnterior/ExAnteriorRow[CD_TIPO='59' or CD_TIPO='62' or CD_TIPO='68']/VLR_AJUSTE)
		-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='60' or CD_TIPO='61' or CD_TIPO='63']/VLR_AJUSTE)
		-sum(/rve/GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701 or CD_TIPO=1703]/VLR_AJUSTE)
		+sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151' or CD_TIPO='66' or CD_TIPO='69' or CD_TIPO='71']/VLR_AJUSTE)
		-sum(ExAtualRow[CD_TIPO='64' or CD_TIPO='65' or CD_TIPO='67' or CD_TIPO='76' or CD_TIPO='77']/VLR_AJUSTE)
		-sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702 or CD_TIPO=1704 or CD_TIPO=1705 or CD_TIPO=1706]/VLR_AJUSTE_MULT)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(
		sum(../ExAnterior/ExAnteriorRow[CD_TIPO='59' or CD_TIPO='62' or CD_TIPO='68']/VLR_AJUSTADO)
		-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='60' or CD_TIPO='61' or CD_TIPO='63']/VLR_AJUSTADO)
		-sum(/rve/GenericoContaRV/GenericoContaRVRow[CD_TIPO=1701 or CD_TIPO=1703]/VLR_AJUSTADO)
		+sum(ExAtualRow[CD_TIPO='1150' or CD_TIPO='1151' or CD_TIPO='66' or CD_TIPO='69' or CD_TIPO='71']/VLR_AJUSTADO)
		-sum(ExAtualRow[CD_TIPO='64' or CD_TIPO='65' or CD_TIPO='67' or CD_TIPO='76' or CD_TIPO='77']/VLR_AJUSTADO)
		-sum(/rve/GenericoContaMult/GenericoContaMultRow[CD_TIPO=1702 or CD_TIPO=1704 or CD_TIPO=1705 or CD_TIPO=1706]/VLR_AJUSTADO_MULT)
		, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

	<!--
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block xsl:use-attribute-sets="txtLeft">
		<fo:inline font-weight="bold">Observa&#231;&#227;o</fo:inline>: Onde se l&#234; 330034010000000
		leia-se 3.3.xx.34.01.00.00.00, conforme IN TCE 4/2021.
		<!- -<fo:inline font-family="Courier, monospace">330034010000000</fo:inline>
		<fo:inline font-family="Courier, monospace">3.3.xx.34.01.00.00.00</fo:inline>- ->
	</fo:block>
	-->
 
</xsl:template>
<!-- #### FIM - UC074-39 ####-->
	
<!--
#############################################
#### UC074-40
############################################# 
-->	
<xsl:template match="Modelo3/Executivo">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExecutivoRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExecutivoRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_3_1">
	  <xsl:text>5.2.3.1 Modelo 3 - Demonstrativo da Disponibilidade de Caixa - Ativo Dispon&#237;vel - Executivo/Indiretas (Exceto RPPS) - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="83pt"/>
  <fo:table-column column-number="3" column-width="160pt"/>
  <fo:table-column column-number="4" column-width="71pt"/>
  <fo:table-column column-number="5" column-width="71pt"/>
  <fo:table-column column-number="6" column-width="71pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Fonte Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExecutivoRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExecutivoRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
        <fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExecutivoRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
      <xsl:value-of select="CD_RECURSO"/>
     </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExecutivoRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExecutivoRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExecutivoRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-40 ####-->

<!--
#############################################
#### UC074-86
############################################# 
-->	
<xsl:template match="Modelo3/Legislativo">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="LegislativoRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="LegislativoRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_3_2">
	  <xsl:text>5.2.3.2 Modelo 3 - Demonstrativo da Disponibilidade de Caixa - Ativo Dispon&#237;vel - Legislativo - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="83pt"/>
  <fo:table-column column-number="3" column-width="160pt"/>
  <fo:table-column column-number="4" column-width="71pt"/>
  <fo:table-column column-number="5" column-width="71pt"/>
  <fo:table-column column-number="6" column-width="71pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Fonte Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(LegislativoRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="LegislativoRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
        <fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="LegislativoRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
      <xsl:value-of select="CD_RECURSO"/>
     </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(LegislativoRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(LegislativoRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(LegislativoRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-39 ####-->
	
<!--
#############################################
#### UC074-41
############################################# 
-->	
<xsl:template match="Modelo3/Rpps">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="RppsRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="RppsRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_3_3">
	  <xsl:text>5.2.3.3 Modelo 3 - Demonstrativo da Disponibilidade de Caixa - Ativo Dispon&#237;vel RPPS - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="83pt"/>
  <fo:table-column column-number="3" column-width="160pt"/>
  <fo:table-column column-number="4" column-width="71pt"/>
  <fo:table-column column-number="5" column-width="71pt"/>
  <fo:table-column column-number="6" column-width="71pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Fonte Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(RppsRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="RppsRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
        <fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="5"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="RppsRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RppsRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RppsRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(RppsRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>

</xsl:template>
<!-- #### FIM - UC074-41 ####-->

<!--
#############################################
#### UC074-42
############################################# 
-->	
<xsl:template match="Modelo4/DividaConsolidada">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="DividaConsolidadaRow[CD_TIPO='80' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="DividaConsolidadaRow[CD_TIPO='80' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4_1">
     	<xsl:text>5.2.4.1 Modelo 4 - Demonstrativo da D&#237;vida Consolidada L&#237;quida - D&#237;vida Consolidada ou Fundada - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/> 
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(DividaConsolidadaRow[CD_TIPO='80' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="DividaConsolidadaRow[CD_TIPO='80' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="DividaConsolidadaRow[CD_TIPO='80' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-42 ####-->

<!--
#############################################
#### UC074-43
############################################# 
-->	
<xsl:template match="Modelo4/AtivoCirculante">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="AtivoCirculanteRow[CD_TIPO='84' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">0</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="AtivoCirculanteRow[CD_TIPO='84' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--	 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4_2">
     	<xsl:text>5.2.4.2 Modelo 4 - Demonstrativo da D&#237;vida Consolidada L&#237;quida - Disponibilidade de Caixa (Disponibilidade de Caixa Bruta - Restos a Pagar Processados) - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	</fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(AtivoCirculanteRow[CD_TIPO='84' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">   
  <xsl:for-each select="AtivoCirculanteRow[CD_TIPO='84' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="AtivoCirculanteRow[CD_TIPO='84' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AtivoCirculanteRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AtivoCirculanteRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AtivoCirculanteRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-43 ####-->

<!--
#############################################
#### UC074-44
############################################# 
-->	
<xsl:template match="Modelo4/ObrigacoesFinanceiras">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ObrigacoesFinanceirasRow[CD_TIPO='86' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ObrigacoesFinanceirasRow[CD_TIPO='86' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable> 
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4_3">
     	<xsl:text>5.2.4.3 Modelo 4 - Demonstrativo da D&#237;vida Consolidada L&#237;quida - Demais Haveres Financeiros - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ObrigacoesFinanceirasRow[CD_TIPO='86' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ObrigacoesFinanceirasRow[CD_TIPO='86' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ObrigacoesFinanceirasRow[CD_TIPO='86' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ObrigacoesFinanceirasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ObrigacoesFinanceirasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ObrigacoesFinanceirasRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Total das Dedu&#231;&#245;es (Disponibilidade de Caixa + Demais Haveres Financeiros) </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block/>
     <!--<fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>-->
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block/>
     <!--<fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>-->
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
   
     <fo:block xsl:use-attribute-sets="total">
      <!-- Se disponibilidade eh negativa, considera-se zero -->
        <xsl:variable name="valorTotalDeducoes">
          <xsl:value-of select="sum(../TotalDeducoes/TotalDeducoesRow/VLR_AJUSTADO)"/>
        </xsl:variable>
        <xsl:value-of select="format-number($valorTotalDeducoes, '###.###.##0,00')"/>
                <!-- <xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)+sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)) &gt;= 0">
                       <xsl:value-of select="format-number((sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)+sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)+sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)), '###.###.##0,00')"/>
                </xsl:if>
                <xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)+sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)) &lt; 0">
                       <xsl:value-of select="format-number((sum(ObrigacoesFinanceirasRow/VLR_CONTABIL)+(sum(ObrigacoesFinanceirasRow/VLR_AJUSTE))), '###.###.##0,00')"/>
                </xsl:if>-->
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">Total da D&#237;vida Consolidada L&#237;quida (D&#237;vida Consolidada - Dedu&#231;&#245;es) </fo:block>
    </fo:table-cell>
	
	<!--
	<xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL)) &gt; 0">
	  <xsl:if test="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_CONTABIL) &gt; (sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))">
       <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number(sum(../DividaConsolidada/DividaConsolidadaRow/VLR_CONTABIL)-sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
       </fo:table-cell>
	  </xsl:if>
	  <xsl:if test="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_CONTABIL) &lt; (sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))">
       <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block font-weight="bold" text-align="right">0,00</fo:block>
       </fo:table-cell>
	  </xsl:if>
    </xsl:if>
	<xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL)) &lt;= 0">
      <fo:table-cell padding="2pt"  border-width="0.5pt">
       <fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number(sum(../DividaConsolidada/DividaConsolidadaRow/VLR_CONTABIL)-sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
      </fo:table-cell>
    </xsl:if>
	-->
	<fo:table-cell padding="2pt"  border-width="0.5pt">
       <fo:block font-weight="bold" text-align="right"></fo:block>
    </fo:table-cell>

	<!--
	<xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)) &gt; 0">
	  <xsl:if test="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTE) &gt; (sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE))">
       <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number(sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTE)-(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)), '###.###.##0,00')"/></fo:block>
       </fo:table-cell>
	  </xsl:if>
	  <xsl:if test="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTE) &lt; (sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE))">
       <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block font-weight="bold" text-align="right"><xsl:text>0,00</xsl:text></fo:block>
       </fo:table-cell>
	  </xsl:if>
    </xsl:if>
	<xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)) &lt;= 0">
      <fo:table-cell padding="2pt"  border-width="0.5pt">
       <fo:block font-weight="bold" text-align="right"><xsl:value-of select="format-number(sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTE)-sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
      </fo:table-cell>
    </xsl:if>
	-->
	<fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block font-weight="bold" text-align="right"></fo:block>
    </fo:table-cell>
	
	<!--### CALCULO DO VALOR TOTAL###-->
	<!-- <xsl:variable name="valorAjusteOld">
	 <xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)) &gt; 0">
	  
	   <xsl:if test="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTADO) &gt; (sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE))">
		 <xsl:value-of select="number(sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTADO))-number((sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)))"/>
	   </xsl:if>
	  
	   <xsl:if test="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTADO) &lt; (sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE))">
	   	 0.00
	   </xsl:if>
     </xsl:if>

	 <xsl:if test="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)-sum(ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)-sum(ObrigacoesFinanceirasRow/VLR_AJUSTE)) &lt;= 0">
       <xsl:value-of select="sum(../DividaConsolidada/DividaConsolidadaRow/VLR_AJUSTADO)"/>
     </xsl:if>
	</xsl:variable>-->
	
	<xsl:variable name="valorAjuste">
		<xsl:value-of select="sum(../TotalDividaConsolidadaLiquida/TotalDividaConsolidadaLiquidaRow/VLR_AJUSTADO)"/>
	</xsl:variable>
	<!-- document(concat($PATH_REMESSA,'\remessa.xml'))//codigo -->

    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($valorAjuste, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-44 ####-->

<!--
#############################################
#### UC074-45
############################################# 
-->	
<xsl:template match="Modelo4/OutrasObrigacoes">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="valorDeducao">
	<xsl:value-of select="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)+sum(../ObrigacoesFinanceiras/ObrigacoesFinanceirasRow/VLR_CONTABIL))+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)+sum(../ObrigacoesFinanceiras/ObrigacoesFinanceirasRow/VLR_AJUSTE))"/>
</xsl:variable>
<xsl:variable name="dispCaixa">
	<xsl:value-of select="(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_CONTABIL)+(sum(../AtivoCirculante/AtivoCirculanteRow/VLR_AJUSTE)))"/>
</xsl:variable>

<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="OutrasObrigacoesRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="OutrasObrigacoesRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable> 
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4_4">
     	<xsl:text>5.2.4.4 Modelo 4 - Demonstrativo da D&#237;vida Consolidada L&#237;quida -  Outras Obriga&#231;&#245;es N&#227;o Integrantes da D&#237;vida Consolidada - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(OutrasObrigacoesRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="OutrasObrigacoesRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="OutrasObrigacoesRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 
  <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <xsl:if test="$dispCaixa &gt;= 0.00">
	 	<fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
	 </xsl:if>
     <xsl:if test="$dispCaixa &lt; 0.00">
	 	<fo:block xsl:use-attribute-sets="totalLeft">SUBTOTAL </fo:block>
	 </xsl:if>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OutrasObrigacoesRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OutrasObrigacoesRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OutrasObrigacoesRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
  </fo:table-row>

 <xsl:if test="$dispCaixa &lt; 0.00">
  <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="2">
	 	<fo:block font-weight="bold" text-align="left">Insufici&#234;ncia Financeira</fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($dispCaixa*-1, '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
  </fo:table-row> 	

  <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="2">
	 	<fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number($dispCaixa*-1 + sum(OutrasObrigacoesRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
  </fo:table-row> 	
 </xsl:if> 

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-45 ####-->
	
<!--
#############################################
#### UC074-46
############################################# 
-->	
<xsl:template match="Modelo5/Garantias">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="GarantiasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="GarantiasRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable> 
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_5_1">
	  <xsl:text>5.2.5.1 Modelo 5 - Demonstrativo das Garantias e Contragarantias de Valores - Garantias - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(GarantiasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="GarantiasRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="GarantiasRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(GarantiasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(GarantiasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(GarantiasRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
	 <fo:block><fo:leader leader-pattern="space"/></fo:block>	
	</fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <xsl:choose>
    <xsl:when test="../Pergunta/PerguntaRow/RESPOSTA='S'">
	<fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">O munic&#237;pio foi chamado a honrar garantias. </fo:block>
	</fo:table-cell>
	</xsl:when>
	<xsl:when test="../Pergunta/PerguntaRow/RESPOSTA='N'">
	<fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">O munic&#237;pio n&#227;o foi chamado a honrar quaisquer garantias. </fo:block>
	</fo:table-cell>
	</xsl:when>
	<xsl:otherwise>
	<fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
	</fo:table-cell>
	</xsl:otherwise>
	</xsl:choose>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-46 ####-->

<!--
#############################################
#### UC074-47
############################################# 
-->	
<xsl:template match="Modelo5/ContraGarantias">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ContraGarantiasRow[CD_TIPO='402' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ContraGarantiasRow[CD_TIPO='402' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_5_2">
	  <xsl:text>5.2.5.2 Modelo 5 - Demonstrativo das Garantias e Contragarantias de Valores - Contragarantias - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ContraGarantiasRow[CD_TIPO='402' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ContraGarantiasRow[CD_TIPO='402' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ContraGarantiasRow[CD_TIPO='402' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContraGarantiasRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContraGarantiasRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ContraGarantiasRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-47 ####-->

<!--
#############################################
#### UC074-48
############################################# 
-->	
<xsl:template match="Modelo6/OperacoesCredito">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
    <xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
    <xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
  </xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
  <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1"/>
    
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell>
          <fo:block xsl:use-attribute-sets="titFCinza">
            <xsl:text>5.2.6.1 Modelo 6 - Demonstrativo das Opera&#231;&#245;es de Cr&#233;dito - Internas e Externas - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
  </fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>
    
    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>

      <!-- CONTAS CD_TIPO=44 SELECAO AUTOMATICA -->
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(OperacoesCreditoRow[CD_TIPO='44' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="OperacoesCreditoRow[CD_TIPO='44' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <!-- CONTAS CD_TIPO=44 SELECAO MANUAL -->
      <xsl:if test="count(OperacoesCreditoRow[CD_TIPO='44' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
        <fo:table-row>
          <fo:table-cell padding="1pt"  border-width="0.5pt">
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
        </fo:table-row>
        <xsl:for-each select="OperacoesCreditoRow[CD_TIPO='44' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
          <fo:table-row>
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
            </fo:table-cell>
            <fo:table-cell border-width="0.5pt" padding="1pt" >
              <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
            </fo:table-cell>	    
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:for-each>
      </xsl:if>

      <!-- TOTAL CONTAS CD_TIPO=44 -->
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE RECEITA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow[CD_TIPO='44']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow[CD_TIPO='44']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow[CD_TIPO='44']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>
  
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
  <!-- redmine #2188, #14491 -->
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>
    
    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>

      <!-- CONTAS CD_TIPO=47 SELECAO AUTOMATICA -->
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(OperacoesCreditoRow[CD_TIPO='47' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="OperacoesCreditoRow[CD_TIPO='47' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <!-- CONTAS CD_TIPO=47 SELECAO MANUAL -->
      <xsl:if test="count(OperacoesCreditoRow[CD_TIPO='47' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
        <fo:table-row>
          <fo:table-cell padding="1pt"  border-width="0.5pt">
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
        </fo:table-row>
        <xsl:for-each select="OperacoesCreditoRow[CD_TIPO='47' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
          <fo:table-row>
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
            </fo:table-cell>
            <fo:table-cell border-width="0.5pt" padding="1pt" >
              <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
            </fo:table-cell>	    
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell border-width="0.5pt" >
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:for-each>
      </xsl:if>

      <!-- TOTAL CONTAS CD_TIPO=47 -->
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS PATRIMONIAIS </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow[CD_TIPO='47']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow[CD_TIPO='47']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow[CD_TIPO='47']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>
  
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>
    <fo:table-body>
      <!-- TOTAL CONTAS CD_TIPO in (44,47) -->
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">Total para fins da apura&#231;&#227;o do cumprimento do limite </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(OperacoesCreditoRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
  </fo:table>

</xsl:template>
<!-- #### FIM - UC074-48 ####-->

<!--
#############################################
#### UC074-49
############################################# 
-->	
<xsl:template match="Modelo6/AntecipacaoReceita">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_6_2">
	  <xsl:text>5.2.6.2 Modelo 6 - Demonstrativo das Opera&#231;&#245;es de Cr&#233;dito - Antecipa&#231;&#227;o da Receita - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
  
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AntecipacaoReceitaRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AntecipacaoReceitaRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AntecipacaoReceitaRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
<!-- #### FIM - UC074-49 ####-->

<!-- #### Modelo6/DividaConsolidadaOutrasOperacoes - redmine #14491 ####-->

<xsl:template match="Modelo6/DividaConsolidadaOutrasOperacoes"> <!-- AntecipacaoReceita -->
<!-- ************* Variaveis locais **************-->
<!-- <xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
 -->
<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="AntecipacaoReceitaRow[CD_TIPO='46' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_6_3">
	  <xsl:text>5.2.6.3 Modelo 6 - Demonstrativo das Opera&#231;&#245;es de Cr&#233;dito - Outras opera&#231;&#245;es que integram a D&#237;vida Consolidada</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
  
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='48' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="DividaConsolidadaOutrasOperacoesRow[CD_TIPO='48' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="DividaConsolidadaOutrasOperacoesRow[CD_TIPO='48' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='48']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='48']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='48']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
 </fo:table>
  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
  
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='49' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="DividaConsolidadaOutrasOperacoesRow[CD_TIPO='49' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="DividaConsolidadaOutrasOperacoesRow[CD_TIPO='49' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='49']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='49']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow[CD_TIPO='49']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
 </fo:table-body>
</fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>
    <fo:table-body>
      <!-- TOTAL CONTAS CD_TIPO in (44,47) -->
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">OUTRAS OPERA&#199;&#213;ES QUE INTEGRAM A D&#205;VIDA CONSOLIDADA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaOutrasOperacoesRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   </fo:table-body>
  </fo:table>

</xsl:template>
<!-- #### FIM - redmine #14491 ####-->

<!--
#############################################
#### UC074-50
############################################# 
-->	
<!--<xsl:template match="DadosDespesa">-->
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->
<!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_2_2_3">
	  <xsl:text>2.2.3 Dados da Despesa</xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="216pt"/>
  <fo:table-column column-number="2" column-width="120pt"/>
  <fo:table-column column-number="3" column-width="120pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Arquivos </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Registros </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Totais </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <xsl:for-each select="DadosDespesaRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="REGISTROS"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(TOTAL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>
  </fo:table-body>	
 </fo:table>
</xsl:template>
-->
<!-- #### FIM - UC074-50 ####-->

<!--
#############################################
#### UC074-51
############################################# 
-->	
<xsl:template match="Assinaturas">
<!-- ************* Variaveis locais **************--> 
 <xsl:variable name="administrador">
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">Prefeito Municipal</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">Presidente da C&#226;mara Municipal</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">Respons&#225;vel</xsl:if>
 </xsl:variable>
 
 <!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
 <xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao"/>
 <xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
 <xsl:variable name="dia" select="substring($data, 9, 2)"/>
 <xsl:variable name="mes" select="substring($data, 6, 2)"/>
 <xsl:variable name="ano" select="substring($data, 1, 4)"/>
 <xsl:variable name="mesNome">
 	<xsl:if test="$mes='01'">Janeiro</xsl:if>
    <xsl:if test="$mes='02'">Fevereiro</xsl:if>
    <xsl:if test="$mes='03'">Mar&#231;o</xsl:if>
    <xsl:if test="$mes='04'">Abril</xsl:if>
    <xsl:if test="$mes='05'">Maio</xsl:if>
    <xsl:if test="$mes='06'">Junho</xsl:if>
    <xsl:if test="$mes='07'">Julho</xsl:if>
    <xsl:if test="$mes='08'">Agosto</xsl:if>
    <xsl:if test="$mes='09'">Setembro</xsl:if>
    <xsl:if test="$mes='10'">Outubro</xsl:if>
    <xsl:if test="$mes='11'">Novembro</xsl:if>
    <xsl:if test="$mes='12'">Dezembro</xsl:if>
 </xsl:variable>  

<!-- ************* Variaveis locais **************-->
 
 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="270pt"/>
  <fo:table-column column-number="2" column-width="16pt"/>
  <fo:table-column column-number="3" column-width="270pt"/>


  <fo:table-body>
   <!--<xsl:for-each select="AssinaturasRow">-->
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" number-columns-spanned="3">
	 <fo:block xsl:use-attribute-sets="txtCenter">
	  <!--<xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO"/>, <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('d'), java:java.util.Date.new())"/> de <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('MMMM'), java:java.util.Date.new())"/> de <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('yyyy'), java:java.util.Date.new())"/>-->
    <xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO"/>, <xsl:value-of select="$dia"/> de <xsl:value-of select="$mesNome"/> de <xsl:value-of select="$ano"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/CONTABILISTA"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter">Contabilista</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" ><fo:block xsl:use-attribute-sets="txtRight"></fo:block></fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/ADMINISTRADOR"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="$administrador"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3">
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
 		<fo:block><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   <!--
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pela Administra&#231;&#227;o Financeira:<xsl:value-of select="InformacoesRow/NOME_REPRESENTANTE"/></fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/RESP_ADMIN_FINAN"/></fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" ><fo:block xsl:use-attribute-sets="txtRight"></fo:block></fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
		<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pelo Controle Interno:</fo:block>
		<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="AssinaturasRow/RESP_CTRL_INTERNO"/></fo:block>
    </fo:table-cell>	    
   </fo:table-row>
   -->
<!--    <fo:table-row> -->
<!-- 	<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="3"> -->
<!--  		<fo:block><fo:leader leader-pattern="space"/></fo:block> -->
<!--  		<fo:block><fo:leader leader-pattern="space"/></fo:block> -->
<!--     </fo:table-cell>	     -->
<!--    </fo:table-row> -->
<!--    <fo:table-row> -->
<!-- 	<fo:table-cell border-width="0.5pt" number-columns-spanned="3"> -->
<!-- 		<fo:block xsl:use-attribute-sets="txtLeft">Respons&#225;vel pelo preenchimento do PAD e gera&#231;&#227;o das informa&#231;&#245;es: <xsl:value-of select="AssinaturasRow/RESPONSAVEL_PAD"/></fo:block> -->
<!-- 		<fo:block xsl:use-attribute-sets="txtLeft">Cargo: <xsl:value-of select="AssinaturasRow/CARGO_RESP_PAD"/></fo:block> -->
<!--     </fo:table-cell> -->
<!--    </fo:table-row> -->
   <!--</xsl:for-each>-->
  </fo:table-body>	
 </fo:table>	
</xsl:template>
<!-- #### FIM - UC074-51 ####-->

<!--
#############################################
#### UC074-52
############################################# 
-->	
<xsl:template match="Modelo7">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoFinal">
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:for-each select="ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='1010' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual2">
	<xsl:variable name="aux4">			
		<xsl:for-each select="ExAtual/ExAtualRow[AUTOMATICA='N' and CD_TIPO='1010' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux4!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_7">
	  <xsl:text>5.2.7 Modelo 7 - Demonstrativo dos Restos a Pagar - Exerc&#237;cio de </xsl:text><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 1o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="120pt"/>
  <fo:table-column column-number="2" column-width="202pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">DEMAIS OBRIGAES FINANCEIRAS - Contas Contbeis </fo:block>
    </fo:table-cell>
   </fo:table-row>      
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">F.R. / Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/> / 
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
		<xsl:value-of select="CD_RECURSO"/> / 
		<xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnterior/ExAnteriorRow[CD_TIPO='1005']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnterior/ExAnteriorRow[CD_TIPO='1005']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnterior/ExAnteriorRow[CD_TIPO='1005']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 2o bloco do relat&#243;rio --> 
 <!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">Obriga&#231;&#245;es de Repasse ao RPPS - Exerc&#237;cio Atual </fo:block>
    </fo:table-cell>
   </fo:table-row>     
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='1010' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='1010' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAtual/ExAtualRow[AUTOMATICA='N' and CD_TIPO='1010' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt" font-weight="bold">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtual/ExAtualRow[CD_TIPO='1010']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt" font-weight="bold">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtual/ExAtualRow[CD_TIPO='1010']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt" font-weight="bold">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtual/ExAtualRow[CD_TIPO='1010']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  -->
 
	<xsl:call-template name="RestosAPagar">
	</xsl:call-template>

</xsl:template>

<xsl:template name="RestosAPagar">

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExAnterior/ExAnteriorRow[CD_TIPO='1005' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

  <!-- 3o bloco do relat&#243;rio -->
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
   <fo:table-column column-number="1" column-width="79pt"/>
   <fo:table-column column-number="2" column-width="79pt"/>
   <fo:table-column column-number="3" column-width="79pt"/>
   <fo:table-column column-number="4" column-width="79pt"/>
   <fo:table-column column-number="5" column-width="79pt"/>
   <fo:table-column column-number="6" column-width="79pt"/>
   <fo:table-column column-number="7" column-width="79pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR PROCESSADOS </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">De Exerccios Anteriores </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Exerccio Atual </fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Valor Contbil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Total Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Valor Contbil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <!--
  <xsl:for-each select="RestosProcs/RestosProcsRow[VLR_EX_ANTERIOR!=0.00 or VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
  -->
  <xsl:for-each select="TodosRestos/TodosRestosRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_PROC_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_PROC_ANTERIOR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_PROC_ANTERIOR+VLR_PROC_ANTERIOR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_PROC_ATUAL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_PROC_ATUAL_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
	  <fo:block font-weight="bold" xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_PROC_ANTERIOR),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_PROC_ANTERIOR_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_PROC_ANTERIOR)+sum(TodosRestos/TodosRestosRow/VLR_PROC_ANTERIOR_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_PROC_ATUAL),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_PROC_ATUAL_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_PROC_ATUAL)+sum(TodosRestos/TodosRestosRow/VLR_PROC_ATUAL_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 4o bloco do relat&#243;rio --> 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="79pt"/>
  <fo:table-column column-number="2" column-width="79pt"/>
  <fo:table-column column-number="3" column-width="79pt"/>
  <fo:table-column column-number="4" column-width="79pt"/>
  <fo:table-column column-number="5" column-width="79pt"/>
  <fo:table-column column-number="6" column-width="79pt"/>
  <fo:table-column column-number="7" column-width="79pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">De Exerccios Anteriores </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Exerccio Atual </fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Valor Contbil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Total Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Valor Contbil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="center">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <!--
  <xsl:for-each select="RestosNProcs/RestosNProcsRow[VLR_EX_ANTERIOR!=0.00 or VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
  -->
  <xsl:for-each select="TodosRestos/TodosRestosRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_NPROC_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_NPROC_ANTERIOR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_NPROC_ANTERIOR+VLR_NPROC_ANTERIOR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_NPROC_ATUAL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_NPROC_ATUAL_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_NPROC_ATUAL+VLR_NPROC_ATUAL_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
	  <fo:block font-weight="bold" xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_NPROC_ANTERIOR),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_NPROC_ANTERIOR_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_NPROC_ANTERIOR)+sum(TodosRestos/TodosRestosRow/VLR_NPROC_ANTERIOR_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_NPROC_ATUAL),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_NPROC_ATUAL_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total" font-weight="bold">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/VLR_NPROC_ATUAL)+sum(TodosRestos/TodosRestosRow/VLR_NPROC_ATUAL_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 5o bloco do relat&#243;rio --> 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="138pt"/>
  <fo:table-column column-number="2" column-width="138pt"/>
  <fo:table-column column-number="3" column-width="138pt"/>
  <fo:table-column column-number="4" column-width="138pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">DISPONIBILIDADE </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
   <!--
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">Ex. Anterior Valor Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Ex. Atual </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="right">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
   -->
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <!--
  <xsl:for-each select="Disponibilidade/DisponibilidadeRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
  -->
  <xsl:for-each select="TodosRestos/TodosRestosRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(DISP_FINANCEIRA,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(DISP_FINANCEIRA_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(DISP_FINANCEIRA+DISP_FINANCEIRA_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
		<fo:block font-weight="bold" xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/DISP_FINANCEIRA),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/DISP_FINANCEIRA_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(TodosRestos/TodosRestosRow/DISP_FINANCEIRA)+sum(TodosRestos/TodosRestosRow/DISP_FINANCEIRA_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <xsl:if test="Manual/ManualRow/MANUAL &gt; 0">
     <fo:block><fo:leader leader-pattern="space"/></fo:block>
     <fo:block><fo:leader leader-pattern="space"/></fo:block>
     <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
     <fo:table-column column-number="1" column-width="556pt"/>
        <fo:table-body>
        <fo:table-row>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="1" padding-left="10pt">
            <fo:block xsl:use-attribute-sets="txtLeft">
            OBS: Houve altera&#231;&#245;es na tela de relacionamentos de contas do Dispon&#237;vel que 
            poder&#227;o estar refletidas nos valores das disponibilidades acima relacionados. 
            As justificativas apresentadas pela entidade constam no item 2.4 deste documento.
            </fo:block>
        </fo:table-cell>
        </fo:table-row>
        </fo:table-body>
     </fo:table>
 </xsl:if>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <!-- 6o BLOCO -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="150pt"/>
  <fo:table-column column-number="2" column-width="20pt"/>
  <fo:table-column column-number="3" column-width="386pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="left">LEGENDA DOS C&#211;DIGOS DAS FONTES DE RECURSO </fo:block>
    </fo:table-cell>
   </fo:table-row>   
 </fo:table-header>

 <fo:table-body>
  <xsl:choose>
    <xsl:when test="Disponibilidade/DisponibilidadeRow">
  <xsl:for-each select="Disponibilidade/DisponibilidadeRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
  </xsl:when>
  <xsl:otherwise>
   <fo:table-row>
    <fo:table-cell/>
   </fo:table-row>
  </xsl:otherwise>
  </xsl:choose>
  </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-52 ####-->

<!--
#############################################
#### UC074-53
############################################# 
-->	
<xsl:template match="Modelo10/ExAnterior">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="periodoInicial">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">01/01/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">01/03/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">01/05/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">01/07/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">01/09/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">01/11/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:for-each select="ExAnteriorRow[CD_TIPO='140' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="ExAnteriorRow[CD_TIPO='140' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='141' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual2">
	<xsl:variable name="aux4">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='141' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux4!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica3">
	<xsl:variable name="aux5">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='142' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux5!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual3">
	<xsl:variable name="aux6">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='142' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux6!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="automatica4">
	<xsl:variable name="aux7">
		1<!--<xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='143' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
	</xsl:variable>
	<xsl:if test="$aux7!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual4">
	<xsl:variable name="aux8">			
		<xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='143' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux8!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="isCamaraIntegrada">
    <xsl:choose>
      <xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
      <xsl:otherwise>N</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<!-- ************* Variaveis locais **************-->
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1"/>
   
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell>
          <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_8_1">
            <xsl:text>5.2.8.1 Modelo 10 - Demonstrativo da Despesa com Pessoal (Legislativo) do exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/><xsl:text> - </xsl:text><xsl:value-of select="$periodoInicial"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/><xsl:text> a 31/12/</xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO_ANTERIOR"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
  </fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <!-- 1o bloco do relat&#243;rio -->
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block font-weight="bold" text-align="left">CONTAS DE DESPESA </fo:block>
        </fo:table-cell>
      </fo:table-row>   
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>
 
    <fo:table-body>

      <xsl:for-each select="ExAnteriorRow[CD_TIPO='139' and AUTOMATICA='S']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='139']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='139']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='139']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
        <!--<fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>-->
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAnteriorRow[CD_TIPO='140' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAnteriorRow[CD_TIPO='140' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>	    
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAnteriorRow[CD_TIPO='140' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>	    
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DEDUES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='140']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='140']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='140']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE DESPESA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='139']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='140']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='139']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='140']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='139']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='140']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 2o bloco do relat&#243;rio --> 
 <!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
      <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
        <fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
      </xsl:if>
      <xsl:if test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C' or $isCamaraIntegrada='S'">
        <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
      </xsl:if>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='141' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='141' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>
  
  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='141' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='141']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='141']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='141']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <!-- 3o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
        <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica3"/></fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='142' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='142' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual3"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='142' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='142']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='142']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='142']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- 4o bloco do relat&#243;rio --> 
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
        </fo:table-cell>
        </fo:table-row>   
        <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>
      <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='138']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA - RPNP </fo:block>
        </fo:table-cell>
        <!--<fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>-->
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='143' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAnteriorRow[AUTOMATICA='S' and CD_TIPO='143' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='143' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DEDUES POR NATUREZA DE DESPESA - RPNP </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='143']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='143']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='143']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DOS RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='143']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='143']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='143']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>
  
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA DESPESA COM PESSOAL (Ex. Anterior) </fo:block>
          <!--<fo:block xsl:use-attribute-sets="totalLeft">Total da Despesa c/ Pessoal Ex. Anterior </fo:block>-->
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138' or CD_TIPO='139' or CD_TIPO='142']/VLR_CONTABIL)-sum(ExAnteriorRow[CD_TIPO='140' or CD_TIPO='141' or CD_TIPO='143']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138' or CD_TIPO='139' or CD_TIPO='142']/VLR_AJUSTE)-sum(ExAnteriorRow[CD_TIPO='140' or CD_TIPO='141' or CD_TIPO='143']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAnteriorRow[CD_TIPO='138' or CD_TIPO='139' or CD_TIPO='142']/VLR_AJUSTADO)-sum(ExAnteriorRow[CD_TIPO='140' or CD_TIPO='141' or CD_TIPO='143']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>
    
    </fo:table-body>
 </fo:table>
</xsl:template>
<!-- #### FIM - UC074-53 ####-->

<!--
#############################################
#### UC074-54
############################################# 
-->	
<xsl:template match="Modelo10/ExAtual">
  <!-- ************* Variaveis locais **************-->
  <xsl:variable name="isCamaraIntegrada">
    <xsl:choose>
      <xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
      <xsl:otherwise>N</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="periodoFinal">
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
      <xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
      <xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
    </xsl:if>
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
    <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
  </xsl:variable>

  <xsl:variable name="automatica">
    <xsl:variable name="aux1">
      1<!--<xsl:for-each select="ExAtualRow[CD_TIPO='144' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
    </xsl:variable>
    <xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
  </xsl:variable>

  <xsl:variable name="manual">
    <xsl:variable name="aux2">			
      <xsl:for-each select="ExAtualRow[CD_TIPO='144' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
    </xsl:variable>
    <xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
  </xsl:variable>

  <xsl:variable name="automatica2">
    <xsl:variable name="aux3">
      1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='145' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
    </xsl:variable>
    <xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
  </xsl:variable>

  <xsl:variable name="manual2">
    <xsl:variable name="aux4">			
      <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='145' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
    </xsl:variable>
    <xsl:if test="$aux4!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
  </xsl:variable>

  <xsl:variable name="automatica3">
    <xsl:variable name="aux5">
      1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='146' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
    </xsl:variable>
    <xsl:if test="$aux5!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
  </xsl:variable>
  
  <xsl:variable name="manual3">
    <xsl:variable name="aux6">			
      <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='146' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
    </xsl:variable>
    <xsl:if test="$aux6!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
  </xsl:variable>

  <xsl:variable name="automatica4">
    <xsl:variable name="aux7">
      1<!--<xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='147' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>-->
    </xsl:variable>
    <xsl:if test="$aux7!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
  </xsl:variable>
  
  <xsl:variable name="manual4">
    <xsl:variable name="aux8">
      <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='147' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
    </xsl:variable>
    <xsl:if test="$aux8!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
  </xsl:variable>
  <!-- ************* Variaveis locais **************-->

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1"/>
    <fo:table-body>
      <fo:table-row>
        <fo:table-cell>
          <fo:block xsl:use-attribute-sets="titFCinza">
            <xsl:text>5.2.8.2 Modelo 10 - Demonstrativo da Despesa com Pessoal (Legislativo) do exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
          </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-body>
  </fo:table>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <!-- 1o bloco do relat&#243;rio -->
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block font-weight="bold" text-align="left">CONTAS DE DESPESA </fo:block>
        </fo:table-cell>
      </fo:table-row>   
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>
      <xsl:for-each select="ExAtualRow[CD_TIPO='148' and AUTOMATICA='S']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='148']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='148']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='148']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt" border-width="0.5pt" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
        <!--<fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>-->
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAtualRow[CD_TIPO='144' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAtualRow[CD_TIPO='144' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAtualRow[CD_TIPO='144' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DEDU&#199;&#213;ES POR NATUREZA DE DESPESA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='144']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='144']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='144']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE DESPESA </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='148']/VLR_CONTABIL)-sum(ExAtualRow[CD_TIPO='144']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='148']/VLR_AJUSTE)-sum(ExAtualRow[CD_TIPO='144']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='148']/VLR_AJUSTADO)-sum(ExAtualRow[CD_TIPO='144']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 2o bloco do relat&#243;rio --> 
 <!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    <xsl:choose>
		<xsl:when test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
		</xsl:when>
		<xsl:otherwise>
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
		</xsl:otherwise>
    </xsl:choose>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and CD_TIPO='145' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='145' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>
  
  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='145' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS DE RECEITA </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='145']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='145']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='145']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <!-- 3o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    <!-- xsl:choose>
		<xsl:when test="../../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
		</xsl:when>
		<xsl:otherwise-->
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
		<!--/xsl:otherwise>
    </xsl:choose-->
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica3"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and CD_TIPO='146' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='146' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual3"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='146' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DAS CONTAS PATRIMONIAIS </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <!-- 4o bloco do relat&#243;rio --> 

  <xsl:choose>
	<xsl:when test="count(ExAtualRow[CD_TIPO=147 or CD_TIPO=149]) &gt; 0">

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-header xsl:use-attribute-sets="cabecalho">
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=6">
            <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
          </xsl:if>     
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES!=6">
            <fo:block font-weight="bold" text-align="left">EMPENHOS N&#195;O LIQUIDADOS </fo:block>
          </xsl:if>
        </fo:table-cell>
      </fo:table-row>   
      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
        </fo:table-cell>
      </fo:table-row>
    </fo:table-header>

    <fo:table-body>
      <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='149']">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block font-weight="bold" text-align="left">TOTAL </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='149']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='149']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='149']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt" number-columns-spanned="5">
          <fo:block xsl:use-attribute-sets="txtLeft">DEDU&#199;&#213;ES POR NATUREZA DE DESPESA - RPNP </fo:block>
        </fo:table-cell>
        <!--<fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>-->
      </fo:table-row>
      <fo:table-row>
        <fo:table-cell padding="1pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:choose>
        <xsl:when test="count(ExAtualRow[AUTOMATICA='S' and CD_TIPO='147' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
          <xsl:for-each select="ExAtualRow[AUTOMATICA='S' and CD_TIPO='147' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
            <fo:table-row>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" padding="1pt" >
                <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
              <fo:table-cell border-width="0.5pt" >
                <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
              </fo:table-cell>
            </fo:table-row>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <fo:table-row>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell padding-left="5pt">
              <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
            <fo:table-cell>
              <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
            </fo:table-cell>
          </fo:table-row>
        </xsl:otherwise>
      </xsl:choose>

      <fo:table-row>
        <fo:table-cell border-width="0.5pt" padding="1pt" >
          <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual4"/></fo:block>
        </fo:table-cell>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>
      <xsl:for-each select="ExAtualRow[AUTOMATICA='N' and CD_TIPO='147' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
        <fo:table-row>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="CD_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" padding="1pt" >
            <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="DS_CONTA"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell border-width="0.5pt" >
            <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:for-each>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block font-weight="bold" text-align="left">TOTAL DEDUES POR NATUREZA DE DESPESA - RPNP </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='147']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='147']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='147']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES=6">
            <fo:block font-weight="bold" text-align="left">TOTAL DOS RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
          </xsl:if>     
          <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES!=6">
            <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DOS EMPENHOS N&#195;O LIQUIDADOS </fo:block>
          </xsl:if>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='149']/VLR_CONTABIL)-sum(ExAtualRow[CD_TIPO='147']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='149']/VLR_AJUSTE)-sum(ExAtualRow[CD_TIPO='147']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='149']/VLR_AJUSTADO)-sum(ExAtualRow[CD_TIPO='147']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>

	</xsl:when>
  </xsl:choose>

	<xsl:call-template name="TabelaGenericaAutoManual">
		<xsl:with-param name="labelTitulo">CONTAS DE CONTROLE
		</xsl:with-param>
		<xsl:with-param name="labelDebug">[CD_TIPO=150]</xsl:with-param>
		<xsl:with-param name="labelCodigo">Cdigo</xsl:with-param>
		<xsl:with-param name="labelDescricao">Descrio</xsl:with-param>
		<xsl:with-param name="labelSubtotal">TOTAL DAS CONTAS DE CONTROLE</xsl:with-param>
		
		<xsl:with-param name="contasList" select="../../GenericoConta/GenericoContaRow[CD_TIPO=150]"/>
	</xsl:call-template>

  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
    <fo:table-column column-number="1" column-width="100pt"/>
    <fo:table-column column-number="2" column-width="222pt"/>
    <fo:table-column column-number="3" column-width="78pt"/>
    <fo:table-column column-number="4" column-width="78pt"/>
    <fo:table-column column-number="5" column-width="78pt"/>

    <fo:table-body>
      <fo:table-row>
        <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
      </fo:table-row>

      <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES!=6">
        <fo:table-row border-width="0.5pt">
          <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
            <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA DESPESA COM PESSOAL (Ex. Atual) </fo:block>
            <!--<fo:block xsl:use-attribute-sets="totalLeft">Total da Despesa c/ Pessoal Ex. Atual </fo:block>-->
          </fo:table-cell>
          <fo:table-cell padding="2pt"  border-width="0.5pt">
            <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146' or CD_TIPO='148' or CD_TIPO='149' or CD_TIPO='150']/VLR_CONTABIL)-sum(ExAtualRow[CD_TIPO='144' or CD_TIPO='145' or CD_TIPO='147']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell padding="2pt"  border-width="0.5pt">
            <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146' or CD_TIPO='148' or CD_TIPO='149' or CD_TIPO='150']/VLR_AJUSTE)-sum(ExAtualRow[CD_TIPO='144' or CD_TIPO='145' or CD_TIPO='147']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
          </fo:table-cell>
          <fo:table-cell padding="2pt"  border-width="0.5pt">
            <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146' or CD_TIPO='148' or CD_TIPO='149' or CD_TIPO='150']/VLR_AJUSTADO)-sum(ExAtualRow[CD_TIPO='144' or CD_TIPO='145' or CD_TIPO='147']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
          </fo:table-cell>
        </fo:table-row>
      </xsl:if>

      <fo:table-row border-width="0.5pt">
        <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="totalLeft">TOTAL DA DESPESA COM PESSOAL
            <xsl:if test="/rve/Cabecalho/CabecalhoRow/MES_INFORMACOES != 12">
              (12 Meses)
            </xsl:if>
          </fo:block>
          <!--<fo:block xsl:use-attribute-sets="totalLeft">Total da Despesa com Pessoal </fo:block>-->
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146' or CD_TIPO='148' or CD_TIPO='149' or CD_TIPO='150']/VLR_CONTABIL)-sum(ExAtualRow[CD_TIPO='144' or CD_TIPO='145' or CD_TIPO='147']/VLR_CONTABIL)+sum(../ExAnterior/ExAnteriorRow[CD_TIPO='138' or CD_TIPO='139' or CD_TIPO='142']/VLR_CONTABIL)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='140' or CD_TIPO='141' or CD_TIPO='143']/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146' or CD_TIPO='148' or CD_TIPO='149' or CD_TIPO='150']/VLR_AJUSTE)-sum(ExAtualRow[CD_TIPO='144' or CD_TIPO='145' or CD_TIPO='147']/VLR_AJUSTE)+sum(../ExAnterior/ExAnteriorRow[CD_TIPO='138' or CD_TIPO='139' or CD_TIPO='142']/VLR_AJUSTE)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='140' or CD_TIPO='141' or CD_TIPO='143']/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
          <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(ExAtualRow[CD_TIPO='146' or CD_TIPO='148' or CD_TIPO='149' or CD_TIPO='150']/VLR_AJUSTADO)-sum(ExAtualRow[CD_TIPO='144' or CD_TIPO='145' or CD_TIPO='147']/VLR_AJUSTADO)+sum(../ExAnterior/ExAnteriorRow[CD_TIPO='138' or CD_TIPO='139' or CD_TIPO='142']/VLR_AJUSTADO)-sum(../ExAnterior/ExAnteriorRow[CD_TIPO='140' or CD_TIPO='141' or CD_TIPO='143']/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
        </fo:table-cell>
      </fo:table-row>

    </fo:table-body>
  </fo:table>
  
	<!--
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block xsl:use-attribute-sets="txtLeft">
		<fo:inline font-weight="bold">Observa&#231;&#227;o</fo:inline>: Onde se l&#234; 330034010000000
		leia-se 3.3.xx.34.01.00.00.00, conforme IN TCE 4/2021.
	</fo:block>
	-->

</xsl:template>
<!-- #### FIM - UC074-54 ####-->

<!--
#############################################
#### UC074-55     Excluida conforme HU 9455
############################################# 
-->
<!--<xsl:template match="Modelo4/DividaConsolidadaRPPS"> 
 ************* Variaveis locais **************-->
<!-- <xsl:variable name="periodoFinal">
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1"> 
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>
 -->
 
<!--   
<xsl:variable name="automatica">
   <xsl:variable name="aux1"> 
		1<xsl:for-each select="DividaConsolidadaRow[CD_TIPO='81' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
   </xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable> 
 -->
<!--
<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="DividaConsolidadaRPPSRow[CD_TIPO='81' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
    <xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>  -->
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->
<!-- 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4_5">
     	<xsl:text>5.2.4.5 Modelo 4 - Demonstrativo da D&#237;vida Consolidada L&#237;quida do Regime Pr&#243;prio de Previd&#234;ncia dos Servidores - RPPS - D&#237;vida Consolidada ou Fundada - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(DividaConsolidadaRPPSRow[CD_TIPO='81' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
   	<xsl:for-each select="DividaConsolidadaRPPSRow[CD_TIPO='81' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  	<xsl:for-each select="DividaConsolidadaRPPSRow[CD_TIPO='81' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaRPPSRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaRPPSRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(DividaConsolidadaRPPSRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template> -->
<!-- #### FIM - UC074-55 ####-->

<!--
#############################################
#### UC074-56    excluida pela HU 9455
############################################# 

<xsl:template match="Modelo4/AtivoCirculanteRPPS">-->	
<!-- ************* Variaveis locais **************-->
<!-- 
<xsl:variable name="periodoFinal">
     <xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable> 
 -->
 <!-- 
<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<xsl:for-each select="AtivoCirculanteRow[CD_TIPO='87' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">0</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
	<xsl:variable name="aux2">			
		<xsl:for-each select="AtivoCirculanteRPPSRow[CD_TIPO='87' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
	</xsl:variable>
	<xsl:if test="$aux2!=''"><xsl:text>SELE&#199;&#195;O MANUAL</xsl:text></xsl:if>
</xsl:variable>  -->
<!-- ************* Variaveis locais **************-->
 
 <!--	 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->
<!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_4_6">
     	<xsl:text>5.2.4.6 Modelo 4 - Demonstrativo da D&#237;vida Consolidada L&#237;quida do Regime Pr&#243;prio de Previd&#234;ncia dos Servidores - RPPS - Ativo Circulante e N&#227;o Circulante - Exerc&#237;cio de </xsl:text><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
	</fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
   </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(AtivoCirculanteRPPSRow[CD_TIPO='87' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">   
   <xsl:for-each select="AtivoCirculanteRPPSRow[CD_TIPO='87' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="AtivoCirculanteRPPSRow[CD_TIPO='87' and AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AtivoCirculanteRPPSRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AtivoCirculanteRPPSRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    	<fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(AtivoCirculanteRPPSRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

 </fo:table-body>
</fo:table>
</xsl:template>
 #### FIM - UC074-56 ####-->
	
<!--
#############################################
#### UC074-57
############################################# 
-->	
<xsl:template match="modelo11">
<!-- ************* Variaveis locais **************-->
<xsl:variable name="isCamaraIntegrada">
	<xsl:choose>		
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
</xsl:variable> 
<xsl:variable name="pmPossuiCamaraIntegrada">
	<xsl:choose>
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTAPM='S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
</xsl:variable>

<xsl:variable name="periodoFinal">
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 1">
		<xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
   		<xsl:if test="(../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and ../Cabecalho/CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
	</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
	<xsl:if test="../Cabecalho/CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
</xsl:variable>

<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:if test="$isCamaraIntegrada='S'">
			<xsl:for-each select="modelo11Prefeitura/ExAnterior/ExAnteriorRow[CD_TIPO='160' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			<xsl:for-each select="modelo11Camara/ExAnterior/ExAnteriorRow[CD_TIPO='160' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual">
  <xsl:if test="$pmPossuiCamaraIntegrada='S'">
    <xsl:if test="count(modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='160' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
    <xsl:if test="count(modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='160' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
</xsl:variable>

<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:if test="$isCamaraIntegrada='S'">			
			<xsl:for-each select="modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			<xsl:for-each select="modelo11Camara/ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>

<xsl:variable name="manual2">
  <xsl:if test="$pmPossuiCamaraIntegrada='S'">
    <xsl:if test="count(modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='N' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
    <xsl:if test="count(modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='N' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
</xsl:variable>
<!-- ************* Variaveis locais **************-->

 <!--
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 -->

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell>
     <fo:block xsl:use-attribute-sets="titFCinza" id="RVE_5_2_9">
	  <xsl:text>5.2.9 Modelo 11 - Demonstrativo dos Restos a Pagar - Exerc&#237;cio de </xsl:text><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> - </xsl:text>01/01/<xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/><xsl:text> a </xsl:text><xsl:value-of select="$periodoFinal"/><xsl:value-of select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 1o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">DEMAIS OBRIGAES FINANCEIRAS - Contas Contbeis </fo:block>
    </fo:table-cell>
   </fo:table-row>      
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">F.R. / Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">    
		<!--
    <xsl:choose>
		<xsl:when test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
		</xsl:when>
		<xsl:otherwise>
		-->
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
		<!--
		</xsl:otherwise>
    </xsl:choose>
		-->
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
  
  <!-- TESTE PARA PM -->
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='S'">
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/> / 
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/> / 
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Prefeitura/ExAnterior/ExAnteriorRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Prefeitura/ExAnterior/ExAnteriorRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Prefeitura/ExAnterior/ExAnteriorRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </xsl:if>

  <!-- TESTE PARA CM -->  
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
  <fo:table-body>
  <xsl:for-each select="modelo11Camara/ExAnterior/ExAnteriorRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/> / 
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Camara/ExAnterior/ExAnteriorRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Camara/ExAnterior/ExAnteriorRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Camara/ExAnterior/ExAnteriorRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </xsl:if>
</fo:table>
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <!-- 2o bloco do relat&#243;rio --> 
 <!--
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="100pt"/>
  <fo:table-column column-number="2" column-width="222pt"/>
  <fo:table-column column-number="3" column-width="78pt"/>
  <fo:table-column column-number="4" column-width="78pt"/>
  <fo:table-column column-number="5" column-width="78pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">Obriga&#231;&#245;es de Repasse ao RPPS - Exerc&#237;cio Atual </fo:block>
    </fo:table-cell>
   </fo:table-row>     
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Cod. Conta </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">Descri&#231;&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
    <xsl:choose>
		<xsl:when test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
		</xsl:when>
		<xsl:otherwise>
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
		</xsl:otherwise>
    </xsl:choose>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <!- - TESTE PARA PM - ->
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='S'">
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell padding="1pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$automatica2"/></fo:block>
    </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
   <xsl:choose>
   <xsl:when test="count(modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
  <xsl:for-each select="modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
     <fo:table-row>
		<fo:table-cell>
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell padding-left="5pt">
	        <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
		<fo:table-cell>
     		<fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(0.00,'###.###.##0,00')"/></fo:block>
    	</fo:table-cell>
  	 </fo:table-row>
   </xsl:otherwise>
   </xsl:choose>

  <fo:table-row>
   <fo:table-cell border-width="0.5pt" padding="1pt" >
    <fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="$manual2"/></fo:block>
   </fo:table-cell>
   <fo:table-cell border-width="0.5pt" number-columns-spanned="4"><fo:block xsl:use-attribute-sets="txtLeft"></fo:block></fo:table-cell>
  </fo:table-row>
  <xsl:for-each select="modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='N' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Prefeitura/ExAtual/ExAtualRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Prefeitura/ExAtual/ExAtualRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Prefeitura/ExAtual/ExAtualRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </xsl:if>

  <!- - TESTE PARA CM - ->
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
  <fo:table-body>
  <xsl:for-each select="modelo11Camara/ExAtual/ExAtualRow[VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00]">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_CONTA"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="DS_CONTA"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Camara/ExAtual/ExAtualRow/VLR_CONTABIL), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Camara/ExAtual/ExAtualRow/VLR_AJUSTE), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt"  border-width="0.5pt">
     <fo:block xsl:use-attribute-sets="total"><xsl:value-of select="format-number(sum(modelo11Camara/ExAtual/ExAtualRow/VLR_AJUSTADO), '###.###.##0,00')"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </xsl:if>
</fo:table>
 -->

	<xsl:call-template name="RestosAPagar">
	</xsl:call-template>

</xsl:template>

<xsl:template match="modelo11obsoleto">

<xsl:variable name="isCamaraIntegrada">
	<xsl:choose>		
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTA = 'S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
</xsl:variable> 
<xsl:variable name="pmPossuiCamaraIntegrada">
	<xsl:choose>
		<xsl:when test="/rve/DadosIniciasPM/DadosIniciasPMRow/RESPOSTAPM='S'">S</xsl:when>
		<xsl:otherwise>N</xsl:otherwise>
	</xsl:choose>
</xsl:variable>
<xsl:variable name="automatica">
	<xsl:variable name="aux1">
		1<!--<xsl:if test="$isCamaraIntegrada='S'">
			<xsl:for-each select="modelo11Prefeitura/ExAnterior/ExAnteriorRow[CD_TIPO='160' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			<xsl:for-each select="modelo11Camara/ExAnterior/ExAnteriorRow[CD_TIPO='160' and AUTOMATICA='S' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>-->
	</xsl:variable>
	<xsl:if test="$aux1!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>
<xsl:variable name="automatica2">
	<xsl:variable name="aux3">
		1<!--<xsl:if test="$isCamaraIntegrada='S'">			
			<xsl:for-each select="modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			<xsl:for-each select="modelo11Camara/ExAtual/ExAtualRow[AUTOMATICA='S' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]">1</xsl:for-each>
		</xsl:if>-->
	</xsl:variable>
	<xsl:if test="$aux3!=''"><xsl:text>SELE&#199;&#195;O AUTOM&#193;TICA</xsl:text></xsl:if>
</xsl:variable>
<xsl:variable name="manual">
  <xsl:if test="$pmPossuiCamaraIntegrada='S'">
    <xsl:if test="count(modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='160' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
    <xsl:if test="count(modelo11Prefeitura/ExAnterior/ExAnteriorRow[AUTOMATICA='N' and CD_TIPO='160' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
</xsl:variable>
<xsl:variable name="manual2">
  <xsl:if test="$pmPossuiCamaraIntegrada='S'">
    <xsl:if test="count(modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='N' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
    <xsl:if test="count(modelo11Prefeitura/ExAtual/ExAtualRow[AUTOMATICA='N' and CD_TIPO='165' and (VLR_CONTABIL!=0.00 or VLR_AJUSTE!=0.00 or VLR_AJUSTADO!=0.00)]) &gt; 0">
      <xsl:text>SELE&#199;&#195;O MANUAL</xsl:text>
    </xsl:if>
  </xsl:if>
</xsl:variable>

<xsl:if test="modelo11Camara/RestosProcs='' and modelo11Prefeitura/RestosProcs=''">
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <!-- 3o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="92pt"/>
  <fo:table-column column-number="2" column-width="92pt"/>
  <fo:table-column column-number="3" column-width="92pt"/>
  <fo:table-column column-number="4" column-width="92pt"/>
  <fo:table-column column-number="5" column-width="92pt"/>
  <fo:table-column column-number="6" column-width="92pt"/>

  <fo:table-body xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR PROCESSADOS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">Ex. Anterior Valor Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Ex. Atual </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="right">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
<!-- alterado pelo bug 1600
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
	 </xsl:if>
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
	 </xsl:if>     -->
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
</xsl:if>

<xsl:if test="modelo11Camara/RestosProcs/RestosProcsRow!='' or modelo11Prefeitura/RestosProcs/RestosProcsRow!=''">
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 
 <!-- 3o bloco do relat&#243;rio -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="92pt"/>
  <fo:table-column column-number="2" column-width="92pt"/>
  <fo:table-column column-number="3" column-width="92pt"/>
  <fo:table-column column-number="4" column-width="92pt"/>
  <fo:table-column column-number="5" column-width="92pt"/>
  <fo:table-column column-number="6" column-width="92pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR PROCESSADOS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">Ex. Anterior Valor Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Ex. Atual </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="right">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
<!-- alterado pelo bug 1600
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
	 </xsl:if>
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
	 </xsl:if>     -->
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <!-- CAMARA -->
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
  <xsl:for-each select="modelo11Camara/RestosProcs/RestosProcsRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_EX_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO+VLR_EX_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Camara/RestosProcs/RestosProcsRow/VLR_EX_ANTERIOR),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Camara/RestosProcs/RestosProcsRow/VLR_CONTABIL),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Camara/RestosProcs/RestosProcsRow/VLR_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Camara/RestosProcs/RestosProcsRow/VLR_AJUSTADO),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Camara/RestosProcs/RestosProcsRow/VLR_AJUSTADO) + sum(modelo11Camara/RestosProcs/RestosProcsRow/VLR_EX_ANTERIOR),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:if>

  <!-- PREFEITURA --> 
  <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='S'">
   <xsl:for-each select="modelo11Prefeitura/RestosProcs/RestosProcsRow">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_EX_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO+VLR_EX_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

   <fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Prefeitura/RestosProcs/RestosProcsRow/VLR_EX_ANTERIOR),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Prefeitura/RestosProcs/RestosProcsRow/VLR_CONTABIL),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Prefeitura/RestosProcs/RestosProcsRow/VLR_AJUSTE),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Prefeitura/RestosProcs/RestosProcsRow/VLR_AJUSTADO),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of select="format-number(sum(modelo11Prefeitura/RestosProcs/RestosProcsRow/VLR_AJUSTADO) + sum(modelo11Prefeitura/RestosProcs/RestosProcsRow/VLR_EX_ANTERIOR),'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>

 </xsl:if>
</fo:table-body>
</fo:table>
</xsl:if>

<xsl:if test="modelo11Camara/RestosNProcs='' and modelo11Prefeitura/RestosNProcs=''">

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 4o bloco do relat&#243;rio --> 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="92pt"/>
  <fo:table-column column-number="2" column-width="92pt"/>
  <fo:table-column column-number="3" column-width="92pt"/>
  <fo:table-column column-number="4" column-width="92pt"/>
  <fo:table-column column-number="5" column-width="92pt"/>
  <fo:table-column column-number="6" column-width="92pt"/>

  <fo:table-body xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">Ex. Anterior Valor Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Ex. Atual </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="right">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
<!-- alterado pelo bug 1600
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
	 </xsl:if>
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
	 </xsl:if>     -->
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
</xsl:if>

<xsl:if test="modelo11Camara/RestosNProcs/RestosNProcsRow!='' or modelo11Prefeitura/RestosNProcs/RestosNProcsRow!=''">

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- 4o bloco do relat&#243;rio --> 
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="92pt"/>
  <fo:table-column column-number="2" column-width="92pt"/>
  <fo:table-column column-number="3" column-width="92pt"/>
  <fo:table-column column-number="4" column-width="92pt"/>
  <fo:table-column column-number="5" column-width="92pt"/>
  <fo:table-column column-number="6" column-width="92pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="5">
     <fo:block font-weight="bold" text-align="left">RESTOS A PAGAR N&#195;O PROCESSADOS </fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">C&#243;d. Fonte de Recurso </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="left">Ex. Anterior Valor Ajustado </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-columns-spanned="3">
     <fo:block font-weight="bold" text-align="center">Ex. Atual </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt" number-rows-spanned="2">
     <fo:block font-weight="bold" text-align="right">Total Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
<!-- alterado pelo bug 1600
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
		<fo:block font-weight="bold" text-align="right">Valor Digitado </fo:block>
	 </xsl:if>
	 <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
	 </xsl:if>     -->
		<fo:block font-weight="bold" text-align="right">Valor Cont&#225;bil </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Adi&#231;&#227;o/Exclus&#227;o </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border="solid" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
   <!-- CAMARA -->
   <xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C' and $isCamaraIntegrada='N'">
  	<xsl:for-each select="modelo11Camara/RestosNProcs/RestosNProcsRow">
	<fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:value-of select="CD_RECURSO"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_EX_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_CONTABIL,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTE,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VLR_AJUSTADO+VLR_EX_ANTERIOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  	
	<fo:table-row>
	<fo:table-cell border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="totalLeft">TOTAL</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" >
     <fo:block xsl:use-attribute-sets="total">
	  <xsl:value-of sele