<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" 
  xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java" extension-element-prefixes="barcode" 
  xmlns:cal="xalan://java.util.GregorianCalendar"> 

<xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

<xsl:decimal-format decimal-separator="," grouping-separator="."/>

  <!-- Variaveis de ambiente de execucao -->
  <xsl:param name="PATH_IMAGENS" select="'imagens/'"/>
  <xsl:param name="PATH_REMESSA" select="'remessa/'"/>

  <xsl:attribute-set name="bordas"> 
	  <xsl:attribute name="border-after-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-after-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-before-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-before-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-left-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-left-style">solid</xsl:attribute> 
  	  <xsl:attribute name="border-right-width">1pt</xsl:attribute> 
  	  <xsl:attribute name="border-right-style">solid</xsl:attribute> 
  </xsl:attribute-set>
    
  <xsl:attribute-set name="cabecalhoLeftCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRightCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoLeft">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRight">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinza">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinzaEscuro">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegrito">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoLeft">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoBig">
	<xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoItalico">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="total">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="totalLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

 <xsl:attribute-set name="cabecalho">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoCenter">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtJustifyMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
	<xsl:attribute name="hyphenate">true</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
	<xsl:attribute name="language">pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtJustify">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
	<xsl:attribute name="hyphenate">true</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
	<xsl:attribute name="language">pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>  
  
  <xsl:attribute-set name="txtLeftBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBigCur">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenter">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenterBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRight">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtRightShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>   

  <xsl:attribute-set name="txtRightBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="linhaTotal">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="border-top-style">solid</xsl:attribute>
	<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtQuadroTce">
    <xsl:attribute name="font-size">7.0pt</xsl:attribute>
    <xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
    <xsl:attribute name="space-before">0pt</xsl:attribute>
    <xsl:attribute name="space-after">0pt</xsl:attribute>
    <xsl:attribute name="padding-top">1pt</xsl:attribute>
    <xsl:attribute name="padding-bottom">1pt</xsl:attribute>
  </xsl:attribute-set>

<xsl:template match="/">
  <fo:root>
    <fo:layout-master-set>
      <!-- Define a body (or default) page. -->
      <fo:simple-page-master master-name="default-master" page-height="29.6cm" page-width="21cm" margin-top="15pt" 	 margin-left="20pt" margin-right="20pt" margin-bottom="15pt">

        <!-- Central part of page -->
        <fo:region-body column-count="1" margin-top="1.65in" margin-bottom="0.2in"/>

        <!-- Header -->
        <fo:region-before border-after-style="solid" extent="1.65in" margin-bottom="0.2in"/>

        <!-- Footer -->
        <fo:region-after border-before-style="solid" extent="0.2in" margin-bottom="0.2in"/>
      </fo:simple-page-master>
    </fo:layout-master-set>

    <!-- Body page -->
    <fo:page-sequence master-reference="default-master">

      <!-- Define the contents of the header. -->
      <fo:static-content flow-name="xsl-region-before">
		<xsl:apply-templates select="Modelo14/Header"/>
      </fo:static-content>

      <!-- Define the contents of the footer. -->
      <fo:static-content flow-name="xsl-region-after">
    
      </fo:static-content>

      <!-- The main contents of the body page, that is, the catalog entries 
	   ########## CORPO DO TEXTO DOS RELAT&#211;RIOS #########
	    -->
      <fo:flow flow-name="xsl-region-body">
        <fo:block font-size="8.0pt" font-family="serif">
		 <fo:block><fo:leader leader-pattern="space" /></fo:block>
		 
		 <!--********** Variaveis **********-->
		 <xsl:variable name="entidade">
	 	  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/TIPO_SETOR_GOV='P'">Poder Executivo</xsl:if>
		  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/TIPO_SETOR_GOV='C'">Poder Legislativo</xsl:if>
		 </xsl:variable>

		<xsl:variable name="periodicidade">
		 <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='S'">Semestre</xsl:if>
		 <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q'">Quadrimestre</xsl:if>
		</xsl:variable>

		<xsl:variable name="periodo">
		 <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='S'">
		  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3 &lt;= 1">1</xsl:if>
		  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3 &gt; 1">2</xsl:if>
		 </xsl:if>
		 <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q'">
		  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt;= 1">1</xsl:if>
		  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &gt; 1 and Modelo14/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt;= 2">2</xsl:if>
		  <xsl:if test="Modelo14/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &gt; 2">3</xsl:if>
		 </xsl:if>
		</xsl:variable>
		<!--********** Variaveis **********-->
		
		<!-- CABECALHO INICIAL -->
		 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		  <fo:table-column column-number="1" column-width="556pt"/>

		  <fo:table-body>  
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">Nome da Entidade: C<xsl:value-of select="substring(Modelo14/Header/Informacoes/InformacoesRow/NOME, 2)"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">CNPJ: <xsl:value-of select="Modelo14/Header/Informacoes/InformacoesRow/CNPJ"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">ORG&#195;O N&#186;: <xsl:value-of select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">Gera&#231;&#227;o do PAD: <xsl:value-of select="$entidade"></xsl:value-of></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		  </fo:table-body>
		 </fo:table>
		 <!-- FIM CABECALHO INICIAL -->

		 <fo:block><fo:leader leader-pattern="space"/></fo:block>
		 <fo:block><fo:leader leader-pattern="space"/></fo:block>

		 <xsl:if test="Modelo14/Modelos/Modelo1!=''">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <xsl:apply-templates select="Modelo14/Modelos/Modelo1"/>
		 </xsl:if>

		 <xsl:if test="Modelo14/Modelos/Modelo10!=''">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
	 	  <xsl:apply-templates select="Modelo14/Modelos/Modelo10"/>
		 </xsl:if>

		 <xsl:if test="((Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q' and $periodo=3) or (Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='S' and $periodo=2))">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <xsl:apply-templates select="Modelo14/Modelos/Modelo11"/>
		 </xsl:if>

		 <xsl:if test="((Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q' and $periodo=3) or (Modelo14/Header/Informacoes/InformacoesRow/TP_ENTREGA='S' and $periodo=2))">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <xsl:apply-templates select="Modelo14/Modelos/Modelo13"/>
		 </xsl:if>

		 <xsl:if test="Modelo14/Header/Informacoes!=''">
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
 		  <xsl:apply-templates select="Modelo14/Header/Informacoes"/>
		 </xsl:if>
   		 
		 <!-- pagina final -->
		 <fo:block id="last-page"/>
		 <!-- pagina final -->
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>


<!--
####################################
########     ALERTAS      ##########
####################################
-->
<xsl:template match="Informacoes"> 
 <!-- INICIO ALERTAS-->
<xsl:if test="((((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &gt; 5.405 and (((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &lt; 5.71) or
              ((((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &gt; 5.705 and (((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &lt; 6.01) or
			  ((((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &gt; 6.005)">
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>  
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>  

 <!-- INICIO ALERTA 1 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DOS ALERTAS </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>Em atendimento ao disposto no  &#167; 1&#186; do art. 59 da Lei Complementar n&#186; 101/2000 - LEI DE RESPONSABILIDADE FISCAL (LRF), e considerando que o &#237;ndice demonstrado no Modelo 14 - Demonstrativo dos Limites est&#225; acima do limite estabelecido na LRF, ser&#225; emitido, automaticamente, conforme o caso, o <fo:inline font-weight="bold">ALERTA</fo:inline> a seguir indicado:</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt">
	<fo:block></fo:block>
	</fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 1 -->
 
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <xsl:if test="(((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &gt; 5.405 and (((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &lt; 5.71 ">
 <!-- INICIO ALERTA 2 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
   </fo:table-row> 

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline> de <xsl:value-of select="format-number((((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100),'###.###.##0,00')"></xsl:value-of> % est&#225; situado <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">no intervalo de 5,41% a 5,70%</fo:inline>, sendo, portanto, superior ao limite para emiss&#227;o do alerta de que trata o Inciso II do &#167; 1&#186; do Art. 59 da LRF, de 5,40%, (percentual este equivalente a 90,00% sobre o limite de 6,00%, conforme estipulado no Inciso II do &#167; 1&#186; do Art. 59 c/c al&#237;nea &#180;&#180;a&#180;&#180; do Inciso III do Art. 20, ambos da LRF).</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 2 -->
 </xsl:if>

 <xsl:if test="(((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &gt; 5.705 and (((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &lt; 6.01 ">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- INICIO ALERTA 3 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline> de <xsl:value-of select="format-number((((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100),'###.###.##0,00')"></xsl:value-of> % est&#225; situado <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">no intervalo de 5,71% a 6,00%</fo:inline>, sendo, portanto, superior ao limite para emiss&#227;o do alerta de que trata o Inciso II do &#167; 1&#186; do Art. 59 da LRF (5,70%, percentual este equivalente a 95,00% sobre o limite de 6,00%, conforme estipulado no par&#225;grafo &#250;nico  do art. 22 c/c al&#237;nea &#180;&#180;a&#180;&#180; do Inciso III do Art. 20, ambos da LRF), e coloca o Poder Legislativo  Municipal, conforme determinado no citado par&#225;grafo &#250;nico do art. 22 da LRF, <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">ao alcance das seguintes VEDA&#199;&#213;ES</fo:inline></fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Incisos I a V do Par&#225;grafo &#218;nico do Art. 22:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 22 -  [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Par&#225;grafo &#218;nico - [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">I - concess&#227;o de vantagem, aumento, reajuste ou adequa&#231;&#227;o de remunera&#231;&#227;o a qualquer t&#237;tulo, salvo os derivados de senten&#231;a judicial ou de determina&#231;&#227;o legal ou contratual, ressalvada a revis&#227;o prevista no inciso X do art. 37 da Constitui&#231;&#227;o;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">II - cria&#231;&#227;o de cargo, emprego ou fun&#231;&#227;o;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">III - altera&#231;&#227;o de estrutura de carreira que implique aumento de despesa;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">IV - provimento de cargo p&#250;blico, admiss&#227;o ou contrata&#231;&#227;o de pessoal a qualquer t&#237;tulo, ressalvada a reposi&#231;&#227;o decorrente de aposentadoria ou falecimento de servidores das &#225;reas de educa&#231;&#227;o, sa&#250;de e seguran&#231;a;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">V - contrata&#231;&#227;o de hora extra, salvo no caso do disposto no inciso II do &#167; 6&#186; do art. 57 da Constitui&#231;&#227;o e as situa&#231;&#245;es previstas na lei de diretrizes or&#231;ament&#225;rias.</fo:block>
    </fo:table-cell>
   </fo:table-row>  
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 3 -->
 </xsl:if>

 <xsl:if test="(((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100) &gt; 6.005">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <!-- INICIO ALERTA 4 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline>
      <!--ao trmino do exerccio financeiro de 2021-->
      de <xsl:value-of select="format-number((((../../Modelos/Modelo10/Modelo10Row/VALOR) div (../../Modelos/Modelo1/Modelo1Row/VALOR))*100),'###.###.##0,00')"></xsl:value-of> %
      <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline>
      ao limite para emiss&#227;o do alerta de que trata o Inciso II do &#167; 1&#186; do art. 59 da LRF, e ao limite de 6,00% fixado na al&#237;nea &#180;&#180;a&#180;&#180; do inciso III do art. 20 da LRF, situa&#231;&#227;o que coloca o Poder Legislativo Municipal <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">
      <!--
      ao alcance do disposto no artigo 15 da Lei Complementar Federal n 178, de 13 de janeiro de 2021, que instituiu um regime especial para eliminao, em dez anos, a partir do exerccio de 2023, do excedente da despesa com pessoal apurado ao final do exerccio de 2021, suspendendo assim as contagens de prazo e das disposies do art. 23 da Lei Complementar Federal n 101, de 2000.
      -->
      ao alcance das veda&#231;&#245;es descritas no par&#225;grafo &#250;nico do art. 22, na obriga&#231;&#227;o de adotar provid&#234;ncias para a elimina&#231;&#227;o do percentual excedente no prazo e condi&#231;&#245;es estabelecidas nos &#167; 1&#186; e &#167; 2&#186; e do caput do art. 23, e o Munic&#237;pio sujeito &#224;s restri&#231;&#245;es dos &#167; 3&#186; e &#167; 4&#186; do mesmo artigo, todos da LRF.
      </fo:inline>
     </fo:block>

     <fo:block xsl:use-attribute-sets="txtJustifyMed">
       <fo:inline font-weight="normal" color="white">__________</fo:inline>
       O Poder Legislativo cuja despesa total com pessoal ao
       <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">
       trmino de 2021 foi superior ao limite estabelecido no art. 20 da LRF, dever eliminar o excesso  razo de, pelo menos, 10% (dez por cento) a cada exerccio a partir de 2023, de forma a se enquadrar no respectivo limite at o trmino do exerccio de 2032
       </fo:inline>
       , conforme regra trazida pelo art. 15 da LC n 178/2021 (Regime Especial). Nessa situao, o Poder Legislativo que no decurso dos 10 anos vier a ficar abaixo do limite legal, volta para o regramento determinado no art. 23 da LRF.
     </fo:block>

    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Das Veda&#231;&#245;es</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Incisos I a V do Par&#225;grafo &#218;nico do Art. 22:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 22 - [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Par&#225;grafo &#218;nico - [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">I - concess&#227;o de vantagem, aumento, reajuste ou adequa&#231;&#227;o de remunera&#231;&#227;o a qualquer t&#237;tulo, salvo os derivados de senten&#231;a judicial ou de determina&#231;&#227;o legal ou contratual, ressalvada a revis&#227;o prevista no inciso X do art. 37 da Constitui&#231;&#227;o;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">II - cria&#231;&#227;o de cargo, emprego ou fun&#231;&#227;o;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">III - altera&#231;&#227;o de estrutura de carreira que implique aumento de despesa;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">IV - provimento de cargo p&#250;blico, admiss&#227;o ou contrata&#231;&#227;o de pessoal a qualquer t&#237;tulo, ressalvada a reposi&#231;&#227;o decorrente de aposentadoria ou falecimento de servidores das &#225;reas de educa&#231;&#227;o, sa&#250;de e seguran&#231;a;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">V - contrata&#231;&#227;o de hora extra, salvo no caso do disposto no inciso II do &#167; 6&#186; do art. 57 da Constitui&#231;&#227;o e as situa&#231;&#245;es previstas na lei de diretrizes or&#231;ament&#225;rias.</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Do Prazo para Elimina&#231;&#227;o do Percentual Excedente</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
     <fo:block xsl:use-attribute-sets="titNegritoMed">Regime ordinrio (para o Poder Legislativo que no exceder o limite ao final de 2021)</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, artigo 23:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 23. Se a despesa total com pessoal, do Poder ou rgo referido no artigo 20, ultrapassar os limites definidos no mesmo artigo, sem prejuzo das medidas previstas no artigo 22, o percentual excedente ter de ser eliminado nos dois quadrimestres seguintes, sendo pelo menos um tero no primeiro, adotando-se, entre outras, as providncias previstas nos  3 e 4 do artigo 169 da Constituio.</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
     <fo:block xsl:use-attribute-sets="titNegritoMed">Regime especial (para o Poder Legislativo que exceder o limite ao final de 2021)</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Lei Complementar Federal n 178, caput e  2, 3 e 4 do artigo 15:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 15. O Poder ou rgo cuja despesa total com pessoal ao trmino do exerccio financeiro da publicao desta Lei Complementar estiver acima de seu respectivo limite estabelecido no art. 20 da Lei Complementar n 101, de 4 de maio de 2000, dever eliminar o excesso  razo de, pelo menos, 10% (dez por cento) a cada exerccio a partir de 2023, por meio da adoo, entre outras, das medidas previstas nos arts. 22 e 23 daquela Lei Complementar, de forma a se enquadrar no respectivo limite at o trmino do exerccio de 2032.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">[...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify"> 2 A comprovao acerca do cumprimento da regra de eliminao do excesso de despesas com pessoal prevista no caput dever ser feita no ltimo quadrimestre de cada exerccio, observado o art. 18 da Lei Complementar n 101, de 4 de maio de 2000.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify"> 3 Ficam suspensas as contagens de prazo e as disposies do art. 23 da Lei Complementar n 101, de 4 de maio de 2000, no exerccio financeiro de publicao desta Lei Complementar.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify"> 4 At o encerramento do prazo a que se refere o caput, ser considerado cumprido o disposto no art. 23 da Lei Complementar n 101, de 4 de maio de 2000, pelo Poder ou rgo referido no art. 20 daquela Lei Complementar que atender ao estabelecido neste artigo.</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
     <fo:block xsl:use-attribute-sets="titNegritoBig">Das Provid&#234;ncias para Elimina&#231;&#227;o do Percentual Excedente</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Lei Complementar Federal n 178, caput do artigo 15:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 15. O Poder ou rgo cuja despesa total com pessoal ao trmino do exerccio financeiro da publicao desta Lei Complementar estiver acima de seu respectivo limite estabelecido no art. 20 da Lei Complementar n 101, de 4 de maio de 2000, dever eliminar o excesso  razo de, pelo menos, 10% (dez por cento) a cada exerccio a partir de 2023, por meio da adoo, entre outras, das medidas previstas nos arts. 22 e 23 daquela Lei Complementar, de forma a se enquadrar no respectivo limite at o trmino do exerccio de 2032.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->
   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, incisos I a V do pargrafo nico do artigo 22:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 22 [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Pargrafo nico. [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">I - concesso de vantagem, aumento, reajuste ou adequao de remunerao a qualquer ttulo, salvo os derivados de sentena judicial ou de determinao legal ou contratual, ressalvada a reviso prevista no inciso X do artigo 37 da Constituio;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">II - criao de cargo, emprego ou funo;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">III - alterao de estrutura de carreira que implique aumento de despesa;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">IV - provimento de cargo pblico, admisso ou contratao de pessoal a qualquer ttulo, ressalvada a reposio decorrente de aposentadoria ou falecimento de servidores das reas de educao, sade e segurana;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">V - contratao de hora extra, salvo no caso do disposto no inciso II do  6 do artigo 57 da Constituio e as situaes previstas na lei de diretrizes oramentrias.</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Art. 23:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 - Ultrapassado o limite legal (6,00%) o percentual excedente dever&#225; ser eliminado nos dois quadrimestres seguintes, sendo pelo menos um ter&#231;o no primeiro.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->

   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Das Provid&#234;ncias para Elimina&#231;&#227;o do Percentual Excedente</fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Constitui&#231;&#227;o Federal, &#167; 3&#186; e &#167; 4&#186; do Art. 169:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 169 -  [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 3&#186; -  [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">I - redu&#231;&#227;o em pelo menos vinte por cento das despesas com cargos em comiss&#227;o e fun&#231;&#245;es de confian&#231;a;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">II - exonera&#231;&#227;o dos servidores n&#227;o est&#225;veis.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 4&#186; - Se as medidas adotadas com base no par&#225;grafo anterior n&#227;o forem suficientes para assegurar o cumprimento da determina&#231;&#227;o da lei complementar referida neste artigo, o servidor est&#225;vel poder&#225; perder o cargo, desde que ato normativo motivado de cada um dos Poderes especifique a atividade funcional, o &#243;rg&#227;o ou unidade administrativa objeto da redu&#231;&#227;o de pessoal. [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, &#167; 1&#186; e &#167; 2&#186; do Art. 23:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 -  [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">&#167; 1&#186; - No caso do inciso I do &#167; 3&#186; do art. 169 da Constitui&#231;&#227;o, o objetivo poder&#225; ser alcan&#231;ado tanto pela extin&#231;&#227;o de cargos e fun&#231;&#245;es quanto pela redu&#231;&#227;o dos valores a eles atribu&#237;dos.
       <!--(Vide ADIN 2.238-5).-->
       &#185;
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">&#167; 2&#186; - &#201; facultada a redu&#231;&#227;o tempor&#225;ria da jornada de trabalho com adequa&#231;&#227;o dos vencimentos &#224; nova carga hor&#225;ria.&#178; [...]
       <!--(Vide ADIN 2.238-5).-->
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">&#185; A express&#227;o &#180;&#180;quanto pela redu&#231;&#227;o dos valores a eles atribu&#237;dos&#180;&#180; foi suspensa pelo STF (ADIN 2238 em 09-5-2002), visto n&#227;o haver previs&#227;o de redu&#231;&#227;o de vencimentos dos servidores p&#250;blicos no art. 169 da Constitui&#231;&#227;o.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">&#178; Prerrogativa suspensa na &#237;ntegra pelo STF (ADIN 2238 de 09-5-2002), porque possibilita a redu&#231;&#227;o tempor&#225;ria da jornada de trabalho com adequa&#231;&#227;o de vencimentos.</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Das Restri&#231;&#245;es</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">Lei Complementar Federal n 178,  1 do artigo 15:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify"> 1 A inobservncia do disposto no caput no prazo fixado sujeita o ente s restries previstas no  3 do art. 23 da Lei Complementar n 101, de 4 de maio de 2000.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">
      <!--
      Lei de Responsabilidade Fiscal, &#167; 3&#186; e &#167; 4&#186; do Art. 23:
      Lei de Responsabilidade Fiscal,  3 do artigo 23:
      -->
      Lei de Responsabilidade Fiscal, &#167;&#167; 3&#186;, 4&#186;, 5&#186; e 6&#186; do Art. 23:
     </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 -  [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 3&#186; N&#227;o alcan&#231;ada a redu&#231;&#227;o no prazo estabelecido, e enquanto perdurar o excesso, o ente n&#227;o poder&#225;:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">I - receber transfer&#234;ncias volunt&#225;rias;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">II - obter garantia, direta ou indireta, de outro ente;</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">III - contratar opera&#231;&#245;es de cr&#233;dito, ressalvadas as destinadas ao refinanciamento da d&#237;vida mobili&#225;ria e as que visem &#224; redu&#231;&#227;o das despesas com pessoal.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">&#167; 4&#186; As restri&#231;&#245;es do &#167; 3&#186; aplicam-se imediatamente se a despesa total com pessoal exceder o limite no primeiro quadrimestre do &#250;ltimo ano do mandato dos titulares de Poder ou &#243;rg&#227;o referidos no art. 20. <!--[...]--></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">&#167; 5&#186; As restries previstas no  3 deste artigo no se aplicam ao Municpio em caso de queda de receita real superior a 10% (dez por cento), em comparao ao correspondente quadrimestre do exerccio financeiro anterior, devido a:</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">I - diminuio das transferncias recebidas do Fundo de Participao dos Municpios decorrente de concesso de isenes tributrias pela Unio; e</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">II - diminuio das receitas recebidas de royalties e participaes especiais.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtJustify">&#167; 6&#186; O disposto no  5 deste artigo s se aplica caso a despesa total com pessoal do quadrimestre vigente no ultrapasse o limite percentual previsto no art. 19 desta Lei Complementar, considerada, para este clculo, a receita corrente lquida do quadrimestre correspondente do ano anterior atualizada monetariamente. [ ... ]</fo:block>
    </fo:table-cell>
   </fo:table-row>

  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 4 -->
 </xsl:if>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- INICIO ALERTA 5 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
    
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>Considerando a(s) ocorr&#234;ncia(s) prevista(s) no inciso II do &#167; 1&#186; do art. 59 da Lei Complementar n&#186; 101, de 04 de maio de 2000 (LRF), o montante da despesa total com pessoal se encontra acima de 90,00% do limite legal de que trata a al&#237;nea &#180;&#180;a&#180;&#180; do Inciso III do art. 20 da referida Lei.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 5 -->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- INICIO ALERTA 6 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="55pt"/>
  <fo:table-column column-number="3" column-width="390pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
    
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>Assim, considerando as compet&#234;ncias estabelecidas no &#167; 1&#186; do art. 59 da Lei Complementar n&#186; 101, de 04 de maio de 2000 (LRF) e o disposto no inciso XI do art. 48, do Regimento Interno do Tribunal de Contas do Estado - RITCE, esta Corte emite o presente <fo:inline font-weight="bold">ALERTA</fo:inline>.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 6 -->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- FIM ALERTA 7 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="55pt"/>
  <fo:table-column column-number="3" column-width="390pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DA CI&#202;NCIA </fo:block>
    </fo:table-cell>
   </fo:table-row>  

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>EU, PRESIDENTE DO PODER LEGISLATIVO MUNICIPAL, com base no &#237;ndice acima demonstrado, considero-me cientificado do referido alerta.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 7 -->
</xsl:if>
<!-- FIM ALERTAS-->
 
<!-- QUEBRA DE PAGINA -->
<fo:block break-before="page"/>
<!-- QUEBRA DE PAGINA -->
   
 <!-- ASSINATURAS -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!--<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/DATA_EX"/></fo:block>-->
 <fo:block xsl:use-attribute-sets="txtCenter">
	<xsl:value-of select="InformacoesRow/DATA_EX"/>
 </fo:block>
 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/NOME_REPRESENTANTE"/></fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter">Presidente da C&#226;mara Municipal</fo:block>

 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/RESP_ADMIN_FINAN"/></fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pela Administra&#231;&#227;o Financeira</fo:block>

 <fo:leader leader-pattern="space" />
 <fo:leader leader-pattern="space" />
 <fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/RESP_CTRL_INTERNO"/></fo:block>
 <fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pelo Controle Interno</fo:block>
</xsl:template>
<!-- FIM ASSINATURAS -->


<!--#############################-->
<!--####       HEADER       ####-->
<!--#############################-->
<xsl:template match="Header">
<!--******** VARIAVEIS *********-->
<xsl:variable name="periodicidade">
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='S'">
  <xsl:value-of select="'Semestre'"></xsl:value-of>
  </xsl:if>
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='Q'">
  <xsl:value-of select="'Quadrimestre'"></xsl:value-of>
 </xsl:if>
</xsl:variable>

<xsl:variable name="periodo">
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='S'">
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3) &lt; 1">1</xsl:if>
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3) = 1">1</xsl:if>
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3) &gt; 1">2</xsl:if>
 </xsl:if>
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='Q'">
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2) &lt; 1">1</xsl:if>
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2) = 1">1</xsl:if>
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2) &gt; 1 and Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt; 2">2</xsl:if>
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2) = 2">2</xsl:if>
  <xsl:if test="(Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2) &gt; 2">3</xsl:if>
 </xsl:if>
</xsl:variable>

 <xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao"/>
 <xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
 <xsl:variable name="horario" select="substring($dataHora, 12, 8)"/>
 <xsl:variable name="dia" select="substring($data, 9, 2)"/>
 <xsl:variable name="mes" select="substring($data, 6, 2)"/>
 <xsl:variable name="ano" select="substring($data, 1, 4)"/>
 <xsl:variable name="hora" select="substring($horario, 1, 2)"/>
 <xsl:variable name="minuto" select="substring($horario, 4, 2)"/>
 <xsl:variable name="segundo" select="substring($horario, 7, 2)"/>  
<!--******** VARIAVEIS *********-->

 <fo:table table-layout="fixed" width="556pt">
   <fo:table-column column-width="40pt"/>
   <fo:table-column column-width="325pt"/>
   <fo:table-column column-width="100pt"/>
   <fo:table-column column-width="10pt"/>
   <fo:table-column column-width="70pt"/>

   <fo:table-body>
    <fo:table-row>
	 <fo:table-cell padding-bottom="3pt">
	    <fo:block>
		<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}"/>
	    </fo:block>
	 </fo:table-cell>
	 <fo:table-cell>
	  <fo:block padding-bottom="5pt">
	      <!-- INICIO CABECALHO  -->
		 <fo:table width="370pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		  <fo:table-column column-number="1" column-width="5pt"/>
		  <fo:table-column column-number="2" column-width="315pt"/>
		  <fo:table-column column-number="3" column-width="5pt"/>

		  <fo:table-body>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt" number-columns-spanned="3" padding-left="5pt">
		     <fo:block xsl:use-attribute-sets="txtLeft">ESTADO DO RIO GRANDE DO SUL </fo:block>
		     <fo:block xsl:use-attribute-sets="txtLeft">TRIBUNAL DE CONTAS DO ESTADO </fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoBig">Modelo 14 - DEMONSTRATIVO DOS LIMITES - RGF</fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">LEGISLATIVO MUNICIPAL</fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">EXERC&#205;CIO DE <xsl:value-of select="Informacoes/InformacoesRow/EXERCICIO"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">C<xsl:value-of select="substring(Informacoes/InformacoesRow/NOME, 2)"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito"><xsl:value-of select="$periodo"/>&#186; <xsl:value-of select="$periodicidade"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		  </fo:table-body>
		 </fo:table>
	    <!-- FIM CABECALHO  -->  
          </fo:block>
	</fo:table-cell>
	<fo:table-cell padding-bottom="3pt" text-align="center">
	  <!-- BARCODE -->
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block>
          <fo:instream-foreign-object>
            <barcode:barcode 
            xmlns:barcode="http://barcode4j.krysalis.org/ns"
            message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-modelo14}">
              <barcode:code128>
                <barcode:height>15mm</barcode:height>
              </barcode:code128>
            </barcode:barcode>
          </fo:instream-foreign-object>
	      </fo:block>
	 <!-- BARCODE -->
        </fo:table-cell>
	<fo:table-cell padding-bottom="3pt">
	    <fo:block>
	    </fo:block>
	</fo:table-cell>    
	<fo:table-cell >
	  <fo:block>
		  <!-- <fo:table text-align="center" table-layout="fixed">
		    <fo:table-column column-width="35pt"/>
		    <fo:table-column column-width="35pt"/>
		    <fo:table-body>
		      <fo:table-row>
		        <fo:table-cell number-columns-spanned="2" border-style="solid" border-width="0.25pt" space-before="0pt" space-after="0pt">
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Para uso do</fo:block>
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Tribunal de Contas</fo:block>
		        </fo:table-cell>
		      </fo:table-row>
		      <fo:table-row>
		        <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Fl.</fo:block>
		          <fo:block xsl:use-attribute-sets="txtQuadroTce"></fo:block>
		        </fo:table-cell>
		        <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Rubrica</fo:block>
		          <fo:block xsl:use-attribute-sets="txtQuadroTce"></fo:block>
		        </fo:table-cell>
		      </fo:table-row>
		    </fo:table-body>
		  </fo:table> -->
		</fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight">
      <fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}" width="42pt"/>
	  </fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
	   <xsl:value-of select="Informacoes/InformacoesRow/VERSAO_PAD"/>
	   <xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
    </fo:block> 	  
	  <fo:block xsl:use-attribute-sets="txtRight">
      <xsl:value-of select="$dia"/>/<xsl:value-of select="$mes"/>/<xsl:value-of select="$ano"/>
	  </fo:block>		 
	  <fo:block xsl:use-attribute-sets="txtRight">
      <xsl:value-of select="$hora"/>:<xsl:value-of select="$minuto"/>:<xsl:value-of select="$segundo"/>
	  </fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight">
	    P&#225;g.: <fo:page-number/>/<fo:page-number-citation ref-id="last-page"/>
    </fo:block>
       </fo:table-cell>
</fo:table-row>
</fo:table-body>
</fo:table>
</xsl:template>


<!--
####################################
########     MODELO 1    ##########
####################################
-->
<xsl:template match="Modelo1">
  <!-- INICIO MODELO 1 -->	
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="400pt"/>
  <fo:table-column column-number="2" column-width="156pt"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell number-columns-spanned="2">
         <fo:block xsl:use-attribute-sets="titFCinza">
	  <xsl:text>MODELO 1 - DEMONSTRATIVO DA RECEITA CORRENTE L&#205;QUIDA </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell>
         <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>Lei Complementar Federal n&#186; 101/2000 - LRF,  Inciso I do art. 53 </xsl:text>
	 </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt">
         <fo:block font-weight="bold" text-align="right" font-size="6.0pt">Valores expressos em reais </fo:block>
        </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="336pt"/>
  <fo:table-column column-number="2" column-width="220pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" xsl:use-attribute-sets="bordas">
     <fo:block font-weight="bold" text-align="left">RECEITA CORRENTE L&#205;QUIDA - DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" border-width="0.5pt" xsl:use-attribute-sets="bordas">
     <fo:block font-weight="bold" text-align="right">VALOR AJUSTADO </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <xsl:for-each select="Modelo1Row">
   <fo:table-row>
	<fo:table-cell border-width="0.5pt" xsl:use-attribute-sets="bordas">
     <fo:block xsl:use-attribute-sets="txtLeft">Arrecadadas no m&#234;s de refer&#234;ncia e nos onze anteriores (12 meses) </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt" padding="1pt" xsl:use-attribute-sets="bordas">
     <fo:block xsl:use-attribute-sets="txtRight">
	  <xsl:value-of select="format-number(VALOR,'###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>	    
   </fo:table-row>
  </xsl:for-each>
  </fo:table-body>
 </fo:table>
</xsl:template>
<!-- FIM MODELO 1 -->


<!--
####################################
########     MODELO 10    ##########
####################################
-->
<xsl:template match="Modelo10">
 <!-- INICIO MODELO 10 -->	
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="400pt"/>
  <fo:table-column column-number="2" column-width="156pt"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell number-columns-spanned="2">
         <fo:block xsl:use-attribute-sets="titFCinza">
	  <xsl:text>MODELO 10 - DEMONSTRATIVO DA DESPESA COM PESSOAL </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell>
         <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;a&#180;&#180; do Inciso I do art. 55 </xsl:text>
	 </fo:block>
        </fo:table-cell>
        <fo:table-cell padding="2pt"  border-width="0.5pt" >
         <fo:block font-weight="bold" text-align="right" font-size="6.0pt">Valores expressos em reais </fo:block>
        </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="253pt"/>
  <fo:table-column column-number="2" column-width="143pt"/>
  <fo:table-column column-number="3" column-width="70pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="left">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">VALOR AJUSTADO </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">% S/RCL </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>
 
  <fo:table-body>
  <xsl:for-each select="Modelo10Row">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Total da Despesa L&#237;quida c/Pessoal nos 12 &#250;ltimos meses </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-right="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
		<xsl:if test="../../Modelo1/Modelo1Row/VALOR=0.00 or ../../Modelo1/Modelo1Row/VALOR='0,00' or ../../Modelo1/Modelo1Row/VALOR=''">
			<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
		</xsl:if>
		<xsl:if test="../../Modelo1/Modelo1Row/VALOR!=0.00 and ../../Modelo1/Modelo1Row/VALOR!='0,00'">
			<xsl:value-of select="format-number((VALOR div (../../Modelo1/Modelo1Row/VALOR))*100, '###.###.##0,00')"/> %
		</xsl:if>
	 </fo:block>
	</fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
   <fo:table-row>
    <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="2" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite para Emiss&#227;o de Alerta - LRF, Inciso II do &#167; 1&#186; do art. 59 </fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-right="3pt">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">5,40 %</fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="2" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Prudencial - LRF, Par&#225;grafo &#218;nico do art. 22 </fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-right="3pt">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">5,70 %</fo:block>
    </fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="2" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal - LRF, al&#237;nea &#180;&#180;a&#180;&#180; do Inciso III do art. 20</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-right="3pt">
     <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">6,00 %</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <xsl:if test="((sum(Modelo10Row/VALOR) div (../Modelo1/Modelo1Row/VALOR))*100) &gt; 6.005">
    <fo:table-row>
     <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="3" padding-left="1pt">
      <fo:block xsl:use-attribute-sets="txtLeft">
	  Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.<!-- no prazo determinado no art. 23 da LRF.-->
	  </fo:block>
	  <!--
	  <fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
	    Nos termos do &#167; 3&#186;, artigo 15 da Lei Complementar 178/2020, est&#227;o suspensas as contagens de prazo e as disposi&#231;&#245;es do art. 23 da LRF no exerc&#237;cio
	    <xsl:value-of select="/Modelo14/Header/Informacoes/InformacoesRow/EXERCICIO"/>.
	  </fo:block>
	  -->
     </fo:table-cell>
    </fo:table-row>
   </xsl:if>
   <xsl:if test="../../MedidasCorretivas/MedidasCorretivasRow/CD_PLANILHA=10">
    <fo:table-row>
     <fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="3" padding-left="1pt">
      <fo:block xsl:use-attribute-sets="txtLeft" font-size="9.0pt">
	   <xsl:value-of select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=10]/TEXTO"/>
	  </fo:block>
     </fo:table-cell>
    </fo:table-row>
   </xsl:if>
  </fo:table-body>
 </fo:table>
</xsl:template>
<!-- FIM MODELO 10 -->


<!--
####################################
########     MODELO 11    ##########
####################################
-->
<xsl:template match="Modelo11">
 <!-- INICIO MODELO 11 -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="400pt"/>
  <fo:table-column column-number="2" column-width="156pt"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="titFCinza">
	  <xsl:text>MODELO 11 - DEMONSTRATIVO DOS RESTOS A PAGAR </xsl:text>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
	<fo:table-cell>
         <fo:block xsl:use-attribute-sets="txtLeft">
	  <xsl:text>Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;b&#180;&#180; do Inciso III do art. 55 </xsl:text>
	 </fo:block>
        </fo:table-cell>
	<fo:table-cell padding="2pt"  border-width="0.5pt">
		<fo:block font-weight="bold" text-align="right" font-size="6.0pt">Valores expressos em reais </fo:block>
	</fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table> 	
 
 <fo:table table-layout="fixed" width="556pt">
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>

  <fo:table-body>
  <fo:table-row>
    <fo:table-cell number-rows-spanned="4" xsl:use-attribute-sets="bordas" padding-left="10pt">
      <fo:block xsl:use-attribute-sets="titNegrito">F.R.</fo:block>
    </fo:table-cell>
    <fo:table-cell number-columns-spanned="5" xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Obrigaes Financeiras</fo:block>
    </fo:table-cell>
  </fo:table-row>
  <fo:table-row>
    <fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Restos a Pagar Processados</fo:block>
    </fo:table-cell>
    <fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">RPNP de Exerccios Anteriores</fo:block>
    </fo:table-cell>
    <fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Demais Obrigaes Financeiras</fo:block>
    </fo:table-cell>
    <fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Total Obrigaes Financeiras antes Inscrio RPNP Exerccio</fo:block>
    </fo:table-cell>
  </fo:table-row>
  <fo:table-row>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">De Exerccios Anteriores</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Do Exerccio</fo:block>
    </fo:table-cell>
  </fo:table-row>
  <fo:table-row>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(a)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(b)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(c)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(d)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(e) = (a) + (b) + (c) + (d)</fo:block>
    </fo:table-cell>
    <!--
    -->
  </fo:table-row>
  <xsl:for-each select="../TodosRestos/TodosRestosRow">
    <fo:table-row>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="CD_RECURSO"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_PROC_ANTERIOR+VLR_PROC_ANTERIOR_AJUSTE,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_NPROC_ANTERIOR+VLR_NPROC_ANTERIOR_AJUSTE,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_DEMAIS_OBR_FINANCEIRAS,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_TOFAIPE,'###.##0,00')"/>
          <!--
          <xsl:value-of select="format-number(VLR_PROC_ANTERIOR+VLR_PROC_ANTERIOR_AJUSTE+
                            VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE+
                            VLR_NPROC_ANTERIOR+VLR_NPROC_ANTERIOR_AJUSTE+
                            VLR_DEMAIS_OBR_FINANCEIRAS,'###.##0,00')"/>
          -->
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
  </xsl:for-each>
  <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
        TOTAL
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_PROC_ANTERIOR)+sum(../TodosRestos/TodosRestosRow/VLR_PROC_ANTERIOR_AJUSTE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_PROC_ATUAL)+sum(../TodosRestos/TodosRestosRow/VLR_PROC_ATUAL_AJUSTE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_NPROC_ANTERIOR)+sum(../TodosRestos/TodosRestosRow/VLR_NPROC_ANTERIOR_AJUSTE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_DEMAIS_OBR_FINANCEIRAS),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_TOFAIPE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
  </fo:table-row>

  </fo:table-body>
</fo:table>

<fo:block><fo:leader leader-pattern="space"/></fo:block>
<fo:block><fo:leader leader-pattern="space"/></fo:block>

<fo:table table-layout="fixed" width="556pt">
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>
  <fo:table-column column-width="92pt"/>

  <fo:table-body>
  <fo:table-row>
    <fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">F.R.</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Disponibilidade de Caixa Bruta</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Total Obrigaes Financeitas antes Inscrio RPNP Exerccio</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Disponibilidade de Caixa Lquida (antes da inscrio RPNP do exerccio)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">RPNP do exerccio</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">Disponibilidade de Caixa Lquida (aps inscrio RPNP do exerccio)</fo:block>
    </fo:table-cell>
  </fo:table-row>
  <fo:table-row>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(f)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(e)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(g) = (f) - (e)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(h)</fo:block>
    </fo:table-cell>
    <fo:table-cell xsl:use-attribute-sets="bordas">
      <fo:block xsl:use-attribute-sets="titNegrito">(i) = (g - h)</fo:block>
    </fo:table-cell>
  </fo:table-row>

  <xsl:for-each select="../TodosRestos/TodosRestosRow">
    <fo:table-row>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="CD_RECURSO"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(DISP_FINANCEIRA+DISP_FINANCEIRA_AJUSTE,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_TOFAIPE,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <!--
          <xsl:value-of select="format-number(VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE-VLR_TOFAIPE,'###.##0,00')"/>
          -->
          <xsl:value-of select="format-number(DISP_FIN_ANTES_IR,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(VLR_NPROC_ATUAL+VLR_NPROC_ATUAL_AJUSTE,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
      <fo:table-cell border-width="0.5pt" >
        <fo:block xsl:use-attribute-sets="txtRight">
          <xsl:value-of select="format-number(DISP_FIN_APOS_IR,'###.##0,00')"/>
        </fo:block>
      </fo:table-cell>
    </fo:table-row>
  </xsl:for-each>
  <fo:table-row>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
        TOTAL
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/DISP_FINANCEIRA)+sum(../TodosRestos/TodosRestosRow/DISP_FINANCEIRA_AJUSTE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_TOFAIPE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/DISP_FIN_ANTES_IR),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/VLR_NPROC_ATUAL)+sum(../TodosRestos/TodosRestosRow/VLR_NPROC_ATUAL_AJUSTE),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow/DISP_FIN_APOS_IR),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
  </fo:table-row>
  <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="6">
      <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
      </fo:block>
    </fo:table-cell>
  </fo:table-row>
  <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="5">
      <fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
        TOTAL DAS FONTES DE RECURSOS COM INSUFICINCIA FINANCEIRA
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt" >
      <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
        <xsl:value-of select="format-number(sum(../TodosRestos/TodosRestosRow[DISP_FIN_APOS_IR &lt; 0]/DISP_FIN_APOS_IR),'###.##0,00')"/>
      </fo:block>
    </fo:table-cell>
  </fo:table-row>

  </fo:table-body>
</fo:table>

<!--
  <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="200pt"/>
	<fo:table-column column-width="130pt"/>
	<fo:table-column column-width="126pt"/>

	<fo:table-header xsl:use-attribute-sets="cabecalho">
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-rows-spanned="3" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">C&#243;d. Fonte de Recurso</fo:block>
			</fo:table-cell>
			<fo:table-cell number-rows-spanned="3" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtCenter" >Nome do Recurso</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtCenter" >INSCRITOS EM RESTOS A PAGAR COM SUFICI&#202;NCIA FINANCEIRA</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" >PROCESSADOS</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">N&#195;O PROCESSADOS</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</fo:table-header>

	<fo:table-body>
		<xsl:for-each select="Modelo11Row">
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
					<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="CD_RECURSO"/></fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
					<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="DS_RECURSO"/></fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtRight" text-align="right"><xsl:value-of select=" format-number(VALOR_P,'###.##0,00')"/></fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
						<xsl:value-of select=" format-number(VALOR_Q,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:for-each> 

		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">SUBTOTAL</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select="format-number(sum(Modelo11Row/VALOR_P),'###.###.###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select="format-number(sum(Modelo11Row/VALOR_Q),'###.###.###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">TOTAL</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select="format-number(sum(Modelo11Row/VALOR_P) + sum(Modelo11Row/VALOR_Q),'###.###.###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</fo:table-body>
 </fo:table>				
 
 <fo:block><fo:leader leader-pattern="space" /></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="180pt"/>
	<fo:table-column column-width="81pt"/>
	<fo:table-column column-width="81pt"/>
	<fo:table-column column-width="81pt"/>
	<fo:table-column column-width="81pt"/>

	<fo:table-header xsl:use-attribute-sets="cabecalho">
	   	<fo:table-row border-width="0.5pt">
    		<fo:table-cell padding="2pt"  border-width="0.5pt" number-columns-spanned="12">
     			<fo:block font-weight="bold" text-align="right" font-size="6.0pt">Valores expressos em reais </fo:block>
    		</fo:table-cell>
   		</fo:table-row>  		
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-rows-spanned="4" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">C&#243;d. Fonte de Recurso</fo:block>
			</fo:table-cell>
			<fo:table-cell number-rows-spanned="4" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtCenter" >Nome do Recurso</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="4">
				<fo:block xsl:use-attribute-sets="txtCenter" >INSCRITOS EM RESTOS A PAGAR COM INSUFICI&#202;NCIA FINANCEIRA</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="titNegrito" >DE EXERC&#205;CIOS ANTERIORES</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="titNegrito" >DO EXERC&#205;CIO ATUAL</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="txtCenter" >PROCESSADOS</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="txtCenter" >N&#195;O PROCESSADOS</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="txtCenter" >PROCESSADOS</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="txtCenter" >N&#195;O PROCESSADOS</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" >
				<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</fo:table-header>
				
	<fo:table-body>
		<xsl:for-each select="Modelo11Row">
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
					<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="CD_RECURSO"/></fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
					<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="DS_RECURSO"/></fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
						<xsl:value-of select=" format-number((VALOR_R),'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
						<xsl:value-of select=" format-number((VALOR_S),'###.##0,00')"/>							
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
						<xsl:value-of select=" format-number((VALOR_T),'###.##0,00')"/>							
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
						<xsl:value-of select=" format-number((VALOR_U),'###.##0,00')"/>							
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:for-each> 

		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">SUBTOTAL</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(sum(Modelo11Row/VALOR_R),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(sum(Modelo11Row/VALOR_S),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(sum(Modelo11Row/VALOR_T),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(sum(Modelo11Row/VALOR_U),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
		</fo:table-row>			

		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">TOTAL</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(sum(Modelo11Row/VALOR_S)+sum(Modelo11Row/VALOR_R),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(sum(Modelo11Row/VALOR_U)+sum(Modelo11Row/VALOR_T),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
		</fo:table-row>		
	</fo:table-body>
 </fo:table>		
				
  <fo:block><fo:leader leader-pattern="space" /></fo:block>
  <fo:block><fo:leader leader-pattern="space" /></fo:block>

 <fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="110pt"/>
	<fo:table-column column-width="90pt"/>
	<fo:table-column column-width="100pt"/>
			
	<fo:table-body>
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-columns-spanned="3">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">TOTAL DOS RESTOS A PAGAR COM INSUFICI&#202;NCIA FINANCEIRA</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left" >Exerc&#237;cios Anteriores</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >Processados</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_R),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >N&#227;o Processados</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_S),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >Subtotal</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_S) + sum(Modelo11Row/VALOR_R),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left"><fo:leader leader-pattern="space" /></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Exerc&#237;cio Atual</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >Processados</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_T),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >N&#227;o Processados</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_U),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >Subtotal</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_T) + sum(Modelo11Row/VALOR_U),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt" number-columns-spanned="2">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left"><fo:leader leader-pattern="space" /></fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" >Total Ex Anterior + Ex Atual</fo:block>
			</fo:table-cell>
			<fo:table-cell >
				<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo11Row/VALOR_T) + sum(Modelo11Row/VALOR_U) + sum(Modelo11Row/VALOR_S) + sum(Modelo11Row/VALOR_R),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
	</fo:table-body>
 </fo:table>	
-->

</xsl:template>
<!-- FIM MODELO 11 -->


<!--
####################################
########     MODELO 13    ##########
####################################
-->
<xsl:template match="Modelo13">
<!-- INICIO MODELO 13 -->	
<!--******** VARIAVEIS *********-->
  <xsl:variable name="isCamara"> 
  	  <xsl:if test="../../Header/Informacoes/InformacoesRow/TIPO_SETOR_GOV='C'">S</xsl:if>
	  <xsl:if test="../../Header/Informacoes/InformacoesRow/TIPO_SETOR_GOV!='C'">N</xsl:if>
  </xsl:variable>

 <xsl:variable name="varRREA">
	<xsl:if test="$isCamara='S'">
		<xsl:value-of select="Camara/CamaraRow[DS_TIPO='RREA']/VALOR"/>
	</xsl:if>
	<xsl:if test="$isCamara='N'">
		<xsl:value-of select="Prefeitura/PrefeituraRow[DS_TIPO='RREA']/VALOR"/>
	</xsl:if>
 </xsl:variable>

 <!-- VARIAVEL DE PORCENTAGEM-->
 <xsl:variable name="porcHabit">
 	<xsl:if test="$isCamara='S'">
		<xsl:if test="Camara/CamaraRow/NRO_HABITANTES &lt; 100000">
                        <xsl:value-of select="7"></xsl:value-of>
		</xsl:if>
		<xsl:if test="Camara/CamaraRow/NRO_HABITANTES &gt; 100001 and Camara/CamaraRow/NRO_HABITANTES &lt; 300000">
			<xsl:value-of select="6"></xsl:value-of>
		</xsl:if>
		<xsl:if test="Camara/CamaraRow/NRO_HABITANTES &gt; 300001 and Camara/CamaraRow/NRO_HABITANTES &lt; 500000">
			<xsl:value-of select="5"></xsl:value-of>
		</xsl:if>
		<xsl:if test="Camara/CamaraRow/NRO_HABITANTES &gt; 500001 and Camara/CamaraRow/NRO_HABITANTES &lt; 3000000">
			<xsl:value-of select="4.5"></xsl:value-of>
		</xsl:if>
                <xsl:if test="Camara/CamaraRow/NRO_HABITANTES &gt; 3000001 and Camara/CamaraRow/NRO_HABITANTES &lt; 8000000">
			<xsl:value-of select="4"></xsl:value-of>
		</xsl:if>
                <xsl:if test="Camara/CamaraRow/NRO_HABITANTES &gt; 8000001">
                        <xsl:value-of select="3.5"></xsl:value-of>
		</xsl:if>
	</xsl:if>
 	<xsl:if test="$isCamara='N'">
		<xsl:if test="Prefeitura/PrefeituraRow/NRO_HABITANTES &lt; 100000">
			<xsl:value-of select="7"></xsl:value-of>
		</xsl:if>
		<xsl:if test="Prefeitura/PrefeituraRow/NRO_HABITANTES &gt; 100001 and Prefeitura/PrefeituraRow/NRO_HABITANTES &lt; 300000">
			<xsl:value-of select="6"></xsl:value-of>
		</xsl:if>
		<xsl:if test="Prefeitura/PrefeituraRow/NRO_HABITANTES &gt; 300001 and Prefeitura/PrefeituraRow/NRO_HABITANTES &lt; 500000">
			<xsl:value-of select="5"></xsl:value-of>
		</xsl:if>
		<xsl:if test="Prefeitura/PrefeituraRow/NRO_HABITANTES &gt; 500001 and Prefeitura/PrefeituraRow/NRO_HABITANTES &lt; 3000000">
			<xsl:value-of select="4.5"></xsl:value-of>
		</xsl:if>
                <xsl:if test="Prefeitura/PrefeituraRow/NRO_HABITANTES &gt; 3000001 and Prefeitura/PrefeituraRow/NRO_HABITANTES &lt; 8000000">
			<xsl:value-of select="4"></xsl:value-of>
		</xsl:if>
                <xsl:if test="Prefeitura/PrefeituraRow/NRO_HABITANTES &gt; 8000001">
                        <xsl:value-of select="3.5"></xsl:value-of>
		</xsl:if>             
	</xsl:if>
  </xsl:variable>
<!--******** VARIAVEIS *********-->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="400pt"/>
  <fo:table-column column-number="2" column-width="156pt"/>
   
  <fo:table-body>
   <fo:table-row>
	<fo:table-cell number-columns-spanned="2">
          <fo:block xsl:use-attribute-sets="titFCinza">
	  <xsl:text>MODELO 13 - DEMONSTRATIVO DOS GASTOS TOTAIS </xsl:text>
	 </fo:block>
       </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
 	<fo:table-cell>
      <fo:block xsl:use-attribute-sets="txtLeft">
	  	<xsl:text>art. 29 - A da Constitui&#231;&#227;o Federal e  inciso VI do art. 59 da Lei de Responsabilidade Fiscal </xsl:text>
	  </fo:block>
    </fo:table-cell>
	<fo:table-cell padding="2pt"  border-width="0.5pt">
		<fo:block font-weight="bold" text-align="right" font-size="6.0pt">Valores expressos em reais </fo:block>
	</fo:table-cell>
  </fo:table-row>
 </fo:table-body>
 </fo:table>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="270pt"/>
  <fo:table-column column-number="2" column-width="90pt"/>
  <fo:table-column column-number="3" column-width="106pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="2">
     <fo:block font-weight="bold" text-align="left">I - Receita Efetivamente Realizada no Exerc&#237;cio Anterior </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Atualizado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <fo:table-body>
 <xsl:if test="$isCamara='S'">
  <xsl:for-each select="Camara/CamaraRow[DS_TIPO='RREA']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">RREA </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:if>

 <xsl:if test="$isCamara='N'">
  <xsl:for-each select="Prefeitura/PrefeituraRow[DS_TIPO='RREA']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtLeft">RREA </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:if>
  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="270pt"/>
  <fo:table-column column-number="2" column-width="90pt"/>
  <fo:table-column column-number="3" column-width="106pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="2">
     <fo:block font-weight="bold" text-align="left">II - GASTOS TOTAIS DO LEGISLATIVO MUNICIPAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <fo:table-body>
 <xsl:if test="$isCamara='S'">
  <xsl:for-each select="Camara/CamaraRow[DS_TIPO='GT']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Gastos Totais </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
		<xsl:if test="$varRREA=0.00 or $varRREA='0,00'">
			<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> % S/RREA 
		</xsl:if>
	 	<xsl:if test="$varRREA!=0.00 and $varRREA!='0,00'">
		 <xsl:value-of select="format-number((VALOR div $varRREA)*100, '###.###.##0,00')"/> % S/RREA 
		</xsl:if>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  <xsl:for-each select="Camara/CamaraRow[DS_TIPO='GT']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" margin-bottom="0.1pt" font-weight="bold">Limite Legal de Gastos Totais - 3,5% a 7% S/RREA </fo:block>
	 <fo:block font-size="6.0pt" font-style="italic">Incisos I a VI do art. 29-A da Constitui&#231;&#227;o Federal </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number($porcHabit, '###.###.##0,00')"/>  % S/RREA </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(($porcHabit div 100)*$varRREA, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:if>

 <xsl:if test="$isCamara='N'">
  <xsl:for-each select="Prefeitura/PrefeituraRow[DS_TIPO='GT']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Gastos Totais </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
		<xsl:if test="$varRREA=0.00 or $varRREA='0,00'">
			<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> % S/RREA 
		</xsl:if>
	 	<xsl:if test="$varRREA!=0.00 and $varRREA!='0,00'">
		 <xsl:value-of select="format-number((VALOR div $varRREA)*100, '###.###.##0,00')"/> % S/RREA 
		</xsl:if>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  <xsl:for-each select="Prefeitura/PrefeituraRow[DS_TIPO='GT']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" margin-bottom="0.1pt" font-weight="bold">Limite Legal de Gastos Totais - 3,5% a 7% S/RREA </fo:block>
	 <fo:block font-size="6.0pt" font-style="italic">Incisos I a VI do art. 29-A da Constitui&#231;&#227;o Federal </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number($porcHabit, '###.###.##0,00')"/>  % S/RREA </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(($porcHabit div 100)*$varRREA, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:if>

  </fo:table-body>
 </fo:table>

 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="270pt"/>
  <fo:table-column column-number="2" column-width="90pt"/>
  <fo:table-column column-number="3" column-width="106pt"/>

  <fo:table-header xsl:use-attribute-sets="cabecalho">
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt" number-columns-spanned="2">
     <fo:block font-weight="bold" text-align="left">III - FOLHA DE PAGAMENTO DO LEGISLATIVO MUNICIPAL </fo:block>
    </fo:table-cell>
    <fo:table-cell padding="2pt" xsl:use-attribute-sets="bordas" border-width="0.5pt">
     <fo:block font-weight="bold" text-align="right">Valor Ajustado </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-header>

  <fo:table-body>

 <xsl:if test="$isCamara='S'">
  <xsl:for-each select="Camara/CamaraRow[DS_TIPO='FP']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Gastos  com Folha de Pagamento </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
		<xsl:if test="$varRREA=0.00 or $varRREA='0,00'">
			<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> % S/GT 
		</xsl:if>
	 	<xsl:if test="$varRREA!=0.00 and $varRREA!='0,00'">	 
	 		<xsl:value-of select="format-number((VALOR*100) div (($porcHabit div 100)*$varRREA), '###.###.##0,00')"/> % S/GT 
		</xsl:if>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  <xsl:for-each select="Camara/CamaraRow[DS_TIPO='FP']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" margin-bottom="0.1pt" font-weight="bold">Limite Legal - at&#233; 70,00% sobre o Limite Legal de Gastos Totais</fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(70.00, '###.###.##0,00')"/>  % S/GT </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number((($porcHabit div 100)*$varRREA)*0.7, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:if>
  
 <xsl:if test="$isCamara='N'">
  <xsl:for-each select="Prefeitura/PrefeituraRow[DS_TIPO='FP']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft">Gastos  com Folha de Pagamento </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
		<xsl:if test="$varRREA=0.00 or $varRREA='0,00'">
			<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> % S/GT 
		</xsl:if>
	 	<xsl:if test="$varRREA!=0.00 and $varRREA!='0,00'">	 
	 		<xsl:value-of select="format-number((VALOR*100) div (($porcHabit div 100)*$varRREA), '###.###.##0,00')"/> % S/GT 
		</xsl:if>
	 </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number(VALOR, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>

  <xsl:for-each select="Prefeitura/PrefeituraRow[DS_TIPO='FP']">
   <fo:table-row>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtLeft" margin-bottom="0.1pt" font-weight="bold">Limite Legal - at&#233; 70,00% sobre o Limite Legal de Gastos Totais</fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" padding-left="1pt">
     <fo:block xsl:use-attribute-sets="txtRight"><xsl:value-of select="format-number(70.00, '###.###.##0,00')"/>  % S/GT </fo:block>
    </fo:table-cell>
	<fo:table-cell xsl:use-attribute-sets="bordas" border-width="0.5pt" >
     <fo:block xsl:use-attribute-sets="txtRight">
	   <xsl:value-of select="format-number((($porcHabit div 100)*$varRREA)*0.7, '###.###.##0,00')"/>
	 </fo:block>
    </fo:table-cell>
   </fo:table-row>
  </xsl:for-each>
 </xsl:if>

  </fo:table-body>
 </fo:table>
</xsl:template>
<!-- FIM MODELO 13 -->

</xsl:stylesheet>