/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import java.util.ArrayList;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.GDKMessage;

public abstract class CharacterConverterMSOLISO2022JPBase
extends CharacterConverter12Byte {
    protected static int MAXLIMIT = 65536;
    static final int BUCKETSIZE = 200;
    static final byte REPLACEMENT_CHAR_IN_BYTE = 63;
    static final byte[] REPLACEMENT_CHAR_IN_BYTES = new byte[]{63};
    static final int ASCII_JISROMAN = 0;
    static final int JISX0208 = 1;
    static final int JISX0212 = 2;
    static final int HALF_WIDTH_KATAKANA = 3;
    static final byte[] JISROMAN_ESCSEQ = new byte[]{27, 40, 66};
    static final byte[] JISX0208_ESCSEQ = new byte[]{27, 36, 66};
    static final byte[] JISX0212_ESCSEQ = new byte[]{27, 36, 40, 68};
    static final byte[] HALF_WIDTH_KATAKANA_ESCSEQ = new byte[]{27, 40, 73};
    static final int FULLWIDTH_MODE = 1;
    static final int HALFWIDTH_MODE = 2;
    public int[] m_oraCharExtraLevel1 = null;
    public char[] m_oraCharExtraLevel2 = null;

    public CharacterConverterMSOLISO2022JPBase() {
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 10.0f;
    }

    int toUnicode(int n) throws SQLException {
        return n;
    }

    int toUnicodeWithReplacement(int n) {
        if (n >= 0 && n <= 127) {
            return n;
        }
        int n2 = n >> 8 & 0xFF;
        int n3 = n & 0xFF;
        int n4 = this.m_ucsCharLevel1[n2] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n2] + n3] : this.m_ucsCharReplacement;
        return n4;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            return this.toUnicodeStringMain(byArray, n, n2, CharacterConverterBehavior.REPORT_ERROR);
        }
        catch (Exception exception) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            return this.toUnicodeStringMain(byArray, n, n2, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            return new String("");
        }
    }

    private String toUnicodeStringMain(byte[] byArray, int n, int n2, CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        int n3 = n;
        int n4 = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = new String("");
        n4 = this.getNextEscpSeq(byArray, n3);
        if (n4 == -1) {
            string = string + this.toUnicodeChars(byArray, 0, byArray.length - 1, 0, characterConverterBehavior);
            bl5 = true;
        } else if (n4 != 0) {
            string = string + this.toUnicodeChars(byArray, 0, n4 - 1, 0, characterConverterBehavior);
        }
        while (!bl5) {
            int n5;
            n3 = n4;
            if ((n4 = this.getNextEscpSeq(byArray, n4 + 1)) == -1) {
                n4 = byArray.length;
                bl5 = true;
            }
            if ((n5 = this.checkEscpSeq(byArray, n3)) == 0 || n5 == 1 || n5 == 3) {
                if (n3 + 3 == n4) continue;
                string = string + this.toUnicodeChars(byArray, n3 + 3, n4 - 1, n5, characterConverterBehavior);
                continue;
            }
            if (n5 == 2) {
                if (n3 + 4 == n4) continue;
                string = string + this.toUnicodeChars(byArray, n3 + 4, n4 - 1, n5, characterConverterBehavior);
                continue;
            }
            characterConverterBehavior.onFailConversion(n3);
        }
        return string;
    }

    private String toUnicodeChars(byte[] byArray, int n, int n2, int n3, CharacterConverterBehavior characterConverterBehavior) throws SQLException {
        String string;
        block5: {
            block4: {
                string = new String("");
                if (n2 < n) {
                    throw new SQLException();
                }
                if (n3 == 0) {
                    return new String(byArray, n, n2 - n + 1);
                }
                if (n3 != 1 && n3 != 2) break block4;
                for (int i = n; i < n2; i += 2) {
                    byte by = byArray[i];
                    byte by2 = byArray[i + 1];
                    int n4 = this.m_ucsCharLevel1[by] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[by] + by2] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[by] + by2] : this.m_ucsCharReplacement;
                    string = string + new String(new char[]{(char)n4});
                }
                break block5;
            }
            if (n3 != 3) break block5;
            for (int i = n; i <= n2; ++i) {
                int n5 = 0;
                byte by = byArray[i];
                int n6 = this.m_ucsCharLevel1[n5] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + by] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n5] + by] : this.m_ucsCharReplacement;
                string = string + new String(new char[]{(char)n6});
            }
        }
        return string;
    }

    public byte[] toOracleString(String string) throws SQLException {
        return this.toISO2022JPStringMain(string, CharacterConverterBehavior.REPORT_ERROR);
    }

    public byte[] toOracleStringWithReplacement(String string) {
        try {
            return this.toISO2022JPStringMain(string, CharacterConverterBehavior.REPLACEMENT);
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public abstract byte[] toISO2022JPStringMain(String var1, CharacterConverterBehavior var2) throws SQLException;

    public byte[] toISO2022JPStringFWHW(String string, CharacterConverterBehavior characterConverterBehavior, int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        char[] cArray = new char[n5];
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(0);
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        byte[] byArray = new byte[200];
        arrayList.add(byArray);
        if (n5 == 0) {
            return new byte[0];
        }
        string.getChars(0, n5, cArray, 0);
        for (int i = 0; i < n5; ++i) {
            if (cArray[i] >= '\u0000' && cArray[i] <= '\u007f') {
                if (n6 != 0) {
                    n6 = 0;
                    n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                    n7 += 3;
                }
                n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{(byte)cArray[i]});
                ++n7;
                continue;
            }
            if (cArray[i] >= '\u00a1' && cArray[i] <= '\u00ff') {
                n4 = cArray[i] >> 8 & 0xFF;
                n3 = cArray[i] & 0xFF;
                if (this.m_oraCharExtraLevel1[n4] == -1 || this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n4] + n3] == '\uffff') continue;
                n2 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n4] + n3];
                if ((char)(n2 & 0xFF) == n2) {
                    if (n6 != 0) {
                        n6 = 0;
                        n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                        n7 += 3;
                    }
                    n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{(byte)(n2 & 0xFF)});
                    ++n7;
                    continue;
                }
                if (n6 != 1) {
                    n6 = 1;
                    n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                    n7 += 3;
                }
                n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)});
                n7 += 2;
                continue;
            }
            n4 = cArray[i] >> 8 & 0xFF;
            n3 = cArray[i] & 0xFF;
            if (this.m_oraCharExtraLevel1[n4] != -1 && this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n4] + n3] != '\uffff') {
                if (n == 1) {
                    if (n6 != 1) {
                        n6 = 1;
                        n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                        n7 += 3;
                    }
                    n2 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n4] + n3];
                    n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)});
                    n7 += 2;
                    continue;
                }
                if (n6 != 3) {
                    n6 = 3;
                    n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                    n7 += 3;
                }
                n2 = this.m_oraCharExtraLevel2[this.m_oraCharExtraLevel1[n4] + n3];
                n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{(byte)(n2 & 0xFF)});
                ++n7;
                continue;
            }
            if (this.m_oraCharLevel1[n4] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n4] + n3] != '\uffff') {
                if (n6 != 1) {
                    n6 = 1;
                    n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                    n7 += 3;
                }
                n2 = this.m_oraCharLevel2[this.m_oraCharLevel1[n4] + n3];
                n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)});
                n7 += 2;
                continue;
            }
            if (characterConverterBehavior == CharacterConverterBehavior.REPLACEMENT) {
                if (n6 != 0) {
                    n6 = 0;
                    n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, n6);
                    n7 += 3;
                }
                n2 = this.m_1ByteOraCharReplacement;
                n8 = CharacterConverterMSOLISO2022JPBase.insertToBucket(n8, arrayList, new byte[]{63});
                ++n7;
                continue;
            }
            throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
        }
        if (n6 != 0) {
            n8 = CharacterConverterMSOLISO2022JPBase.insertEscSeq(n8, arrayList, 0);
            n7 += 3;
        }
        byte[] byArray2 = new byte[n7];
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            int n9 = (n7 - n3) / 200 > 0 ? 200 : n7 % 200;
            n4 = 0;
            while (n4 < n9) {
                byArray2[n3] = ((byte[])arrayList.get(n2))[n4];
                ++n4;
                ++n3;
            }
        }
        return byArray2;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharExtraLevel1 = new int[256];
        char[] cArray = new char[MAXLIMIT];
        int n4 = 0;
        int[][] nArray = new int[MAXLIMIT][2];
        int n5 = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            this.m_oraCharLevel1[n3] = -1;
        }
        for (n3 = 0; n3 < MAXLIMIT; ++n3) {
            cArray[n3] = 65535;
        }
        for (n3 = 0; n3 < 65535; ++n3) {
            int n6 = this.toUnicodeWithReplacement(n3);
            if (n6 == this.m_ucsCharReplacement) continue;
            nArray[n5][0] = n6;
            nArray[n5][1] = n3;
            ++n5;
        }
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3][0] >>> 8 & 0xFF;
            n = nArray[n3][0] & 0xFF;
            if (this.m_oraCharLevel1[n2] == -1) {
                this.m_oraCharLevel1[n2] = n4;
                n4 += 256;
            }
            if (cArray[this.m_oraCharLevel1[n2] + n] != '\uffff') continue;
            cArray[this.m_oraCharLevel1[n2] + n] = (char)(nArray[n3][1] & 0xFFFF);
        }
        this.m_oraCharLevel2 = new char[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.m_oraCharLevel2[n3] = cArray[n3];
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n4 = 0;
            for (n3 = 0; n3 < 256; ++n3) {
                this.m_oraCharExtraLevel1[n3] = -1;
            }
            for (n3 = 0; n3 < MAXLIMIT; ++n3) {
                cArray[n3] = 65535;
            }
            int n7 = this.extraUnicodeToOracleMapping.length;
            for (n3 = 0; n3 < n7; ++n3) {
                int n8 = this.extraUnicodeToOracleMapping[n3][0];
                int n9 = this.extraUnicodeToOracleMapping[n3][1];
                n2 = n8 >>> 8 & 0xFF;
                n = n8 & 0xFF;
                if (this.m_oraCharExtraLevel1[n2] == -1) {
                    this.m_oraCharExtraLevel1[n2] = n4;
                    n4 += 256;
                }
                if (cArray[this.m_oraCharExtraLevel1[n2] + n] != '\uffff') continue;
                cArray[this.m_oraCharExtraLevel1[n2] + n] = (char)n9;
            }
            this.m_oraCharExtraLevel2 = new char[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.m_oraCharExtraLevel2[n3] = cArray[n3];
            }
        }
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    private static int insertToBucket(int n, ArrayList arrayList, byte[] byArray) {
        if (n + byArray.length - 1 >= 200) {
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n >= 200) {
                    byte[] byArray2 = new byte[200];
                    arrayList.add(byArray2);
                    n = 0;
                }
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n] = byArray[n2];
                ++n2;
                ++n;
            }
        } else {
            int n3 = 0;
            while (n3 < byArray.length) {
                ((byte[])arrayList.get((int)(arrayList.size() - 1)))[n] = byArray[n3];
                ++n3;
                ++n;
            }
        }
        return n;
    }

    private int checkEscpSeq(byte[] byArray, int n) throws SQLException {
        if (n + 2 >= byArray.length) {
            return -1;
        }
        if (byArray[n + 1] == 40) {
            if (byArray[n + 2] == 66 || byArray[n + 2] == 74) {
                return 0;
            }
            if (byArray[n + 2] == 73) {
                return 3;
            }
        } else if (byArray[n + 1] == 36) {
            if (byArray[n + 2] == 64 || byArray[n + 2] == 66) {
                return 1;
            }
            if (byArray[n + 2] == 40 && byArray[n + 3] == 68) {
                return 2;
            }
        }
        return -1;
    }

    private static int insertEscSeq(int n, ArrayList arrayList, int n2) {
        byte[] byArray = null;
        if (n2 == 0) {
            byArray = JISROMAN_ESCSEQ;
        } else if (n2 == 1) {
            byArray = JISX0208_ESCSEQ;
        } else if (n2 == 2) {
            byArray = JISX0212_ESCSEQ;
        } else if (n2 == 3) {
            byArray = HALF_WIDTH_KATAKANA_ESCSEQ;
        }
        return CharacterConverterMSOLISO2022JPBase.insertToBucket(n, arrayList, byArray);
    }

    private int getNextEscpSeq(byte[] byArray, int n) {
        while (n < byArray.length) {
            if (byArray[n] == 27) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static abstract class CharacterConverterBehavior {
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior(){

            public void onFailConversion(int n) throws SQLException {
                throw new SQLException();
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior(){

            public void onFailConversion(int n) throws SQLException {
            }
        };

        public abstract void onFailConversion(int var1) throws SQLException;
    }
}

