/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull = false;
    protected boolean isBufferEmpty = false;
    protected int availableBytesToSend = 0;
    protected int availableBytesToRead = 0;

    public DataPacket(Packet packet) {
        super(packet);
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = this.length - this.dataOff;
        this.dataFlags = this.buffer[8] & 0xFF;
        this.dataFlags <<= 8;
        this.dataFlags |= this.buffer[9] & 0xFF;
        if ((this.dataFlags & 0x40) != 0) {
            this.sAtts.dataEOF = true;
        }
    }

    public DataPacket(SessionAtts sessionAtts) {
        this(sessionAtts, sessionAtts.getSDU());
    }

    public DataPacket(SessionAtts sessionAtts, int n) {
        super(sessionAtts);
        this.initialize(n);
    }

    protected int getDataFromBuffer(byte[] byArray, int n, int n2) throws NetException {
        int n3;
        int n4 = n3 = this.length - this.pktOffset <= n2 ? this.length - this.pktOffset : n2;
        if (n3 > 0) {
            System.arraycopy(this.buffer, this.pktOffset, byArray, n, n3);
            this.pktOffset += n3;
            this.isBufferEmpty = this.pktOffset == this.buffer.length;
            this.availableBytesToRead = this.dataOff + this.dataLen - this.pktOffset;
        }
        return n3;
    }

    protected void initialize(int n) {
        this.pktOffset = 10;
        this.dataOff = 10;
        this.dataLen = n - this.dataOff;
        this.dataFlags = 0;
        this.createBuffer(n, 6, 0);
    }

    protected int putDataInBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n3 = this.buffer.length - this.pktOffset <= n2 ? this.buffer.length - this.pktOffset : n2;
        if (n3 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.pktOffset, n3);
            this.pktOffset += n3;
            this.isBufferFull = this.pktOffset == this.buffer.length;
            this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
        }
        return n3;
    }

    protected void send() throws IOException {
        this.send(0);
    }

    protected void send(int n) throws IOException {
        this.buffer[8] = (byte)(n / 256);
        this.buffer[9] = (byte)(n % 256);
        this.setBufferLength(this.pktOffset);
        this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
        this.pktOffset = 10;
        this.availableBytesToSend = 0;
        this.isBufferFull = false;
    }

    protected void setBufferLength(int n) throws NetException {
        this.buffer[0] = (byte)(n / 256);
        this.buffer[1] = (byte)(n % 256);
    }
}

