/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMFAIL = 0x20000000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    protected Connection m_conn = null;
    protected int m_timeout = 60;
    protected String m_dblink = null;
    private Connection l_conn = null;
    private String m_rcvr_sql_cnt = "SELECT count (*) FROM SYS.DBA_PENDING_TRANSACTIONS";
    private String m_rcvr_sql_rows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected Xid m_stackedXid = null;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    protected void checkError(int n) throws OracleXAException {
        if ((n & 0xFFFF) != 0) {
            throw new OracleXAException(n);
        }
    }

    public abstract void commit(Xid var1, boolean var2) throws XAException;

    public abstract void end(Xid var1, int var2) throws XAException;

    public abstract void forget(Xid var1) throws XAException;

    public Connection getConnection() {
        return this.m_conn;
    }

    public String getDBLink() {
        return this.m_dblink;
    }

    protected boolean getSQLXAErrorFlag() {
        if (this.l_conn != null) {
            return ((OracleConnection)this.l_conn).getXAErrorFlag();
        }
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        String string = ((OracleConnection)this.m_conn).getURL();
        String string2 = ((OracleConnection)this.m_conn).getProtocolType();
        if (connection != null) {
            return connection.equals(this.m_conn) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
        }
        return false;
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void join(Xid xid, int n) throws XAException {
        this.m_timeout = n;
        this.start(xid, 0x200000);
    }

    protected void pop() {
        this.trace("pop: clearing stacked xid " + this.m_stackedXid);
        this.m_stackedXid = null;
    }

    public abstract int prepare(Xid var1) throws XAException;

    protected void push(Xid xid) {
        this.trace("push: stacking xid " + xid);
        this.m_stackedXid = xid;
    }

    public Xid[] recover(int n) throws XAException {
        int n2 = 0;
        Xid[] xidArray = null;
        if (n != 0 && (n & 0x1000000) != 0x1000000 && (n & 0x800000) != 0x800000) {
            this.trace("OracleXAResource.recover(): XAER_INVAL; invalid flag");
            throw new XAException(-5);
        }
        try {
            Statement statement = this.m_conn.createStatement();
            ResultSet resultSet = statement.executeQuery(this.m_rcvr_sql_cnt);
            resultSet.next();
            n2 = resultSet.getInt(1);
            resultSet.close();
            this.trace("No of Rows in Recover table are " + n2);
            xidArray = new Xid[n2];
            if (n2 == 0) {
                return xidArray;
            }
            int n3 = 0;
            byte[] byArray = null;
            byte[] byArray2 = null;
            int n4 = 0;
            resultSet = statement.executeQuery(this.m_rcvr_sql_rows);
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
                byArray = resultSet.getBytes(2);
                byArray2 = resultSet.getBytes(3);
                xidArray[n4] = new OracleXid(n3, byArray, byArray2);
                ++n4;
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(-3);
        }
        return xidArray;
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void resume(Xid xid, int n) throws XAException {
        this.m_timeout = n;
        this.start(xid, 0x8000000);
    }

    protected void resumeStacked(Xid xid) throws XAException {
        this.trace("resumeStacked: entry with xid " + xid);
        if (xid != null) {
            this.trace("resumeStacked: resuming xid " + xid);
            this.start(xid, 0x8000000);
        }
    }

    public abstract void rollback(Xid var1) throws XAException;

    public synchronized void setConnection(Connection connection) throws XAException {
        this.m_conn = connection;
        if (this.m_conn == null) {
            throw new XAException(-7);
        }
    }

    public void setDBLink(String string) {
        this.m_dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.l_conn = connection;
    }

    protected void setSQLXAErrorFlag(boolean bl) {
        if (this.l_conn != null) {
            ((OracleConnection)this.l_conn).setXAErrorFlag(bl);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.m_timeout = n;
        return true;
    }

    public abstract void start(Xid var1, int var2) throws XAException;

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        this.trace("suspendStacked: entry with xid " + xid);
        if (this.m_stackedXid != null && this.m_stackedXid != xid) {
            xid2 = this.m_stackedXid;
            this.trace("suspendStacked: suspending stacked xid " + xid2);
            this.end(xid2, 0x2000000);
        }
        return xid2;
    }

    protected Xid suspendStacked(Xid xid, int n) throws XAException {
        Xid xid2 = null;
        this.trace("suspendStacked: entry with xid " + xid + ", flags " + Integer.toHexString(n));
        if (n == 0x4000000 && this.m_stackedXid != null && xid != this.m_stackedXid) {
            xid2 = this.m_stackedXid;
            this.trace("suspendStacked: suspending stacked xid " + xid2);
            this.end(xid2, 0x2000000);
            this.trace("suspendStacked: resuming xid " + xid);
            this.start(xid, 0x8000000);
        }
        return xid2;
    }

    protected void trace(String string) {
    }
}

