/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.io.IOException;
import oracle.xml.differ.XSLDiffGenerator;

class InsertedNode {
    short m_nodetype = (short)-1;
    short m_optype = (short)-1;
    short m_pathtype = (short)-1;
    String m_xpath;
    String m_text;
    String m_nsattr;
    InsertedNode m_prev = null;
    InsertedNode m_next = null;
    InsertedNode m_startnode = null;
    int m_attr_parentnode = 0;
    short m_reftype = (short)-1;
    int m_attrCount = 0;
    int m_level = -1;
    boolean m_copynode_set = false;
    XSLDiffGenerator m_diffgen = null;
    int m_count = 0;
    boolean m_indent_param_set = false;
    InsertedNode template = null;

    InsertedNode(XSLDiffGenerator xSLDiffGenerator) {
        this.m_diffgen = xSLDiffGenerator;
    }

    InsertedNode(short s, short s2, short s3, String string, String string2, String string3, int n) {
        this.m_nodetype = s;
        this.m_optype = s2;
        this.m_pathtype = s3;
        this.m_xpath = string;
        this.m_text = string2;
        this.m_nsattr = string3;
        this.m_level = n;
    }

    InsertedNode(String string) {
        this.m_text = string;
    }

    void setNode(InsertedNode insertedNode) {
        if (this.m_startnode == null) {
            this.m_startnode = insertedNode;
            insertedNode.setPrev(insertedNode);
            insertedNode.setNext(null);
        } else {
            InsertedNode insertedNode2 = this.m_startnode.getPrev();
            insertedNode2.setNext(insertedNode);
            insertedNode.setNext(null);
            this.m_startnode.setPrev(insertedNode);
        }
        ++this.m_count;
    }

    void setNodeBeforeLastNode(InsertedNode insertedNode) {
        if (this.m_startnode == null) {
            return;
        }
        InsertedNode insertedNode2 = this.m_startnode.getPrev();
        if (this.m_count == 1) {
            this.m_startnode = insertedNode;
        }
        insertedNode.setPrev(insertedNode2.getPrev());
        insertedNode.setNext(insertedNode2);
        insertedNode2.setPrev(insertedNode);
        ++this.m_count;
    }

    void setNodeAfterNode(InsertedNode insertedNode, InsertedNode insertedNode2) {
        if (this.m_startnode == null) {
            return;
        }
        insertedNode.getNext().setPrev(insertedNode2);
        insertedNode2.setNext(insertedNode.getNext());
        insertedNode.setNext(insertedNode2);
        insertedNode2.setPrev(insertedNode);
        ++this.m_count;
    }

    private boolean isInElement(InsertedNode insertedNode) {
        return insertedNode.getNodeType() == 2 || insertedNode.getPathType() == 3;
    }

    private boolean isRefType(InsertedNode insertedNode) {
        return insertedNode.getOpType() == 1 || insertedNode.getOpType() == 4;
    }

    void saveNode(InsertedNode insertedNode) {
        if (this.m_startnode == null) {
            this.template = new InsertedNode("<xsl:template match=\"" + insertedNode.getXPath() + "\">");
            this.template.setXPath(insertedNode.getXPath());
            this.setNode(this.template);
            this.m_level = insertedNode.getLevel();
            if (this.isInElement(insertedNode)) {
                --this.m_level;
                if (insertedNode.getNSAttr() == null) {
                    this.setNode(new InsertedNode("<xsl:element name = \"{name()}\">"));
                } else {
                    this.setNode(new InsertedNode("<xsl:element name = \"{name()}\" namespace=\"" + insertedNode.getNSAttr() + "\">"));
                }
                ++this.m_attr_parentnode;
                if (insertedNode.getNodeType() == 2) {
                    ++this.m_attrCount;
                } else {
                    this.setNode(new InsertedNode(this.m_diffgen.getApplyAttr()));
                }
                this.m_reftype = insertedNode.getOpType();
            } else if (this.isRefType(insertedNode)) {
                this.m_reftype = insertedNode.getOpType();
            } else if (insertedNode.getPathType() == 1) {
                this.setNode(new InsertedNode(this.m_diffgen.getCopyNodesAttr()));
            }
            if (this.m_reftype != 1) {
                this.setNode(insertedNode);
            }
        } else {
            if (!this.m_copynode_set && this.m_reftype == 0 && insertedNode.getPathType() == 1) {
                if (insertedNode.getNodeType() == 2) {
                    this.setNode(new InsertedNode(this.m_diffgen.getApply()));
                } else if (this.getLast().getNodeType() == 2) {
                    this.setNode(new InsertedNode(this.m_diffgen.getApply() + "</xsl:element>"));
                } else {
                    this.setNode(new InsertedNode(this.m_diffgen.getCopyNodesAttr()));
                }
                this.m_copynode_set = true;
            }
            if (this.isInElement(insertedNode)) {
                this.m_reftype = insertedNode.getNodeType();
                if (this.m_attr_parentnode == 0) {
                    if (insertedNode.getNSAttr() == null) {
                        this.setNode(new InsertedNode("<xsl:element name = \"{name()}\">"));
                    } else {
                        this.setNode(new InsertedNode("<xsl:element name = \"{name()}\" namespace=\"" + insertedNode.getNSAttr() + "\">"));
                    }
                    if (this.m_reftype != 2) {
                        this.setNode(new InsertedNode(this.m_diffgen.getApplyAttr()));
                    }
                }
                ++this.m_attr_parentnode;
                if (this.m_reftype == 2) {
                    ++this.m_attrCount;
                }
            } else if (this.isRefType(insertedNode)) {
                this.m_reftype = insertedNode.getOpType();
            } else if (this.isInElement(this.getLast())) {
                this.setNode(new InsertedNode("</xsl:element>"));
            }
            this.setNode(insertedNode);
        }
        if (!this.m_indent_param_set && this.m_diffgen.getIndentIncr() > 0 && insertedNode.m_optype != 1) {
            this.setNodeAfterNode(this.template, new InsertedNode("<xsl:param name=\"indent\" select=\"'&#xA;'\"/>"));
            this.m_indent_param_set = true;
        }
    }

    void putDeletedNode(InsertedNode insertedNode, boolean bl) {
        this.saveNode(insertedNode);
        if (bl) {
            String string = insertedNode.getXPath();
            int n = string.lastIndexOf("/");
            String string2 = string.substring(0, n);
            InsertedNode insertedNode2 = new InsertedNode("<xsl:template match=\"" + string2 + "/text()[generate-id(.)=generate-id(" + string + "/preceding-sibling::node()[1])][normalize-space()='']\"/>");
            this.setNodeBeforeLastNode(insertedNode2);
        }
    }

    void writeBatchInserts() throws IOException {
        InsertedNode insertedNode;
        if (this.m_startnode == null) {
            return;
        }
        InsertedNode insertedNode2 = insertedNode = this.m_startnode;
        while (insertedNode != null) {
            this.m_diffgen.lineWrite(insertedNode.getText());
            insertedNode2 = insertedNode;
            insertedNode = insertedNode.getNext();
        }
        if (this.isInElement(insertedNode2)) {
            if (insertedNode2.getNodeType() == 2) {
                this.m_diffgen.lineWrite(this.m_diffgen.getApply());
            }
            this.m_diffgen.lineWrite("</xsl:element>");
        } else if (insertedNode2.getPathType() == 2) {
            this.m_diffgen.lineWrite(this.m_diffgen.getCopyNodesAttr());
        }
        this.m_diffgen.lineWrite("</xsl:template>");
        this.m_diffgen.flush();
        this.m_startnode = null;
        this.m_attr_parentnode = 0;
        this.m_reftype = (short)-1;
        this.m_attrCount = 0;
        this.m_level = -1;
        this.m_copynode_set = false;
        this.m_count = 0;
        this.m_indent_param_set = false;
    }

    void setNodeType(short s) {
        this.m_nodetype = s;
    }

    short getNodeType() {
        return this.m_nodetype;
    }

    void setOpType(short s) {
        this.m_optype = s;
    }

    short getOpType() {
        return this.m_optype;
    }

    void setPathType(short s) {
        this.m_pathtype = s;
    }

    short getPathType() {
        return this.m_pathtype;
    }

    void setXPath(String string) {
        this.m_xpath = string;
    }

    String getXPath() {
        return this.m_xpath;
    }

    void setText(String string) {
        this.m_text = string;
    }

    String getText() {
        return this.m_text;
    }

    void setPrev(InsertedNode insertedNode) {
        this.m_prev = insertedNode;
    }

    InsertedNode getPrev() {
        return this.m_prev;
    }

    void setNext(InsertedNode insertedNode) {
        this.m_next = insertedNode;
    }

    InsertedNode getNext() {
        return this.m_next;
    }

    InsertedNode getStart() {
        return this.m_startnode;
    }

    short getRefType() {
        return this.m_reftype;
    }

    void setRefType(short s) {
        this.m_reftype = s;
    }

    int getAttrCount() {
        return this.m_attrCount;
    }

    InsertedNode getLast() {
        return this.m_startnode.getPrev();
    }

    String getFirstXPath() {
        if (this.m_startnode == null) {
            return null;
        }
        return this.m_startnode.getXPath();
    }

    int getLevel() {
        return this.m_level;
    }

    void setLevel(int n) {
        this.m_level = n;
    }

    String getNSAttr() {
        return this.m_nsattr;
    }
}

