/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DomHash {
    protected static String m_property_hash = "DOMHash";
    protected static String m_digest_algo = "MD5";
    protected MessageDigest md;

    public DomHash() {
        try {
            this.md = MessageDigest.getInstance(m_digest_algo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] getDOMHash(Node node) {
        byte[] byArray = null;
        if (((XMLNode)node).getProperty(m_property_hash) != null) {
            byArray = (byte[])((XMLNode)node).getProperty(m_property_hash);
            return byArray;
        }
        switch (node.getNodeType()) {
            case 3: {
                byArray = this.getDigestTextNode((XMLText)node);
                break;
            }
            case 8: {
                byArray = this.getDigestCommentNode((XMLComment)node);
                break;
            }
            case 7: {
                byArray = this.getDigestPINode((XMLPI)node);
                break;
            }
            case 2: {
                byArray = this.getDigestAttributeNode((XMLAttr)node);
                break;
            }
            case 1: {
                byArray = this.getDigestElementNode((XMLElement)node);
                break;
            }
            case 10: {
                byte[] byArray2 = new byte[]{-1};
                byArray = byArray2;
                break;
            }
            default: {
                System.out.println("No digest value for " + node.getNodeType() + " type of node.");
            }
        }
        if (byArray != null) {
            ((XMLNode)node).setProperty(m_property_hash, (Object)byArray);
        }
        return byArray;
    }

    public byte[] getDigestTextNode(XMLText xMLText) {
        try {
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)3);
            this.md.update(xMLText.getData().getBytes("UnicodeBigUnmarked"));
            return this.md.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getDigestCommentNode(XMLComment xMLComment) {
        try {
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)8);
            this.md.update(xMLComment.getData().getBytes("UnicodeBigUnmarked"));
            return this.md.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getDigestPINode(XMLPI xMLPI) {
        try {
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)7);
            this.md.update(xMLPI.getTarget().getBytes("UnicodeBigUnmarked"));
            this.md.update(xMLPI.getData().getBytes("UnicodeBigUnmarked"));
            return this.md.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getDigestAttributeNode(XMLAttr xMLAttr) {
        try {
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update((byte)2);
            this.md.update(xMLAttr.getName().getBytes("UnicodeBigUnmarked"));
            this.md.update((byte)0);
            this.md.update((byte)0);
            this.md.update(xMLAttr.getValue().getBytes("UnicodeBigUnmarked"));
            return this.md.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getDigestElementNode(XMLElement xMLElement) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(1);
            dataOutputStream.write(xMLElement.getTagName().getBytes("UnicodeBigUnmarked"));
            dataOutputStream.write(0);
            dataOutputStream.write(0);
            NamedNodeMap namedNodeMap = xMLElement.getAttributes();
            int n = namedNodeMap.getLength();
            dataOutputStream.writeInt(n);
            Attr[] attrArray = this.sortAttr(namedNodeMap);
            for (int i = 0; i < n; ++i) {
                dataOutputStream.write(this.getDOMHash(attrArray[i]));
            }
            NodeList nodeList = xMLElement.getChildNodes();
            n = nodeList.getLength();
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                dataOutputStream.write(this.getDOMHash(node));
            }
            dataOutputStream.close();
            this.md.update(byteArrayOutputStream.toByteArray());
            return this.md.digest();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Attr[] sortAttr(NamedNodeMap namedNodeMap) {
        XMLDocument xMLDocument = new XMLDocument();
        if (namedNodeMap.getLength() != 0) {
            Attr[] attrArray = new Attr[namedNodeMap.getLength()];
            int n = 0;
            int n2 = 0;
            Attr attr = (Attr)namedNodeMap.item(n2);
            int n3 = 0;
            while (attr != null) {
                while (n < n3 && attrArray[n].getName().compareTo(attr.getName()) <= 0) {
                    ++n;
                }
                if (n == n3) {
                    attrArray[n] = xMLDocument.createAttributeNS(attr.getNamespaceURI(), attr.getName());
                    attrArray[n].setValue(attr.getValue());
                    ++n3;
                } else {
                    for (int i = n; i < n3; ++i) {
                        attrArray[i + 1] = attrArray[i];
                    }
                    attrArray[n] = xMLDocument.createAttributeNS(attr.getNamespaceURI(), attr.getName());
                    attrArray[n].setValue(attr.getValue());
                    ++n3;
                }
                if (n2 == attrArray.length - 1) break;
                attr = (Attr)namedNodeMap.item(++n2);
            }
            return attrArray;
        }
        return null;
    }
}

