/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

final class TableLayoutManager
implements LayoutManager {
    private Grid _grid;
    private Header _rowHeader;
    private Header _columnHeader;

    TableLayoutManager() {
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("grid")) {
            this._grid = (Grid)component;
        } else if (string.equals("rowHeader")) {
            this._rowHeader = (Header)component;
        } else if (string.equals("columnHeader")) {
            this._columnHeader = (Header)component;
        } else {
            component.setVisible(false);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this._grid) {
            this._grid = null;
        } else if (component == this._rowHeader) {
            this._rowHeader = null;
        } else if (component == this._columnHeader) {
            this._columnHeader = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        SpreadTable spreadTable = (SpreadTable)container;
        Dimension dimension = new Dimension(this._grid.getPreferredSize());
        if (spreadTable.isRowHeaderVisible() && this._rowHeader != null) {
            dimension.width += spreadTable.getRowHeaderWidth();
        }
        if (spreadTable.isColumnHeaderVisible() && this._columnHeader != null) {
            dimension.height += spreadTable.getColumnHeaderHeight();
        }
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        SpreadTable spreadTable = (SpreadTable)container;
        Dimension dimension = new Dimension(this._grid.getMinimumSize());
        if (spreadTable.isRowHeaderVisible() && this._rowHeader != null) {
            dimension.width += this._rowHeader.getMinimumSize().width;
        }
        if (spreadTable.isColumnHeaderVisible() && this._columnHeader != null) {
            dimension.height += this._columnHeader.getMinimumSize().height;
        }
        return dimension;
    }

    public void layoutContainer(Container container) {
        int n;
        SpreadTable spreadTable = (SpreadTable)container;
        boolean bl = spreadTable.getActualReadingDirection() == 1;
        Dimension dimension = spreadTable.getSize();
        ImmInsets immInsets = spreadTable.getBorderInsets();
        if (immInsets != null) {
            dimension.width -= immInsets.left + immInsets.right;
            dimension.height -= immInsets.top + immInsets.bottom;
        }
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        boolean bl2 = spreadTable.isRowHeaderVisible() && this._rowHeader != null;
        boolean bl3 = spreadTable.isColumnHeaderVisible() && this._columnHeader != null;
        int n2 = bl2 ? spreadTable.getRowHeaderWidth() : 0;
        int n3 = bl3 ? spreadTable.getColumnHeaderHeight() : 0;
        Point point = immInsets == null ? new Point() : new Point(immInsets.left, immInsets.top);
        int n4 = point.x;
        int n5 = point.y;
        if (bl2) {
            this._rowHeader.setVisible(true);
            int n6 = n = bl ? point.x : dimension.width - n2 + point.x;
            if (bl3) {
                this._rowHeader.setBounds(n, n3 + point.y, n2, dimension.height - n3);
            } else {
                this._rowHeader.setBounds(n, point.y, n2, dimension.height);
            }
            if (bl) {
                n4 += n2;
            }
        } else if (this._rowHeader != null) {
            this._rowHeader.setVisible(false);
        }
        if (bl3) {
            this._columnHeader.setVisible(true);
            if (bl2) {
                n = bl ? n2 + point.x : point.x;
                this._columnHeader.setBounds(n, point.y, dimension.width - n2, n3);
            } else {
                this._columnHeader.setBounds(point.x, point.y, dimension.width, n3);
            }
            n5 += n3;
        } else if (this._columnHeader != null) {
            this._columnHeader.setVisible(false);
        }
        this._grid.setVisible(true);
        this._grid.setBounds(n4, n5, dimension.width - n2, dimension.height - n3);
        if (bl3 && bl2) {
            Component component;
            if (bl) {
                component = spreadTable.getCornerComponent("UPPER_LEFT_CORNER");
                if (component != null) {
                    component.setBounds(point.x, point.y, n2, n3);
                }
            } else {
                component = spreadTable.getCornerComponent("UPPER_RIGHT_CORNER");
                if (component != null) {
                    component.setBounds(n4 + (dimension.width - n2), point.y, n2, n3);
                }
            }
            if (component != null) {
                component.setVisible(true);
            }
        }
    }
}

