/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Color;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;

class PivotHeaderAppearMgr
implements AppearanceManager {
    private PivotHeader _pivotHeader;
    private AppearanceManager _toWrap;
    private int _item = -1;

    public PivotHeaderAppearMgr(AppearanceManager appearanceManager, PivotHeader pivotHeader) {
        this._toWrap = appearanceManager;
        this._pivotHeader = pivotHeader;
    }

    public void dispose() {
        if (this._pivotHeader == null) {
            return;
        }
        this._toWrap.setGrid(null);
        this._toWrap = null;
        this._pivotHeader = null;
    }

    public void setSwapItem(int n) {
        this._item = n;
    }

    public AppearanceManager getWrapped() {
        return this._toWrap;
    }

    public void updateUI() {
        if (this._pivotHeader != null) {
            this._pivotHeader.resetAppearanceManager();
        }
    }

    public Appearance getCellPaintingAppearance(int n, int n2) {
        boolean bl;
        Appearance appearance = this._toWrap.getCellPaintingAppearance(n, n2);
        if (this._item == -1) {
            return appearance;
        }
        boolean bl2 = bl = this._pivotHeader.getOrientation() == 0;
        if (bl && this._item == n2) {
            appearance = this._createSwapAppearance(appearance);
        } else if (!bl) {
            if (this._pivotHeader.isOutline()) {
                AbstractPivotHeaderCell abstractPivotHeaderCell = this._pivotHeader.getPivotHeaderCell(n, n2);
                if (abstractPivotHeaderCell != null && abstractPivotHeaderCell.getIndent() == this._item) {
                    appearance = this._createSwapAppearance(appearance);
                }
            } else if (this._item == n) {
                appearance = this._createSwapAppearance(appearance);
            }
        }
        return appearance;
    }

    private Appearance _createSwapAppearance(Appearance appearance) {
        Appearance appearance2 = appearance.copy();
        EWTPivotHeaderUI eWTPivotHeaderUI = this._pivotHeader.getPivotHeaderUI();
        Color color = eWTPivotHeaderUI.getSwapForegroundColor(this._pivotHeader, appearance);
        appearance2.setForeground(color);
        appearance2.setSelectForeground(color);
        color = eWTPivotHeaderUI.getSwapBackgroundColor(this._pivotHeader, appearance);
        appearance2.setBackground(color);
        appearance2.setSelectBackground(color);
        return appearance2;
    }

    public void setGrid(Grid grid) {
        if (this._toWrap != null) {
            this._toWrap.setGrid(grid);
        }
    }

    public TwoDModelListener getTwoDModelListener() {
        return this._toWrap.getTwoDModelListener();
    }
}

